/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARNANDFLASH_H_INC_
#define ___ARNANDFLASH_H_INC_
#define NDFLASH_CMDQ_FIFO_WIDTH 32
#define NDFLASH_CMDQ_FIFO_DEPTH 8
#define NDFLASH_ECC_FIFO_WIDTH  32
#define NDFLASH_ECC_FIFO_DEPTH  128
#define NDFLASH_AFIFO_WIDTH     32
#define NDFLASH_AFIFO_DEPTH     1024
#define NDFLASH_BFIFO_WIDTH     32
#define NDFLASH_BFIFO_DEPTH     128
#define NDFLASH_CS_MAX  8
#define NDFLASH_DMA_MAX_BYTES   65536
#define NDFLASH_DMA_PTR_ALIGN   4
#define NDFLASH_CMDQ_MAX_PKT_LENGTH     15
#define NDFLASH_PARITY_SZ_RS_T1_256     4
#define NDFLASH_PARITY_SZ_RS_T4_512     12
#define NDFLASH_PARITY_SZ_RS_T4_1024    20
#define NDFLASH_PARITY_SZ_RS_T4_2048    36
#define NDFLASH_PARITY_SZ_RS_T4_4096    72
#define NDFLASH_PARITY_SZ_RS_T6_512     16
#define NDFLASH_PARITY_SZ_RS_T6_1024    28
#define NDFLASH_PARITY_SZ_RS_T6_2048    56
#define NDFLASH_PARITY_SZ_RS_T6_4096    108
#define NDFLASH_PARITY_SZ_RS_T8_512     20
#define NDFLASH_PARITY_SZ_RS_T8_1024    36
#define NDFLASH_PARITY_SZ_RS_T8_2048    72
#define NDFLASH_PARITY_SZ_RS_T8_4096    144
#define NDFLASH_PARITY_SZ_HAMMING_256   4
#define NDFLASH_PARITY_SZ_HAMMING_512   4
#define NDFLASH_PARITY_SZ_HAMMING_1024  8
#define NDFLASH_PARITY_SZ_HAMMING_2048  16
#define NDFLASH_PARITY_SZ_HAMMING_4096  32
#define NDFLASH_PARITY_SZ_HAMMING_SPARE 4
#define NDFLASH_PARITY_SZ_BCH_T4_512    7
#define NDFLASH_PARITY_SZ_BCH_T8_512    13
#define NDFLASH_PARITY_SZ_BCH_T14_512   23
#define NDFLASH_PARITY_SZ_BCH_T16_512   26

// Register NAND_COMMAND_0  
#define NAND_COMMAND_0                  _MK_ADDR_CONST(0x0)
#define NAND_COMMAND_0_SECURE                   0x0
#define NAND_COMMAND_0_WORD_COUNT                       0x1
#define NAND_COMMAND_0_RESET_VAL                        _MK_MASK_CONST(0x800004)
#define NAND_COMMAND_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_COMMAND_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_COMMAND_0_WRITE_MASK                       _MK_MASK_CONST(0x7fffffff)
// 0 = HW clears when programmed nand IO 
//     operation is completed.
#define NAND_COMMAND_0_GO_SHIFT                 _MK_SHIFT_CONST(31)
#define NAND_COMMAND_0_GO_FIELD                 (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_GO_SHIFT)
#define NAND_COMMAND_0_GO_RANGE                 31:31
#define NAND_COMMAND_0_GO_WOFFSET                       0x0
#define NAND_COMMAND_0_GO_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_GO_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_GO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_GO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_GO_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_GO_ENABLE                        _MK_ENUM_CONST(1)

// CLE enable
// 1 = Flash sequence has Command Cycle(CLE) enabled 
// 0 = Flash sequence has Command Cycle(CLE) disabled
#define NAND_COMMAND_0_CLE_SHIFT                        _MK_SHIFT_CONST(30)
#define NAND_COMMAND_0_CLE_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CLE_SHIFT)
#define NAND_COMMAND_0_CLE_RANGE                        30:30
#define NAND_COMMAND_0_CLE_WOFFSET                      0x0
#define NAND_COMMAND_0_CLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CLE_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CLE_ENABLE                       _MK_ENUM_CONST(1)

// ALE enable
// 1 = Flash sequence has Address Cycle(CLE) enabled 
// 0 = Flash sequence has Address Cycle(CLE) disabled 
#define NAND_COMMAND_0_ALE_SHIFT                        _MK_SHIFT_CONST(29)
#define NAND_COMMAND_0_ALE_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_ALE_SHIFT)
#define NAND_COMMAND_0_ALE_RANGE                        29:29
#define NAND_COMMAND_0_ALE_WOFFSET                      0x0
#define NAND_COMMAND_0_ALE_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_ALE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_ALE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_ALE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_ALE_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_ALE_ENABLE                       _MK_ENUM_CONST(1)

// PIO mode of operation enable
// 1 = Dataout is from NAND_RESP register
//     and Datain is to NAND_RESP register
// 0 = Dataout is from FIFO buffer
//     and Datain to FIFO buffer
#define NAND_COMMAND_0_PIO_SHIFT                        _MK_SHIFT_CONST(28)
#define NAND_COMMAND_0_PIO_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_PIO_SHIFT)
#define NAND_COMMAND_0_PIO_RANGE                        28:28
#define NAND_COMMAND_0_PIO_WOFFSET                      0x0
#define NAND_COMMAND_0_PIO_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_PIO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_PIO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_PIO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_PIO_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_PIO_ENABLE                       _MK_ENUM_CONST(1)

// write data transfer enable - required for FLASH program
// 1 = Write data transfers to flash is enabled
// 0 = Write data transfers to flash is disabled
#define NAND_COMMAND_0_TX_SHIFT                 _MK_SHIFT_CONST(27)
#define NAND_COMMAND_0_TX_FIELD                 (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_TX_SHIFT)
#define NAND_COMMAND_0_TX_RANGE                 27:27
#define NAND_COMMAND_0_TX_WOFFSET                       0x0
#define NAND_COMMAND_0_TX_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_TX_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_TX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_TX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_TX_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_TX_ENABLE                        _MK_ENUM_CONST(1)

// read data transfer enabled - required for FLASH read
// 1 = Read data transfers from flash is enabled
// 0 = Read data transfers from flash is disabled
#define NAND_COMMAND_0_RX_SHIFT                 _MK_SHIFT_CONST(26)
#define NAND_COMMAND_0_RX_FIELD                 (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_RX_SHIFT)
#define NAND_COMMAND_0_RX_RANGE                 26:26
#define NAND_COMMAND_0_RX_WOFFSET                       0x0
#define NAND_COMMAND_0_RX_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RX_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_RX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RX_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_RX_ENABLE                        _MK_ENUM_CONST(1)

// CMD2 sequence to flash enable
// 1 = NAND command sequence have a second command(CLE)
//     cycle
// 0 = NAND command sequence doesnt have second CLE cycle
#define NAND_COMMAND_0_SEC_CMD_SHIFT                    _MK_SHIFT_CONST(25)
#define NAND_COMMAND_0_SEC_CMD_FIELD                    (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_SEC_CMD_SHIFT)
#define NAND_COMMAND_0_SEC_CMD_RANGE                    25:25
#define NAND_COMMAND_0_SEC_CMD_WOFFSET                  0x0
#define NAND_COMMAND_0_SEC_CMD_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_SEC_CMD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_SEC_CMD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_SEC_CMD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_SEC_CMD_DISABLE                  _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_SEC_CMD_ENABLE                   _MK_ENUM_CONST(1)

// CMD2 placement control
// 1 - CMD2 CLE cycle is issued after data transfer cycles.
//     this is the typical usage during FLASH program
// 0 - CMD2 CLE cycle is issued right after Address transfer
//      cycles, typical usage during FLASH read
#define NAND_COMMAND_0_AFT_DAT_SHIFT                    _MK_SHIFT_CONST(24)
#define NAND_COMMAND_0_AFT_DAT_FIELD                    (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_AFT_DAT_SHIFT)
#define NAND_COMMAND_0_AFT_DAT_RANGE                    24:24
#define NAND_COMMAND_0_AFT_DAT_WOFFSET                  0x0
#define NAND_COMMAND_0_AFT_DAT_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_AFT_DAT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_AFT_DAT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_AFT_DAT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_AFT_DAT_DISABLE                  _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_AFT_DAT_ENABLE                   _MK_ENUM_CONST(1)

// Transfer size of bytes  Depends on PAGE_SIZE_SEL field of CONFIG register
#define NAND_COMMAND_0_TRANS_SIZE_SHIFT                 _MK_SHIFT_CONST(20)
#define NAND_COMMAND_0_TRANS_SIZE_FIELD                 (_MK_MASK_CONST(0xf) << NAND_COMMAND_0_TRANS_SIZE_SHIFT)
#define NAND_COMMAND_0_TRANS_SIZE_RANGE                 23:20
#define NAND_COMMAND_0_TRANS_SIZE_WOFFSET                       0x0
#define NAND_COMMAND_0_TRANS_SIZE_DEFAULT                       _MK_MASK_CONST(0x8)
#define NAND_COMMAND_0_TRANS_SIZE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define NAND_COMMAND_0_TRANS_SIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_TRANS_SIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES1                        _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES2                        _MK_ENUM_CONST(1)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES3                        _MK_ENUM_CONST(2)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES4                        _MK_ENUM_CONST(3)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES5                        _MK_ENUM_CONST(4)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES6                        _MK_ENUM_CONST(5)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES7                        _MK_ENUM_CONST(6)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES8                        _MK_ENUM_CONST(7)
#define NAND_COMMAND_0_TRANS_SIZE_BYTES_PAGE_SIZE_SEL                   _MK_ENUM_CONST(8)

// Main data region transer enable 
// 1 = Involves Main area data transfer in flash sequence
// 0 = Doesnt involve Main area data transfer
#define NAND_COMMAND_0_A_VALID_SHIFT                    _MK_SHIFT_CONST(19)
#define NAND_COMMAND_0_A_VALID_FIELD                    (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_A_VALID_SHIFT)
#define NAND_COMMAND_0_A_VALID_RANGE                    19:19
#define NAND_COMMAND_0_A_VALID_WOFFSET                  0x0
#define NAND_COMMAND_0_A_VALID_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_A_VALID_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_A_VALID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_A_VALID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_A_VALID_DISABLE                  _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_A_VALID_ENABLE                   _MK_ENUM_CONST(1)

// Spare region (aka TAG) transfer enable
// 1 = Involves spare area data transfer in flash sequence
// 0 = Doesnt involve spare area data transfer
#define NAND_COMMAND_0_B_VALID_SHIFT                    _MK_SHIFT_CONST(18)
#define NAND_COMMAND_0_B_VALID_FIELD                    (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_B_VALID_SHIFT)
#define NAND_COMMAND_0_B_VALID_RANGE                    18:18
#define NAND_COMMAND_0_B_VALID_WOFFSET                  0x0
#define NAND_COMMAND_0_B_VALID_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_B_VALID_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_B_VALID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_B_VALID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_B_VALID_DISABLE                  _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_B_VALID_ENABLE                   _MK_ENUM_CONST(1)

// H/W assisted read status check enable
// 1 = Indicates to controller that current IO sequence 
//     need RD STATUS check condition to be qualified. 
// 0 = auto read status check is disabled
// notes: please refer to NAND_HWSTATUS_CMD register for
//        qualifier conditon 
#define NAND_COMMAND_0_RD_STATUS_CHK_SHIFT                      _MK_SHIFT_CONST(17)
#define NAND_COMMAND_0_RD_STATUS_CHK_FIELD                      (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_RD_STATUS_CHK_SHIFT)
#define NAND_COMMAND_0_RD_STATUS_CHK_RANGE                      17:17
#define NAND_COMMAND_0_RD_STATUS_CHK_WOFFSET                    0x0
#define NAND_COMMAND_0_RD_STATUS_CHK_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RD_STATUS_CHK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_RD_STATUS_CHK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RD_STATUS_CHK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RD_STATUS_CHK_DISABLE                    _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_RD_STATUS_CHK_ENABLE                     _MK_ENUM_CONST(1)

// H/W assited rbsy check enable 
// 1 = Indicates to controller that current IO sequence 
//     need RBSY check condition to be qualified. 
// 0 = auto RBSY check is disabled
// notes: please refer to NAND_HWSTATUS_CMD register for
//        qualifier conditon 
#define NAND_COMMAND_0_RBSY_CHK_SHIFT                   _MK_SHIFT_CONST(16)
#define NAND_COMMAND_0_RBSY_CHK_FIELD                   (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_RBSY_CHK_SHIFT)
#define NAND_COMMAND_0_RBSY_CHK_RANGE                   16:16
#define NAND_COMMAND_0_RBSY_CHK_WOFFSET                 0x0
#define NAND_COMMAND_0_RBSY_CHK_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RBSY_CHK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_RBSY_CHK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RBSY_CHK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RBSY_CHK_DISABLE                 _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_RBSY_CHK_ENABLE                  _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 7
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE7_SHIFT                        _MK_SHIFT_CONST(15)
#define NAND_COMMAND_0_CE7_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE7_SHIFT)
#define NAND_COMMAND_0_CE7_RANGE                        15:15
#define NAND_COMMAND_0_CE7_WOFFSET                      0x0
#define NAND_COMMAND_0_CE7_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE7_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE7_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE7_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 6
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE6_SHIFT                        _MK_SHIFT_CONST(14)
#define NAND_COMMAND_0_CE6_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE6_SHIFT)
#define NAND_COMMAND_0_CE6_RANGE                        14:14
#define NAND_COMMAND_0_CE6_WOFFSET                      0x0
#define NAND_COMMAND_0_CE6_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE6_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE6_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE6_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 5
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE5_SHIFT                        _MK_SHIFT_CONST(13)
#define NAND_COMMAND_0_CE5_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE5_SHIFT)
#define NAND_COMMAND_0_CE5_RANGE                        13:13
#define NAND_COMMAND_0_CE5_WOFFSET                      0x0
#define NAND_COMMAND_0_CE5_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE5_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE5_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE5_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 4
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE4_SHIFT                        _MK_SHIFT_CONST(12)
#define NAND_COMMAND_0_CE4_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE4_SHIFT)
#define NAND_COMMAND_0_CE4_RANGE                        12:12
#define NAND_COMMAND_0_CE4_WOFFSET                      0x0
#define NAND_COMMAND_0_CE4_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE4_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE4_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE4_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 3
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE3_SHIFT                        _MK_SHIFT_CONST(11)
#define NAND_COMMAND_0_CE3_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE3_SHIFT)
#define NAND_COMMAND_0_CE3_RANGE                        11:11
#define NAND_COMMAND_0_CE3_WOFFSET                      0x0
#define NAND_COMMAND_0_CE3_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE3_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE3_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE3_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 2
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE2_SHIFT                        _MK_SHIFT_CONST(10)
#define NAND_COMMAND_0_CE2_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE2_SHIFT)
#define NAND_COMMAND_0_CE2_RANGE                        10:10
#define NAND_COMMAND_0_CE2_WOFFSET                      0x0
#define NAND_COMMAND_0_CE2_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE2_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE2_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 1
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE1_SHIFT                        _MK_SHIFT_CONST(9)
#define NAND_COMMAND_0_CE1_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE1_SHIFT)
#define NAND_COMMAND_0_CE1_RANGE                        9:9
#define NAND_COMMAND_0_CE1_WOFFSET                      0x0
#define NAND_COMMAND_0_CE1_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE1_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE1_ENABLE                       _MK_ENUM_CONST(1)

// Chip select enable for Flash Card 0
// 0 = Disable 1 = Enable
#define NAND_COMMAND_0_CE0_SHIFT                        _MK_SHIFT_CONST(8)
#define NAND_COMMAND_0_CE0_FIELD                        (_MK_MASK_CONST(0x1) << NAND_COMMAND_0_CE0_SHIFT)
#define NAND_COMMAND_0_CE0_RANGE                        8:8
#define NAND_COMMAND_0_CE0_WOFFSET                      0x0
#define NAND_COMMAND_0_CE0_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_COMMAND_0_CE0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CE0_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CE0_ENABLE                       _MK_ENUM_CONST(1)

#define NAND_COMMAND_0_RSVD_SHIFT                       _MK_SHIFT_CONST(6)
#define NAND_COMMAND_0_RSVD_FIELD                       (_MK_MASK_CONST(0x3) << NAND_COMMAND_0_RSVD_SHIFT)
#define NAND_COMMAND_0_RSVD_RANGE                       7:6
#define NAND_COMMAND_0_RSVD_WOFFSET                     0x0
#define NAND_COMMAND_0_RSVD_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RSVD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define NAND_COMMAND_0_RSVD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_RSVD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  Command cycle byte count
#define NAND_COMMAND_0_CLE_BYTE_SIZE_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_FIELD                      (_MK_MASK_CONST(0x3) << NAND_COMMAND_0_CLE_BYTE_SIZE_SHIFT)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_RANGE                      5:4
#define NAND_COMMAND_0_CLE_BYTE_SIZE_WOFFSET                    0x0
#define NAND_COMMAND_0_CLE_BYTE_SIZE_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_CLE_BYTES1                 _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_CLE_BYTES2                 _MK_ENUM_CONST(1)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_CLE_BYTES3                 _MK_ENUM_CONST(2)
#define NAND_COMMAND_0_CLE_BYTE_SIZE_CLE_BYTES4                 _MK_ENUM_CONST(3)

// Address cycle byte count Reserved
#define NAND_COMMAND_0_ALE_BYTE_SIZE_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_FIELD                      (_MK_MASK_CONST(0xf) << NAND_COMMAND_0_ALE_BYTE_SIZE_SHIFT)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_RANGE                      3:0
#define NAND_COMMAND_0_ALE_BYTE_SIZE_WOFFSET                    0x0
#define NAND_COMMAND_0_ALE_BYTE_SIZE_DEFAULT                    _MK_MASK_CONST(0x4)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES1                 _MK_ENUM_CONST(0)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES2                 _MK_ENUM_CONST(1)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES3                 _MK_ENUM_CONST(2)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES4                 _MK_ENUM_CONST(3)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES5                 _MK_ENUM_CONST(4)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES6                 _MK_ENUM_CONST(5)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES7                 _MK_ENUM_CONST(6)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES8                 _MK_ENUM_CONST(7)
#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES9                 _MK_ENUM_CONST(8)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES10                        _MK_ENUM_CONST(9)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES11                        _MK_ENUM_CONST(10)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES12                        _MK_ENUM_CONST(11)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES13                        _MK_ENUM_CONST(12)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES14                        _MK_ENUM_CONST(13)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES15                        _MK_ENUM_CONST(14)    // // Reserved

#define NAND_COMMAND_0_ALE_BYTE_SIZE_ALE_BYTES16                        _MK_ENUM_CONST(15)


// Register NAND_STATUS_0  
#define NAND_STATUS_0                   _MK_ADDR_CONST(0x4)
#define NAND_STATUS_0_SECURE                    0x0
#define NAND_STATUS_0_WORD_COUNT                        0x1
#define NAND_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffc1)
#define NAND_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_READ_MASK                         _MK_MASK_CONST(0xffffffc1)
#define NAND_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_NA2_SHIFT                 _MK_SHIFT_CONST(16)
#define NAND_STATUS_0_NA2_FIELD                 (_MK_MASK_CONST(0xffff) << NAND_STATUS_0_NA2_SHIFT)
#define NAND_STATUS_0_NA2_RANGE                 31:16
#define NAND_STATUS_0_NA2_WOFFSET                       0x0
#define NAND_STATUS_0_NA2_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_NA2_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define NAND_STATUS_0_NA2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_NA2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = Indicates flash7 is RDY
#define NAND_STATUS_0_RBSY7_SHIFT                       _MK_SHIFT_CONST(15)
#define NAND_STATUS_0_RBSY7_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY7_SHIFT)
#define NAND_STATUS_0_RBSY7_RANGE                       15:15
#define NAND_STATUS_0_RBSY7_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY7_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY7_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash6 is RDY
#define NAND_STATUS_0_RBSY6_SHIFT                       _MK_SHIFT_CONST(14)
#define NAND_STATUS_0_RBSY6_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY6_SHIFT)
#define NAND_STATUS_0_RBSY6_RANGE                       14:14
#define NAND_STATUS_0_RBSY6_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY6_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY6_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash5 is RDY
#define NAND_STATUS_0_RBSY5_SHIFT                       _MK_SHIFT_CONST(13)
#define NAND_STATUS_0_RBSY5_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY5_SHIFT)
#define NAND_STATUS_0_RBSY5_RANGE                       13:13
#define NAND_STATUS_0_RBSY5_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY5_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY5_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash4 is RDY
#define NAND_STATUS_0_RBSY4_SHIFT                       _MK_SHIFT_CONST(12)
#define NAND_STATUS_0_RBSY4_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY4_SHIFT)
#define NAND_STATUS_0_RBSY4_RANGE                       12:12
#define NAND_STATUS_0_RBSY4_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY4_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash3 is RDY
#define NAND_STATUS_0_RBSY3_SHIFT                       _MK_SHIFT_CONST(11)
#define NAND_STATUS_0_RBSY3_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY3_SHIFT)
#define NAND_STATUS_0_RBSY3_RANGE                       11:11
#define NAND_STATUS_0_RBSY3_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY3_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash2 is RDY
#define NAND_STATUS_0_RBSY2_SHIFT                       _MK_SHIFT_CONST(10)
#define NAND_STATUS_0_RBSY2_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY2_SHIFT)
#define NAND_STATUS_0_RBSY2_RANGE                       10:10
#define NAND_STATUS_0_RBSY2_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY2_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash1 is RDY
#define NAND_STATUS_0_RBSY1_SHIFT                       _MK_SHIFT_CONST(9)
#define NAND_STATUS_0_RBSY1_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY1_SHIFT)
#define NAND_STATUS_0_RBSY1_RANGE                       9:9
#define NAND_STATUS_0_RBSY1_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY1_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates flash0 is RDY
#define NAND_STATUS_0_RBSY0_SHIFT                       _MK_SHIFT_CONST(8)
#define NAND_STATUS_0_RBSY0_FIELD                       (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RBSY0_SHIFT)
#define NAND_STATUS_0_RBSY0_RANGE                       8:8
#define NAND_STATUS_0_RBSY0_WOFFSET                     0x0
#define NAND_STATUS_0_RBSY0_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RBSY0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RBSY0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = Indicates write cycles to flash are in progress
#define NAND_STATUS_0_WR_ACT_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_STATUS_0_WR_ACT_FIELD                      (_MK_MASK_CONST(0x1) << NAND_STATUS_0_WR_ACT_SHIFT)
#define NAND_STATUS_0_WR_ACT_RANGE                      7:7
#define NAND_STATUS_0_WR_ACT_WOFFSET                    0x0
#define NAND_STATUS_0_WR_ACT_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_WR_ACT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_WR_ACT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_WR_ACT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  1 = Indicates read cycles to flash are in progress
#define NAND_STATUS_0_RD_ACT_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_STATUS_0_RD_ACT_FIELD                      (_MK_MASK_CONST(0x1) << NAND_STATUS_0_RD_ACT_SHIFT)
#define NAND_STATUS_0_RD_ACT_RANGE                      6:6
#define NAND_STATUS_0_RD_ACT_WOFFSET                    0x0
#define NAND_STATUS_0_RD_ACT_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RD_ACT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_RD_ACT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_RD_ACT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  1 = Indicates NAND controller is in IDLE state of operation, 
//      and there are no flash/DMA transactions are pending.
#define NAND_STATUS_0_ISEMPTY_SHIFT                     _MK_SHIFT_CONST(0)
#define NAND_STATUS_0_ISEMPTY_FIELD                     (_MK_MASK_CONST(0x1) << NAND_STATUS_0_ISEMPTY_SHIFT)
#define NAND_STATUS_0_ISEMPTY_RANGE                     0:0
#define NAND_STATUS_0_ISEMPTY_WOFFSET                   0x0
#define NAND_STATUS_0_ISEMPTY_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_ISEMPTY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_STATUS_0_ISEMPTY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_STATUS_0_ISEMPTY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register NAND_ISR_0  
#define NAND_ISR_0                      _MK_ADDR_CONST(0x8)
#define NAND_ISR_0_SECURE                       0x0
#define NAND_ISR_0_WORD_COUNT                   0x1
#define NAND_ISR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define NAND_ISR_0_RESET_MASK                   _MK_MASK_CONST(0xfffc)
#define NAND_ISR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define NAND_ISR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_ISR_0_READ_MASK                    _MK_MASK_CONST(0x100fffc)
#define NAND_ISR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffc)
// 1 = Correctable OR Un-correctable errors occurred in the DMA transfer 
//     without regard to HW_ERR_CORRECTION feature is enabled or not. 
//     Use extended decode results in NAND_DEC_RESULT and NAND_DEC_STATUS_EXT 
//     to figure out further action for block replacement/wear leveling during 
//     file system management for s/w.
//     Covers all ECC selection: RS/Hamming/BCH modes
#define NAND_ISR_0_CORRFAIL_ERR_SHIFT                   _MK_SHIFT_CONST(24)
#define NAND_ISR_0_CORRFAIL_ERR_FIELD                   (_MK_MASK_CONST(0x1) << NAND_ISR_0_CORRFAIL_ERR_SHIFT)
#define NAND_ISR_0_CORRFAIL_ERR_RANGE                   24:24
#define NAND_ISR_0_CORRFAIL_ERR_WOFFSET                 0x0
#define NAND_ISR_0_CORRFAIL_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_ISR_0_CORRFAIL_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_ISR_0_CORRFAIL_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_ISR_0_CORRFAIL_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// 1 = Flash7 is Ready interrupt occured 
// This is SET only when NOT running in COMMAND QUEUE  MODE
#define NAND_ISR_0_IS_RBSY7_SHIFT                       _MK_SHIFT_CONST(15)
#define NAND_ISR_0_IS_RBSY7_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY7_SHIFT)
#define NAND_ISR_0_IS_RBSY7_RANGE                       15:15
#define NAND_ISR_0_IS_RBSY7_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY7_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY7_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash6 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY6_SHIFT                       _MK_SHIFT_CONST(14)
#define NAND_ISR_0_IS_RBSY6_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY6_SHIFT)
#define NAND_ISR_0_IS_RBSY6_RANGE                       14:14
#define NAND_ISR_0_IS_RBSY6_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY6_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY6_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash5 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY5_SHIFT                       _MK_SHIFT_CONST(13)
#define NAND_ISR_0_IS_RBSY5_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY5_SHIFT)
#define NAND_ISR_0_IS_RBSY5_RANGE                       13:13
#define NAND_ISR_0_IS_RBSY5_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY5_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY5_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash4 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY4_SHIFT                       _MK_SHIFT_CONST(12)
#define NAND_ISR_0_IS_RBSY4_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY4_SHIFT)
#define NAND_ISR_0_IS_RBSY4_RANGE                       12:12
#define NAND_ISR_0_IS_RBSY4_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY4_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash3 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY3_SHIFT                       _MK_SHIFT_CONST(11)
#define NAND_ISR_0_IS_RBSY3_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY3_SHIFT)
#define NAND_ISR_0_IS_RBSY3_RANGE                       11:11
#define NAND_ISR_0_IS_RBSY3_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY3_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash2 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY2_SHIFT                       _MK_SHIFT_CONST(10)
#define NAND_ISR_0_IS_RBSY2_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY2_SHIFT)
#define NAND_ISR_0_IS_RBSY2_RANGE                       10:10
#define NAND_ISR_0_IS_RBSY2_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY2_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash1 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY1_SHIFT                       _MK_SHIFT_CONST(9)
#define NAND_ISR_0_IS_RBSY1_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY1_SHIFT)
#define NAND_ISR_0_IS_RBSY1_RANGE                       9:9
#define NAND_ISR_0_IS_RBSY1_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY1_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = Flash0 is Ready interrupt occured
// This is SET only when NOT running in COMMAND QUEUE MODE
#define NAND_ISR_0_IS_RBSY0_SHIFT                       _MK_SHIFT_CONST(8)
#define NAND_ISR_0_IS_RBSY0_FIELD                       (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_RBSY0_SHIFT)
#define NAND_ISR_0_IS_RBSY0_RANGE                       8:8
#define NAND_ISR_0_IS_RBSY0_WOFFSET                     0x0
#define NAND_ISR_0_IS_RBSY0_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_RBSY0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_RBSY0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 1 = FIFO under run interrupt occured
// this should not happen in general usage, if it happens
// there is a potential h/w issue.
#define NAND_ISR_0_IS_UND_SHIFT                 _MK_SHIFT_CONST(7)
#define NAND_ISR_0_IS_UND_FIELD                 (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_UND_SHIFT)
#define NAND_ISR_0_IS_UND_RANGE                 7:7
#define NAND_ISR_0_IS_UND_WOFFSET                       0x0
#define NAND_ISR_0_IS_UND_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_UND_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_UND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_UND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 1 = FIFO is Overrun
// this should not happen in general usage, if it happens
// there is potential h/w issue.
#define NAND_ISR_0_IS_OVR_SHIFT                 _MK_SHIFT_CONST(6)
#define NAND_ISR_0_IS_OVR_FIELD                 (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_OVR_SHIFT)
#define NAND_ISR_0_IS_OVR_RANGE                 6:6
#define NAND_ISR_0_IS_OVR_WOFFSET                       0x0
#define NAND_ISR_0_IS_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 1 = Command operations are completed as per NAND 
//     command register settings.
//     This is set ONLY when not running in COMMAND QUEUE  MODE
#define NAND_ISR_0_IS_CMD_DONE_SHIFT                    _MK_SHIFT_CONST(5)
#define NAND_ISR_0_IS_CMD_DONE_FIELD                    (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_CMD_DONE_SHIFT)
#define NAND_ISR_0_IS_CMD_DONE_RANGE                    5:5
#define NAND_ISR_0_IS_CMD_DONE_WOFFSET                  0x0
#define NAND_ISR_0_IS_CMD_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_CMD_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_CMD_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_CMD_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 1 = ECC error generated for following reasons.  
//     ->ecc decode resulted in uncorrectable errors in one of 
//       sector(sub-page)
//     ->ecc decode resulted in correctable errors more than
//       trigger level as defined in TRIG_LVL in NAND_CONFIG
//       register
// Bit is set for legacy mode of ECC selection with HW_ECC & ECC_TAG_EN only.
// i.e. for RS/Hamming selection. Will not be set for BCH selection
//
#define NAND_ISR_0_IS_ECC_ERR_SHIFT                     _MK_SHIFT_CONST(4)
#define NAND_ISR_0_IS_ECC_ERR_FIELD                     (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_ECC_ERR_SHIFT)
#define NAND_ISR_0_IS_ECC_ERR_RANGE                     4:4
#define NAND_ISR_0_IS_ECC_ERR_WOFFSET                   0x0
#define NAND_ISR_0_IS_ECC_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_ECC_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_ECC_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_ECC_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 1 = Command queue execution completed 
#define NAND_ISR_0_IS_LL_DONE_SHIFT                     _MK_SHIFT_CONST(3)
#define NAND_ISR_0_IS_LL_DONE_FIELD                     (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_LL_DONE_SHIFT)
#define NAND_ISR_0_IS_LL_DONE_RANGE                     3:3
#define NAND_ISR_0_IS_LL_DONE_WOFFSET                   0x0
#define NAND_ISR_0_IS_LL_DONE_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_LL_DONE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_LL_DONE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_LL_DONE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 1 = One of the Command queue packet execution  returned ERROR
#define NAND_ISR_0_IS_LL_ERR_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_ISR_0_IS_LL_ERR_FIELD                      (_MK_MASK_CONST(0x1) << NAND_ISR_0_IS_LL_ERR_SHIFT)
#define NAND_ISR_0_IS_LL_ERR_RANGE                      2:2
#define NAND_ISR_0_IS_LL_ERR_WOFFSET                    0x0
#define NAND_ISR_0_IS_LL_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_LL_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_ISR_0_IS_LL_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_ISR_0_IS_LL_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_IER_0  
#define NAND_IER_0                      _MK_ADDR_CONST(0xc)
#define NAND_IER_0_SECURE                       0x0
#define NAND_IER_0_WORD_COUNT                   0x1
#define NAND_IER_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define NAND_IER_0_RESET_MASK                   _MK_MASK_CONST(0xffffd)
#define NAND_IER_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_IER_0_READ_MASK                    _MK_MASK_CONST(0xffffd)
#define NAND_IER_0_WRITE_MASK                   _MK_MASK_CONST(0xffffd)
// Trigger for correctable error Interrupts by main ECC RS decoder, if 
// HW_ERR_CORRECTION feature is enabled. Mechansim for SW to get an idea
// on error pattern development over a period of usage. NAND controller
// will trigger interrupt if the current main page read transfer resulted 
// in correctable errors reached this trigger value for Reed-Solomon selection. 
// For example, of ECC_ERROR interrupt for t=4, with ERR_TRIG_VAL=3 could 
// imply only one of the following.
// a) If DEC_FAIL = 1, one of the sub-page decode returned failure because no. 
// of symbol errors are more than 4.
// b) If DEC_FAIL = 0, one of the sub-page decode returned 3 correctable errors.
#define NAND_IER_0_ERR_TRIG_VAL_SHIFT                   _MK_SHIFT_CONST(16)
#define NAND_IER_0_ERR_TRIG_VAL_FIELD                   (_MK_MASK_CONST(0xf) << NAND_IER_0_ERR_TRIG_VAL_SHIFT)
#define NAND_IER_0_ERR_TRIG_VAL_RANGE                   19:16
#define NAND_IER_0_ERR_TRIG_VAL_WOFFSET                 0x0
#define NAND_IER_0_ERR_TRIG_VAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_IER_0_ERR_TRIG_VAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define NAND_IER_0_ERR_TRIG_VAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_IER_0_ERR_TRIG_VAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_0                     _MK_ENUM_CONST(0)    // // Reports for every single error, equivalent to ECC_ERROR interrupt without
// HW_ERR_CORRECTION feature.

#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_1                     _MK_ENUM_CONST(1)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_2                     _MK_ENUM_CONST(2)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_3                     _MK_ENUM_CONST(3)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_4                     _MK_ENUM_CONST(4)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_5                     _MK_ENUM_CONST(5)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_6                     _MK_ENUM_CONST(6)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_7                     _MK_ENUM_CONST(7)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_8                     _MK_ENUM_CONST(8)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_9                     _MK_ENUM_CONST(9)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_10                    _MK_ENUM_CONST(10)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_11                    _MK_ENUM_CONST(11)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_12                    _MK_ENUM_CONST(12)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_13                    _MK_ENUM_CONST(13)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_14                    _MK_ENUM_CONST(14)
#define NAND_IER_0_ERR_TRIG_VAL_CORR_ERRS_15                    _MK_ENUM_CONST(15)

// 1 = flash7 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY7_SHIFT                       _MK_SHIFT_CONST(15)
#define NAND_IER_0_IE_RBSY7_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY7_SHIFT)
#define NAND_IER_0_IE_RBSY7_RANGE                       15:15
#define NAND_IER_0_IE_RBSY7_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY7_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY7_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY7_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY7_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash6 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY6_SHIFT                       _MK_SHIFT_CONST(14)
#define NAND_IER_0_IE_RBSY6_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY6_SHIFT)
#define NAND_IER_0_IE_RBSY6_RANGE                       14:14
#define NAND_IER_0_IE_RBSY6_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY6_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY6_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY6_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY6_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash5 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY5_SHIFT                       _MK_SHIFT_CONST(13)
#define NAND_IER_0_IE_RBSY5_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY5_SHIFT)
#define NAND_IER_0_IE_RBSY5_RANGE                       13:13
#define NAND_IER_0_IE_RBSY5_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY5_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY5_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY5_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY5_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash4 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY4_SHIFT                       _MK_SHIFT_CONST(12)
#define NAND_IER_0_IE_RBSY4_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY4_SHIFT)
#define NAND_IER_0_IE_RBSY4_RANGE                       12:12
#define NAND_IER_0_IE_RBSY4_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY4_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY4_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY4_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash3 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY3_SHIFT                       _MK_SHIFT_CONST(11)
#define NAND_IER_0_IE_RBSY3_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY3_SHIFT)
#define NAND_IER_0_IE_RBSY3_RANGE                       11:11
#define NAND_IER_0_IE_RBSY3_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY3_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY3_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY3_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash2 RBSY line High interrupt 
#define NAND_IER_0_IE_RBSY2_SHIFT                       _MK_SHIFT_CONST(10)
#define NAND_IER_0_IE_RBSY2_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY2_SHIFT)
#define NAND_IER_0_IE_RBSY2_RANGE                       10:10
#define NAND_IER_0_IE_RBSY2_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY2_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY2_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY2_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash1 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY1_SHIFT                       _MK_SHIFT_CONST(9)
#define NAND_IER_0_IE_RBSY1_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY1_SHIFT)
#define NAND_IER_0_IE_RBSY1_RANGE                       9:9
#define NAND_IER_0_IE_RBSY1_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY1_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY1_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY1_ENABLE                      _MK_ENUM_CONST(1)

// 1 = flash0 RBSY line High interrupt
#define NAND_IER_0_IE_RBSY0_SHIFT                       _MK_SHIFT_CONST(8)
#define NAND_IER_0_IE_RBSY0_FIELD                       (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_RBSY0_SHIFT)
#define NAND_IER_0_IE_RBSY0_RANGE                       8:8
#define NAND_IER_0_IE_RBSY0_WOFFSET                     0x0
#define NAND_IER_0_IE_RBSY0_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_RBSY0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_RBSY0_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_RBSY0_ENABLE                      _MK_ENUM_CONST(1)

// 1 = FIFO underrun interrupt 
#define NAND_IER_0_IE_UND_SHIFT                 _MK_SHIFT_CONST(7)
#define NAND_IER_0_IE_UND_FIELD                 (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_UND_SHIFT)
#define NAND_IER_0_IE_UND_RANGE                 7:7
#define NAND_IER_0_IE_UND_WOFFSET                       0x0
#define NAND_IER_0_IE_UND_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_UND_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_UND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_UND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_UND_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_UND_ENABLE                        _MK_ENUM_CONST(1)

// 1 = FIFO overrun interupt 
#define NAND_IER_0_IE_OVR_SHIFT                 _MK_SHIFT_CONST(6)
#define NAND_IER_0_IE_OVR_FIELD                 (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_OVR_SHIFT)
#define NAND_IER_0_IE_OVR_RANGE                 6:6
#define NAND_IER_0_IE_OVR_WOFFSET                       0x0
#define NAND_IER_0_IE_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_OVR_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_OVR_ENABLE                        _MK_ENUM_CONST(1)

// 1 = Command operations are completed as per NAND  
//     command register settings.
#define NAND_IER_0_IE_CMD_DONE_SHIFT                    _MK_SHIFT_CONST(5)
#define NAND_IER_0_IE_CMD_DONE_FIELD                    (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_CMD_DONE_SHIFT)
#define NAND_IER_0_IE_CMD_DONE_RANGE                    5:5
#define NAND_IER_0_IE_CMD_DONE_WOFFSET                  0x0
#define NAND_IER_0_IE_CMD_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_CMD_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_CMD_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_CMD_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_CMD_DONE_DISABLE                  _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_CMD_DONE_ENABLE                   _MK_ENUM_CONST(1)

// 1 = ECC error interrupt 
// please refer to IS_ECC_ERR above for interrupt event
// details
#define NAND_IER_0_IE_ECC_ERR_SHIFT                     _MK_SHIFT_CONST(4)
#define NAND_IER_0_IE_ECC_ERR_FIELD                     (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_ECC_ERR_SHIFT)
#define NAND_IER_0_IE_ECC_ERR_RANGE                     4:4
#define NAND_IER_0_IE_ECC_ERR_WOFFSET                   0x0
#define NAND_IER_0_IE_ECC_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_ECC_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_ECC_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_ECC_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_ECC_ERR_DISABLE                   _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_ECC_ERR_ENABLE                    _MK_ENUM_CONST(1)

// Command queue execution completion interrupt
#define NAND_IER_0_IE_LL_DONE_SHIFT                     _MK_SHIFT_CONST(3)
#define NAND_IER_0_IE_LL_DONE_FIELD                     (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_LL_DONE_SHIFT)
#define NAND_IER_0_IE_LL_DONE_RANGE                     3:3
#define NAND_IER_0_IE_LL_DONE_WOFFSET                   0x0
#define NAND_IER_0_IE_LL_DONE_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_LL_DONE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_LL_DONE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_LL_DONE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_LL_DONE_DISABLE                   _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_LL_DONE_ENABLE                    _MK_ENUM_CONST(1)

// Flash errors in Command queue  execution interrupt
#define NAND_IER_0_IE_LL_ERR_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_IER_0_IE_LL_ERR_FIELD                      (_MK_MASK_CONST(0x1) << NAND_IER_0_IE_LL_ERR_SHIFT)
#define NAND_IER_0_IE_LL_ERR_RANGE                      2:2
#define NAND_IER_0_IE_LL_ERR_WOFFSET                    0x0
#define NAND_IER_0_IE_LL_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_LL_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_IER_0_IE_LL_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_LL_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_IER_0_IE_LL_ERR_DISABLE                    _MK_ENUM_CONST(0)
#define NAND_IER_0_IE_LL_ERR_ENABLE                     _MK_ENUM_CONST(1)

// 0 = Masks all of the interrupts, and interrupt to
//     signal to cpu is disabled.
#define NAND_IER_0_GIE_SHIFT                    _MK_SHIFT_CONST(0)
#define NAND_IER_0_GIE_FIELD                    (_MK_MASK_CONST(0x1) << NAND_IER_0_GIE_SHIFT)
#define NAND_IER_0_GIE_RANGE                    0:0
#define NAND_IER_0_GIE_WOFFSET                  0x0
#define NAND_IER_0_GIE_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_GIE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_IER_0_GIE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_IER_0_GIE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_IER_0_GIE_DISABLE                  _MK_ENUM_CONST(0)
#define NAND_IER_0_GIE_ENABLE                   _MK_ENUM_CONST(1)


// Register NAND_CONFIG_0  
#define NAND_CONFIG_0                   _MK_ADDR_CONST(0x10)
#define NAND_CONFIG_0_SECURE                    0x0
#define NAND_CONFIG_0_WORD_COUNT                        0x1
#define NAND_CONFIG_0_RESET_VAL                         _MK_MASK_CONST(0x10030000)
#define NAND_CONFIG_0_RESET_MASK                        _MK_MASK_CONST(0xfbffffff)
#define NAND_CONFIG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_READ_MASK                         _MK_MASK_CONST(0xfbffffff)
#define NAND_CONFIG_0_WRITE_MASK                        _MK_MASK_CONST(0xfbffffff)
// HW Error detection enable for Main page read data
#define NAND_CONFIG_0_HW_ECC_SHIFT                      _MK_SHIFT_CONST(31)
#define NAND_CONFIG_0_HW_ECC_FIELD                      (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_HW_ECC_SHIFT)
#define NAND_CONFIG_0_HW_ECC_RANGE                      31:31
#define NAND_CONFIG_0_HW_ECC_WOFFSET                    0x0
#define NAND_CONFIG_0_HW_ECC_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_HW_ECC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_HW_ECC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_HW_ECC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_HW_ECC_DISABLE                    _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_HW_ECC_ENABLE                     _MK_ENUM_CONST(1)

// HE Error detection algorithm selection
#define NAND_CONFIG_0_ECC_SEL_SHIFT                     _MK_SHIFT_CONST(30)
#define NAND_CONFIG_0_ECC_SEL_FIELD                     (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_ECC_SEL_SHIFT)
#define NAND_CONFIG_0_ECC_SEL_RANGE                     30:30
#define NAND_CONFIG_0_ECC_SEL_WOFFSET                   0x0
#define NAND_CONFIG_0_ECC_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_ECC_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_ECC_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_ECC_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_ECC_SEL_HAMMING                   _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_ECC_SEL_RS                        _MK_ENUM_CONST(1)

// Enable Auto HW correction. Emulates SW behavior of reading the error 
// vectors from system buffer as pointed in the error vector address register,
// applies correction and updates the memory word with corrected data.
// This is done on page basis as soon as the decode information is avialable
// as the flash read is placed in memory.
#define NAND_CONFIG_0_HW_ERR_CORRECTION_SHIFT                   _MK_SHIFT_CONST(29)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_FIELD                   (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_HW_ERR_CORRECTION_SHIFT)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_RANGE                   29:29
#define NAND_CONFIG_0_HW_ERR_CORRECTION_WOFFSET                 0x0
#define NAND_CONFIG_0_HW_ERR_CORRECTION_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_DISABLE                 _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_HW_ERR_CORRECTION_ENABLE                  _MK_ENUM_CONST(1)

// Enable next page flash READ data transfer even before current page ECC 
// Decode is completed. If disabled, new page READ is started  only 
// after the previous page flash read, ECC decode(detection) are completed.
#define NAND_CONFIG_0_PIPELINE_EN_SHIFT                 _MK_SHIFT_CONST(28)
#define NAND_CONFIG_0_PIPELINE_EN_FIELD                 (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_PIPELINE_EN_SHIFT)
#define NAND_CONFIG_0_PIPELINE_EN_RANGE                 28:28
#define NAND_CONFIG_0_PIPELINE_EN_WOFFSET                       0x0
#define NAND_CONFIG_0_PIPELINE_EN_DEFAULT                       _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_PIPELINE_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_PIPELINE_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_PIPELINE_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_PIPELINE_EN_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_PIPELINE_EN_ENABLE                        _MK_ENUM_CONST(1)

// HW Error detection enable for Spare read data
#define NAND_CONFIG_0_ECC_EN_TAG_SHIFT                  _MK_SHIFT_CONST(27)
#define NAND_CONFIG_0_ECC_EN_TAG_FIELD                  (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_ECC_EN_TAG_SHIFT)
#define NAND_CONFIG_0_ECC_EN_TAG_RANGE                  27:27
#define NAND_CONFIG_0_ECC_EN_TAG_WOFFSET                        0x0
#define NAND_CONFIG_0_ECC_EN_TAG_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_ECC_EN_TAG_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_ECC_EN_TAG_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_ECC_EN_TAG_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_ECC_EN_TAG_DISABLE                        _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_ECC_EN_TAG_ENABLE                 _MK_ENUM_CONST(1)

// HW Error correction algorithm tValue for RS EDC selction  11 = Rsvd
#define NAND_CONFIG_0_TVALUE_SHIFT                      _MK_SHIFT_CONST(24)
#define NAND_CONFIG_0_TVALUE_FIELD                      (_MK_MASK_CONST(0x3) << NAND_CONFIG_0_TVALUE_SHIFT)
#define NAND_CONFIG_0_TVALUE_RANGE                      25:24
#define NAND_CONFIG_0_TVALUE_WOFFSET                    0x0
#define NAND_CONFIG_0_TVALUE_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_TVALUE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define NAND_CONFIG_0_TVALUE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_TVALUE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_TVALUE_TVAL4                      _MK_ENUM_CONST(0)    // // (t=4) 4 bit error correction per each 512 bytes of data

#define NAND_CONFIG_0_TVALUE_TVAL6                      _MK_ENUM_CONST(1)    // // (t=6) 6 bit error correction per each 512 bytes of data

#define NAND_CONFIG_0_TVALUE_TVAL8                      _MK_ENUM_CONST(2)    // // (t=8) 8 bit error correction per each 512 bytes of data

#define NAND_CONFIG_0_TVALUE_TVAL_RSVD                  _MK_ENUM_CONST(3)

// Skip spare region in flash to start read/write bytes after 
// completing the main area transfer.
// SKIP_SPAE_SEL below indicates how many bytes in spare
// area of flash to be skipped over either for reading/writing
// all spare access will offset to this.
#define NAND_CONFIG_0_SKIP_SPARE_SHIFT                  _MK_SHIFT_CONST(23)
#define NAND_CONFIG_0_SKIP_SPARE_FIELD                  (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_SKIP_SPARE_SHIFT)
#define NAND_CONFIG_0_SKIP_SPARE_RANGE                  23:23
#define NAND_CONFIG_0_SKIP_SPARE_WOFFSET                        0x0
#define NAND_CONFIG_0_SKIP_SPARE_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SKIP_SPARE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_SKIP_SPARE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SKIP_SPARE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SKIP_SPARE_DISABLE                        _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_SKIP_SPARE_ENABLE                 _MK_ENUM_CONST(1)

//  RBSY0 is from Flash card 0
#define NAND_CONFIG_0_COM_BSY_SHIFT                     _MK_SHIFT_CONST(22)
#define NAND_CONFIG_0_COM_BSY_FIELD                     (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_COM_BSY_SHIFT)
#define NAND_CONFIG_0_COM_BSY_RANGE                     22:22
#define NAND_CONFIG_0_COM_BSY_WOFFSET                   0x0
#define NAND_CONFIG_0_COM_BSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_COM_BSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_COM_BSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_COM_BSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_COM_BSY_DISABLE                   _MK_ENUM_CONST(0)    // // RBSY0 seen by HW is wired AND of all flash cards connected

#define NAND_CONFIG_0_COM_BSY_ENABLE                    _MK_ENUM_CONST(1)

//Flash read/write databus width selection Datsbus width 8-bit
#define NAND_CONFIG_0_BUS_WIDTH_SHIFT                   _MK_SHIFT_CONST(21)
#define NAND_CONFIG_0_BUS_WIDTH_FIELD                   (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_BUS_WIDTH_SHIFT)
#define NAND_CONFIG_0_BUS_WIDTH_RANGE                   21:21
#define NAND_CONFIG_0_BUS_WIDTH_WOFFSET                 0x0
#define NAND_CONFIG_0_BUS_WIDTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_BUS_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_BUS_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_BUS_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_BUS_WIDTH_BUS_WIDTH_8                     _MK_ENUM_CONST(0)    // // Databus width 16-bit

#define NAND_CONFIG_0_BUS_WIDTH_BUS_WIDTH_16                    _MK_ENUM_CONST(1)

// LPDDR1 mode of pin ordering Pin ordering to be package friendly with LPDDR1
#define NAND_CONFIG_0_LPDDR1_MODE_SHIFT                 _MK_SHIFT_CONST(20)
#define NAND_CONFIG_0_LPDDR1_MODE_FIELD                 (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_LPDDR1_MODE_SHIFT)
#define NAND_CONFIG_0_LPDDR1_MODE_RANGE                 20:20
#define NAND_CONFIG_0_LPDDR1_MODE_WOFFSET                       0x0
#define NAND_CONFIG_0_LPDDR1_MODE_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_LPDDR1_MODE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_LPDDR1_MODE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_LPDDR1_MODE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_LPDDR1_MODE_DISABLE                       _MK_ENUM_CONST(0)    // // Standard mode of pin ordering

#define NAND_CONFIG_0_LPDDR1_MODE_ENABLE                        _MK_ENUM_CONST(1)

// EDO mode of flash read data sampling sampled on posedge of REN 
#define NAND_CONFIG_0_EDO_MODE_SHIFT                    _MK_SHIFT_CONST(19)
#define NAND_CONFIG_0_EDO_MODE_FIELD                    (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_EDO_MODE_SHIFT)
#define NAND_CONFIG_0_EDO_MODE_RANGE                    19:19
#define NAND_CONFIG_0_EDO_MODE_WOFFSET                  0x0
#define NAND_CONFIG_0_EDO_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_EDO_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_EDO_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_EDO_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_EDO_MODE_DISABLE                  _MK_ENUM_CONST(0)    // // sampled on completion of read cycle time

#define NAND_CONFIG_0_EDO_MODE_ENABLE                   _MK_ENUM_CONST(1)

// Page size selection - depends on Flash used.
#define NAND_CONFIG_0_PAGE_SIZE_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_FIELD                       (_MK_MASK_CONST(0x7) << NAND_CONFIG_0_PAGE_SIZE_SEL_SHIFT)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_RANGE                       18:16
#define NAND_CONFIG_0_PAGE_SIZE_SEL_WOFFSET                     0x0
#define NAND_CONFIG_0_PAGE_SIZE_SEL_DEFAULT                     _MK_MASK_CONST(0x3)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_256                       _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_512                       _MK_ENUM_CONST(1)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_1024                      _MK_ENUM_CONST(2)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_2048                      _MK_ENUM_CONST(3)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_4096                      _MK_ENUM_CONST(4)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_RSVD1                     _MK_ENUM_CONST(5)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_RSVD2                     _MK_ENUM_CONST(6)
#define NAND_CONFIG_0_PAGE_SIZE_SEL_PAGE_SIZE_RSVD3                     _MK_ENUM_CONST(7)

// Size in granularity of 4 bytes to skippedd for spare access
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SHIFT                      _MK_SHIFT_CONST(14)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_FIELD                      (_MK_MASK_CONST(0x3) << NAND_CONFIG_0_SKIP_SPARE_SEL_SHIFT)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_RANGE                      15:14
#define NAND_CONFIG_0_SKIP_SPARE_SEL_WOFFSET                    0x0
#define NAND_CONFIG_0_SKIP_SPARE_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SKIP_SPARE_SIZE_4                  _MK_ENUM_CONST(0)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SKIP_SPARE_SIZE_8                  _MK_ENUM_CONST(1)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SKIP_SPARE_SIZE_12                 _MK_ENUM_CONST(2)
#define NAND_CONFIG_0_SKIP_SPARE_SEL_SKIP_SPARE_SIZE_16                 _MK_ENUM_CONST(3)

// Debug mode selection for HW debug
#define NAND_CONFIG_0_DEBUG_MODE_SHIFT                  _MK_SHIFT_CONST(13)
#define NAND_CONFIG_0_DEBUG_MODE_FIELD                  (_MK_MASK_CONST(0x1) << NAND_CONFIG_0_DEBUG_MODE_SHIFT)
#define NAND_CONFIG_0_DEBUG_MODE_RANGE                  13:13
#define NAND_CONFIG_0_DEBUG_MODE_WOFFSET                        0x0
#define NAND_CONFIG_0_DEBUG_MODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_DEBUG_MODE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define NAND_CONFIG_0_DEBUG_MODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_DEBUG_MODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Debug selection for HW debug
#define NAND_CONFIG_0_DEBUG_SEL_SHIFT                   _MK_SHIFT_CONST(9)
#define NAND_CONFIG_0_DEBUG_SEL_FIELD                   (_MK_MASK_CONST(0xf) << NAND_CONFIG_0_DEBUG_SEL_SHIFT)
#define NAND_CONFIG_0_DEBUG_SEL_RANGE                   12:9
#define NAND_CONFIG_0_DEBUG_SEL_WOFFSET                 0x0
#define NAND_CONFIG_0_DEBUG_SEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_DEBUG_SEL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define NAND_CONFIG_0_DEBUG_SEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_DEBUG_SEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Block Size in Bytes for TAG  data from spare area of flash.
// This is used for specifying the size of the TAG Block data byets 
// to be move/from to spare area. Used when B_VALID is true.
// Specified in Bytes (n-1 encoding)
#define NAND_CONFIG_0_TAG_BYTE_SIZE_SHIFT                       _MK_SHIFT_CONST(0)
#define NAND_CONFIG_0_TAG_BYTE_SIZE_FIELD                       (_MK_MASK_CONST(0x1ff) << NAND_CONFIG_0_TAG_BYTE_SIZE_SHIFT)
#define NAND_CONFIG_0_TAG_BYTE_SIZE_RANGE                       8:0
#define NAND_CONFIG_0_TAG_BYTE_SIZE_WOFFSET                     0x0
#define NAND_CONFIG_0_TAG_BYTE_SIZE_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_TAG_BYTE_SIZE_DEFAULT_MASK                        _MK_MASK_CONST(0x1ff)
#define NAND_CONFIG_0_TAG_BYTE_SIZE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_CONFIG_0_TAG_BYTE_SIZE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register NAND_TIMING_0  
#define NAND_TIMING_0                   _MK_ADDR_CONST(0x14)
#define NAND_TIMING_0_SECURE                    0x0
#define NAND_TIMING_0_WORD_COUNT                        0x1
#define NAND_TIMING_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_TIMING_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_TIMING_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Read pulse width(RE Low time)timing for status read cycles 
// Generated timing = (n+1) * NAND_CLK_PERIOD ns,
// 
// -----------------------------------------------------------------------------
// GUIDELINE: for tRP_RESP/tRP timing 
// -----------------------------------------------------------------------------
//        
// non-EDO mode: Max(tRP, tREA) timing + 6ns (round trip delay) 
// EDO mode:     tRP timing from flash datasheet
//
// Notes: 
// (1)"round trip delay" to account for - REN out PAD delay + REN out board delay 
//        + DATA driven OUT from flash to chip input + DATA INPUT pad delay. 
//
//    Based on AP15 timings, PAD delays attribute to 4ns and rest
//    2ns is estimated for board delays. If it's more than one need to 
//    increase the "round trip delay" number to come up 
//    with "tRP/TRP_RESP" timing requirement. 
// (2)For EDO modes - since controller latches data without regard 
//    to `nRE' (REN) posedge tREA, round trip delay factors need not 
//    be considered. 
#define NAND_TIMING_0_TRP_RESP_CNT_SHIFT                        _MK_SHIFT_CONST(28)
#define NAND_TIMING_0_TRP_RESP_CNT_FIELD                        (_MK_MASK_CONST(0xf) << NAND_TIMING_0_TRP_RESP_CNT_SHIFT)
#define NAND_TIMING_0_TRP_RESP_CNT_RANGE                        31:28
#define NAND_TIMING_0_TRP_RESP_CNT_WOFFSET                      0x0
#define NAND_TIMING_0_TRP_RESP_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TRP_RESP_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define NAND_TIMING_0_TRP_RESP_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TRP_RESP_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// WE High to RBSY low asserted (by flash) timing
// Generated timing = (n+1) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Refer to tWB timing from flash datasheet
// -----------------------------------------------------------------------------
#define NAND_TIMING_0_TWB_CNT_SHIFT                     _MK_SHIFT_CONST(24)
#define NAND_TIMING_0_TWB_CNT_FIELD                     (_MK_MASK_CONST(0xf) << NAND_TIMING_0_TWB_CNT_SHIFT)
#define NAND_TIMING_0_TWB_CNT_RANGE                     27:24
#define NAND_TIMING_0_TWB_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TWB_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWB_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define NAND_TIMING_0_TWB_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWB_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// RBSY High to RE low timing
// Generated timing = (n+3) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Program Max(tCR, tAR, tRR) timings from flash data sheet
// -----------------------------------------------------------------------------
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_SHIFT                     _MK_SHIFT_CONST(20)
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_FIELD                     (_MK_MASK_CONST(0xf) << NAND_TIMING_0_TCR_TAR_TRR_CNT_SHIFT)
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_RANGE                     23:20
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TCR_TAR_TRR_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// WE High to RE Low timing - Status Read Cycles
// Generated timing = (n+1) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Refer to tWHR timing from flash data sheet
// -----------------------------------------------------------------------------
#define NAND_TIMING_0_TWHR_CNT_SHIFT                    _MK_SHIFT_CONST(16)
#define NAND_TIMING_0_TWHR_CNT_FIELD                    (_MK_MASK_CONST(0xf) << NAND_TIMING_0_TWHR_CNT_SHIFT)
#define NAND_TIMING_0_TWHR_CNT_RANGE                    19:16
#define NAND_TIMING_0_TWHR_CNT_WOFFSET                  0x0
#define NAND_TIMING_0_TWHR_CNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWHR_CNT_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define NAND_TIMING_0_TWHR_CNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWHR_CNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// CS/CLE/ALE Setup/Hold time.
// Generated timing: 
// tCLS/tALS/tCS [for setup timing] = [tCS_CNT + tWP CNT + 2 ] * NAND_CLK_PERIOD 
// tCLH/tALH/tCH [for hold timing]  = [tCS_CNT + tWH CNT + 3 ] * NAND_CLK_PERIO
// -----------------------------------------------------------------------------
// GUIDELINE: Program for Max(tCS, tCH, tALS, tALH, tCLS, TCLH) timings from 
//            flash datasheet
// -----------------------------------------------------------------------------
// This timing is met timing requirements.
// 1. from CE Low -> WE posedge of CLE/ALE.
// 2. from WE posedge of CLE to-> WE posedge of ALE.
#define NAND_TIMING_0_TCS_CNT_SHIFT                     _MK_SHIFT_CONST(14)
#define NAND_TIMING_0_TCS_CNT_FIELD                     (_MK_MASK_CONST(0x3) << NAND_TIMING_0_TCS_CNT_SHIFT)
#define NAND_TIMING_0_TCS_CNT_RANGE                     15:14
#define NAND_TIMING_0_TCS_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TCS_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TCS_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define NAND_TIMING_0_TCS_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TCS_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Write pulse HOLD time
// Generated timing = (n+1) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Refer to tWH timing from flash datasheet
// -----------------------------------------------------------------------------
#define NAND_TIMING_0_TWH_CNT_SHIFT                     _MK_SHIFT_CONST(12)
#define NAND_TIMING_0_TWH_CNT_FIELD                     (_MK_MASK_CONST(0x3) << NAND_TIMING_0_TWH_CNT_SHIFT)
#define NAND_TIMING_0_TWH_CNT_RANGE                     13:12
#define NAND_TIMING_0_TWH_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TWH_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWH_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define NAND_TIMING_0_TWH_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWH_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Write pulse width time
// Generated timing = (n+1) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Refer to tWP timing from flash datasheet
// -----------------------------------------------------------------------------
#define NAND_TIMING_0_TWP_CNT_SHIFT                     _MK_SHIFT_CONST(8)
#define NAND_TIMING_0_TWP_CNT_FIELD                     (_MK_MASK_CONST(0xf) << NAND_TIMING_0_TWP_CNT_SHIFT)
#define NAND_TIMING_0_TWP_CNT_RANGE                     11:8
#define NAND_TIMING_0_TWP_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TWP_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWP_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define NAND_TIMING_0_TWP_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TWP_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define NAND_TIMING_0_NA1_SHIFT                 _MK_SHIFT_CONST(6)
#define NAND_TIMING_0_NA1_FIELD                 (_MK_MASK_CONST(0x3) << NAND_TIMING_0_NA1_SHIFT)
#define NAND_TIMING_0_NA1_RANGE                 7:6
#define NAND_TIMING_0_NA1_WOFFSET                       0x0
#define NAND_TIMING_0_NA1_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_NA1_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define NAND_TIMING_0_NA1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_NA1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Read pulse HOLD time
// Generated timing = (n+1) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Refer to tRH timing from flash datasheet
// -----------------------------------------------------------------------------
#define NAND_TIMING_0_TRH_CNT_SHIFT                     _MK_SHIFT_CONST(4)
#define NAND_TIMING_0_TRH_CNT_FIELD                     (_MK_MASK_CONST(0x3) << NAND_TIMING_0_TRH_CNT_SHIFT)
#define NAND_TIMING_0_TRH_CNT_RANGE                     5:4
#define NAND_TIMING_0_TRH_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TRH_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TRH_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define NAND_TIMING_0_TRH_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TRH_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Read pulse width(RE Low time)timing for Data read cycles 
// Generated timing = (n+1) * NAND_CLKS,
// 
// where n - value programmed in the tRP_RESP_CNT field of timing register.
//
// -----------------------------------------------------------------------------
// GUIDELINE: tRP_RESP/tRP timing register programming  
// -----------------------------------------------------------------------------
// non-EDO mode: Max(tRP, tREA) timing + 6ns (round trip delay) 
// EDO mode:     tRP timing 
//Notes: 
// (1) "round trip delay" to account for - REN out PAD delay + REN out board delay 
//     + DATA driven OUT from flash to chip input + DATA INPUT pad delay. 
//     Based on AP15 timings, PAD delays attribute to 4ns and rest
//     2ns is estimated for board delays. If it's more than one need to 
//     increase the "round trip delay" number to come up 
//     with "tRP/TRP_RESP" timing requirement. 
// (2) For EDO modes - since controller latches data without regard 
//     to `nRE' (REN) posedge tREA, round trip delay factors need not 
//     be considered. 
#define NAND_TIMING_0_TRP_CNT_SHIFT                     _MK_SHIFT_CONST(0)
#define NAND_TIMING_0_TRP_CNT_FIELD                     (_MK_MASK_CONST(0xf) << NAND_TIMING_0_TRP_CNT_SHIFT)
#define NAND_TIMING_0_TRP_CNT_RANGE                     3:0
#define NAND_TIMING_0_TRP_CNT_WOFFSET                   0x0
#define NAND_TIMING_0_TRP_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TRP_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define NAND_TIMING_0_TRP_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_TIMING_0_TRP_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register NAND_RESP_0  
#define NAND_RESP_0                     _MK_ADDR_CONST(0x18)
#define NAND_RESP_0_SECURE                      0x0
#define NAND_RESP_0_WORD_COUNT                  0x1
#define NAND_RESP_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define NAND_RESP_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define NAND_RESP_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define NAND_RESP_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_RESP_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define NAND_RESP_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Write/Response data byte 3 (MSB)
#define NAND_RESP_0_BYTE3_SHIFT                 _MK_SHIFT_CONST(24)
#define NAND_RESP_0_BYTE3_FIELD                 (_MK_MASK_CONST(0xff) << NAND_RESP_0_BYTE3_SHIFT)
#define NAND_RESP_0_BYTE3_RANGE                 31:24
#define NAND_RESP_0_BYTE3_WOFFSET                       0x0
#define NAND_RESP_0_BYTE3_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_RESP_0_BYTE3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Write/Response data byte 2
#define NAND_RESP_0_BYTE2_SHIFT                 _MK_SHIFT_CONST(16)
#define NAND_RESP_0_BYTE2_FIELD                 (_MK_MASK_CONST(0xff) << NAND_RESP_0_BYTE2_SHIFT)
#define NAND_RESP_0_BYTE2_RANGE                 23:16
#define NAND_RESP_0_BYTE2_WOFFSET                       0x0
#define NAND_RESP_0_BYTE2_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_RESP_0_BYTE2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Write/Response data byte 1
#define NAND_RESP_0_BYTE1_SHIFT                 _MK_SHIFT_CONST(8)
#define NAND_RESP_0_BYTE1_FIELD                 (_MK_MASK_CONST(0xff) << NAND_RESP_0_BYTE1_SHIFT)
#define NAND_RESP_0_BYTE1_RANGE                 15:8
#define NAND_RESP_0_BYTE1_WOFFSET                       0x0
#define NAND_RESP_0_BYTE1_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_RESP_0_BYTE1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Write/Response data byte 0 (LSB)
#define NAND_RESP_0_BYTE0_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_RESP_0_BYTE0_FIELD                 (_MK_MASK_CONST(0xff) << NAND_RESP_0_BYTE0_SHIFT)
#define NAND_RESP_0_BYTE0_RANGE                 7:0
#define NAND_RESP_0_BYTE0_WOFFSET                       0x0
#define NAND_RESP_0_BYTE0_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_RESP_0_BYTE0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_RESP_0_BYTE0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register NAND_TIMING2_0  
#define NAND_TIMING2_0                  _MK_ADDR_CONST(0x1c)
#define NAND_TIMING2_0_SECURE                   0x0
#define NAND_TIMING2_0_WORD_COUNT                       0x1
#define NAND_TIMING2_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_TIMING2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_TIMING2_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_TIMING2_0_NA1_SHIFT                        _MK_SHIFT_CONST(4)
#define NAND_TIMING2_0_NA1_FIELD                        (_MK_MASK_CONST(0xfffffff) << NAND_TIMING2_0_NA1_SHIFT)
#define NAND_TIMING2_0_NA1_RANGE                        31:4
#define NAND_TIMING2_0_NA1_WOFFSET                      0x0
#define NAND_TIMING2_0_NA1_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_NA1_DEFAULT_MASK                 _MK_MASK_CONST(0xfffffff)
#define NAND_TIMING2_0_NA1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_NA1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// WE posedge of address cycle to WE posedge of data cycle
//
// Generated timing = (n+3) * NAND_CLK_PERIOD ns.
// -----------------------------------------------------------------------------
// GUIDELINE: Refer to tADL timing from flash datasheet
// -----------------------------------------------------------------------------
//
// Please note that timing generated from controller is for the duration from 
// ALE low to WP low. In the convention of flash vendor tADL timing
// this amounts to = (n+3)*NAND_CLK_PERIOD + tWH(previous address cycle)
//                                         + tWP(following data cycle).
// 
#define NAND_TIMING2_0_TADL_CNT_SHIFT                   _MK_SHIFT_CONST(0)
#define NAND_TIMING2_0_TADL_CNT_FIELD                   (_MK_MASK_CONST(0xf) << NAND_TIMING2_0_TADL_CNT_SHIFT)
#define NAND_TIMING2_0_TADL_CNT_RANGE                   3:0
#define NAND_TIMING2_0_TADL_CNT_WOFFSET                 0x0
#define NAND_TIMING2_0_TADL_CNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_TADL_CNT_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define NAND_TIMING2_0_TADL_CNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_TIMING2_0_TADL_CNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register NAND_CMD_REG1_0  // Commmand cycle generation use these during COMMAND1 time
#define NAND_CMD_REG1_0                 _MK_ADDR_CONST(0x20)
#define NAND_CMD_REG1_0_SECURE                  0x0
#define NAND_CMD_REG1_0_WORD_COUNT                      0x1
#define NAND_CMD_REG1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_CMD_REG1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_CMD_REG1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Command byte 3(MSB)
#define NAND_CMD_REG1_0_CMD_BYTE3_SHIFT                 _MK_SHIFT_CONST(24)
#define NAND_CMD_REG1_0_CMD_BYTE3_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG1_0_CMD_BYTE3_SHIFT)
#define NAND_CMD_REG1_0_CMD_BYTE3_RANGE                 31:24
#define NAND_CMD_REG1_0_CMD_BYTE3_WOFFSET                       0x0
#define NAND_CMD_REG1_0_CMD_BYTE3_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG1_0_CMD_BYTE3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Command byte 2
#define NAND_CMD_REG1_0_CMD_BYTE2_SHIFT                 _MK_SHIFT_CONST(16)
#define NAND_CMD_REG1_0_CMD_BYTE2_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG1_0_CMD_BYTE2_SHIFT)
#define NAND_CMD_REG1_0_CMD_BYTE2_RANGE                 23:16
#define NAND_CMD_REG1_0_CMD_BYTE2_WOFFSET                       0x0
#define NAND_CMD_REG1_0_CMD_BYTE2_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG1_0_CMD_BYTE2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Command byte 1
#define NAND_CMD_REG1_0_CMD_BYTE1_SHIFT                 _MK_SHIFT_CONST(8)
#define NAND_CMD_REG1_0_CMD_BYTE1_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG1_0_CMD_BYTE1_SHIFT)
#define NAND_CMD_REG1_0_CMD_BYTE1_RANGE                 15:8
#define NAND_CMD_REG1_0_CMD_BYTE1_WOFFSET                       0x0
#define NAND_CMD_REG1_0_CMD_BYTE1_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG1_0_CMD_BYTE1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Command byte 0(LSB)
#define NAND_CMD_REG1_0_CMD_BYTE0_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_CMD_REG1_0_CMD_BYTE0_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG1_0_CMD_BYTE0_SHIFT)
#define NAND_CMD_REG1_0_CMD_BYTE0_RANGE                 7:0
#define NAND_CMD_REG1_0_CMD_BYTE0_WOFFSET                       0x0
#define NAND_CMD_REG1_0_CMD_BYTE0_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG1_0_CMD_BYTE0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG1_0_CMD_BYTE0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register NAND_CMD_REG2_0  // Commmand cycle generation use these during COMMAND2 time
#define NAND_CMD_REG2_0                 _MK_ADDR_CONST(0x24)
#define NAND_CMD_REG2_0_SECURE                  0x0
#define NAND_CMD_REG2_0_WORD_COUNT                      0x1
#define NAND_CMD_REG2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_CMD_REG2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_CMD_REG2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Command byte 3(MSB)
#define NAND_CMD_REG2_0_CMD_BYTE3_SHIFT                 _MK_SHIFT_CONST(24)
#define NAND_CMD_REG2_0_CMD_BYTE3_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG2_0_CMD_BYTE3_SHIFT)
#define NAND_CMD_REG2_0_CMD_BYTE3_RANGE                 31:24
#define NAND_CMD_REG2_0_CMD_BYTE3_WOFFSET                       0x0
#define NAND_CMD_REG2_0_CMD_BYTE3_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG2_0_CMD_BYTE3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Command byte 2
#define NAND_CMD_REG2_0_CMD_BYTE2_SHIFT                 _MK_SHIFT_CONST(16)
#define NAND_CMD_REG2_0_CMD_BYTE2_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG2_0_CMD_BYTE2_SHIFT)
#define NAND_CMD_REG2_0_CMD_BYTE2_RANGE                 23:16
#define NAND_CMD_REG2_0_CMD_BYTE2_WOFFSET                       0x0
#define NAND_CMD_REG2_0_CMD_BYTE2_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG2_0_CMD_BYTE2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Command byte 1
#define NAND_CMD_REG2_0_CMD_BYTE1_SHIFT                 _MK_SHIFT_CONST(8)
#define NAND_CMD_REG2_0_CMD_BYTE1_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG2_0_CMD_BYTE1_SHIFT)
#define NAND_CMD_REG2_0_CMD_BYTE1_RANGE                 15:8
#define NAND_CMD_REG2_0_CMD_BYTE1_WOFFSET                       0x0
#define NAND_CMD_REG2_0_CMD_BYTE1_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG2_0_CMD_BYTE1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Command byte 0(LSB)
#define NAND_CMD_REG2_0_CMD_BYTE0_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_CMD_REG2_0_CMD_BYTE0_FIELD                 (_MK_MASK_CONST(0xff) << NAND_CMD_REG2_0_CMD_BYTE0_SHIFT)
#define NAND_CMD_REG2_0_CMD_BYTE0_RANGE                 7:0
#define NAND_CMD_REG2_0_CMD_BYTE0_WOFFSET                       0x0
#define NAND_CMD_REG2_0_CMD_BYTE0_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_CMD_REG2_0_CMD_BYTE0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_CMD_REG2_0_CMD_BYTE0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register NAND_ADDR_REG1_0  // Adderss cycle generation use these bytes 
#define NAND_ADDR_REG1_0                        _MK_ADDR_CONST(0x28)
#define NAND_ADDR_REG1_0_SECURE                         0x0
#define NAND_ADDR_REG1_0_WORD_COUNT                     0x1
#define NAND_ADDR_REG1_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define NAND_ADDR_REG1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_ADDR_REG1_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Address byte 3
#define NAND_ADDR_REG1_0_ADDR_BYTE3_SHIFT                       _MK_SHIFT_CONST(24)
#define NAND_ADDR_REG1_0_ADDR_BYTE3_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG1_0_ADDR_BYTE3_SHIFT)
#define NAND_ADDR_REG1_0_ADDR_BYTE3_RANGE                       31:24
#define NAND_ADDR_REG1_0_ADDR_BYTE3_WOFFSET                     0x0
#define NAND_ADDR_REG1_0_ADDR_BYTE3_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE3_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG1_0_ADDR_BYTE3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Address byte 2
#define NAND_ADDR_REG1_0_ADDR_BYTE2_SHIFT                       _MK_SHIFT_CONST(16)
#define NAND_ADDR_REG1_0_ADDR_BYTE2_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG1_0_ADDR_BYTE2_SHIFT)
#define NAND_ADDR_REG1_0_ADDR_BYTE2_RANGE                       23:16
#define NAND_ADDR_REG1_0_ADDR_BYTE2_WOFFSET                     0x0
#define NAND_ADDR_REG1_0_ADDR_BYTE2_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE2_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG1_0_ADDR_BYTE2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Address byte 1
#define NAND_ADDR_REG1_0_ADDR_BYTE1_SHIFT                       _MK_SHIFT_CONST(8)
#define NAND_ADDR_REG1_0_ADDR_BYTE1_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG1_0_ADDR_BYTE1_SHIFT)
#define NAND_ADDR_REG1_0_ADDR_BYTE1_RANGE                       15:8
#define NAND_ADDR_REG1_0_ADDR_BYTE1_WOFFSET                     0x0
#define NAND_ADDR_REG1_0_ADDR_BYTE1_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE1_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG1_0_ADDR_BYTE1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Address byte 0 (LSB)
#define NAND_ADDR_REG1_0_ADDR_BYTE0_SHIFT                       _MK_SHIFT_CONST(0)
#define NAND_ADDR_REG1_0_ADDR_BYTE0_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG1_0_ADDR_BYTE0_SHIFT)
#define NAND_ADDR_REG1_0_ADDR_BYTE0_RANGE                       7:0
#define NAND_ADDR_REG1_0_ADDR_BYTE0_WOFFSET                     0x0
#define NAND_ADDR_REG1_0_ADDR_BYTE0_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE0_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG1_0_ADDR_BYTE0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG1_0_ADDR_BYTE0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register NAND_ADDR_REG2_0  // Adderss cycle generation use these bytes
#define NAND_ADDR_REG2_0                        _MK_ADDR_CONST(0x2c)
#define NAND_ADDR_REG2_0_SECURE                         0x0
#define NAND_ADDR_REG2_0_WORD_COUNT                     0x1
#define NAND_ADDR_REG2_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define NAND_ADDR_REG2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_ADDR_REG2_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Address byte 3
#define NAND_ADDR_REG2_0_ADDR_BYTE7_SHIFT                       _MK_SHIFT_CONST(24)
#define NAND_ADDR_REG2_0_ADDR_BYTE7_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG2_0_ADDR_BYTE7_SHIFT)
#define NAND_ADDR_REG2_0_ADDR_BYTE7_RANGE                       31:24
#define NAND_ADDR_REG2_0_ADDR_BYTE7_WOFFSET                     0x0
#define NAND_ADDR_REG2_0_ADDR_BYTE7_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE7_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG2_0_ADDR_BYTE7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Address byte 2
#define NAND_ADDR_REG2_0_ADDR_BYTE6_SHIFT                       _MK_SHIFT_CONST(16)
#define NAND_ADDR_REG2_0_ADDR_BYTE6_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG2_0_ADDR_BYTE6_SHIFT)
#define NAND_ADDR_REG2_0_ADDR_BYTE6_RANGE                       23:16
#define NAND_ADDR_REG2_0_ADDR_BYTE6_WOFFSET                     0x0
#define NAND_ADDR_REG2_0_ADDR_BYTE6_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE6_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG2_0_ADDR_BYTE6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Address byte 1
#define NAND_ADDR_REG2_0_ADDR_BYTE5_SHIFT                       _MK_SHIFT_CONST(8)
#define NAND_ADDR_REG2_0_ADDR_BYTE5_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG2_0_ADDR_BYTE5_SHIFT)
#define NAND_ADDR_REG2_0_ADDR_BYTE5_RANGE                       15:8
#define NAND_ADDR_REG2_0_ADDR_BYTE5_WOFFSET                     0x0
#define NAND_ADDR_REG2_0_ADDR_BYTE5_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE5_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG2_0_ADDR_BYTE5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Address byte 0 (LSB)
#define NAND_ADDR_REG2_0_ADDR_BYTE4_SHIFT                       _MK_SHIFT_CONST(0)
#define NAND_ADDR_REG2_0_ADDR_BYTE4_FIELD                       (_MK_MASK_CONST(0xff) << NAND_ADDR_REG2_0_ADDR_BYTE4_SHIFT)
#define NAND_ADDR_REG2_0_ADDR_BYTE4_RANGE                       7:0
#define NAND_ADDR_REG2_0_ADDR_BYTE4_WOFFSET                     0x0
#define NAND_ADDR_REG2_0_ADDR_BYTE4_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE4_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_ADDR_REG2_0_ADDR_BYTE4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_ADDR_REG2_0_ADDR_BYTE4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register NAND_DMA_MST_CTRL_0  
#define NAND_DMA_MST_CTRL_0                     _MK_ADDR_CONST(0x30)
#define NAND_DMA_MST_CTRL_0_SECURE                      0x0
#define NAND_DMA_MST_CTRL_0_WORD_COUNT                  0x1
#define NAND_DMA_MST_CTRL_0_RESET_VAL                   _MK_MASK_CONST(0x24000000)
#define NAND_DMA_MST_CTRL_0_RESET_MASK                  _MK_MASK_CONST(0xff100006)
#define NAND_DMA_MST_CTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_READ_MASK                   _MK_MASK_CONST(0xff100006)
#define NAND_DMA_MST_CTRL_0_WRITE_MASK                  _MK_MASK_CONST(0x7f100006)
// Enable NAND DMA interface for data transfers. Auto clear type.
// HW clears when programmed length of data transfer is completed.
#define NAND_DMA_MST_CTRL_0_DMA_GO_SHIFT                        _MK_SHIFT_CONST(31)
#define NAND_DMA_MST_CTRL_0_DMA_GO_FIELD                        (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_DMA_GO_SHIFT)
#define NAND_DMA_MST_CTRL_0_DMA_GO_RANGE                        31:31
#define NAND_DMA_MST_CTRL_0_DMA_GO_WOFFSET                      0x0
#define NAND_DMA_MST_CTRL_0_DMA_GO_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_GO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_DMA_GO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_GO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_GO_DISABLE                      _MK_ENUM_CONST(0)
#define NAND_DMA_MST_CTRL_0_DMA_GO_ENABLE                       _MK_ENUM_CONST(1)

// DMA data transfer direction  Read from system and write to flash
#define NAND_DMA_MST_CTRL_0_DIR_SHIFT                   _MK_SHIFT_CONST(30)
#define NAND_DMA_MST_CTRL_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_DIR_SHIFT)
#define NAND_DMA_MST_CTRL_0_DIR_RANGE                   30:30
#define NAND_DMA_MST_CTRL_0_DIR_WOFFSET                 0x0
#define NAND_DMA_MST_CTRL_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DIR_DMA_RD                  _MK_ENUM_CONST(0)    // // Write to  system and read from flash

#define NAND_DMA_MST_CTRL_0_DIR_DMA_WR                  _MK_ENUM_CONST(1)

// DMA peformace feature enable. as soon as the Error vectors equal to BURST  SIZE programmed 
// received DMA suspends current data transfers and moves to 
// Error vector transfer and waits till that page decode is completed.
// Potentially if Error vectors are received around each 512 sub-page
// boundary  this could cause stall of next page READ data transfers 
// causing performance  degradation. To take advantage of 
// PIPELINE_EN ECC decoder pipeline  capability this should be enabled.
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_SHIFT                   _MK_SHIFT_CONST(29)
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_FIELD                   (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_DMA_PERF_EN_SHIFT)
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_RANGE                   29:29
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_WOFFSET                 0x0
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_DEFAULT                 _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_DISABLE                 _MK_ENUM_CONST(0)    // //

#define NAND_DMA_MST_CTRL_0_DMA_PERF_EN_ENABLE                  _MK_ENUM_CONST(1)

// Enable interrupt on DMA transfer completion 
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_SHIFT                   _MK_SHIFT_CONST(28)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_FIELD                   (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_IE_DMA_DONE_SHIFT)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_RANGE                   28:28
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_WOFFSET                 0x0
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_DISABLE                 _MK_ENUM_CONST(0)
#define NAND_DMA_MST_CTRL_0_IE_DMA_DONE_ENABLE                  _MK_ENUM_CONST(1)

// increments the Error Vector  destination address continuously 
// till the total DMA transfer size is done
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_SHIFT                  _MK_SHIFT_CONST(27)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_FIELD                  (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_REUSE_BUFFER_SHIFT)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_RANGE                  27:27
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_WOFFSET                        0x0
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_DISABLE                        _MK_ENUM_CONST(0)
#define NAND_DMA_MST_CTRL_0_REUSE_BUFFER_ENABLE                 _MK_ENUM_CONST(1)

// DMA burst size
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_SHIFT                    _MK_SHIFT_CONST(24)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_FIELD                    (_MK_MASK_CONST(0x7) << NAND_DMA_MST_CTRL_0_BURST_SIZE_SHIFT)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_RANGE                    26:24
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_WOFFSET                  0x0
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_DEFAULT                  _MK_MASK_CONST(0x4)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_RSVD1                      _MK_ENUM_CONST(0)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_RSVD2                      _MK_ENUM_CONST(1)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_1WORDS                     _MK_ENUM_CONST(2)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_4WORDS                     _MK_ENUM_CONST(3)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_8WORDS                     _MK_ENUM_CONST(4)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_16WORDS                    _MK_ENUM_CONST(5)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_RSVD3                      _MK_ENUM_CONST(6)
#define NAND_DMA_MST_CTRL_0_BURST_SIZE_BURST_RSVD4                      _MK_ENUM_CONST(7)

// 1 = DMA transfer completed interrupt. 
// This is set ONLY when  not running in COMMAND QUEUE MODE
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_SHIFT                   _MK_SHIFT_CONST(20)
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_FIELD                   (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_IS_DMA_DONE_SHIFT)
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_RANGE                   20:20
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_WOFFSET                 0x0
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_IS_DMA_DONE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Enable DMA transfer for Data (A) 
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_FIELD                      (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_DMA_EN_A_SHIFT)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_RANGE                      2:2
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_WOFFSET                    0x0
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_DISABLE                    _MK_ENUM_CONST(0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_A_ENABLE                     _MK_ENUM_CONST(1)

// Enable DMA transfer for TAG/Spare (B)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_FIELD                      (_MK_MASK_CONST(0x1) << NAND_DMA_MST_CTRL_0_DMA_EN_B_SHIFT)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_RANGE                      1:1
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_WOFFSET                    0x0
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_DISABLE                    _MK_ENUM_CONST(0)
#define NAND_DMA_MST_CTRL_0_DMA_EN_B_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_DMA_CFG_A_0  
#define NAND_DMA_CFG_A_0                        _MK_ADDR_CONST(0x34)
#define NAND_DMA_CFG_A_0_SECURE                         0x0
#define NAND_DMA_CFG_A_0_WORD_COUNT                     0x1
#define NAND_DMA_CFG_A_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_A_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define NAND_DMA_CFG_A_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_A_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_A_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define NAND_DMA_CFG_A_0_WRITE_MASK                     _MK_MASK_CONST(0xffff)
// DMA Data Block size in Bytes(N-1) value
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_FIELD                 (_MK_MASK_CONST(0xffff) << NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_SHIFT)
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_RANGE                 15:0
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_WOFFSET                       0x0
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_A_0_DMA_BLOCK_SIZE_A_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register NAND_DMA_CFG_B_0  
#define NAND_DMA_CFG_B_0                        _MK_ADDR_CONST(0x38)
#define NAND_DMA_CFG_B_0_SECURE                         0x0
#define NAND_DMA_CFG_B_0_WORD_COUNT                     0x1
#define NAND_DMA_CFG_B_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_B_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define NAND_DMA_CFG_B_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_B_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_B_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define NAND_DMA_CFG_B_0_WRITE_MASK                     _MK_MASK_CONST(0xffff)
// DMA TAG Block size in Bytes(N-1) value
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_FIELD                 (_MK_MASK_CONST(0xffff) << NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_SHIFT)
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_RANGE                 15:0
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_WOFFSET                       0x0
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DMA_CFG_B_0_DMA_BLOCK_SIZE_B_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register NAND_FIFO_CTRL_0  
#define NAND_FIFO_CTRL_0                        _MK_ADDR_CONST(0x3c)
#define NAND_FIFO_CTRL_0_SECURE                         0x0
#define NAND_FIFO_CTRL_0_WORD_COUNT                     0x1
#define NAND_FIFO_CTRL_0_RESET_VAL                      _MK_MASK_CONST(0xaa00)
#define NAND_FIFO_CTRL_0_RESET_MASK                     _MK_MASK_CONST(0xff0f)
#define NAND_FIFO_CTRL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_READ_MASK                      _MK_MASK_CONST(0xff0f)
#define NAND_FIFO_CTRL_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
// 1 = Indicates Command queue FIFO Empty
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_SHIFT                     _MK_SHIFT_CONST(15)
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_FIELD                     (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_LL_BUF_EMPTY_SHIFT)
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_RANGE                     15:15
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_WOFFSET                   0x0
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_DEFAULT                   _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_LL_BUF_EMPTY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 1 = Indicates Command queue FIFO Full
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_SHIFT                      _MK_SHIFT_CONST(14)
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_FIELD                      (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_LL_BUF_FULL_SHIFT)
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_RANGE                      14:14
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_WOFFSET                    0x0
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_LL_BUF_FULL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 1 = Indicates Data FIFO Empty
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_SHIFT                     _MK_SHIFT_CONST(13)
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_FIELD                     (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_A_EMPTY_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_RANGE                     13:13
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_WOFFSET                   0x0
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_DEFAULT                   _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_A_EMPTY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 1 = Indicates Data FIFO Full
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_SHIFT                      _MK_SHIFT_CONST(12)
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_FIELD                      (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_A_FULL_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_RANGE                      12:12
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_WOFFSET                    0x0
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_A_FULL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 1 = Indicates TAG FIFO Empty
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_SHIFT                     _MK_SHIFT_CONST(11)
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_FIELD                     (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_B_EMPTY_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_RANGE                     11:11
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_WOFFSET                   0x0
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_DEFAULT                   _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_B_EMPTY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 1 = Indicates TAG FIFO Full
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_SHIFT                      _MK_SHIFT_CONST(10)
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_FIELD                      (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_B_FULL_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_RANGE                      10:10
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_WOFFSET                    0x0
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_B_FULL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 1 = Indicates ECC FIFO Empty
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_SHIFT                     _MK_SHIFT_CONST(9)
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_FIELD                     (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_C_EMPTY_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_RANGE                     9:9
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_WOFFSET                   0x0
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_DEFAULT                   _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_C_EMPTY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 1 = Indicates ECC FIFO Full
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_SHIFT                      _MK_SHIFT_CONST(8)
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_FIELD                      (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_C_FULL_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_RANGE                      8:8
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_WOFFSET                    0x0
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_C_FULL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// field set to "CLEAR_ALL_FIFO" flushs all the buffers(i.e.,LL_BUF,FIFO_A,FIFO_B,FIFO_C) 
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_SHIFT                       _MK_SHIFT_CONST(3)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_FIELD                       (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_LL_BUF_CLR_SHIFT)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_RANGE                       3:3
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_WOFFSET                     0x0
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_CLEAR_NO_FIFO                       _MK_ENUM_CONST(0)
#define NAND_FIFO_CTRL_0_LL_BUF_CLR_CLEAR_ALL_FIFO                      _MK_ENUM_CONST(1)

// Flush the DATA FIFO contents
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_SHIFT                       _MK_SHIFT_CONST(2)
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_FIELD                       (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_A_CLR_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_RANGE                       2:2
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_WOFFSET                     0x0
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_A_CLR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Flush the TAG FIFO contents
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_SHIFT                       _MK_SHIFT_CONST(1)
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_FIELD                       (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_B_CLR_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_RANGE                       1:1
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_WOFFSET                     0x0
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_B_CLR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Flush the ECC FIFO contents
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_SHIFT                       _MK_SHIFT_CONST(0)
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_FIELD                       (_MK_MASK_CONST(0x1) << NAND_FIFO_CTRL_0_FIFO_C_CLR_SHIFT)
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_RANGE                       0:0
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_WOFFSET                     0x0
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_FIFO_CTRL_0_FIFO_C_CLR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register NAND_DATA_BLOCK_PTR_0  
#define NAND_DATA_BLOCK_PTR_0                   _MK_ADDR_CONST(0x40)
#define NAND_DATA_BLOCK_PTR_0_SECURE                    0x0
#define NAND_DATA_BLOCK_PTR_0_WORD_COUNT                        0x1
#define NAND_DATA_BLOCK_PTR_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_DATA_BLOCK_PTR_0_RESET_MASK                        _MK_MASK_CONST(0xfffffffc)
#define NAND_DATA_BLOCK_PTR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_DATA_BLOCK_PTR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_DATA_BLOCK_PTR_0_READ_MASK                         _MK_MASK_CONST(0xfffffffc)
#define NAND_DATA_BLOCK_PTR_0_WRITE_MASK                        _MK_MASK_CONST(0xfffffffc)
// DMA data block source/destination address pointer
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_SHIFT                  _MK_SHIFT_CONST(2)
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_FIELD                  (_MK_MASK_CONST(0x3fffffff) << NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_SHIFT)
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_RANGE                  31:2
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_WOFFSET                        0x0
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_DATA_BLOCK_PTR_0_DMA_DATA_BLOCK_PTR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register NAND_TAG_PTR_0  
#define NAND_TAG_PTR_0                  _MK_ADDR_CONST(0x44)
#define NAND_TAG_PTR_0_SECURE                   0x0
#define NAND_TAG_PTR_0_WORD_COUNT                       0x1
#define NAND_TAG_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define NAND_TAG_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define NAND_TAG_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define NAND_TAG_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_TAG_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define NAND_TAG_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// DMA TAG block source/destination address pointer
#define NAND_TAG_PTR_0_DMA_TAG_PTR_SHIFT                        _MK_SHIFT_CONST(2)
#define NAND_TAG_PTR_0_DMA_TAG_PTR_FIELD                        (_MK_MASK_CONST(0x3fffffff) << NAND_TAG_PTR_0_DMA_TAG_PTR_SHIFT)
#define NAND_TAG_PTR_0_DMA_TAG_PTR_RANGE                        31:2
#define NAND_TAG_PTR_0_DMA_TAG_PTR_WOFFSET                      0x0
#define NAND_TAG_PTR_0_DMA_TAG_PTR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_TAG_PTR_0_DMA_TAG_PTR_DEFAULT_MASK                 _MK_MASK_CONST(0x3fffffff)
#define NAND_TAG_PTR_0_DMA_TAG_PTR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_TAG_PTR_0_DMA_TAG_PTR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_ECC_PTR_0  
#define NAND_ECC_PTR_0                  _MK_ADDR_CONST(0x48)
#define NAND_ECC_PTR_0_SECURE                   0x0
#define NAND_ECC_PTR_0_WORD_COUNT                       0x1
#define NAND_ECC_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define NAND_ECC_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define NAND_ECC_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define NAND_ECC_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define NAND_ECC_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define NAND_ECC_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// DMA Error vector destination address pointer
#define NAND_ECC_PTR_0_DMA_ECC_PTR_SHIFT                        _MK_SHIFT_CONST(2)
#define NAND_ECC_PTR_0_DMA_ECC_PTR_FIELD                        (_MK_MASK_CONST(0x3fffffff) << NAND_ECC_PTR_0_DMA_ECC_PTR_SHIFT)
#define NAND_ECC_PTR_0_DMA_ECC_PTR_RANGE                        31:2
#define NAND_ECC_PTR_0_DMA_ECC_PTR_WOFFSET                      0x0
#define NAND_ECC_PTR_0_DMA_ECC_PTR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_ECC_PTR_0_DMA_ECC_PTR_DEFAULT_MASK                 _MK_MASK_CONST(0x3fffffff)
#define NAND_ECC_PTR_0_DMA_ECC_PTR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_ECC_PTR_0_DMA_ECC_PTR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_DEC_STATUS_0  
#define NAND_DEC_STATUS_0                       _MK_ADDR_CONST(0x4c)
#define NAND_DEC_STATUS_0_SECURE                        0x0
#define NAND_DEC_STATUS_0_WORD_COUNT                    0x1
#define NAND_DEC_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffff03)
#define NAND_DEC_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffff03)
#define NAND_DEC_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Indicates the reference to the PAGE for Error  Correction 
// to be applied. Valid when IS_ECC_ERROR is generated
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_SHIFT                 _MK_SHIFT_CONST(24)
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_FIELD                 (_MK_MASK_CONST(0xff) << NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_SHIFT)
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_RANGE                 31:24
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_WOFFSET                       0x0
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_ERR_PAGE_NUMBER_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// No. of Errors occurred in main block READ data  plus TAG read 
// data when corresponding features are enabled.
#define NAND_DEC_STATUS_0_ERR_COUNT_SHIFT                       _MK_SHIFT_CONST(16)
#define NAND_DEC_STATUS_0_ERR_COUNT_FIELD                       (_MK_MASK_CONST(0xff) << NAND_DEC_STATUS_0_ERR_COUNT_SHIFT)
#define NAND_DEC_STATUS_0_ERR_COUNT_RANGE                       23:16
#define NAND_DEC_STATUS_0_ERR_COUNT_WOFFSET                     0x0
#define NAND_DEC_STATUS_0_ERR_COUNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_ERR_COUNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define NAND_DEC_STATUS_0_ERR_COUNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_ERR_COUNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Indicates sub-page decode failure within a page size. 
// When decode failure is observed SW can use to figure
// out which sub-page (512 byte) decode failure. 
// for ex: of 2K page size selection,
// bit 0 - first sub-page
// bit 1 - second sub-page
// bit 2 - third sub-page
// bit 3 - fourth sub-page
// and so on as applicable
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_SHIFT                   _MK_SHIFT_CONST(8)
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_FIELD                   (_MK_MASK_CONST(0xff) << NAND_DEC_STATUS_0_SUB_PAGE_FAIL_SHIFT)
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_RANGE                   15:8
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_WOFFSET                 0x0
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_SUB_PAGE_FAIL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// 0 = Main block data decode without decode fail
#define NAND_DEC_STATUS_0_A_ECC_FAIL_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_DEC_STATUS_0_A_ECC_FAIL_FIELD                      (_MK_MASK_CONST(0x1) << NAND_DEC_STATUS_0_A_ECC_FAIL_SHIFT)
#define NAND_DEC_STATUS_0_A_ECC_FAIL_RANGE                      1:1
#define NAND_DEC_STATUS_0_A_ECC_FAIL_WOFFSET                    0x0
#define NAND_DEC_STATUS_0_A_ECC_FAIL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_A_ECC_FAIL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_DEC_STATUS_0_A_ECC_FAIL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_A_ECC_FAIL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 0 = Tag block data decode without decode fail
#define NAND_DEC_STATUS_0_B_ECC_FAIL_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_DEC_STATUS_0_B_ECC_FAIL_FIELD                      (_MK_MASK_CONST(0x1) << NAND_DEC_STATUS_0_B_ECC_FAIL_SHIFT)
#define NAND_DEC_STATUS_0_B_ECC_FAIL_RANGE                      0:0
#define NAND_DEC_STATUS_0_B_ECC_FAIL_WOFFSET                    0x0
#define NAND_DEC_STATUS_0_B_ECC_FAIL_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_B_ECC_FAIL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_DEC_STATUS_0_B_ECC_FAIL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_DEC_STATUS_0_B_ECC_FAIL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_HWSTATUS_CMD_0  
#define NAND_HWSTATUS_CMD_0                     _MK_ADDR_CONST(0x50)
#define NAND_HWSTATUS_CMD_0_SECURE                      0x0
#define NAND_HWSTATUS_CMD_0_WORD_COUNT                  0x1
#define NAND_HWSTATUS_CMD_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_CMD_0_RESET_MASK                  _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_CMD_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_CMD_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_CMD_0_READ_MASK                   _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_CMD_0_WRITE_MASK                  _MK_MASK_CONST(0xff)
// Command byte value used for READ STATUS commands  when 
// automatic HW RBSY_CHK or RD_STATUS_CHK are enabled.
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_SHIFT                  _MK_SHIFT_CONST(0)
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_FIELD                  (_MK_MASK_CONST(0xff) << NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_SHIFT)
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_RANGE                  7:0
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_WOFFSET                        0x0
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_CMD_0_HWSTATUS_CMD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register NAND_HWSTATUS_MASK_0  
#define NAND_HWSTATUS_MASK_0                    _MK_ADDR_CONST(0x54)
#define NAND_HWSTATUS_MASK_0_SECURE                     0x0
#define NAND_HWSTATUS_MASK_0_WORD_COUNT                         0x1
#define NAND_HWSTATUS_MASK_0_RESET_VAL                  _MK_MASK_CONST(0xffe04040)
#define NAND_HWSTATUS_MASK_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_HWSTATUS_MASK_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_MASK_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_MASK_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define NAND_HWSTATUS_MASK_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// 8 bit Mask value to extract the correct bit fields 
// from READ STATUS information for RD_STATUS_CHK
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_SHIFT                        _MK_SHIFT_CONST(24)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_FIELD                        (_MK_MASK_CONST(0xff) << NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_SHIFT)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_RANGE                        31:24
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_WOFFSET                      0x0
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_DEFAULT                      _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_MASK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 8 bit expected RD STATUS VALUE for RD_STATUS_CHK
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_SHIFT                     _MK_SHIFT_CONST(16)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_FIELD                     (_MK_MASK_CONST(0xff) << NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_SHIFT)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_RANGE                     23:16
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_WOFFSET                   0x0
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_DEFAULT                   _MK_MASK_CONST(0xe0)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_MASK_0_RDSTATUS_EXP_VAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 8 bit Mask value to extract the correct bit fields 
// from READ STATUS information for RBSY_CHK
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_SHIFT                    _MK_SHIFT_CONST(8)
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_FIELD                    (_MK_MASK_CONST(0xff) << NAND_HWSTATUS_MASK_0_RBSY_MASK_SHIFT)
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_RANGE                    15:8
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_WOFFSET                  0x0
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_DEFAULT                  _MK_MASK_CONST(0x40)
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_MASK_0_RBSY_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 8 bit expected RD STATUS VALUE for RBSY_CHK
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_FIELD                 (_MK_MASK_CONST(0xff) << NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_SHIFT)
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_RANGE                 7:0
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_WOFFSET                       0x0
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_DEFAULT                       _MK_MASK_CONST(0x40)
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_HWSTATUS_MASK_0_RBSY_EXP_VAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register NAND_LL_CONFIG_0  
#define NAND_LL_CONFIG_0                        _MK_ADDR_CONST(0x58)
#define NAND_LL_CONFIG_0_SECURE                         0x0
#define NAND_LL_CONFIG_0_WORD_COUNT                     0x1
#define NAND_LL_CONFIG_0_RESET_VAL                      _MK_MASK_CONST(0xc0000)
#define NAND_LL_CONFIG_0_RESET_MASK                     _MK_MASK_CONST(0x800f0fff)
#define NAND_LL_CONFIG_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_READ_MASK                      _MK_MASK_CONST(0x800f0fff)
#define NAND_LL_CONFIG_0_WRITE_MASK                     _MK_MASK_CONST(0xf0fff)
// HW clears when command queue data and flash operations
// are completed.
#define NAND_LL_CONFIG_0_LL_START_SHIFT                 _MK_SHIFT_CONST(31)
#define NAND_LL_CONFIG_0_LL_START_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LL_CONFIG_0_LL_START_SHIFT)
#define NAND_LL_CONFIG_0_LL_START_RANGE                 31:31
#define NAND_LL_CONFIG_0_LL_START_WOFFSET                       0x0
#define NAND_LL_CONFIG_0_LL_START_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_LL_START_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LL_CONFIG_0_LL_START_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_LL_START_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_LL_START_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LL_CONFIG_0_LL_START_ENABLE                        _MK_ENUM_CONST(1)

// Enable word count status update in  LL_STATUS register
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_SHIFT                       _MK_SHIFT_CONST(19)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_FIELD                       (_MK_MASK_CONST(0x1) << NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_SHIFT)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_RANGE                       19:19
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_WOFFSET                     0x0
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_DISABLE                     _MK_ENUM_CONST(0)
#define NAND_LL_CONFIG_0_WORD_CNT_STATUS_EN_ENABLE                      _MK_ENUM_CONST(1)

//DMA burst size for  Command Queue data requests
#define NAND_LL_CONFIG_0_BURST_SIZE_SHIFT                       _MK_SHIFT_CONST(16)
#define NAND_LL_CONFIG_0_BURST_SIZE_FIELD                       (_MK_MASK_CONST(0x7) << NAND_LL_CONFIG_0_BURST_SIZE_SHIFT)
#define NAND_LL_CONFIG_0_BURST_SIZE_RANGE                       18:16
#define NAND_LL_CONFIG_0_BURST_SIZE_WOFFSET                     0x0
#define NAND_LL_CONFIG_0_BURST_SIZE_DEFAULT                     _MK_MASK_CONST(0x4)
#define NAND_LL_CONFIG_0_BURST_SIZE_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define NAND_LL_CONFIG_0_BURST_SIZE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_BURST_SIZE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_RSVD1                 _MK_ENUM_CONST(0)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_RSVD2                 _MK_ENUM_CONST(1)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_1WORDS                        _MK_ENUM_CONST(2)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_4WORDS                        _MK_ENUM_CONST(3)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_8WORDS                        _MK_ENUM_CONST(4)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_16WORDS                       _MK_ENUM_CONST(5)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_RSVD3                 _MK_ENUM_CONST(6)
#define NAND_LL_CONFIG_0_BURST_SIZE_BURST_RSVD4                 _MK_ENUM_CONST(7)

// Command queue up word length programmed is parsed  and `START is 
// done when the execution is complete. However for when errors  are 
// detected for any case of the flash operation failure command queue  
// execution is aborted immediately before this length. 
#define NAND_LL_CONFIG_0_LL_LENGTH_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LL_CONFIG_0_LL_LENGTH_FIELD                        (_MK_MASK_CONST(0xfff) << NAND_LL_CONFIG_0_LL_LENGTH_SHIFT)
#define NAND_LL_CONFIG_0_LL_LENGTH_RANGE                        11:0
#define NAND_LL_CONFIG_0_LL_LENGTH_WOFFSET                      0x0
#define NAND_LL_CONFIG_0_LL_LENGTH_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_LL_LENGTH_DEFAULT_MASK                 _MK_MASK_CONST(0xfff)
#define NAND_LL_CONFIG_0_LL_LENGTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LL_CONFIG_0_LL_LENGTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LL_PTR_0  
#define NAND_LL_PTR_0                   _MK_ADDR_CONST(0x5c)
#define NAND_LL_PTR_0_SECURE                    0x0
#define NAND_LL_PTR_0_WORD_COUNT                        0x1
#define NAND_LL_PTR_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LL_PTR_0_RESET_MASK                        _MK_MASK_CONST(0xfffffffc)
#define NAND_LL_PTR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LL_PTR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LL_PTR_0_READ_MASK                         _MK_MASK_CONST(0xfffffffc)
#define NAND_LL_PTR_0_WRITE_MASK                        _MK_MASK_CONST(0xfffffffc)
// Command queue data pointer Register
#define NAND_LL_PTR_0_LL_PTR_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LL_PTR_0_LL_PTR_FIELD                      (_MK_MASK_CONST(0x3fffffff) << NAND_LL_PTR_0_LL_PTR_SHIFT)
#define NAND_LL_PTR_0_LL_PTR_RANGE                      31:2
#define NAND_LL_PTR_0_LL_PTR_WOFFSET                    0x0
#define NAND_LL_PTR_0_LL_PTR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LL_PTR_0_LL_PTR_DEFAULT_MASK                       _MK_MASK_CONST(0x3fffffff)
#define NAND_LL_PTR_0_LL_PTR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LL_PTR_0_LL_PTR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LL_STATUS_0  
#define NAND_LL_STATUS_0                        _MK_ADDR_CONST(0x60)
#define NAND_LL_STATUS_0_SECURE                         0x0
#define NAND_LL_STATUS_0_WORD_COUNT                     0x1
#define NAND_LL_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0xffcf0fff)
#define NAND_LL_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_READ_MASK                      _MK_MASK_CONST(0xffcf0fff)
#define NAND_LL_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0xc00000)
// Command queue PACKET ID completed at this time.  S/W has write 
// access to this bit field position so that any time S/W can  clear
// this field. Also NAND controller reset will reset this status.
#define NAND_LL_STATUS_0_LL_PKT_ID_SHIFT                        _MK_SHIFT_CONST(24)
#define NAND_LL_STATUS_0_LL_PKT_ID_FIELD                        (_MK_MASK_CONST(0xff) << NAND_LL_STATUS_0_LL_PKT_ID_SHIFT)
#define NAND_LL_STATUS_0_LL_PKT_ID_RANGE                        31:24
#define NAND_LL_STATUS_0_LL_PKT_ID_WOFFSET                      0x0
#define NAND_LL_STATUS_0_LL_PKT_ID_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_LL_PKT_ID_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define NAND_LL_STATUS_0_LL_PKT_ID_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_LL_PKT_ID_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Interrupt status of LL_DONE { Read Only}
#define NAND_LL_STATUS_0_IS_LL_DONE_SHIFT                       _MK_SHIFT_CONST(23)
#define NAND_LL_STATUS_0_IS_LL_DONE_FIELD                       (_MK_MASK_CONST(0x1) << NAND_LL_STATUS_0_IS_LL_DONE_SHIFT)
#define NAND_LL_STATUS_0_IS_LL_DONE_RANGE                       23:23
#define NAND_LL_STATUS_0_IS_LL_DONE_WOFFSET                     0x0
#define NAND_LL_STATUS_0_IS_LL_DONE_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_IS_LL_DONE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define NAND_LL_STATUS_0_IS_LL_DONE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_IS_LL_DONE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Interrupt status of LL_ERR { Read Only}
#define NAND_LL_STATUS_0_IS_LL_ERR_SHIFT                        _MK_SHIFT_CONST(22)
#define NAND_LL_STATUS_0_IS_LL_ERR_FIELD                        (_MK_MASK_CONST(0x1) << NAND_LL_STATUS_0_IS_LL_ERR_SHIFT)
#define NAND_LL_STATUS_0_IS_LL_ERR_RANGE                        22:22
#define NAND_LL_STATUS_0_IS_LL_ERR_WOFFSET                      0x0
#define NAND_LL_STATUS_0_IS_LL_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_IS_LL_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define NAND_LL_STATUS_0_IS_LL_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_IS_LL_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Command queue Word length of last packet executed  in the queue.
// Please note that WORD_CNT_STATUS_EN in LL_CONFIG should be  enabled 
// for this status update
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_SHIFT                       _MK_SHIFT_CONST(16)
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_FIELD                       (_MK_MASK_CONST(0xf) << NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_SHIFT)
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_RANGE                       19:16
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_WOFFSET                     0x0
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_LL_LENGTH_LAST_PKT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Command queue Word length(32-bit) completed till  this time.
// Please note that WORD_CNT_STATUS_EN in LL_CONFIG should be  enabled 
// for this status update
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_SHIFT                   _MK_SHIFT_CONST(0)
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_FIELD                   (_MK_MASK_CONST(0xfff) << NAND_LL_STATUS_0_LL_LENGTH_DONE_SHIFT)
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_RANGE                   11:0
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_WOFFSET                 0x0
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_DEFAULT_MASK                    _MK_MASK_CONST(0xfff)
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LL_STATUS_0_LL_LENGTH_DONE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register NAND_LOCK_CONTROL_0  
#define NAND_LOCK_CONTROL_0                     _MK_ADDR_CONST(0x64)
#define NAND_LOCK_CONTROL_0_SECURE                      0x0
#define NAND_LOCK_CONTROL_0_WORD_COUNT                  0x1
#define NAND_LOCK_CONTROL_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_RESET_MASK                  _MK_MASK_CONST(0x1ff)
#define NAND_LOCK_CONTROL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_READ_MASK                   _MK_MASK_CONST(0x1ff)
#define NAND_LOCK_CONTROL_0_WRITE_MASK                  _MK_MASK_CONST(0x1ff)
// Intterrupt enable on memory range match.
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_SHIFT                   _MK_SHIFT_CONST(8)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_FIELD                   (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_IE_LOCK_ERR_SHIFT)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_RANGE                   8:8
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_WOFFSET                 0x0
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_DISABLE                 _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_IE_LOCK_ERR_ENABLE                  _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 7 Can be set only once register field, h/w reset OR controller reset ONLY 
// can disable this feature.
// LOCK_APER_START7, LOCK_APER_END7, LOCK_APER_CHIPID7 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_SHIFT                 _MK_SHIFT_CONST(7)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN7_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_RANGE                 7:7
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN7_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 6 Can be set only once register field, h/w reset OR controller reset ONLY 
// can disable this feature.
// LOCK_APER_START6, LOCK_APER_END6, LOCK_APER_CHIPID6 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_SHIFT                 _MK_SHIFT_CONST(6)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN6_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_RANGE                 6:6
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN6_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 5 Can be set only once register field, h/w reset OR controller reset ONLY 
// can disable this feature.
// LOCK_APER_START5, LOCK_APER_END5, LOCK_APER_CHIPID5 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_SHIFT                 _MK_SHIFT_CONST(5)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN5_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_RANGE                 5:5
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN5_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 4 Can be set only once register field, h/w reset OR controller reset ONLY 
// can disable this feature.
// LOCK_APER_START4, LOCK_APER_END4, LOCK_APER_CHIPID4 cant be
// programmed once this SET
//
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_SHIFT                 _MK_SHIFT_CONST(4)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN4_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_RANGE                 4:4
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN4_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 3 Can be set only once register field, h/w reset OR controller reset ONLY
// can disable this feature.
// LOCK_APER_START3, LOCK_APER_END3, LOCK_APER_CHIPID3 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_SHIFT                 _MK_SHIFT_CONST(3)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN3_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_RANGE                 3:3
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN3_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 2 Can be set only once register field, h/w reset OR controller reset ONLY 
// can disable this feature.
// LOCK_APER_START2, LOCK_APER_END2, LOCK_APER_CHIPID2 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_SHIFT                 _MK_SHIFT_CONST(2)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN2_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_RANGE                 2:2
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN2_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 1 Can be set only once register field, h/w reset OR controller reset ONLY
// can disable this feature.
// LOCK_APER_START1, LOCK_APER_END1, LOCK_APER_CHIPID1 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_SHIFT                 _MK_SHIFT_CONST(1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN1_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_RANGE                 1:1
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN1_ENABLE                        _MK_ENUM_CONST(1)

// Enable lock feature for selected apertures 0 Can be set only once register field, h/w reset OR controller reset ONLY
// can disable this feature.
// LOCK_APER_START0, LOCK_APER_END0, LOCK_APER_CHIPID0 cant be
// programmed once this SET
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_FIELD                 (_MK_MASK_CONST(0x1) << NAND_LOCK_CONTROL_0_LOCK_APER_EN0_SHIFT)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_RANGE                 0:0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_WOFFSET                       0x0
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_DISABLE                       _MK_ENUM_CONST(0)
#define NAND_LOCK_CONTROL_0_LOCK_APER_EN0_ENABLE                        _MK_ENUM_CONST(1)


// Register NAND_LOCK_STATUS_0  
#define NAND_LOCK_STATUS_0                      _MK_ADDR_CONST(0x68)
#define NAND_LOCK_STATUS_0_SECURE                       0x0
#define NAND_LOCK_STATUS_0_WORD_COUNT                   0x1
#define NAND_LOCK_STATUS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_RESET_MASK                   _MK_MASK_CONST(0x1ff)
#define NAND_LOCK_STATUS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_READ_MASK                    _MK_MASK_CONST(0x1ff)
#define NAND_LOCK_STATUS_0_WRITE_MASK                   _MK_MASK_CONST(0x1ff)
// 1 = Memory protection error detected
// check LOCK_STATUS register to identify
// which aperture matched.
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_SHIFT                    _MK_SHIFT_CONST(8)
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_FIELD                    (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_IS_LOCK_ERR_SHIFT)
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_RANGE                    8:8
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_WOFFSET                  0x0
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_IS_LOCK_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_RANGE                      7:7
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_RANGE                      6:6
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_RANGE                      5:5
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_RANGE                      4:4
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_RANGE                      3:3
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_RANGE                      2:2
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_RANGE                      1:1
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Respective bit is set by HW on protection range detection. 
// Write 1 to clear IS.LOCK_ERR will clear this status information
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_SHIFT)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_RANGE                      0:0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_WOFFSET                    0x0
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_STATUS_0_LOCK_APER_STATUS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START0_0  
#define NAND_LOCK_APER_START0_0                 _MK_ADDR_CONST(0x6c)
#define NAND_LOCK_APER_START0_0_SECURE                  0x0
#define NAND_LOCK_APER_START0_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START0_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START0_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START0_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START0_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START0_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START0_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START0_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START1_0  
#define NAND_LOCK_APER_START1_0                 _MK_ADDR_CONST(0x70)
#define NAND_LOCK_APER_START1_0_SECURE                  0x0
#define NAND_LOCK_APER_START1_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START1_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START1_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START1_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START1_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START1_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START1_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START1_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START2_0  
#define NAND_LOCK_APER_START2_0                 _MK_ADDR_CONST(0x74)
#define NAND_LOCK_APER_START2_0_SECURE                  0x0
#define NAND_LOCK_APER_START2_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START2_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START2_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START2_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START2_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START2_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START2_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START2_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START3_0  
#define NAND_LOCK_APER_START3_0                 _MK_ADDR_CONST(0x78)
#define NAND_LOCK_APER_START3_0_SECURE                  0x0
#define NAND_LOCK_APER_START3_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START3_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START3_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START3_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START3_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START3_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START3_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START3_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START3_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START4_0  
#define NAND_LOCK_APER_START4_0                 _MK_ADDR_CONST(0x7c)
#define NAND_LOCK_APER_START4_0_SECURE                  0x0
#define NAND_LOCK_APER_START4_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START4_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START4_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START4_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START4_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START4_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START4_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START4_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START4_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START5_0  
#define NAND_LOCK_APER_START5_0                 _MK_ADDR_CONST(0x80)
#define NAND_LOCK_APER_START5_0_SECURE                  0x0
#define NAND_LOCK_APER_START5_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START5_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START5_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START5_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START5_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START5_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START5_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START5_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START5_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START5_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START6_0  
#define NAND_LOCK_APER_START6_0                 _MK_ADDR_CONST(0x84)
#define NAND_LOCK_APER_START6_0_SECURE                  0x0
#define NAND_LOCK_APER_START6_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START6_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START6_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START6_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START6_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START6_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START6_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START6_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START6_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START6_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_START7_0  
#define NAND_LOCK_APER_START7_0                 _MK_ADDR_CONST(0x88)
#define NAND_LOCK_APER_START7_0_SECURE                  0x0
#define NAND_LOCK_APER_START7_0_WORD_COUNT                      0x1
#define NAND_LOCK_APER_START7_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START7_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_START7_0_ADDR_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_START7_0_ADDR_FIELD                      (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_START7_0_ADDR_SHIFT)
#define NAND_LOCK_APER_START7_0_ADDR_RANGE                      31:0
#define NAND_LOCK_APER_START7_0_ADDR_WOFFSET                    0x0
#define NAND_LOCK_APER_START7_0_ADDR_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_START7_0_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END0_0  
#define NAND_LOCK_APER_END0_0                   _MK_ADDR_CONST(0x8c)
#define NAND_LOCK_APER_END0_0_SECURE                    0x0
#define NAND_LOCK_APER_END0_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END0_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END0_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END0_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END0_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END0_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END0_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END0_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END0_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END1_0  
#define NAND_LOCK_APER_END1_0                   _MK_ADDR_CONST(0x90)
#define NAND_LOCK_APER_END1_0_SECURE                    0x0
#define NAND_LOCK_APER_END1_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END1_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END1_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END1_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END1_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END1_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END1_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END1_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END1_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END2_0  
#define NAND_LOCK_APER_END2_0                   _MK_ADDR_CONST(0x94)
#define NAND_LOCK_APER_END2_0_SECURE                    0x0
#define NAND_LOCK_APER_END2_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END2_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END2_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END2_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END2_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END2_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END2_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END2_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END2_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END3_0  
#define NAND_LOCK_APER_END3_0                   _MK_ADDR_CONST(0x98)
#define NAND_LOCK_APER_END3_0_SECURE                    0x0
#define NAND_LOCK_APER_END3_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END3_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END3_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END3_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END3_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END3_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END3_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END3_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END3_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END4_0  
#define NAND_LOCK_APER_END4_0                   _MK_ADDR_CONST(0x9c)
#define NAND_LOCK_APER_END4_0_SECURE                    0x0
#define NAND_LOCK_APER_END4_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END4_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END4_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END4_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END4_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END4_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END4_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END4_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END4_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END4_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END5_0  
#define NAND_LOCK_APER_END5_0                   _MK_ADDR_CONST(0xa0)
#define NAND_LOCK_APER_END5_0_SECURE                    0x0
#define NAND_LOCK_APER_END5_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END5_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END5_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END5_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END5_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END5_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END5_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END5_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END5_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END5_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END6_0  
#define NAND_LOCK_APER_END6_0                   _MK_ADDR_CONST(0xa4)
#define NAND_LOCK_APER_END6_0_SECURE                    0x0
#define NAND_LOCK_APER_END6_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END6_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END6_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END6_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END6_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END6_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END6_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END6_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END6_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END6_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_END7_0  
#define NAND_LOCK_APER_END7_0                   _MK_ADDR_CONST(0xa8)
#define NAND_LOCK_APER_END7_0_SECURE                    0x0
#define NAND_LOCK_APER_END7_0_WORD_COUNT                        0x1
#define NAND_LOCK_APER_END7_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END7_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define NAND_LOCK_APER_END7_0_ADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_END7_0_ADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << NAND_LOCK_APER_END7_0_ADDR_SHIFT)
#define NAND_LOCK_APER_END7_0_ADDR_RANGE                        31:0
#define NAND_LOCK_APER_END7_0_ADDR_WOFFSET                      0x0
#define NAND_LOCK_APER_END7_0_ADDR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_ADDR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_ADDR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_END7_0_ADDR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register NAND_LOCK_APER_CHIPID0_0  
#define NAND_LOCK_APER_CHIPID0_0                        _MK_ADDR_CONST(0xac)
#define NAND_LOCK_APER_CHIPID0_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID0_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID0_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID0_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID0_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID0_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID0_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID0_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID0_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID0_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID0_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID0_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID0_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID0_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID0_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID0_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID0_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID0_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID0_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID0_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID0_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID0_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID0_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID0_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID0_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID0_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID0_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID0_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID0_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID0_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID0_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID0_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID0_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID0_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID0_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID0_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID0_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID0_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID0_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID0_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID1_0  
#define NAND_LOCK_APER_CHIPID1_0                        _MK_ADDR_CONST(0xb0)
#define NAND_LOCK_APER_CHIPID1_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID1_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID1_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID1_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID1_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID1_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID1_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID1_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID1_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID1_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID1_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID1_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID1_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID1_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID1_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID1_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID1_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID1_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID1_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID1_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID1_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID1_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID1_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID1_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID1_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID1_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID1_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID1_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID1_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID1_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID1_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID1_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID1_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID1_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID1_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID1_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID1_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID1_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID1_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID1_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID2_0  
#define NAND_LOCK_APER_CHIPID2_0                        _MK_ADDR_CONST(0xb4)
#define NAND_LOCK_APER_CHIPID2_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID2_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID2_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID2_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID2_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID2_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID2_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID2_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID2_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID2_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID2_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID2_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID2_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID2_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID2_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID2_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID2_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID2_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID2_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID2_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID2_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID2_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID2_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID2_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID2_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID2_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID2_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID2_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID2_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID2_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID2_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID2_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID2_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID2_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID2_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID2_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID2_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID2_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID2_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID2_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID3_0  
#define NAND_LOCK_APER_CHIPID3_0                        _MK_ADDR_CONST(0xb8)
#define NAND_LOCK_APER_CHIPID3_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID3_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID3_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID3_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID3_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID3_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID3_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID3_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID3_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID3_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID3_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID3_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID3_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID3_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID3_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID3_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID3_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID3_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID3_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID3_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID3_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID3_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID3_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID3_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID3_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID3_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID3_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID3_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID3_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID3_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID3_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID3_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID3_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID3_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID3_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID3_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID3_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID3_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID3_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID3_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID4_0  
#define NAND_LOCK_APER_CHIPID4_0                        _MK_ADDR_CONST(0xbc)
#define NAND_LOCK_APER_CHIPID4_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID4_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID4_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID4_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID4_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID4_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID4_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID4_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID4_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID4_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID4_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID4_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID4_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID4_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID4_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID4_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID4_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID4_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID4_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID4_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID4_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID4_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID4_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID4_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID4_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID4_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID4_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID4_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID4_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID4_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID4_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID4_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID4_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID4_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID4_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID4_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID4_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID4_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID4_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID4_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID5_0  
#define NAND_LOCK_APER_CHIPID5_0                        _MK_ADDR_CONST(0xc0)
#define NAND_LOCK_APER_CHIPID5_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID5_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID5_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID5_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID5_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID5_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID5_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID5_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID5_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID5_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID5_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID5_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID5_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID5_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID5_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID5_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID5_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID5_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID5_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID5_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID5_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID5_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID5_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID5_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID5_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID5_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID5_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID5_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID5_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID5_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID5_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID5_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID5_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID5_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID5_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID5_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID5_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID5_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID5_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID5_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID6_0  
#define NAND_LOCK_APER_CHIPID6_0                        _MK_ADDR_CONST(0xc4)
#define NAND_LOCK_APER_CHIPID6_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID6_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID6_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID6_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID6_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID6_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID6_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID6_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID6_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID6_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID6_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID6_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID6_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID6_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID6_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID6_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID6_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID6_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID6_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID6_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID6_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID6_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID6_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID6_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID6_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID6_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID6_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID6_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID6_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID6_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID6_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID6_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID6_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID6_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID6_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID6_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID6_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID6_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID6_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID6_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_LOCK_APER_CHIPID7_0  
#define NAND_LOCK_APER_CHIPID7_0                        _MK_ADDR_CONST(0xc8)
#define NAND_LOCK_APER_CHIPID7_0_SECURE                         0x0
#define NAND_LOCK_APER_CHIPID7_0_WORD_COUNT                     0x1
#define NAND_LOCK_APER_CHIPID7_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define NAND_LOCK_APER_CHIPID7_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Memory Protection of aperture[0-7] valid for Chip select7
#define NAND_LOCK_APER_CHIPID7_0_CS7_SHIFT                      _MK_SHIFT_CONST(7)
#define NAND_LOCK_APER_CHIPID7_0_CS7_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS7_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS7_RANGE                      7:7
#define NAND_LOCK_APER_CHIPID7_0_CS7_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS7_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS7_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS7_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select7 

#define NAND_LOCK_APER_CHIPID7_0_CS7_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select6
#define NAND_LOCK_APER_CHIPID7_0_CS6_SHIFT                      _MK_SHIFT_CONST(6)
#define NAND_LOCK_APER_CHIPID7_0_CS6_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS6_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS6_RANGE                      6:6
#define NAND_LOCK_APER_CHIPID7_0_CS6_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS6_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS6_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS6_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select6 

#define NAND_LOCK_APER_CHIPID7_0_CS6_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select5
#define NAND_LOCK_APER_CHIPID7_0_CS5_SHIFT                      _MK_SHIFT_CONST(5)
#define NAND_LOCK_APER_CHIPID7_0_CS5_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS5_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS5_RANGE                      5:5
#define NAND_LOCK_APER_CHIPID7_0_CS5_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS5_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS5_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select5 

#define NAND_LOCK_APER_CHIPID7_0_CS5_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select4
#define NAND_LOCK_APER_CHIPID7_0_CS4_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_LOCK_APER_CHIPID7_0_CS4_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS4_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS4_RANGE                      4:4
#define NAND_LOCK_APER_CHIPID7_0_CS4_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS4_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS4_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select4 

#define NAND_LOCK_APER_CHIPID7_0_CS4_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select3
#define NAND_LOCK_APER_CHIPID7_0_CS3_SHIFT                      _MK_SHIFT_CONST(3)
#define NAND_LOCK_APER_CHIPID7_0_CS3_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS3_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS3_RANGE                      3:3
#define NAND_LOCK_APER_CHIPID7_0_CS3_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS3_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS3_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select3 

#define NAND_LOCK_APER_CHIPID7_0_CS3_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select2
#define NAND_LOCK_APER_CHIPID7_0_CS2_SHIFT                      _MK_SHIFT_CONST(2)
#define NAND_LOCK_APER_CHIPID7_0_CS2_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS2_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS2_RANGE                      2:2
#define NAND_LOCK_APER_CHIPID7_0_CS2_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS2_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS2_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select2 

#define NAND_LOCK_APER_CHIPID7_0_CS2_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select1
#define NAND_LOCK_APER_CHIPID7_0_CS1_SHIFT                      _MK_SHIFT_CONST(1)
#define NAND_LOCK_APER_CHIPID7_0_CS1_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS1_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS1_RANGE                      1:1
#define NAND_LOCK_APER_CHIPID7_0_CS1_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS1_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS1_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select1 

#define NAND_LOCK_APER_CHIPID7_0_CS1_ENABLE                     _MK_ENUM_CONST(1)

// Memory Protection of aperture[0-7] valid for Chip select0
#define NAND_LOCK_APER_CHIPID7_0_CS0_SHIFT                      _MK_SHIFT_CONST(0)
#define NAND_LOCK_APER_CHIPID7_0_CS0_FIELD                      (_MK_MASK_CONST(0x1) << NAND_LOCK_APER_CHIPID7_0_CS0_SHIFT)
#define NAND_LOCK_APER_CHIPID7_0_CS0_RANGE                      0:0
#define NAND_LOCK_APER_CHIPID7_0_CS0_WOFFSET                    0x0
#define NAND_LOCK_APER_CHIPID7_0_CS0_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_LOCK_APER_CHIPID7_0_CS0_DISABLE                    _MK_ENUM_CONST(0)    // // Memory Protection of aperture[0-7] not valid for Chip select0 

#define NAND_LOCK_APER_CHIPID7_0_CS0_ENABLE                     _MK_ENUM_CONST(1)


// Register NAND_BCH_CONFIG_0  
#define NAND_BCH_CONFIG_0                       _MK_ADDR_CONST(0xcc)
#define NAND_BCH_CONFIG_0_SECURE                        0x0
#define NAND_BCH_CONFIG_0_WORD_COUNT                    0x1
#define NAND_BCH_CONFIG_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_RESET_MASK                    _MK_MASK_CONST(0x31)
#define NAND_BCH_CONFIG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_READ_MASK                     _MK_MASK_CONST(0x31)
#define NAND_BCH_CONFIG_0_WRITE_MASK                    _MK_MASK_CONST(0x31)
// BCH error correction strength selection 16 single bit random errors per sector 
#define NAND_BCH_CONFIG_0_BCH_TVALUE_SHIFT                      _MK_SHIFT_CONST(4)
#define NAND_BCH_CONFIG_0_BCH_TVALUE_FIELD                      (_MK_MASK_CONST(0x3) << NAND_BCH_CONFIG_0_BCH_TVALUE_SHIFT)
#define NAND_BCH_CONFIG_0_BCH_TVALUE_RANGE                      5:4
#define NAND_BCH_CONFIG_0_BCH_TVALUE_WOFFSET                    0x0
#define NAND_BCH_CONFIG_0_BCH_TVALUE_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_BCH_TVALUE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define NAND_BCH_CONFIG_0_BCH_TVALUE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_BCH_TVALUE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_BCH_TVALUE_BCH_TVAL4                  _MK_ENUM_CONST(0)    // // 4 single bit random errors per sector

#define NAND_BCH_CONFIG_0_BCH_TVALUE_BCH_TVAL8                  _MK_ENUM_CONST(1)    // // 8 single bit random errors per sector

#define NAND_BCH_CONFIG_0_BCH_TVALUE_BCH_TVAL14                 _MK_ENUM_CONST(2)    // // 14 single bit random errors per sector

#define NAND_BCH_CONFIG_0_BCH_TVALUE_BCH_TVAL16                 _MK_ENUM_CONST(3)

// BCH encoder & decoder is enabled
#define NAND_BCH_CONFIG_0_BCH_ECC_SHIFT                 _MK_SHIFT_CONST(0)
#define NAND_BCH_CONFIG_0_BCH_ECC_FIELD                 (_MK_MASK_CONST(0x1) << NAND_BCH_CONFIG_0_BCH_ECC_SHIFT)
#define NAND_BCH_CONFIG_0_BCH_ECC_RANGE                 0:0
#define NAND_BCH_CONFIG_0_BCH_ECC_WOFFSET                       0x0
#define NAND_BCH_CONFIG_0_BCH_ECC_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_BCH_ECC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define NAND_BCH_CONFIG_0_BCH_ECC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_BCH_ECC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_BCH_CONFIG_0_BCH_ECC_DISABLE                       _MK_ENUM_CONST(0)    // // BCH encoder & decoder is not enabled

#define NAND_BCH_CONFIG_0_BCH_ECC_ENABLE                        _MK_ENUM_CONST(1)


// Register NAND_BCH_DEC_RESULT_0  
#define NAND_BCH_DEC_RESULT_0                   _MK_ADDR_CONST(0xd0)
#define NAND_BCH_DEC_RESULT_0_SECURE                    0x0
#define NAND_BCH_DEC_RESULT_0_WORD_COUNT                        0x1
#define NAND_BCH_DEC_RESULT_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_READ_MASK                         _MK_MASK_CONST(0x1ff)
#define NAND_BCH_DEC_RESULT_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// 1 = Correctable OR Un-correctable errors occurred in the DMA transfer 
//     without regard to HW_ERR_CORRECTION feature is enabled or not. 
//     Use extended decode results in NAND_DEC_RESULT and NAND_DEC_STATUS_EXT 
//     to figure out further action for block replacement/wear leveling during 
//     file system management for s/w.
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_SHIFT                        _MK_SHIFT_CONST(8)
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_FIELD                        (_MK_MASK_CONST(0x1) << NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_SHIFT)
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_RANGE                        8:8
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_WOFFSET                      0x0
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_CORRFAIL_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// No. of pages resulted either in un-correctable or correctable errors
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_SHIFT                  _MK_SHIFT_CONST(0)
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_FIELD                  (_MK_MASK_CONST(0xff) << NAND_BCH_DEC_RESULT_0_PAGE_COUNT_SHIFT)
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_RANGE                  7:0
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_WOFFSET                        0x0
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_RESULT_0_PAGE_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register NAND_BCH_DEC_STATUS_BUF_0  
#define NAND_BCH_DEC_STATUS_BUF_0                       _MK_ADDR_CONST(0xd4)
#define NAND_BCH_DEC_STATUS_BUF_0_SECURE                        0x0
#define NAND_BCH_DEC_STATUS_BUF_0_WORD_COUNT                    0x1
#define NAND_BCH_DEC_STATUS_BUF_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_READ_MASK                     _MK_MASK_CONST(0xffff7fff)
#define NAND_BCH_DEC_STATUS_BUF_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Sector wise un-correctable error indicator
// Bit 31 = 1, sector 7 has un-correctable errors
// Bit 31 = 0, sector 7 has no un-correctable errors
// ...
// Bit 24 = 1, sector 0 has un-correctable errors
// Bit 24 = 0, sector 0 has no un-correctable errors
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_SHIFT                   _MK_SHIFT_CONST(24)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_FIELD                   (_MK_MASK_CONST(0xff) << NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_SHIFT)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_RANGE                   31:24
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_WOFFSET                 0x0
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_SEC_FLAG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Sector wise correctable error indicator
// Bit 23 = 1, sector 7 has correctable errors
// Bit 23 = 0, sector 7 has no correctable errors
// ...
// Bit 16 = 1, sector 0 has correctable errors
// Bit 16 = 0, sector 0 has no correctable errors
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_SHIFT                   _MK_SHIFT_CONST(16)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_FIELD                   (_MK_MASK_CONST(0xff) << NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_SHIFT)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_RANGE                   23:16
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_WOFFSET                 0x0
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_DEFAULT                 _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_SEC_FLAG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Spare area error decode resulted in un-correctable errors 
// in case of RS/Hamming ECC selection.
// For BCH this field is not applicable.
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_SHIFT                        _MK_SHIFT_CONST(14)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_FIELD                        (_MK_MASK_CONST(0x1) << NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_SHIFT)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_RANGE                        14:14
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_WOFFSET                      0x0
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_FAIL_TAG_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Spare area error decode resulted in correctable errors 
// in case of RS/Hamming ECC selection.
// For BCH this field is not applicable.
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_SHIFT                        _MK_SHIFT_CONST(13)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_FIELD                        (_MK_MASK_CONST(0x1) << NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_SHIFT)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_RANGE                        13:13
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_WOFFSET                      0x0
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_DEFAULT                      _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_CORR_TAG_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Maximum no. of correctable errors occurred out of all sectors.
// For example of 2K page, if sector 0 has 2 correctable errors 
// and sector3 has 4 errors MAX_ERR_CNT will reflect as 4                                      
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_SHIFT                    _MK_SHIFT_CONST(8)
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_FIELD                    (_MK_MASK_CONST(0x1f) << NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_SHIFT)
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_RANGE                    12:8
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_WOFFSET                  0x0
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_MAX_CORR_CNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Page number which resulted in either correctable/un-correctable errors
// 0 to 63 indicattion for 64 pages of DMA transfer.
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_SHIFT                     _MK_SHIFT_CONST(0)
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_FIELD                     (_MK_MASK_CONST(0xff) << NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_SHIFT)
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_RANGE                     7:0
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_WOFFSET                   0x0
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_DEFAULT                   _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define NAND_BCH_DEC_STATUS_BUF_0_PAGE_NUMBER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Packet CMDQ_CMD
#define CMDQ_CMD_SIZE 32

// Pakcet ID
#define CMDQ_CMD_PKT_ID_SHIFT                   _MK_SHIFT_CONST(24)
#define CMDQ_CMD_PKT_ID_FIELD                   (_MK_MASK_CONST(0xff) << CMDQ_CMD_PKT_ID_SHIFT)
#define CMDQ_CMD_PKT_ID_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(24)
#define CMDQ_CMD_PKT_ID_ROW                     0

// not used range
#define CMDQ_CMD_RSVD_SHIFT                     _MK_SHIFT_CONST(14)
#define CMDQ_CMD_RSVD_FIELD                     (_MK_MASK_CONST(0x3ff) << CMDQ_CMD_RSVD_SHIFT)
#define CMDQ_CMD_RSVD_RANGE                     _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(14)
#define CMDQ_CMD_RSVD_ROW                       0

// ENABLE = NAND_COMMAND register requires update in this packet execution
#define CMDQ_CMD_COMMAND_SHIFT                  _MK_SHIFT_CONST(13)
#define CMDQ_CMD_COMMAND_FIELD                  (_MK_MASK_CONST(0x1) << CMDQ_CMD_COMMAND_SHIFT)
#define CMDQ_CMD_COMMAND_RANGE                  _MK_SHIFT_CONST(13):_MK_SHIFT_CONST(13)
#define CMDQ_CMD_COMMAND_ROW                    0
#define CMDQ_CMD_COMMAND_DISABLE                        _MK_ENUM_CONST(0)
#define CMDQ_CMD_COMMAND_ENABLE                 _MK_ENUM_CONST(1)

// ENABLE = NAND_HWSTATUS_MASK register requires update in this packet execution
#define CMDQ_CMD_HWSTATUS_MASK_SHIFT                    _MK_SHIFT_CONST(12)
#define CMDQ_CMD_HWSTATUS_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CMDQ_CMD_HWSTATUS_MASK_SHIFT)
#define CMDQ_CMD_HWSTATUS_MASK_RANGE                    _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(12)
#define CMDQ_CMD_HWSTATUS_MASK_ROW                      0
#define CMDQ_CMD_HWSTATUS_MASK_DISABLE                  _MK_ENUM_CONST(0)
#define CMDQ_CMD_HWSTATUS_MASK_ENABLE                   _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_HWSTATUS_CMD_SHIFT                     _MK_SHIFT_CONST(11)
#define CMDQ_CMD_HWSTATUS_CMD_FIELD                     (_MK_MASK_CONST(0x1) << CMDQ_CMD_HWSTATUS_CMD_SHIFT)
#define CMDQ_CMD_HWSTATUS_CMD_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(11)
#define CMDQ_CMD_HWSTATUS_CMD_ROW                       0
#define CMDQ_CMD_HWSTATUS_CMD_DISABLE                   _MK_ENUM_CONST(0)
#define CMDQ_CMD_HWSTATUS_CMD_ENABLE                    _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_CMD_REG2_SHIFT                 _MK_SHIFT_CONST(10)
#define CMDQ_CMD_CMD_REG2_FIELD                 (_MK_MASK_CONST(0x1) << CMDQ_CMD_CMD_REG2_SHIFT)
#define CMDQ_CMD_CMD_REG2_RANGE                 _MK_SHIFT_CONST(10):_MK_SHIFT_CONST(10)
#define CMDQ_CMD_CMD_REG2_ROW                   0
#define CMDQ_CMD_CMD_REG2_DISABLE                       _MK_ENUM_CONST(0)
#define CMDQ_CMD_CMD_REG2_ENABLE                        _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_CMD_REG1_SHIFT                 _MK_SHIFT_CONST(9)
#define CMDQ_CMD_CMD_REG1_FIELD                 (_MK_MASK_CONST(0x1) << CMDQ_CMD_CMD_REG1_SHIFT)
#define CMDQ_CMD_CMD_REG1_RANGE                 _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(9)
#define CMDQ_CMD_CMD_REG1_ROW                   0
#define CMDQ_CMD_CMD_REG1_DISABLE                       _MK_ENUM_CONST(0)
#define CMDQ_CMD_CMD_REG1_ENABLE                        _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_ADDR_REG2_SHIFT                        _MK_SHIFT_CONST(8)
#define CMDQ_CMD_ADDR_REG2_FIELD                        (_MK_MASK_CONST(0x1) << CMDQ_CMD_ADDR_REG2_SHIFT)
#define CMDQ_CMD_ADDR_REG2_RANGE                        _MK_SHIFT_CONST(8):_MK_SHIFT_CONST(8)
#define CMDQ_CMD_ADDR_REG2_ROW                  0
#define CMDQ_CMD_ADDR_REG2_DISABLE                      _MK_ENUM_CONST(0)
#define CMDQ_CMD_ADDR_REG2_ENABLE                       _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_ADDR_REG1_SHIFT                        _MK_SHIFT_CONST(7)
#define CMDQ_CMD_ADDR_REG1_FIELD                        (_MK_MASK_CONST(0x1) << CMDQ_CMD_ADDR_REG1_SHIFT)
#define CMDQ_CMD_ADDR_REG1_RANGE                        _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define CMDQ_CMD_ADDR_REG1_ROW                  0
#define CMDQ_CMD_ADDR_REG1_DISABLE                      _MK_ENUM_CONST(0)
#define CMDQ_CMD_ADDR_REG1_ENABLE                       _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_MST_CTRL_SHIFT                 _MK_SHIFT_CONST(6)
#define CMDQ_CMD_MST_CTRL_FIELD                 (_MK_MASK_CONST(0x1) << CMDQ_CMD_MST_CTRL_SHIFT)
#define CMDQ_CMD_MST_CTRL_RANGE                 _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(6)
#define CMDQ_CMD_MST_CTRL_ROW                   0
#define CMDQ_CMD_MST_CTRL_DISABLE                       _MK_ENUM_CONST(0)
#define CMDQ_CMD_MST_CTRL_ENABLE                        _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_ECC_PTR_SHIFT                  _MK_SHIFT_CONST(5)
#define CMDQ_CMD_ECC_PTR_FIELD                  (_MK_MASK_CONST(0x1) << CMDQ_CMD_ECC_PTR_SHIFT)
#define CMDQ_CMD_ECC_PTR_RANGE                  _MK_SHIFT_CONST(5):_MK_SHIFT_CONST(5)
#define CMDQ_CMD_ECC_PTR_ROW                    0
#define CMDQ_CMD_ECC_PTR_DISABLE                        _MK_ENUM_CONST(0)
#define CMDQ_CMD_ECC_PTR_ENABLE                 _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_TAG_PTR_SHIFT                  _MK_SHIFT_CONST(4)
#define CMDQ_CMD_TAG_PTR_FIELD                  (_MK_MASK_CONST(0x1) << CMDQ_CMD_TAG_PTR_SHIFT)
#define CMDQ_CMD_TAG_PTR_RANGE                  _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(4)
#define CMDQ_CMD_TAG_PTR_ROW                    0
#define CMDQ_CMD_TAG_PTR_DISABLE                        _MK_ENUM_CONST(0)
#define CMDQ_CMD_TAG_PTR_ENABLE                 _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_DATA_BLOCK_PTR_SHIFT                   _MK_SHIFT_CONST(3)
#define CMDQ_CMD_DATA_BLOCK_PTR_FIELD                   (_MK_MASK_CONST(0x1) << CMDQ_CMD_DATA_BLOCK_PTR_SHIFT)
#define CMDQ_CMD_DATA_BLOCK_PTR_RANGE                   _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define CMDQ_CMD_DATA_BLOCK_PTR_ROW                     0
#define CMDQ_CMD_DATA_BLOCK_PTR_DISABLE                 _MK_ENUM_CONST(0)
#define CMDQ_CMD_DATA_BLOCK_PTR_ENABLE                  _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_DMA_CNFGB_SHIFT                        _MK_SHIFT_CONST(2)
#define CMDQ_CMD_DMA_CNFGB_FIELD                        (_MK_MASK_CONST(0x1) << CMDQ_CMD_DMA_CNFGB_SHIFT)
#define CMDQ_CMD_DMA_CNFGB_RANGE                        _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define CMDQ_CMD_DMA_CNFGB_ROW                  0
#define CMDQ_CMD_DMA_CNFGB_DISABLE                      _MK_ENUM_CONST(0)
#define CMDQ_CMD_DMA_CNFGB_ENABLE                       _MK_ENUM_CONST(1)

//
#define CMDQ_CMD_DMA_CNFGA_SHIFT                        _MK_SHIFT_CONST(1)
#define CMDQ_CMD_DMA_CNFGA_FIELD                        (_MK_MASK_CONST(0x1) << CMDQ_CMD_DMA_CNFGA_SHIFT)
#define CMDQ_CMD_DMA_CNFGA_RANGE                        _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define CMDQ_CMD_DMA_CNFGA_ROW                  0
#define CMDQ_CMD_DMA_CNFGA_DISABLE                      _MK_ENUM_CONST(0)
#define CMDQ_CMD_DMA_CNFGA_ENABLE                       _MK_ENUM_CONST(1)

// 
#define CMDQ_CMD_CONFIG_SHIFT                   _MK_SHIFT_CONST(0)
#define CMDQ_CMD_CONFIG_FIELD                   (_MK_MASK_CONST(0x1) << CMDQ_CMD_CONFIG_SHIFT)
#define CMDQ_CMD_CONFIG_RANGE                   _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CMDQ_CMD_CONFIG_ROW                     0
#define CMDQ_CMD_CONFIG_DISABLE                 _MK_ENUM_CONST(0)
#define CMDQ_CMD_CONFIG_ENABLE                  _MK_ENUM_CONST(1)


//
// REGISTER LIST
//
#define LIST_ARNANDFLASH_REGS(_op_) \
_op_(NAND_COMMAND_0) \
_op_(NAND_STATUS_0) \
_op_(NAND_ISR_0) \
_op_(NAND_IER_0) \
_op_(NAND_CONFIG_0) \
_op_(NAND_TIMING_0) \
_op_(NAND_RESP_0) \
_op_(NAND_TIMING2_0) \
_op_(NAND_CMD_REG1_0) \
_op_(NAND_CMD_REG2_0) \
_op_(NAND_ADDR_REG1_0) \
_op_(NAND_ADDR_REG2_0) \
_op_(NAND_DMA_MST_CTRL_0) \
_op_(NAND_DMA_CFG_A_0) \
_op_(NAND_DMA_CFG_B_0) \
_op_(NAND_FIFO_CTRL_0) \
_op_(NAND_DATA_BLOCK_PTR_0) \
_op_(NAND_TAG_PTR_0) \
_op_(NAND_ECC_PTR_0) \
_op_(NAND_DEC_STATUS_0) \
_op_(NAND_HWSTATUS_CMD_0) \
_op_(NAND_HWSTATUS_MASK_0) \
_op_(NAND_LL_CONFIG_0) \
_op_(NAND_LL_PTR_0) \
_op_(NAND_LL_STATUS_0) \
_op_(NAND_LOCK_CONTROL_0) \
_op_(NAND_LOCK_STATUS_0) \
_op_(NAND_LOCK_APER_START0_0) \
_op_(NAND_LOCK_APER_START1_0) \
_op_(NAND_LOCK_APER_START2_0) \
_op_(NAND_LOCK_APER_START3_0) \
_op_(NAND_LOCK_APER_START4_0) \
_op_(NAND_LOCK_APER_START5_0) \
_op_(NAND_LOCK_APER_START6_0) \
_op_(NAND_LOCK_APER_START7_0) \
_op_(NAND_LOCK_APER_END0_0) \
_op_(NAND_LOCK_APER_END1_0) \
_op_(NAND_LOCK_APER_END2_0) \
_op_(NAND_LOCK_APER_END3_0) \
_op_(NAND_LOCK_APER_END4_0) \
_op_(NAND_LOCK_APER_END5_0) \
_op_(NAND_LOCK_APER_END6_0) \
_op_(NAND_LOCK_APER_END7_0) \
_op_(NAND_LOCK_APER_CHIPID0_0) \
_op_(NAND_LOCK_APER_CHIPID1_0) \
_op_(NAND_LOCK_APER_CHIPID2_0) \
_op_(NAND_LOCK_APER_CHIPID3_0) \
_op_(NAND_LOCK_APER_CHIPID4_0) \
_op_(NAND_LOCK_APER_CHIPID5_0) \
_op_(NAND_LOCK_APER_CHIPID6_0) \
_op_(NAND_LOCK_APER_CHIPID7_0) \
_op_(NAND_BCH_CONFIG_0) \
_op_(NAND_BCH_DEC_RESULT_0) \
_op_(NAND_BCH_DEC_STATUS_BUF_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_NAND       0x00000000

//
// ARNANDFLASH REGISTER BANKS
//

#define NAND0_FIRST_REG 0x0000 // NAND_COMMAND_0
#define NAND0_LAST_REG 0x00d4 // NAND_BCH_DEC_STATUS_BUF_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARNANDFLASH_H_INC_
