/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___AROWR_H_INC_
#define ___AROWR_H_INC_
#define OWR_TX_FIFO_DEPTH       32
#define OWR_RX_FIFO_DEPTH       32

// Register OWR_CONTROL_0  
#define OWR_CONTROL_0                   _MK_ADDR_CONST(0x0)
#define OWR_CONTROL_0_SECURE                    0x0
#define OWR_CONTROL_0_WORD_COUNT                        0x1
#define OWR_CONTROL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define OWR_CONTROL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define OWR_CONTROL_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
//Generate Reset Presence Pulse 
//write only bit 
//read to this register will return 0
//bit should be programed after all the registers are programed
#define OWR_CONTROL_0_GO_SHIFT                  _MK_SHIFT_CONST(0)
#define OWR_CONTROL_0_GO_FIELD                  (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_GO_SHIFT)
#define OWR_CONTROL_0_GO_RANGE                  0:0
#define OWR_CONTROL_0_GO_WOFFSET                        0x0
#define OWR_CONTROL_0_GO_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_GO_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_GO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_GO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_GO_NO_PRESENCE_PULSE                      _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_GO_START_PRESENCE_PULSE                   _MK_ENUM_CONST(1)

// when set, dq is driven to low by master before the slave does 
// clearing this bit disables the ppm    
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_SHIFT                      _MK_SHIFT_CONST(1)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_FIELD                      (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_PRESENCE_PULSE_MASKING_SHIFT)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_RANGE                      1:1
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_WOFFSET                    0x0
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_NO_PPM                     _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_PRESENCE_PULSE_MASKING_START_PPM                  _MK_ENUM_CONST(1)

// if set to 1 data transfer is done bit by bit
// if set to 0 data transfer is done through byte
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_SHIFT                  _MK_SHIFT_CONST(2)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_FIELD                  (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_DATA_TRANSFER_MODE_SHIFT)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_RANGE                  2:2
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_WOFFSET                        0x0
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_BYTE_TRANSFER_MODE                     _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_DATA_TRANSFER_MODE_BIT_TRANSFER_MODE                      _MK_ENUM_CONST(1)

// if set to 1 16bit crc is executed
// if set to 0 8bit crc is executed
#define OWR_CONTROL_0_CRC_16BIT_EN_SHIFT                        _MK_SHIFT_CONST(3)
#define OWR_CONTROL_0_CRC_16BIT_EN_FIELD                        (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_CRC_16BIT_EN_SHIFT)
#define OWR_CONTROL_0_CRC_16BIT_EN_RANGE                        3:3
#define OWR_CONTROL_0_CRC_16BIT_EN_WOFFSET                      0x0
#define OWR_CONTROL_0_CRC_16BIT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_CRC_16BIT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_CRC_16BIT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_CRC_16BIT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_CRC_16BIT_EN_CRC_8BIT_EN                  _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_CRC_16BIT_EN_CRC_16BIT_EN                 _MK_ENUM_CONST(1)

// Transmit fifo attention level
// 000 = 1 word, fifo req is asserted when least one word empty in the fifo
// 001 = 2 word, fifo req is asserted when least 2 words empty in the fifo
// etc.......
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_SHIFT                 _MK_SHIFT_CONST(4)
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_FIELD                 (_MK_MASK_CONST(0x1f) << OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_SHIFT)
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_RANGE                 8:4
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_WOFFSET                       0x0
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_TX_FIFO_ATTEN_LEVEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Receive  fifo attention level
// 000 = 1 word, fifo req is asserted when least one word full in the fifo
// 001 = 2 word, fifo req is asserted when least 2 words full in the fifo
// etc.....
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_SHIFT                 _MK_SHIFT_CONST(9)
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_FIELD                 (_MK_MASK_CONST(0x1f) << OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_SHIFT)
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_RANGE                 13:9
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_WOFFSET                       0x0
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RX_FIFO_ATTEN_LEVEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//This bit is set to 1, if crc is required 
//for read memory cmd at end of memory
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_SHIFT                      _MK_SHIFT_CONST(14)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_FIELD                      (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_RD_MEM_CRC_REQ_SHIFT)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_RANGE                      14:14
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_WOFFSET                    0x0
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_NO_CRC_READ                        _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_RD_MEM_CRC_REQ_CRC_READ                   _MK_ENUM_CONST(1)

//presence pulse sample clk, master samples the data_in 
//which should be less than or equal to (tpdl - 6) clks   
// 6 clks are used for dglitch, 
// if Deglitch bypassed 3 clks should be enough
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_SHIFT                 _MK_SHIFT_CONST(15)
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_FIELD                 (_MK_MASK_CONST(0xff) << OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_SHIFT)
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_RANGE                 22:15
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_WOFFSET                       0x0
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_PRESENCE_SAMPLE_CLK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//read data sample window, master samples the data_in
//which should be less than or equal to (tlow1 - 6) clks   
// 6 clks are used for Deglitch, 
// if Deglitch bypassed 3 clks should be enough
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_SHIFT                  _MK_SHIFT_CONST(23)
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_FIELD                  (_MK_MASK_CONST(0xf) << OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_SHIFT)
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_RANGE                  26:23
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_WOFFSET                        0x0
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_DATA_SAMPLE_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// This bit is used to bypass the deglitch logic,
// If 1, just takes the sync output
// If 0, looks for any glitch in the sample window for at least 1us,
// Deglitch requires a minimum of 6 clks(2 for sync, 2 for deglitch,
// if glitch, checks for 2 more clks, still glitch exists, err interrupt is
// asserted and data transfer should start from first)  
#define OWR_CONTROL_0_BY_PASS_DGLITCH_SHIFT                     _MK_SHIFT_CONST(27)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_FIELD                     (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_BY_PASS_DGLITCH_SHIFT)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_RANGE                     27:27
#define OWR_CONTROL_0_BY_PASS_DGLITCH_WOFFSET                   0x0
#define OWR_CONTROL_0_BY_PASS_DGLITCH_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_START_DGLITCH                     _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_BY_PASS_DGLITCH_NO_DGLITCH                        _MK_ENUM_CONST(1)

// this bit is set to 1, if transfer needs to continue on crc err
// else on err transfer stops, 
// and again transfer should start on setting rpp reset(go bit)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_SHIFT                     _MK_SHIFT_CONST(28)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_FIELD                     (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_BY_PASS_CRC_ERR_SHIFT)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_RANGE                     28:28
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_WOFFSET                   0x0
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_STOP_TRANSFER_ON_CRC_ERR                  _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_BY_PASS_CRC_ERR_CONTINUE_TRANSFER_ON_CRC_ERR                      _MK_ENUM_CONST(1)

// if 0 no transfer is done
// if 1 write one time slot is executed
//This bit is a write only 
//read to this register will return 0
#define OWR_CONTROL_0_WR1_BIT_SHIFT                     _MK_SHIFT_CONST(29)
#define OWR_CONTROL_0_WR1_BIT_FIELD                     (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_WR1_BIT_SHIFT)
#define OWR_CONTROL_0_WR1_BIT_RANGE                     29:29
#define OWR_CONTROL_0_WR1_BIT_WOFFSET                   0x0
#define OWR_CONTROL_0_WR1_BIT_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_WR1_BIT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_WR1_BIT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_WR1_BIT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_WR1_BIT_NO_TRANSFER                       _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_WR1_BIT_TRANSFER_ONE                      _MK_ENUM_CONST(1)

// if 0 no transfer is done
// if 1 write zero time slot is executed
//write only bit
//read to this register will return 0
#define OWR_CONTROL_0_WR0_BIT_SHIFT                     _MK_SHIFT_CONST(30)
#define OWR_CONTROL_0_WR0_BIT_FIELD                     (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_WR0_BIT_SHIFT)
#define OWR_CONTROL_0_WR0_BIT_RANGE                     30:30
#define OWR_CONTROL_0_WR0_BIT_WOFFSET                   0x0
#define OWR_CONTROL_0_WR0_BIT_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_WR0_BIT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_WR0_BIT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_WR0_BIT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_WR0_BIT_NO_TRANSFER                       _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_WR0_BIT_TRANSFER_ZERO                     _MK_ENUM_CONST(1)

// if 0 no transfer is done
// if 1 read time slot is executed
//write only bit 
//read to this register will return 0
#define OWR_CONTROL_0_RD_BIT_SHIFT                      _MK_SHIFT_CONST(31)
#define OWR_CONTROL_0_RD_BIT_FIELD                      (_MK_MASK_CONST(0x1) << OWR_CONTROL_0_RD_BIT_SHIFT)
#define OWR_CONTROL_0_RD_BIT_RANGE                      31:31
#define OWR_CONTROL_0_RD_BIT_WOFFSET                    0x0
#define OWR_CONTROL_0_RD_BIT_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_BIT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_CONTROL_0_RD_BIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_BIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_CONTROL_0_RD_BIT_NO_TRANSFER                        _MK_ENUM_CONST(0)
#define OWR_CONTROL_0_RD_BIT_TRANSFER_READ_SLOT                 _MK_ENUM_CONST(1)


// Register OWR_COMMAND_0  
#define OWR_COMMAND_0                   _MK_ADDR_CONST(0x4)
#define OWR_COMMAND_0_SECURE                    0x0
#define OWR_COMMAND_0_WORD_COUNT                        0x1
#define OWR_COMMAND_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define OWR_COMMAND_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define OWR_COMMAND_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
//1-wire ROM commands 
#define OWR_COMMAND_0_ROM_CMD_SHIFT                     _MK_SHIFT_CONST(0)
#define OWR_COMMAND_0_ROM_CMD_FIELD                     (_MK_MASK_CONST(0xff) << OWR_COMMAND_0_ROM_CMD_SHIFT)
#define OWR_COMMAND_0_ROM_CMD_RANGE                     7:0
#define OWR_COMMAND_0_ROM_CMD_WOFFSET                   0x0
#define OWR_COMMAND_0_ROM_CMD_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_ROM_CMD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define OWR_COMMAND_0_ROM_CMD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_ROM_CMD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//1-wire MEM commands 
#define OWR_COMMAND_0_MEM_CMD_SHIFT                     _MK_SHIFT_CONST(8)
#define OWR_COMMAND_0_MEM_CMD_FIELD                     (_MK_MASK_CONST(0xff) << OWR_COMMAND_0_MEM_CMD_SHIFT)
#define OWR_COMMAND_0_MEM_CMD_RANGE                     15:8
#define OWR_COMMAND_0_MEM_CMD_WOFFSET                   0x0
#define OWR_COMMAND_0_MEM_CMD_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_MEM_CMD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define OWR_COMMAND_0_MEM_CMD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_MEM_CMD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//Eprom Starting Address[15:0] to write/read data into Eprom
#define OWR_COMMAND_0_MEM_ADDR_SHIFT                    _MK_SHIFT_CONST(16)
#define OWR_COMMAND_0_MEM_ADDR_FIELD                    (_MK_MASK_CONST(0xffff) << OWR_COMMAND_0_MEM_ADDR_SHIFT)
#define OWR_COMMAND_0_MEM_ADDR_RANGE                    31:16
#define OWR_COMMAND_0_MEM_ADDR_WOFFSET                  0x0
#define OWR_COMMAND_0_MEM_ADDR_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_MEM_ADDR_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define OWR_COMMAND_0_MEM_ADDR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_COMMAND_0_MEM_ADDR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register OWR_EPROM_0  
#define OWR_EPROM_0                     _MK_ADDR_CONST(0x8)
#define OWR_EPROM_0_SECURE                      0x0
#define OWR_EPROM_0_WORD_COUNT                  0x1
#define OWR_EPROM_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define OWR_EPROM_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define OWR_EPROM_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Num of Eprom memory bytes to transfer, 
// Mem_Addr - Eprom end address
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_SHIFT                 _MK_SHIFT_CONST(0)
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_FIELD                 (_MK_MASK_CONST(0xffff) << OWR_EPROM_0_MEMORY_BYTES_TRANSFER_SHIFT)
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_RANGE                 15:0
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_WOFFSET                       0x0
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_MEMORY_BYTES_TRANSFER_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Num of Eprom Status bytes to transfer, 
// Mem_Addr - Status bytes end address
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_SHIFT                 _MK_SHIFT_CONST(16)
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_FIELD                 (_MK_MASK_CONST(0xffff) << OWR_EPROM_0_STATUS_BYTES_TRANSFER_SHIFT)
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_RANGE                 31:16
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_WOFFSET                       0x0
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_EPROM_0_STATUS_BYTES_TRANSFER_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register OWR_WR_RD_TCTL_0  
#define OWR_WR_RD_TCTL_0                        _MK_ADDR_CONST(0xc)
#define OWR_WR_RD_TCTL_0_SECURE                         0x0
#define OWR_WR_RD_TCTL_0_WORD_COUNT                     0x1
#define OWR_WR_RD_TCTL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_RESET_MASK                     _MK_MASK_CONST(0x3fffffff)
#define OWR_WR_RD_TCTL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_READ_MASK                      _MK_MASK_CONST(0x3fffffff)
#define OWR_WR_RD_TCTL_0_WRITE_MASK                     _MK_MASK_CONST(0x3fffffff)
// Active time slot for write or read data,
// Tslot = N+1 owr clks,    Range = 60 <= tslot < 120
#define OWR_WR_RD_TCTL_0_TSLOT_SHIFT                    _MK_SHIFT_CONST(0)
#define OWR_WR_RD_TCTL_0_TSLOT_FIELD                    (_MK_MASK_CONST(0x7f) << OWR_WR_RD_TCTL_0_TSLOT_SHIFT)
#define OWR_WR_RD_TCTL_0_TSLOT_RANGE                    6:0
#define OWR_WR_RD_TCTL_0_TSLOT_WOFFSET                  0x0
#define OWR_WR_RD_TCTL_0_TSLOT_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TSLOT_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define OWR_WR_RD_TCTL_0_TSLOT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TSLOT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Write one time Low, or TLOWR both are same
// Tlow1 = N+1 owr clks,    Range = 1 <= tlow1 < 15
// TlowR = N+1 owr clks,    Range = 1 <= tlowR < 15
#define OWR_WR_RD_TCTL_0_TLOW1_SHIFT                    _MK_SHIFT_CONST(7)
#define OWR_WR_RD_TCTL_0_TLOW1_FIELD                    (_MK_MASK_CONST(0xf) << OWR_WR_RD_TCTL_0_TLOW1_SHIFT)
#define OWR_WR_RD_TCTL_0_TLOW1_RANGE                    10:7
#define OWR_WR_RD_TCTL_0_TLOW1_WOFFSET                  0x0
#define OWR_WR_RD_TCTL_0_TLOW1_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TLOW1_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define OWR_WR_RD_TCTL_0_TLOW1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TLOW1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Write Zero time Low,
// Tlow0 = N+1 owr clks,    Range = 60 <= tlow0 < tslot < 120
#define OWR_WR_RD_TCTL_0_TLOW0_SHIFT                    _MK_SHIFT_CONST(11)
#define OWR_WR_RD_TCTL_0_TLOW0_FIELD                    (_MK_MASK_CONST(0x7f) << OWR_WR_RD_TCTL_0_TLOW0_SHIFT)
#define OWR_WR_RD_TCTL_0_TLOW0_RANGE                    17:11
#define OWR_WR_RD_TCTL_0_TLOW0_WOFFSET                  0x0
#define OWR_WR_RD_TCTL_0_TLOW0_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TLOW0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define OWR_WR_RD_TCTL_0_TLOW0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TLOW0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Read data valid time,
// Trdv  = N+1 owr clks,    Range = Exactly 15
#define OWR_WR_RD_TCTL_0_TRDV_SHIFT                     _MK_SHIFT_CONST(18)
#define OWR_WR_RD_TCTL_0_TRDV_FIELD                     (_MK_MASK_CONST(0xf) << OWR_WR_RD_TCTL_0_TRDV_SHIFT)
#define OWR_WR_RD_TCTL_0_TRDV_RANGE                     21:18
#define OWR_WR_RD_TCTL_0_TRDV_WOFFSET                   0x0
#define OWR_WR_RD_TCTL_0_TRDV_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TRDV_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define OWR_WR_RD_TCTL_0_TRDV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TRDV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Release 1-wire Time,
// Trelease = N owr clks,   Range = 0 <= trelease < 45
#define OWR_WR_RD_TCTL_0_TRELEASE_SHIFT                 _MK_SHIFT_CONST(22)
#define OWR_WR_RD_TCTL_0_TRELEASE_FIELD                 (_MK_MASK_CONST(0x3f) << OWR_WR_RD_TCTL_0_TRELEASE_SHIFT)
#define OWR_WR_RD_TCTL_0_TRELEASE_RANGE                 27:22
#define OWR_WR_RD_TCTL_0_TRELEASE_WOFFSET                       0x0
#define OWR_WR_RD_TCTL_0_TRELEASE_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TRELEASE_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define OWR_WR_RD_TCTL_0_TRELEASE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TRELEASE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Read Data Setup,
// Tsu = N owr clks,        Range = tsu < 1 
#define OWR_WR_RD_TCTL_0_TSU_SHIFT                      _MK_SHIFT_CONST(28)
#define OWR_WR_RD_TCTL_0_TSU_FIELD                      (_MK_MASK_CONST(0x3) << OWR_WR_RD_TCTL_0_TSU_SHIFT)
#define OWR_WR_RD_TCTL_0_TSU_RANGE                      29:28
#define OWR_WR_RD_TCTL_0_TSU_WOFFSET                    0x0
#define OWR_WR_RD_TCTL_0_TSU_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TSU_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define OWR_WR_RD_TCTL_0_TSU_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_WR_RD_TCTL_0_TSU_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register OWR_RST_PRESENCE_TCTL_0  
#define OWR_RST_PRESENCE_TCTL_0                 _MK_ADDR_CONST(0x10)
#define OWR_RST_PRESENCE_TCTL_0_SECURE                  0x0
#define OWR_RST_PRESENCE_TCTL_0_WORD_COUNT                      0x1
#define OWR_RST_PRESENCE_TCTL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define OWR_RST_PRESENCE_TCTL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define OWR_RST_PRESENCE_TCTL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// RESET_TIME_HIGH,
// Trsth = N+1 owr clks, Range = 480 <= trsth < infinity  
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_SHIFT                     _MK_SHIFT_CONST(0)
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_FIELD                     (_MK_MASK_CONST(0x1ff) << OWR_RST_PRESENCE_TCTL_0_TRSTH_SHIFT)
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_RANGE                     8:0
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_WOFFSET                   0x0
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_DEFAULT_MASK                      _MK_MASK_CONST(0x1ff)
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TRSTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// RESET_TIME_LOW 
// Trstl = N+1 owr clks, Range = 480 <= trstl < infinity  
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_SHIFT                     _MK_SHIFT_CONST(9)
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_FIELD                     (_MK_MASK_CONST(0x1ff) << OWR_RST_PRESENCE_TCTL_0_TRSTL_SHIFT)
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_RANGE                     17:9
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_WOFFSET                   0x0
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_DEFAULT_MASK                      _MK_MASK_CONST(0x1ff)
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TRSTL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// PRESENCE_DETECT_HIGH  
// Tpdh = N+1 owr clks,  Range = 15  <= tpdh < 60  
#define OWR_RST_PRESENCE_TCTL_0_TPDH_SHIFT                      _MK_SHIFT_CONST(18)
#define OWR_RST_PRESENCE_TCTL_0_TPDH_FIELD                      (_MK_MASK_CONST(0x3f) << OWR_RST_PRESENCE_TCTL_0_TPDH_SHIFT)
#define OWR_RST_PRESENCE_TCTL_0_TPDH_RANGE                      23:18
#define OWR_RST_PRESENCE_TCTL_0_TPDH_WOFFSET                    0x0
#define OWR_RST_PRESENCE_TCTL_0_TPDH_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TPDH_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define OWR_RST_PRESENCE_TCTL_0_TPDH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TPDH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// PRESENCE_DETECT_LOW 
// Tpdl = N owr clks,    Range = 60  <= tpdl < 240  
#define OWR_RST_PRESENCE_TCTL_0_TPDL_SHIFT                      _MK_SHIFT_CONST(24)
#define OWR_RST_PRESENCE_TCTL_0_TPDL_FIELD                      (_MK_MASK_CONST(0xff) << OWR_RST_PRESENCE_TCTL_0_TPDL_SHIFT)
#define OWR_RST_PRESENCE_TCTL_0_TPDL_RANGE                      31:24
#define OWR_RST_PRESENCE_TCTL_0_TPDL_WOFFSET                    0x0
#define OWR_RST_PRESENCE_TCTL_0_TPDL_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TPDL_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define OWR_RST_PRESENCE_TCTL_0_TPDL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_RST_PRESENCE_TCTL_0_TPDL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register OWR_PPM_CORRECTION_TCTL_0  
#define OWR_PPM_CORRECTION_TCTL_0                       _MK_ADDR_CONST(0x14)
#define OWR_PPM_CORRECTION_TCTL_0_SECURE                        0x0
#define OWR_PPM_CORRECTION_TCTL_0_WORD_COUNT                    0x1
#define OWR_PPM_CORRECTION_TCTL_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define OWR_PPM_CORRECTION_TCTL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define OWR_PPM_CORRECTION_TCTL_0_WRITE_MASK                    _MK_MASK_CONST(0xffff)
// PRESENCE PULSE MASK START
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_SHIFT                   _MK_SHIFT_CONST(0)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_FIELD                   (_MK_MASK_CONST(0x3f) << OWR_PPM_CORRECTION_TCTL_0_TPPM1_SHIFT)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_RANGE                   5:0
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_WOFFSET                 0x0
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// PRESENCE PULSE MASK STOP 
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_SHIFT                   _MK_SHIFT_CONST(6)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_FIELD                   (_MK_MASK_CONST(0x3ff) << OWR_PPM_CORRECTION_TCTL_0_TPPM2_SHIFT)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_RANGE                   15:6
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_WOFFSET                 0x0
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_DEFAULT_MASK                    _MK_MASK_CONST(0x3ff)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_PPM_CORRECTION_TCTL_0_TPPM2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register OWR_PROG_PULSE_TCTL_0  
#define OWR_PROG_PULSE_TCTL_0                   _MK_ADDR_CONST(0x18)
#define OWR_PROG_PULSE_TCTL_0_SECURE                    0x0
#define OWR_PROG_PULSE_TCTL_0_WORD_COUNT                        0x1
#define OWR_PROG_PULSE_TCTL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define OWR_PROG_PULSE_TCTL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define OWR_PROG_PULSE_TCTL_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Delay to program 
// Tpd = N+1 owr clks, Range = > 5  
#define OWR_PROG_PULSE_TCTL_0_TPD_SHIFT                 _MK_SHIFT_CONST(0)
#define OWR_PROG_PULSE_TCTL_0_TPD_FIELD                 (_MK_MASK_CONST(0xf) << OWR_PROG_PULSE_TCTL_0_TPD_SHIFT)
#define OWR_PROG_PULSE_TCTL_0_TPD_RANGE                 3:0
#define OWR_PROG_PULSE_TCTL_0_TPD_WOFFSET                       0x0
#define OWR_PROG_PULSE_TCTL_0_TPD_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TPD_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define OWR_PROG_PULSE_TCTL_0_TPD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TPD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Delay to verify
// Tdv = N owr clks,   Range = > 5       
#define OWR_PROG_PULSE_TCTL_0_TDV_SHIFT                 _MK_SHIFT_CONST(4)
#define OWR_PROG_PULSE_TCTL_0_TDV_FIELD                 (_MK_MASK_CONST(0xf) << OWR_PROG_PULSE_TCTL_0_TDV_SHIFT)
#define OWR_PROG_PULSE_TCTL_0_TDV_RANGE                 7:4
#define OWR_PROG_PULSE_TCTL_0_TDV_WOFFSET                       0x0
#define OWR_PROG_PULSE_TCTL_0_TDV_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TDV_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define OWR_PROG_PULSE_TCTL_0_TDV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TDV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Program Voltage Rise Time
// Trp = N owr clks    Range = 0.5 to 5 
#define OWR_PROG_PULSE_TCTL_0_TRP_SHIFT                 _MK_SHIFT_CONST(8)
#define OWR_PROG_PULSE_TCTL_0_TRP_FIELD                 (_MK_MASK_CONST(0xf) << OWR_PROG_PULSE_TCTL_0_TRP_SHIFT)
#define OWR_PROG_PULSE_TCTL_0_TRP_RANGE                 11:8
#define OWR_PROG_PULSE_TCTL_0_TRP_WOFFSET                       0x0
#define OWR_PROG_PULSE_TCTL_0_TRP_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TRP_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define OWR_PROG_PULSE_TCTL_0_TRP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TRP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Program Voltage Fall Time
// Tfp = N owr clks    Range = 0.5 to 5 
#define OWR_PROG_PULSE_TCTL_0_TFP_SHIFT                 _MK_SHIFT_CONST(12)
#define OWR_PROG_PULSE_TCTL_0_TFP_FIELD                 (_MK_MASK_CONST(0xf) << OWR_PROG_PULSE_TCTL_0_TFP_SHIFT)
#define OWR_PROG_PULSE_TCTL_0_TFP_RANGE                 15:12
#define OWR_PROG_PULSE_TCTL_0_TFP_WOFFSET                       0x0
#define OWR_PROG_PULSE_TCTL_0_TFP_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TFP_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define OWR_PROG_PULSE_TCTL_0_TFP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TFP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Program Pulse Width
// Tpp = N owr clks    Range = 480 to 5000 
#define OWR_PROG_PULSE_TCTL_0_TPP_SHIFT                 _MK_SHIFT_CONST(16)
#define OWR_PROG_PULSE_TCTL_0_TPP_FIELD                 (_MK_MASK_CONST(0xffff) << OWR_PROG_PULSE_TCTL_0_TPP_SHIFT)
#define OWR_PROG_PULSE_TCTL_0_TPP_RANGE                 31:16
#define OWR_PROG_PULSE_TCTL_0_TPP_WOFFSET                       0x0
#define OWR_PROG_PULSE_TCTL_0_TPP_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TPP_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define OWR_PROG_PULSE_TCTL_0_TPP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_PROG_PULSE_TCTL_0_TPP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register OWR_READ_ROM0_0  
#define OWR_READ_ROM0_0                 _MK_ADDR_CONST(0x1c)
#define OWR_READ_ROM0_0_SECURE                  0x0
#define OWR_READ_ROM0_0_WORD_COUNT                      0x1
#define OWR_READ_ROM0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define OWR_READ_ROM0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define OWR_READ_ROM0_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Reads the 8 bit family code of ROM 
#define OWR_READ_ROM0_0_FAMILY_CODE_SHIFT                       _MK_SHIFT_CONST(0)
#define OWR_READ_ROM0_0_FAMILY_CODE_FIELD                       (_MK_MASK_CONST(0xff) << OWR_READ_ROM0_0_FAMILY_CODE_SHIFT)
#define OWR_READ_ROM0_0_FAMILY_CODE_RANGE                       7:0
#define OWR_READ_ROM0_0_FAMILY_CODE_WOFFSET                     0x0
#define OWR_READ_ROM0_0_FAMILY_CODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_FAMILY_CODE_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define OWR_READ_ROM0_0_FAMILY_CODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_FAMILY_CODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Reads the first 24 bits of rom  serial number
#define OWR_READ_ROM0_0_SERIAL_NUM0_SHIFT                       _MK_SHIFT_CONST(8)
#define OWR_READ_ROM0_0_SERIAL_NUM0_FIELD                       (_MK_MASK_CONST(0xffffff) << OWR_READ_ROM0_0_SERIAL_NUM0_SHIFT)
#define OWR_READ_ROM0_0_SERIAL_NUM0_RANGE                       31:8
#define OWR_READ_ROM0_0_SERIAL_NUM0_WOFFSET                     0x0
#define OWR_READ_ROM0_0_SERIAL_NUM0_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_SERIAL_NUM0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define OWR_READ_ROM0_0_SERIAL_NUM0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_READ_ROM0_0_SERIAL_NUM0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register OWR_READ_ROM1_0  
#define OWR_READ_ROM1_0                 _MK_ADDR_CONST(0x20)
#define OWR_READ_ROM1_0_SECURE                  0x0
#define OWR_READ_ROM1_0_WORD_COUNT                      0x1
#define OWR_READ_ROM1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define OWR_READ_ROM1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define OWR_READ_ROM1_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Reads the next 24 bits of rom serial number
#define OWR_READ_ROM1_0_SERIAL_NUM1_SHIFT                       _MK_SHIFT_CONST(0)
#define OWR_READ_ROM1_0_SERIAL_NUM1_FIELD                       (_MK_MASK_CONST(0xffffff) << OWR_READ_ROM1_0_SERIAL_NUM1_SHIFT)
#define OWR_READ_ROM1_0_SERIAL_NUM1_RANGE                       23:0
#define OWR_READ_ROM1_0_SERIAL_NUM1_WOFFSET                     0x0
#define OWR_READ_ROM1_0_SERIAL_NUM1_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_SERIAL_NUM1_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define OWR_READ_ROM1_0_SERIAL_NUM1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_SERIAL_NUM1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Reads the 8 bit CRC code of ROM
#define OWR_READ_ROM1_0_CRC_BYTE_SHIFT                  _MK_SHIFT_CONST(24)
#define OWR_READ_ROM1_0_CRC_BYTE_FIELD                  (_MK_MASK_CONST(0xff) << OWR_READ_ROM1_0_CRC_BYTE_SHIFT)
#define OWR_READ_ROM1_0_CRC_BYTE_RANGE                  31:24
#define OWR_READ_ROM1_0_CRC_BYTE_WOFFSET                        0x0
#define OWR_READ_ROM1_0_CRC_BYTE_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_CRC_BYTE_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define OWR_READ_ROM1_0_CRC_BYTE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_READ_ROM1_0_CRC_BYTE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register OWR_INTR_MASK_0  
#define OWR_INTR_MASK_0                 _MK_ADDR_CONST(0x24)
#define OWR_INTR_MASK_0_SECURE                  0x0
#define OWR_INTR_MASK_0_WORD_COUNT                      0x1
#define OWR_INTR_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RESET_MASK                      _MK_MASK_CONST(0x3fff)
#define OWR_INTR_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_READ_MASK                       _MK_MASK_CONST(0x3fff)
#define OWR_INTR_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0x3fff)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_RANGE                       0:0
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_WOFFSET                     0x0
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_PRESENCE_ERR_INT_EN_ENABLE                      _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_SHIFT                    _MK_SHIFT_CONST(1)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_CRC_ERR_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_RANGE                    1:1
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_CRC_ERR_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_RANGE                 2:2
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_WOFFSET                       0x0
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_DISABLE                       _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_MEM_WR_ERR_INT_EN_ENABLE                        _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_SHIFT                    _MK_SHIFT_CONST(3)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_ERR_CMD_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_RANGE                    3:3
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_ERR_CMD_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_SHIFT                 _MK_SHIFT_CONST(4)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_RESET_DONE_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_RANGE                 4:4
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_WOFFSET                       0x0
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_DISABLE                       _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_RESET_DONE_INT_EN_ENABLE                        _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_SHIFT                      _MK_SHIFT_CONST(5)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_RANGE                      5:5
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_WOFFSET                    0x0
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_PRESENCE_DONE_INT_EN_ENABLE                     _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_SHIFT                       _MK_SHIFT_CONST(6)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_RANGE                       6:6
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_WOFFSET                     0x0
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_ROM_CMD_DONE_INT_EN_ENABLE                      _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_SHIFT                       _MK_SHIFT_CONST(7)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_RANGE                       7:7
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_WOFFSET                     0x0
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_MEM_CMD_DONE_INT_EN_ENABLE                      _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_SHIFT                    _MK_SHIFT_CONST(8)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_TXF_OVF_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_RANGE                    8:8
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_TXF_OVF_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_SHIFT                    _MK_SHIFT_CONST(9)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_RXF_UNR_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_RANGE                    9:9
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_RXF_UNR_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_DGLITCH_INT_EN_SHIFT                    _MK_SHIFT_CONST(10)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_DGLITCH_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_RANGE                    10:10
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_DGLITCH_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_SHIFT                    _MK_SHIFT_CONST(11)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_RANGE                    11:11
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_TXFIFO_DATA_REQ_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_SHIFT                    _MK_SHIFT_CONST(12)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_RANGE                    12:12
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_WOFFSET                  0x0
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_RXFIFO_DATA_REQ_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_SHIFT                  _MK_SHIFT_CONST(13)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_SHIFT)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_RANGE                  13:13
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_WOFFSET                        0x0
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define OWR_INTR_MASK_0_BIT_TRANSFER_DONE_INT_EN_ENABLE                 _MK_ENUM_CONST(1)


// Register OWR_INTR_STATUS_0  
#define OWR_INTR_STATUS_0                       _MK_ADDR_CONST(0x28)
#define OWR_INTR_STATUS_0_SECURE                        0x0
#define OWR_INTR_STATUS_0_WORD_COUNT                    0x1
#define OWR_INTR_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x3fff)
#define OWR_INTR_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x3fff)
#define OWR_INTR_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x27ff)
// Presence ERROR. This bit is set when device presence not found  
#define OWR_INTR_STATUS_0_PRESENCE_ERR_SHIFT                    _MK_SHIFT_CONST(0)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_PRESENCE_ERR_SHIFT)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_RANGE                    0:0
#define OWR_INTR_STATUS_0_PRESENCE_ERR_WOFFSET                  0x0
#define OWR_INTR_STATUS_0_PRESENCE_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_SLAVE_DETECTED                   _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_PRESENCE_ERR_NO_SLAVE_DETECTED                        _MK_ENUM_CONST(1)

// CRC ERROR: Indicates the received data is correct or not
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_CRC_ERR_SHIFT                 _MK_SHIFT_CONST(1)
#define OWR_INTR_STATUS_0_CRC_ERR_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_CRC_ERR_SHIFT)
#define OWR_INTR_STATUS_0_CRC_ERR_RANGE                 1:1
#define OWR_INTR_STATUS_0_CRC_ERR_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_CRC_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_CRC_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_CRC_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_CRC_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_CRC_ERR_N0_ERROR                      _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_CRC_ERR_ERROR                 _MK_ENUM_CONST(1)

// MEM WR ERROR: Indicates the received data from eprom is correct or not
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_MEM_WR_ERR_SHIFT                      _MK_SHIFT_CONST(2)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_FIELD                      (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_MEM_WR_ERR_SHIFT)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_RANGE                      2:2
#define OWR_INTR_STATUS_0_MEM_WR_ERR_WOFFSET                    0x0
#define OWR_INTR_STATUS_0_MEM_WR_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_N0_ERROR                   _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_MEM_WR_ERR_ERROR                      _MK_ENUM_CONST(1)

// ERROR CMD:Indicates error command written in the register
// It should be ignored when transfer is in single bit mode 
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_ERR_CMD_SHIFT                 _MK_SHIFT_CONST(3)
#define OWR_INTR_STATUS_0_ERR_CMD_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_ERR_CMD_SHIFT)
#define OWR_INTR_STATUS_0_ERR_CMD_RANGE                 3:3
#define OWR_INTR_STATUS_0_ERR_CMD_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_ERR_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_ERR_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_ERR_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_ERR_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_ERR_CMD_CORRECT_CMD                   _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_ERR_CMD_ERROR_CMD                     _MK_ENUM_CONST(1)

// This indicates the master has send the reset, then waits for presence
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_RESET_DONE_SHIFT                      _MK_SHIFT_CONST(4)
#define OWR_INTR_STATUS_0_RESET_DONE_FIELD                      (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_RESET_DONE_SHIFT)
#define OWR_INTR_STATUS_0_RESET_DONE_RANGE                      4:4
#define OWR_INTR_STATUS_0_RESET_DONE_WOFFSET                    0x0
#define OWR_INTR_STATUS_0_RESET_DONE_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RESET_DONE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_RESET_DONE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RESET_DONE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RESET_DONE_NOT_DONE                   _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_RESET_DONE_DONE                       _MK_ENUM_CONST(1)

// This indicates the presence done, master has detected the device
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_PRESENCE_DONE_SHIFT                   _MK_SHIFT_CONST(5)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_FIELD                   (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_PRESENCE_DONE_SHIFT)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_RANGE                   5:5
#define OWR_INTR_STATUS_0_PRESENCE_DONE_WOFFSET                 0x0
#define OWR_INTR_STATUS_0_PRESENCE_DONE_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_NOT_DONE                        _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_PRESENCE_DONE_DONE                    _MK_ENUM_CONST(1)

// This indicates master has received the rom data from battery
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_SHIFT                    _MK_SHIFT_CONST(6)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_ROM_CMD_DONE_SHIFT)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_RANGE                    6:6
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_WOFFSET                  0x0
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_NOT_DONE                 _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_ROM_CMD_DONE_DONE                     _MK_ENUM_CONST(1)

// This Indicates the master has written data into eprom or data received
// from eprom without any error 
// Software writes a 1 to clear it. 
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_SHIFT                    _MK_SHIFT_CONST(7)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_MEM_CMD_DONE_SHIFT)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_RANGE                    7:7
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_WOFFSET                  0x0
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_NOT_DONE                 _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_MEM_CMD_DONE_DONE                     _MK_ENUM_CONST(1)

// TX FIFO Overflow: RO.  This bit is set to 1 whenever software tries 
// to write to a full TX FIFO. 
// Software writes a 1 to clear this bit. 
#define OWR_INTR_STATUS_0_TXF_OVF_SHIFT                 _MK_SHIFT_CONST(8)
#define OWR_INTR_STATUS_0_TXF_OVF_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_TXF_OVF_SHIFT)
#define OWR_INTR_STATUS_0_TXF_OVF_RANGE                 8:8
#define OWR_INTR_STATUS_0_TXF_OVF_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_TXF_OVF_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_TXF_OVF_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_TXF_OVF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_TXF_OVF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_TXF_OVF_NOT_EMPTY                     _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_TXF_OVF_EMPTY                 _MK_ENUM_CONST(1)

// RX FIFO Under run: RO.  This bit is set to 1 whenever software tries to
// read from an empty RX FIFO. 
// Software writes a 1 to clear this bit. 
#define OWR_INTR_STATUS_0_RXF_UNR_SHIFT                 _MK_SHIFT_CONST(9)
#define OWR_INTR_STATUS_0_RXF_UNR_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_RXF_UNR_SHIFT)
#define OWR_INTR_STATUS_0_RXF_UNR_RANGE                 9:9
#define OWR_INTR_STATUS_0_RXF_UNR_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_RXF_UNR_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RXF_UNR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_RXF_UNR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RXF_UNR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RXF_UNR_NOT_EMPTY                     _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_RXF_UNR_EMPTY                 _MK_ENUM_CONST(1)

// This bit is set when data is not stable for at least 1us,
// Software writes a 1 to clear this bit. 
// if deglitch detected data transfer should start from 1st. 
#define OWR_INTR_STATUS_0_DGLITCH_SHIFT                 _MK_SHIFT_CONST(10)
#define OWR_INTR_STATUS_0_DGLITCH_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_DGLITCH_SHIFT)
#define OWR_INTR_STATUS_0_DGLITCH_RANGE                 10:10
#define OWR_INTR_STATUS_0_DGLITCH_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_DGLITCH_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_DGLITCH_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_DGLITCH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_DGLITCH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_DGLITCH_DGLITCH_NOT_DETECTED                  _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_DGLITCH_DGLITCH_DETECTED                      _MK_ENUM_CONST(1)

// TX FIFO data req
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_SHIFT                 _MK_SHIFT_CONST(11)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_SHIFT)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_RANGE                 11:11
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_TX_NOT_RDY                    _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_TXFIFO_DATA_REQ_TX_RDY                        _MK_ENUM_CONST(1)

// RX FIFO data req  
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_SHIFT                 _MK_SHIFT_CONST(12)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_SHIFT)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_RANGE                 12:12
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_WOFFSET                       0x0
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_RX_NOT_RDY                    _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_RXFIFO_DATA_REQ_RX_RDY                        _MK_ENUM_CONST(1)

// This bit is set when transfer of each bit done
// this is set on in one bit transfer mode
// software writes 1 to clear this bit
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_SHIFT                       _MK_SHIFT_CONST(13)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_SHIFT)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_RANGE                       13:13
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_WOFFSET                     0x0
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_NOT_DONE                    _MK_ENUM_CONST(0)
#define OWR_INTR_STATUS_0_BIT_TRANSFER_DONE_DONE                        _MK_ENUM_CONST(1)


// Register OWR_INTR_SOURCE_0  
#define OWR_INTR_SOURCE_0                       _MK_ADDR_CONST(0x2c)
#define OWR_INTR_SOURCE_0_SECURE                        0x0
#define OWR_INTR_SOURCE_0_WORD_COUNT                    0x1
#define OWR_INTR_SOURCE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RESET_MASK                    _MK_MASK_CONST(0x3fff)
#define OWR_INTR_SOURCE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_READ_MASK                     _MK_MASK_CONST(0x3fff)
#define OWR_INTR_SOURCE_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_SHIFT                    _MK_SHIFT_CONST(0)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_PRESENCE_ERR_SHIFT)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_RANGE                    0:0
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_WOFFSET                  0x0
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_SLAVE_DETECTED                   _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_PRESENCE_ERR_NO_SLAVE_DETECTED                        _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_CRC_ERR_SHIFT                 _MK_SHIFT_CONST(1)
#define OWR_INTR_SOURCE_0_CRC_ERR_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_CRC_ERR_SHIFT)
#define OWR_INTR_SOURCE_0_CRC_ERR_RANGE                 1:1
#define OWR_INTR_SOURCE_0_CRC_ERR_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_CRC_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_CRC_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_CRC_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_CRC_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_CRC_ERR_N0_ERROR                      _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_CRC_ERR_ERROR                 _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_MEM_WR_ERR_SHIFT                      _MK_SHIFT_CONST(2)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_FIELD                      (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_MEM_WR_ERR_SHIFT)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_RANGE                      2:2
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_WOFFSET                    0x0
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_N0_ERROR                   _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_MEM_WR_ERR_ERROR                      _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_ERR_CMD_SHIFT                 _MK_SHIFT_CONST(3)
#define OWR_INTR_SOURCE_0_ERR_CMD_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_ERR_CMD_SHIFT)
#define OWR_INTR_SOURCE_0_ERR_CMD_RANGE                 3:3
#define OWR_INTR_SOURCE_0_ERR_CMD_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_ERR_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_ERR_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_ERR_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_ERR_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_ERR_CMD_CORRECT_CMD                   _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_ERR_CMD_ERROR_CMD                     _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_RESET_DONE_SHIFT                      _MK_SHIFT_CONST(4)
#define OWR_INTR_SOURCE_0_RESET_DONE_FIELD                      (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_RESET_DONE_SHIFT)
#define OWR_INTR_SOURCE_0_RESET_DONE_RANGE                      4:4
#define OWR_INTR_SOURCE_0_RESET_DONE_WOFFSET                    0x0
#define OWR_INTR_SOURCE_0_RESET_DONE_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RESET_DONE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_RESET_DONE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RESET_DONE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RESET_DONE_NOT_DONE                   _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_RESET_DONE_DONE                       _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_PRESENCE_DONE_SHIFT                   _MK_SHIFT_CONST(5)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_FIELD                   (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_PRESENCE_DONE_SHIFT)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_RANGE                   5:5
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_WOFFSET                 0x0
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_NOT_DONE                        _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_PRESENCE_DONE_DONE                    _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_SHIFT                    _MK_SHIFT_CONST(6)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_ROM_CMD_DONE_SHIFT)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_RANGE                    6:6
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_WOFFSET                  0x0
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_NOT_DONE                 _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_ROM_CMD_DONE_DONE                     _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_SHIFT                    _MK_SHIFT_CONST(7)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_MEM_CMD_DONE_SHIFT)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_RANGE                    7:7
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_WOFFSET                  0x0
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_NOT_DONE                 _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_MEM_CMD_DONE_DONE                     _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_TXF_OVF_SHIFT                 _MK_SHIFT_CONST(8)
#define OWR_INTR_SOURCE_0_TXF_OVF_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_TXF_OVF_SHIFT)
#define OWR_INTR_SOURCE_0_TXF_OVF_RANGE                 8:8
#define OWR_INTR_SOURCE_0_TXF_OVF_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_TXF_OVF_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_TXF_OVF_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_TXF_OVF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_TXF_OVF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_TXF_OVF_NOT_EMPTY                     _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_TXF_OVF_EMPTY                 _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_RXF_UNR_SHIFT                 _MK_SHIFT_CONST(9)
#define OWR_INTR_SOURCE_0_RXF_UNR_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_RXF_UNR_SHIFT)
#define OWR_INTR_SOURCE_0_RXF_UNR_RANGE                 9:9
#define OWR_INTR_SOURCE_0_RXF_UNR_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_RXF_UNR_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RXF_UNR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_RXF_UNR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RXF_UNR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RXF_UNR_NOT_EMPTY                     _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_RXF_UNR_EMPTY                 _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_DGLITCH_SHIFT                 _MK_SHIFT_CONST(10)
#define OWR_INTR_SOURCE_0_DGLITCH_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_DGLITCH_SHIFT)
#define OWR_INTR_SOURCE_0_DGLITCH_RANGE                 10:10
#define OWR_INTR_SOURCE_0_DGLITCH_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_DGLITCH_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_DGLITCH_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_DGLITCH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_DGLITCH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_DGLITCH_DGLITCH_NOT_DETECTED                  _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_DGLITCH_DGLITCH_DETECTED                      _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_SHIFT                 _MK_SHIFT_CONST(11)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_SHIFT)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_RANGE                 11:11
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_TX_NOT_RDY                    _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_TXFIFO_DATA_REQ_TX_RDY                        _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_SHIFT                 _MK_SHIFT_CONST(12)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_SHIFT)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_RANGE                 12:12
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_WOFFSET                       0x0
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_RX_NOT_RDY                    _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_RXFIFO_DATA_REQ_RX_RDY                        _MK_ENUM_CONST(1)

#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_SHIFT                       _MK_SHIFT_CONST(13)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_SHIFT)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_RANGE                       13:13
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_WOFFSET                     0x0
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_NOT_DONE                    _MK_ENUM_CONST(0)
#define OWR_INTR_SOURCE_0_BIT_TRANSFER_DONE_DONE                        _MK_ENUM_CONST(1)


// Register OWR_INTR_SET_0  
#define OWR_INTR_SET_0                  _MK_ADDR_CONST(0x30)
#define OWR_INTR_SET_0_SECURE                   0x0
#define OWR_INTR_SET_0_WORD_COUNT                       0x1
#define OWR_INTR_SET_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RESET_MASK                       _MK_MASK_CONST(0x27ff)
#define OWR_INTR_SET_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_READ_MASK                        _MK_MASK_CONST(0x27ff)
#define OWR_INTR_SET_0_WRITE_MASK                       _MK_MASK_CONST(0x27ff)
#define OWR_INTR_SET_0_PRESENCE_ERR_SHIFT                       _MK_SHIFT_CONST(0)
#define OWR_INTR_SET_0_PRESENCE_ERR_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_PRESENCE_ERR_SHIFT)
#define OWR_INTR_SET_0_PRESENCE_ERR_RANGE                       0:0
#define OWR_INTR_SET_0_PRESENCE_ERR_WOFFSET                     0x0
#define OWR_INTR_SET_0_PRESENCE_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_PRESENCE_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_PRESENCE_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_PRESENCE_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_PRESENCE_ERR_SLAVE_DETECTED                      _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_PRESENCE_ERR_NO_SLAVE_DETECTED                   _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_CRC_ERR_SHIFT                    _MK_SHIFT_CONST(1)
#define OWR_INTR_SET_0_CRC_ERR_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_CRC_ERR_SHIFT)
#define OWR_INTR_SET_0_CRC_ERR_RANGE                    1:1
#define OWR_INTR_SET_0_CRC_ERR_WOFFSET                  0x0
#define OWR_INTR_SET_0_CRC_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_CRC_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_CRC_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_CRC_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_CRC_ERR_N0_ERROR                 _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_CRC_ERR_ERROR                    _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_MEM_WR_ERR_SHIFT                 _MK_SHIFT_CONST(2)
#define OWR_INTR_SET_0_MEM_WR_ERR_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_MEM_WR_ERR_SHIFT)
#define OWR_INTR_SET_0_MEM_WR_ERR_RANGE                 2:2
#define OWR_INTR_SET_0_MEM_WR_ERR_WOFFSET                       0x0
#define OWR_INTR_SET_0_MEM_WR_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_MEM_WR_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_MEM_WR_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_MEM_WR_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_MEM_WR_ERR_N0_ERROR                      _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_MEM_WR_ERR_ERROR                 _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_ERR_CMD_SHIFT                    _MK_SHIFT_CONST(3)
#define OWR_INTR_SET_0_ERR_CMD_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_ERR_CMD_SHIFT)
#define OWR_INTR_SET_0_ERR_CMD_RANGE                    3:3
#define OWR_INTR_SET_0_ERR_CMD_WOFFSET                  0x0
#define OWR_INTR_SET_0_ERR_CMD_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_ERR_CMD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_ERR_CMD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_ERR_CMD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_ERR_CMD_CORRECT_CMD                      _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_ERR_CMD_ERROR_CMD                        _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_RESET_DONE_SHIFT                 _MK_SHIFT_CONST(4)
#define OWR_INTR_SET_0_RESET_DONE_FIELD                 (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_RESET_DONE_SHIFT)
#define OWR_INTR_SET_0_RESET_DONE_RANGE                 4:4
#define OWR_INTR_SET_0_RESET_DONE_WOFFSET                       0x0
#define OWR_INTR_SET_0_RESET_DONE_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RESET_DONE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_RESET_DONE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RESET_DONE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RESET_DONE_NOT_DONE                      _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_RESET_DONE_DONE                  _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_PRESENCE_DONE_SHIFT                      _MK_SHIFT_CONST(5)
#define OWR_INTR_SET_0_PRESENCE_DONE_FIELD                      (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_PRESENCE_DONE_SHIFT)
#define OWR_INTR_SET_0_PRESENCE_DONE_RANGE                      5:5
#define OWR_INTR_SET_0_PRESENCE_DONE_WOFFSET                    0x0
#define OWR_INTR_SET_0_PRESENCE_DONE_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_PRESENCE_DONE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_PRESENCE_DONE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_PRESENCE_DONE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_PRESENCE_DONE_NOT_DONE                   _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_PRESENCE_DONE_DONE                       _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_ROM_CMD_DONE_SHIFT                       _MK_SHIFT_CONST(6)
#define OWR_INTR_SET_0_ROM_CMD_DONE_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_ROM_CMD_DONE_SHIFT)
#define OWR_INTR_SET_0_ROM_CMD_DONE_RANGE                       6:6
#define OWR_INTR_SET_0_ROM_CMD_DONE_WOFFSET                     0x0
#define OWR_INTR_SET_0_ROM_CMD_DONE_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_ROM_CMD_DONE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_ROM_CMD_DONE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_ROM_CMD_DONE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_ROM_CMD_DONE_NOT_DONE                    _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_ROM_CMD_DONE_DONE                        _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_MEM_CMD_DONE_SHIFT                       _MK_SHIFT_CONST(7)
#define OWR_INTR_SET_0_MEM_CMD_DONE_FIELD                       (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_MEM_CMD_DONE_SHIFT)
#define OWR_INTR_SET_0_MEM_CMD_DONE_RANGE                       7:7
#define OWR_INTR_SET_0_MEM_CMD_DONE_WOFFSET                     0x0
#define OWR_INTR_SET_0_MEM_CMD_DONE_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_MEM_CMD_DONE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_MEM_CMD_DONE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_MEM_CMD_DONE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_MEM_CMD_DONE_NOT_DONE                    _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_MEM_CMD_DONE_DONE                        _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_TXF_OVF_SHIFT                    _MK_SHIFT_CONST(8)
#define OWR_INTR_SET_0_TXF_OVF_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_TXF_OVF_SHIFT)
#define OWR_INTR_SET_0_TXF_OVF_RANGE                    8:8
#define OWR_INTR_SET_0_TXF_OVF_WOFFSET                  0x0
#define OWR_INTR_SET_0_TXF_OVF_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_TXF_OVF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_TXF_OVF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_TXF_OVF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_TXF_OVF_NOT_EMPTY                        _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_TXF_OVF_EMPTY                    _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_RXF_UNR_SHIFT                    _MK_SHIFT_CONST(9)
#define OWR_INTR_SET_0_RXF_UNR_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_RXF_UNR_SHIFT)
#define OWR_INTR_SET_0_RXF_UNR_RANGE                    9:9
#define OWR_INTR_SET_0_RXF_UNR_WOFFSET                  0x0
#define OWR_INTR_SET_0_RXF_UNR_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RXF_UNR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_RXF_UNR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RXF_UNR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_RXF_UNR_NOT_EMPTY                        _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_RXF_UNR_EMPTY                    _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_DGLITCH_SHIFT                    _MK_SHIFT_CONST(10)
#define OWR_INTR_SET_0_DGLITCH_FIELD                    (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_DGLITCH_SHIFT)
#define OWR_INTR_SET_0_DGLITCH_RANGE                    10:10
#define OWR_INTR_SET_0_DGLITCH_WOFFSET                  0x0
#define OWR_INTR_SET_0_DGLITCH_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_DGLITCH_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_DGLITCH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_DGLITCH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_DGLITCH_DGLITCH_NOT_DETECTED                     _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_DGLITCH_DGLITCH_DETECTED                 _MK_ENUM_CONST(1)

#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_SHIFT                  _MK_SHIFT_CONST(13)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_FIELD                  (_MK_MASK_CONST(0x1) << OWR_INTR_SET_0_BIT_TRANSFER_DONE_SHIFT)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_RANGE                  13:13
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_WOFFSET                        0x0
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_NOT_DONE                       _MK_ENUM_CONST(0)
#define OWR_INTR_SET_0_BIT_TRANSFER_DONE_DONE                   _MK_ENUM_CONST(1)


// Register OWR_STATUS_0  
#define OWR_STATUS_0                    _MK_ADDR_CONST(0x34)
#define OWR_STATUS_0_SECURE                     0x0
#define OWR_STATUS_0_WORD_COUNT                         0x1
#define OWR_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x15)
#define OWR_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0xffffff)
#define OWR_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_READ_MASK                  _MK_MASK_CONST(0xffffff)
#define OWR_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x60)
// Ready bit. This bit is set at the end of every transfer and 
// its cleared by hardware when next transfer starts  
#define OWR_STATUS_0_RDY_SHIFT                  _MK_SHIFT_CONST(0)
#define OWR_STATUS_0_RDY_FIELD                  (_MK_MASK_CONST(0x1) << OWR_STATUS_0_RDY_SHIFT)
#define OWR_STATUS_0_RDY_RANGE                  0:0
#define OWR_STATUS_0_RDY_WOFFSET                        0x0
#define OWR_STATUS_0_RDY_DEFAULT                        _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RDY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RDY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RDY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RDY_NOT_READY                      _MK_ENUM_CONST(0)
#define OWR_STATUS_0_RDY_READY                  _MK_ENUM_CONST(1)

// TX FIFO full status: RO.Hardware sets this bit to 1 if TX FIFO is full.
// Otherwise, this bit is set to 0. 
#define OWR_STATUS_0_TXF_FULL_SHIFT                     _MK_SHIFT_CONST(1)
#define OWR_STATUS_0_TXF_FULL_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_TXF_FULL_SHIFT)
#define OWR_STATUS_0_TXF_FULL_RANGE                     1:1
#define OWR_STATUS_0_TXF_FULL_WOFFSET                   0x0
#define OWR_STATUS_0_TXF_FULL_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TXF_FULL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_TXF_FULL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TXF_FULL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TXF_FULL_NOT_FULL                  _MK_ENUM_CONST(0)
#define OWR_STATUS_0_TXF_FULL_FULL                      _MK_ENUM_CONST(1)

// TX FIFO empty status: RO.Hardware sets this bit to 1 if TX FIFO is empty
// Otherwise, this bit is set to 0.   
#define OWR_STATUS_0_TXF_EMPTY_SHIFT                    _MK_SHIFT_CONST(2)
#define OWR_STATUS_0_TXF_EMPTY_FIELD                    (_MK_MASK_CONST(0x1) << OWR_STATUS_0_TXF_EMPTY_SHIFT)
#define OWR_STATUS_0_TXF_EMPTY_RANGE                    2:2
#define OWR_STATUS_0_TXF_EMPTY_WOFFSET                  0x0
#define OWR_STATUS_0_TXF_EMPTY_DEFAULT                  _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_TXF_EMPTY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_TXF_EMPTY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TXF_EMPTY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TXF_EMPTY_NOT_EMPTY                        _MK_ENUM_CONST(0)
#define OWR_STATUS_0_TXF_EMPTY_EMPTY                    _MK_ENUM_CONST(1)

// RX FIFO full status: RO.Hardware sets this bit to 1 if RX FIFO is full.
// Otherwise, this bit is set to 0.  
#define OWR_STATUS_0_RXF_FULL_SHIFT                     _MK_SHIFT_CONST(3)
#define OWR_STATUS_0_RXF_FULL_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_RXF_FULL_SHIFT)
#define OWR_STATUS_0_RXF_FULL_RANGE                     3:3
#define OWR_STATUS_0_RXF_FULL_WOFFSET                   0x0
#define OWR_STATUS_0_RXF_FULL_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RXF_FULL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RXF_FULL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RXF_FULL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RXF_FULL_NOT_FULL                  _MK_ENUM_CONST(0)
#define OWR_STATUS_0_RXF_FULL_FULL                      _MK_ENUM_CONST(1)

// RX FIFO empty status: RO.Hardware sets this bit to 1 if RX FIFO is empty
// Otherwise, this bit is set to 0.  
#define OWR_STATUS_0_RXF_EMPTY_SHIFT                    _MK_SHIFT_CONST(4)
#define OWR_STATUS_0_RXF_EMPTY_FIELD                    (_MK_MASK_CONST(0x1) << OWR_STATUS_0_RXF_EMPTY_SHIFT)
#define OWR_STATUS_0_RXF_EMPTY_RANGE                    4:4
#define OWR_STATUS_0_RXF_EMPTY_WOFFSET                  0x0
#define OWR_STATUS_0_RXF_EMPTY_DEFAULT                  _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RXF_EMPTY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RXF_EMPTY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RXF_EMPTY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RXF_EMPTY_NOT_EMPTY                        _MK_ENUM_CONST(0)
#define OWR_STATUS_0_RXF_EMPTY_EMPTY                    _MK_ENUM_CONST(1)

// flush the tx fifo,cleared after fifo is empty 
#define OWR_STATUS_0_TX_FLUSH_SHIFT                     _MK_SHIFT_CONST(5)
#define OWR_STATUS_0_TX_FLUSH_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_TX_FLUSH_SHIFT)
#define OWR_STATUS_0_TX_FLUSH_RANGE                     5:5
#define OWR_STATUS_0_TX_FLUSH_WOFFSET                   0x0
#define OWR_STATUS_0_TX_FLUSH_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TX_FLUSH_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_TX_FLUSH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TX_FLUSH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TX_FLUSH_DISABLE                   _MK_ENUM_CONST(0)
#define OWR_STATUS_0_TX_FLUSH_ENABLE                    _MK_ENUM_CONST(1)

// flush the rx fifo,cleared after fifo is empty 
#define OWR_STATUS_0_RX_FLUSH_SHIFT                     _MK_SHIFT_CONST(6)
#define OWR_STATUS_0_RX_FLUSH_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_RX_FLUSH_SHIFT)
#define OWR_STATUS_0_RX_FLUSH_RANGE                     6:6
#define OWR_STATUS_0_RX_FLUSH_WOFFSET                   0x0
#define OWR_STATUS_0_RX_FLUSH_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RX_FLUSH_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RX_FLUSH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RX_FLUSH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RX_FLUSH_DISABLE                   _MK_ENUM_CONST(0)
#define OWR_STATUS_0_RX_FLUSH_ENABLE                    _MK_ENUM_CONST(1)

// The number of slots to be read from  the rx fifo
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_SHIFT                     _MK_SHIFT_CONST(7)
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_FIELD                     (_MK_MASK_CONST(0x3f) << OWR_STATUS_0_RX_FIFO_FULL_CNT_SHIFT)
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_RANGE                     12:7
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_WOFFSET                   0x0
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RX_FIFO_FULL_CNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// The number of slots that can be written to the tx fifo
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_SHIFT                    _MK_SHIFT_CONST(13)
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_FIELD                    (_MK_MASK_CONST(0x3f) << OWR_STATUS_0_TX_FIFO_EMPTY_CNT_SHIFT)
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_RANGE                    18:13
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_WOFFSET                  0x0
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_TX_FIFO_EMPTY_CNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// this is set when rpp reset bit is set in ctl reg(go), 
// auto cleared on completion of reset initialization sequence.
#define OWR_STATUS_0_RPP_SHIFT                  _MK_SHIFT_CONST(19)
#define OWR_STATUS_0_RPP_FIELD                  (_MK_MASK_CONST(0x1) << OWR_STATUS_0_RPP_SHIFT)
#define OWR_STATUS_0_RPP_RANGE                  19:19
#define OWR_STATUS_0_RPP_WOFFSET                        0x0
#define OWR_STATUS_0_RPP_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RPP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RPP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RPP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RPP_IDLE                   _MK_ENUM_CONST(0)
#define OWR_STATUS_0_RPP_RESET_PRESENCE_PULSE                   _MK_ENUM_CONST(1)

// WRITE 0 : This bit is self clearing,and is cleared 
// when write zero time slot completes 
// on write sequence 0  is transfered 
#define OWR_STATUS_0_WR0_BUSY_SHIFT                     _MK_SHIFT_CONST(20)
#define OWR_STATUS_0_WR0_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_WR0_BUSY_SHIFT)
#define OWR_STATUS_0_WR0_BUSY_RANGE                     20:20
#define OWR_STATUS_0_WR0_BUSY_WOFFSET                   0x0
#define OWR_STATUS_0_WR0_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_WR0_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_WR0_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_WR0_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_WR0_BUSY_IDLE                      _MK_ENUM_CONST(0)
#define OWR_STATUS_0_WR0_BUSY_BUSY                      _MK_ENUM_CONST(1)

// WRITE1 : This is a self clearing bit and is cleared 
// when write one time slot completes
// on write sequence 1  is transfered 
#define OWR_STATUS_0_WR1_BUSY_SHIFT                     _MK_SHIFT_CONST(21)
#define OWR_STATUS_0_WR1_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_WR1_BUSY_SHIFT)
#define OWR_STATUS_0_WR1_BUSY_RANGE                     21:21
#define OWR_STATUS_0_WR1_BUSY_WOFFSET                   0x0
#define OWR_STATUS_0_WR1_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_WR1_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_WR1_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_WR1_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_WR1_BUSY_IDLE                      _MK_ENUM_CONST(0)
#define OWR_STATUS_0_WR1_BUSY_BUSY                      _MK_ENUM_CONST(1)

// READ : This is a self clearing bit and is cleared 
// when read time slot completes
// on read sequence the sampled read bit is stored in READ_BIT
#define OWR_STATUS_0_RD_BUSY_SHIFT                      _MK_SHIFT_CONST(22)
#define OWR_STATUS_0_RD_BUSY_FIELD                      (_MK_MASK_CONST(0x1) << OWR_STATUS_0_RD_BUSY_SHIFT)
#define OWR_STATUS_0_RD_BUSY_RANGE                      22:22
#define OWR_STATUS_0_RD_BUSY_WOFFSET                    0x0
#define OWR_STATUS_0_RD_BUSY_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RD_BUSY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_RD_BUSY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RD_BUSY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_RD_BUSY_IDLE                       _MK_ENUM_CONST(0)
#define OWR_STATUS_0_RD_BUSY_BUSY                       _MK_ENUM_CONST(1)

// the bit is valid only RD_BUSY is cleared 
#define OWR_STATUS_0_READ_SAMPLED_BIT_SHIFT                     _MK_SHIFT_CONST(23)
#define OWR_STATUS_0_READ_SAMPLED_BIT_FIELD                     (_MK_MASK_CONST(0x1) << OWR_STATUS_0_READ_SAMPLED_BIT_SHIFT)
#define OWR_STATUS_0_READ_SAMPLED_BIT_RANGE                     23:23
#define OWR_STATUS_0_READ_SAMPLED_BIT_WOFFSET                   0x0
#define OWR_STATUS_0_READ_SAMPLED_BIT_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_READ_SAMPLED_BIT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define OWR_STATUS_0_READ_SAMPLED_BIT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_READ_SAMPLED_BIT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_STATUS_0_READ_SAMPLED_BIT_READ_ZERO                 _MK_ENUM_CONST(0)
#define OWR_STATUS_0_READ_SAMPLED_BIT_READ_ONE                  _MK_ENUM_CONST(1)


// Register OWR_CRC_0  
#define OWR_CRC_0                       _MK_ADDR_CONST(0x38)
#define OWR_CRC_0_SECURE                        0x0
#define OWR_CRC_0_WORD_COUNT                    0x1
#define OWR_CRC_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define OWR_CRC_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define OWR_CRC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define OWR_CRC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define OWR_CRC_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define OWR_CRC_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// CRC Received on Read Data
#define OWR_CRC_0_CRC_RECEV_SHIFT                       _MK_SHIFT_CONST(0)
#define OWR_CRC_0_CRC_RECEV_FIELD                       (_MK_MASK_CONST(0xffff) << OWR_CRC_0_CRC_RECEV_SHIFT)
#define OWR_CRC_0_CRC_RECEV_RANGE                       15:0
#define OWR_CRC_0_CRC_RECEV_WOFFSET                     0x0
#define OWR_CRC_0_CRC_RECEV_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_CRC_0_CRC_RECEV_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define OWR_CRC_0_CRC_RECEV_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_CRC_0_CRC_RECEV_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// CRC calculated by owr current wr/rd operation
#define OWR_CRC_0_CRC_CALC_SHIFT                        _MK_SHIFT_CONST(16)
#define OWR_CRC_0_CRC_CALC_FIELD                        (_MK_MASK_CONST(0xffff) << OWR_CRC_0_CRC_CALC_SHIFT)
#define OWR_CRC_0_CRC_CALC_RANGE                        31:16
#define OWR_CRC_0_CRC_CALC_WOFFSET                      0x0
#define OWR_CRC_0_CRC_CALC_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_CRC_0_CRC_CALC_DEFAULT_MASK                 _MK_MASK_CONST(0xffff)
#define OWR_CRC_0_CRC_CALC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_CRC_0_CRC_CALC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register OWR_BYTE_CNT_0  
#define OWR_BYTE_CNT_0                  _MK_ADDR_CONST(0x3c)
#define OWR_BYTE_CNT_0_SECURE                   0x0
#define OWR_BYTE_CNT_0_WORD_COUNT                       0x1
#define OWR_BYTE_CNT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define OWR_BYTE_CNT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define OWR_BYTE_CNT_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
// Number of bytes Received on Read Data includes crc byte cnt
#define OWR_BYTE_CNT_0_RECEIVED_SHIFT                   _MK_SHIFT_CONST(0)
#define OWR_BYTE_CNT_0_RECEIVED_FIELD                   (_MK_MASK_CONST(0xffff) << OWR_BYTE_CNT_0_RECEIVED_SHIFT)
#define OWR_BYTE_CNT_0_RECEIVED_RANGE                   15:0
#define OWR_BYTE_CNT_0_RECEIVED_WOFFSET                 0x0
#define OWR_BYTE_CNT_0_RECEIVED_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_RECEIVED_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define OWR_BYTE_CNT_0_RECEIVED_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_RECEIVED_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Number of bytes Transmitted on wr cmds or addr sent
#define OWR_BYTE_CNT_0_TRANSMITTED_SHIFT                        _MK_SHIFT_CONST(16)
#define OWR_BYTE_CNT_0_TRANSMITTED_FIELD                        (_MK_MASK_CONST(0xffff) << OWR_BYTE_CNT_0_TRANSMITTED_SHIFT)
#define OWR_BYTE_CNT_0_TRANSMITTED_RANGE                        31:16
#define OWR_BYTE_CNT_0_TRANSMITTED_WOFFSET                      0x0
#define OWR_BYTE_CNT_0_TRANSMITTED_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_TRANSMITTED_DEFAULT_MASK                 _MK_MASK_CONST(0xffff)
#define OWR_BYTE_CNT_0_TRANSMITTED_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_BYTE_CNT_0_TRANSMITTED_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register OWR_TX_FIFO_0  
#define OWR_TX_FIFO_0                   _MK_ADDR_CONST(0x40)
#define OWR_TX_FIFO_0_SECURE                    0x0
#define OWR_TX_FIFO_0_WORD_COUNT                        0x1
#define OWR_TX_FIFO_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define OWR_TX_FIFO_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define OWR_TX_FIFO_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define OWR_TX_FIFO_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_TX_FIFO_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define OWR_TX_FIFO_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// TX FIFO
#define OWR_TX_FIFO_0_WR_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define OWR_TX_FIFO_0_WR_DATA_FIELD                     (_MK_MASK_CONST(0xffffffff) << OWR_TX_FIFO_0_WR_DATA_SHIFT)
#define OWR_TX_FIFO_0_WR_DATA_RANGE                     31:0
#define OWR_TX_FIFO_0_WR_DATA_WOFFSET                   0x0
#define OWR_TX_FIFO_0_WR_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_TX_FIFO_0_WR_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define OWR_TX_FIFO_0_WR_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_TX_FIFO_0_WR_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register OWR_RX_FIFO_0  
#define OWR_RX_FIFO_0                   _MK_ADDR_CONST(0x44)
#define OWR_RX_FIFO_0_SECURE                    0x0
#define OWR_RX_FIFO_0_WORD_COUNT                        0x1
#define OWR_RX_FIFO_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define OWR_RX_FIFO_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define OWR_RX_FIFO_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define OWR_RX_FIFO_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define OWR_RX_FIFO_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define OWR_RX_FIFO_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// RX FIFO
#define OWR_RX_FIFO_0_RD_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define OWR_RX_FIFO_0_RD_DATA_FIELD                     (_MK_MASK_CONST(0xffffffff) << OWR_RX_FIFO_0_RD_DATA_SHIFT)
#define OWR_RX_FIFO_0_RD_DATA_RANGE                     31:0
#define OWR_RX_FIFO_0_RD_DATA_WOFFSET                   0x0
#define OWR_RX_FIFO_0_RD_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_RX_FIFO_0_RD_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define OWR_RX_FIFO_0_RD_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define OWR_RX_FIFO_0_RD_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register OWR_STATE_BITS_0  
#define OWR_STATE_BITS_0                        _MK_ADDR_CONST(0x48)
#define OWR_STATE_BITS_0_SECURE                         0x0
#define OWR_STATE_BITS_0_WORD_COUNT                     0x1
#define OWR_STATE_BITS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define OWR_STATE_BITS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define OWR_STATE_BITS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// controls reset initialization sequence , rom cmd and mem cmd
#define OWR_STATE_BITS_0_OWR_STATE_SHIFT                        _MK_SHIFT_CONST(0)
#define OWR_STATE_BITS_0_OWR_STATE_FIELD                        (_MK_MASK_CONST(0xf) << OWR_STATE_BITS_0_OWR_STATE_SHIFT)
#define OWR_STATE_BITS_0_OWR_STATE_RANGE                        3:0
#define OWR_STATE_BITS_0_OWR_STATE_WOFFSET                      0x0
#define OWR_STATE_BITS_0_OWR_STATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_OWR_STATE_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define OWR_STATE_BITS_0_OWR_STATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_OWR_STATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// executes a particular cmd in rom or mem cmd
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_SHIFT                        _MK_SHIFT_CONST(4)
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_FIELD                        (_MK_MASK_CONST(0xf) << OWR_STATE_BITS_0_CMD_EXECUTE_STATE_SHIFT)
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_RANGE                        7:4
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_WOFFSET                      0x0
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_CMD_EXECUTE_STATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// executes write time slots
#define OWR_STATE_BITS_0_WRITE_STATE_SHIFT                      _MK_SHIFT_CONST(8)
#define OWR_STATE_BITS_0_WRITE_STATE_FIELD                      (_MK_MASK_CONST(0xf) << OWR_STATE_BITS_0_WRITE_STATE_SHIFT)
#define OWR_STATE_BITS_0_WRITE_STATE_RANGE                      11:8
#define OWR_STATE_BITS_0_WRITE_STATE_WOFFSET                    0x0
#define OWR_STATE_BITS_0_WRITE_STATE_DEFAULT                    _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_WRITE_STATE_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define OWR_STATE_BITS_0_WRITE_STATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_WRITE_STATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// executes read time slots 
#define OWR_STATE_BITS_0_READ_STATE_SHIFT                       _MK_SHIFT_CONST(12)
#define OWR_STATE_BITS_0_READ_STATE_FIELD                       (_MK_MASK_CONST(0xf) << OWR_STATE_BITS_0_READ_STATE_SHIFT)
#define OWR_STATE_BITS_0_READ_STATE_RANGE                       15:12
#define OWR_STATE_BITS_0_READ_STATE_WOFFSET                     0x0
#define OWR_STATE_BITS_0_READ_STATE_DEFAULT                     _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_READ_STATE_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define OWR_STATE_BITS_0_READ_STATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define OWR_STATE_BITS_0_READ_STATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_AROWR_REGS(_op_) \
_op_(OWR_CONTROL_0) \
_op_(OWR_COMMAND_0) \
_op_(OWR_EPROM_0) \
_op_(OWR_WR_RD_TCTL_0) \
_op_(OWR_RST_PRESENCE_TCTL_0) \
_op_(OWR_PPM_CORRECTION_TCTL_0) \
_op_(OWR_PROG_PULSE_TCTL_0) \
_op_(OWR_READ_ROM0_0) \
_op_(OWR_READ_ROM1_0) \
_op_(OWR_INTR_MASK_0) \
_op_(OWR_INTR_STATUS_0) \
_op_(OWR_INTR_SOURCE_0) \
_op_(OWR_INTR_SET_0) \
_op_(OWR_STATUS_0) \
_op_(OWR_CRC_0) \
_op_(OWR_BYTE_CNT_0) \
_op_(OWR_TX_FIFO_0) \
_op_(OWR_RX_FIFO_0) \
_op_(OWR_STATE_BITS_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_OWR        0x00000000

//
// AROWR REGISTER BANKS
//

#define OWR0_FIRST_REG 0x0000 // OWR_CONTROL_0
#define OWR0_LAST_REG 0x0048 // OWR_STATE_BITS_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___AROWR_H_INC_
