/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARSLINK_H_INC_
#define ___ARSLINK_H_INC_

// Register SLINK_COMMAND_0  
#define SLINK_COMMAND_0                 _MK_ADDR_CONST(0x0)
#define SLINK_COMMAND_0_SECURE                  0x0
#define SLINK_COMMAND_0_WORD_COUNT                      0x1
#define SLINK_COMMAND_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_RESET_MASK                      _MK_MASK_CONST(0xf3f33fff)
#define SLINK_COMMAND_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_READ_MASK                       _MK_MASK_CONST(0xf3f33fff)
#define SLINK_COMMAND_0_WRITE_MASK                      _MK_MASK_CONST(0xf3f33fff)
// RD/WD access to Data Register would start the next  transfer. (This allows continuous Receive via RD of Buffer and Automated  Transmit per WD of Buffer Register)
#define SLINK_COMMAND_0_ENB_SHIFT                       _MK_SHIFT_CONST(31)
#define SLINK_COMMAND_0_ENB_FIELD                       (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_ENB_SHIFT)
#define SLINK_COMMAND_0_ENB_RANGE                       31:31
#define SLINK_COMMAND_0_ENB_WOFFSET                     0x0
#define SLINK_COMMAND_0_ENB_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_ENB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_ENB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_ENB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_ENB_DISABLE                     _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_ENB_ENABLE                      _MK_ENUM_CONST(1)

// Program 1 after all the other bits in the COMMAND2 and COMMAND are programmed to start the trasnfer
// HW clears this bit automatically after the trasnfer is done
// Clearing of the bit by SW will stop the Shifter  and latch the partial data into buffer
#define SLINK_COMMAND_0_GO_SHIFT                        _MK_SHIFT_CONST(30)
#define SLINK_COMMAND_0_GO_FIELD                        (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_GO_SHIFT)
#define SLINK_COMMAND_0_GO_RANGE                        30:30
#define SLINK_COMMAND_0_GO_WOFFSET                      0x0
#define SLINK_COMMAND_0_GO_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_GO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_GO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_GO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_GO_STOP                 _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_GO_GO                   _MK_ENUM_CONST(1)

//  1 = Hold APB Cycle from writing another data into COMMAND register until RDY 0  = NOP. Use of this bit is deprecated.
#define SLINK_COMMAND_0_WAIT_SHIFT                      _MK_SHIFT_CONST(29)
#define SLINK_COMMAND_0_WAIT_FIELD                      (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_WAIT_SHIFT)
#define SLINK_COMMAND_0_WAIT_RANGE                      29:29
#define SLINK_COMMAND_0_WAIT_WOFFSET                    0x0
#define SLINK_COMMAND_0_WAIT_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_WAIT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_WAIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_WAIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_WAIT_NOP                        _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_WAIT_WAIT                       _MK_ENUM_CONST(1)

// 1 = Master Mode (internal Clock) 0 = Slave Mode  (external Clock)
#define SLINK_COMMAND_0_M_S_SHIFT                       _MK_SHIFT_CONST(28)
#define SLINK_COMMAND_0_M_S_FIELD                       (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_M_S_SHIFT)
#define SLINK_COMMAND_0_M_S_RANGE                       28:28
#define SLINK_COMMAND_0_M_S_WOFFSET                     0x0
#define SLINK_COMMAND_0_M_S_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_M_S_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_M_S_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_M_S_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_M_S_SLAVE                       _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_M_S_MASTER                      _MK_ENUM_CONST(1)

// 11 = Pull High 10 = Pull Low 01 = Driven High 00 =  Driven Low (def)
#define SLINK_COMMAND_0_IDLE_SCLK_SHIFT                 _MK_SHIFT_CONST(24)
#define SLINK_COMMAND_0_IDLE_SCLK_FIELD                 (_MK_MASK_CONST(0x3) << SLINK_COMMAND_0_IDLE_SCLK_SHIFT)
#define SLINK_COMMAND_0_IDLE_SCLK_RANGE                 25:24
#define SLINK_COMMAND_0_IDLE_SCLK_WOFFSET                       0x0
#define SLINK_COMMAND_0_IDLE_SCLK_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_IDLE_SCLK_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define SLINK_COMMAND_0_IDLE_SCLK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_IDLE_SCLK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_IDLE_SCLK_DRIVE_LOW                     _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_IDLE_SCLK_DRIVE_HIGH                    _MK_ENUM_CONST(1)
#define SLINK_COMMAND_0_IDLE_SCLK_PULL_LOW                      _MK_ENUM_CONST(2)
#define SLINK_COMMAND_0_IDLE_SCLK_PULL_HIGH                     _MK_ENUM_CONST(3)

//  1 = CS3 active high  0  = CS3 active low
#define SLINK_COMMAND_0_CS_POLARITY3_SHIFT                      _MK_SHIFT_CONST(23)
#define SLINK_COMMAND_0_CS_POLARITY3_FIELD                      (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CS_POLARITY3_SHIFT)
#define SLINK_COMMAND_0_CS_POLARITY3_RANGE                      23:23
#define SLINK_COMMAND_0_CS_POLARITY3_WOFFSET                    0x0
#define SLINK_COMMAND_0_CS_POLARITY3_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CS_POLARITY3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY3_LOW                        _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CS_POLARITY3_HIGH                       _MK_ENUM_CONST(1)

//  1 = CS2 active high  0  = CS2 active low
#define SLINK_COMMAND_0_CS_POLARITY2_SHIFT                      _MK_SHIFT_CONST(22)
#define SLINK_COMMAND_0_CS_POLARITY2_FIELD                      (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CS_POLARITY2_SHIFT)
#define SLINK_COMMAND_0_CS_POLARITY2_RANGE                      22:22
#define SLINK_COMMAND_0_CS_POLARITY2_WOFFSET                    0x0
#define SLINK_COMMAND_0_CS_POLARITY2_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CS_POLARITY2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY2_LOW                        _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CS_POLARITY2_HIGH                       _MK_ENUM_CONST(1)

//  1 = Rising Edge 0 =  Falling Edge (def)
#define SLINK_COMMAND_0_CK_SDA_SHIFT                    _MK_SHIFT_CONST(21)
#define SLINK_COMMAND_0_CK_SDA_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CK_SDA_SHIFT)
#define SLINK_COMMAND_0_CK_SDA_RANGE                    21:21
#define SLINK_COMMAND_0_CK_SDA_WOFFSET                  0x0
#define SLINK_COMMAND_0_CK_SDA_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CK_SDA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CK_SDA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CK_SDA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CK_SDA_FIRST_CLK_EDGE                   _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CK_SDA_SECOND_CLK_EDGE                  _MK_ENUM_CONST(1)

//  1 = CS1 active high  0  = CS1 active low
#define SLINK_COMMAND_0_CS_POLARITY1_SHIFT                      _MK_SHIFT_CONST(20)
#define SLINK_COMMAND_0_CS_POLARITY1_FIELD                      (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CS_POLARITY1_SHIFT)
#define SLINK_COMMAND_0_CS_POLARITY1_RANGE                      20:20
#define SLINK_COMMAND_0_CS_POLARITY1_WOFFSET                    0x0
#define SLINK_COMMAND_0_CS_POLARITY1_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CS_POLARITY1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY1_LOW                        _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CS_POLARITY1_HIGH                       _MK_ENUM_CONST(1)

// 11 = Pull High 10 = Pull Low 01 = Driven High 00  = Driven Low
#define SLINK_COMMAND_0_IDLE_SDA_SHIFT                  _MK_SHIFT_CONST(16)
#define SLINK_COMMAND_0_IDLE_SDA_FIELD                  (_MK_MASK_CONST(0x3) << SLINK_COMMAND_0_IDLE_SDA_SHIFT)
#define SLINK_COMMAND_0_IDLE_SDA_RANGE                  17:16
#define SLINK_COMMAND_0_IDLE_SDA_WOFFSET                        0x0
#define SLINK_COMMAND_0_IDLE_SDA_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_IDLE_SDA_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define SLINK_COMMAND_0_IDLE_SDA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_IDLE_SDA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_IDLE_SDA_DRIVE_LOW                      _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_IDLE_SDA_DRIVE_HIGH                     _MK_ENUM_CONST(1)
#define SLINK_COMMAND_0_IDLE_SDA_PULL_LOW                       _MK_ENUM_CONST(2)
#define SLINK_COMMAND_0_IDLE_SDA_PULL_HIGH                      _MK_ENUM_CONST(3)

//  1 = CS0 active high  0  = CS0 active low
#define SLINK_COMMAND_0_CS_POLARITY0_SHIFT                      _MK_SHIFT_CONST(13)
#define SLINK_COMMAND_0_CS_POLARITY0_FIELD                      (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CS_POLARITY0_SHIFT)
#define SLINK_COMMAND_0_CS_POLARITY0_RANGE                      13:13
#define SLINK_COMMAND_0_CS_POLARITY0_WOFFSET                    0x0
#define SLINK_COMMAND_0_CS_POLARITY0_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CS_POLARITY0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_POLARITY0_LOW                        _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CS_POLARITY0_HIGH                       _MK_ENUM_CONST(1)

//  1 = CS is high  0  = CS is low  
#define SLINK_COMMAND_0_CS_VALUE_SHIFT                  _MK_SHIFT_CONST(12)
#define SLINK_COMMAND_0_CS_VALUE_FIELD                  (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CS_VALUE_SHIFT)
#define SLINK_COMMAND_0_CS_VALUE_RANGE                  12:12
#define SLINK_COMMAND_0_CS_VALUE_WOFFSET                        0x0
#define SLINK_COMMAND_0_CS_VALUE_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_VALUE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CS_VALUE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_VALUE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_VALUE_LOW                    _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CS_VALUE_HIGH                   _MK_ENUM_CONST(1)

//  1 = CS controlled by SW   0  = CS controlled by hardware
#define SLINK_COMMAND_0_CS_SW_SHIFT                     _MK_SHIFT_CONST(11)
#define SLINK_COMMAND_0_CS_SW_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_CS_SW_SHIFT)
#define SLINK_COMMAND_0_CS_SW_RANGE                     11:11
#define SLINK_COMMAND_0_CS_SW_WOFFSET                   0x0
#define SLINK_COMMAND_0_CS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_CS_SW_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_SW_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_CS_SW_HARD                      _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_CS_SW_SOFT                      _MK_ENUM_CONST(1)

//  1 = both lines transmit/receive   0  = one line transmit and other receive 
#define SLINK_COMMAND_0_BOTH_EN_SHIFT                   _MK_SHIFT_CONST(10)
#define SLINK_COMMAND_0_BOTH_EN_FIELD                   (_MK_MASK_CONST(0x1) << SLINK_COMMAND_0_BOTH_EN_SHIFT)
#define SLINK_COMMAND_0_BOTH_EN_RANGE                   10:10
#define SLINK_COMMAND_0_BOTH_EN_WOFFSET                 0x0
#define SLINK_COMMAND_0_BOTH_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_BOTH_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SLINK_COMMAND_0_BOTH_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_BOTH_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_BOTH_EN_DISABLE                 _MK_ENUM_CONST(0)
#define SLINK_COMMAND_0_BOTH_EN_ENABLE                  _MK_ENUM_CONST(1)

// 31 = Thirty Two words (Max)
#define SLINK_COMMAND_0_WORD_SIZE_SHIFT                 _MK_SHIFT_CONST(5)
#define SLINK_COMMAND_0_WORD_SIZE_FIELD                 (_MK_MASK_CONST(0x1f) << SLINK_COMMAND_0_WORD_SIZE_SHIFT)
#define SLINK_COMMAND_0_WORD_SIZE_RANGE                 9:5
#define SLINK_COMMAND_0_WORD_SIZE_WOFFSET                       0x0
#define SLINK_COMMAND_0_WORD_SIZE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_WORD_SIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define SLINK_COMMAND_0_WORD_SIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_WORD_SIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 31 = Thirty Two bit Transfers (Max)
#define SLINK_COMMAND_0_BIT_LENGTH_SHIFT                        _MK_SHIFT_CONST(0)
#define SLINK_COMMAND_0_BIT_LENGTH_FIELD                        (_MK_MASK_CONST(0x1f) << SLINK_COMMAND_0_BIT_LENGTH_SHIFT)
#define SLINK_COMMAND_0_BIT_LENGTH_RANGE                        4:0
#define SLINK_COMMAND_0_BIT_LENGTH_WOFFSET                      0x0
#define SLINK_COMMAND_0_BIT_LENGTH_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_BIT_LENGTH_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define SLINK_COMMAND_0_BIT_LENGTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND_0_BIT_LENGTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register SLINK_COMMAND2_0  
#define SLINK_COMMAND2_0                        _MK_ADDR_CONST(0x4)
#define SLINK_COMMAND2_0_SECURE                         0x0
#define SLINK_COMMAND2_0_WORD_COUNT                     0x1
#define SLINK_COMMAND2_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_RESET_MASK                     _MK_MASK_CONST(0xfcfe1fd3)
#define SLINK_COMMAND2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_READ_MASK                      _MK_MASK_CONST(0xfcfe1fd3)
#define SLINK_COMMAND2_0_WRITE_MASK                     _MK_MASK_CONST(0xfcfe1fd3)
// Receive enable 
#define SLINK_COMMAND2_0_RXEN_SHIFT                     _MK_SHIFT_CONST(31)
#define SLINK_COMMAND2_0_RXEN_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_RXEN_SHIFT)
#define SLINK_COMMAND2_0_RXEN_RANGE                     31:31
#define SLINK_COMMAND2_0_RXEN_WOFFSET                   0x0
#define SLINK_COMMAND2_0_RXEN_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_RXEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_RXEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_RXEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_RXEN_DISABLE                   _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_RXEN_ENABLE                    _MK_ENUM_CONST(1)

// Transmit enable 
#define SLINK_COMMAND2_0_TXEN_SHIFT                     _MK_SHIFT_CONST(30)
#define SLINK_COMMAND2_0_TXEN_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_TXEN_SHIFT)
#define SLINK_COMMAND2_0_TXEN_RANGE                     30:30
#define SLINK_COMMAND2_0_TXEN_WOFFSET                   0x0
#define SLINK_COMMAND2_0_TXEN_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_TXEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_TXEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_TXEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_TXEN_DISABLE                   _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_TXEN_ENABLE                    _MK_ENUM_CONST(1)

//  1 = bi directional mode 0 = Normal mode
#define SLINK_COMMAND2_0_SPC0_SHIFT                     _MK_SHIFT_CONST(29)
#define SLINK_COMMAND2_0_SPC0_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_SPC0_SHIFT)
#define SLINK_COMMAND2_0_SPC0_RANGE                     29:29
#define SLINK_COMMAND2_0_SPC0_WOFFSET                   0x0
#define SLINK_COMMAND2_0_SPC0_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SPC0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_SPC0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SPC0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SPC0_NORMAL                    _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_SPC0_BIDIR                     _MK_ENUM_CONST(1)

// number of cycles between two packs in the DMA. Use of this field is deprecated. Use INT_SIZE 8 = number of cycles between 2 packs (Max) 
#define SLINK_COMMAND2_0_WAIT_PACK_INT_SHIFT                    _MK_SHIFT_CONST(26)
#define SLINK_COMMAND2_0_WAIT_PACK_INT_FIELD                    (_MK_MASK_CONST(0x7) << SLINK_COMMAND2_0_WAIT_PACK_INT_SHIFT)
#define SLINK_COMMAND2_0_WAIT_PACK_INT_RANGE                    28:26
#define SLINK_COMMAND2_0_WAIT_PACK_INT_WOFFSET                  0x0
#define SLINK_COMMAND2_0_WAIT_PACK_INT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_WAIT_PACK_INT_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define SLINK_COMMAND2_0_WAIT_PACK_INT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_WAIT_PACK_INT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Number of transfers the CS should stay low for word sizes more than 32.
// This will enable to do the trasnfer of word sizes > 32 without using apb-dma
// 0x00  For word_sizes 1 to 32
// 0x01  For word_sizes 33 to 64
// 0x10  For word sizes 65 to 96
// 0x11  For word sizes 97 to 128
#define SLINK_COMMAND2_0_FIFO_REFILLS_SHIFT                     _MK_SHIFT_CONST(22)
#define SLINK_COMMAND2_0_FIFO_REFILLS_FIELD                     (_MK_MASK_CONST(0x3) << SLINK_COMMAND2_0_FIFO_REFILLS_SHIFT)
#define SLINK_COMMAND2_0_FIFO_REFILLS_RANGE                     23:22
#define SLINK_COMMAND2_0_FIFO_REFILLS_WOFFSET                   0x0
#define SLINK_COMMAND2_0_FIFO_REFILLS_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_FIFO_REFILLS_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define SLINK_COMMAND2_0_FIFO_REFILLS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_FIFO_REFILLS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_FIFO_REFILLS_REFILL0                   _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_FIFO_REFILLS_REFILL1                   _MK_ENUM_CONST(1)
#define SLINK_COMMAND2_0_FIFO_REFILLS_REFILL2                   _MK_ENUM_CONST(2)
#define SLINK_COMMAND2_0_FIFO_REFILLS_REFILL3                   _MK_ENUM_CONST(3)

// number of cycles CS should stay inactive between packets 4 = number of cycles in setup for chip select (Max)   
#define SLINK_COMMAND2_0_SS_SETUP_SHIFT                 _MK_SHIFT_CONST(20)
#define SLINK_COMMAND2_0_SS_SETUP_FIELD                 (_MK_MASK_CONST(0x3) << SLINK_COMMAND2_0_SS_SETUP_SHIFT)
#define SLINK_COMMAND2_0_SS_SETUP_RANGE                 21:20
#define SLINK_COMMAND2_0_SS_SETUP_WOFFSET                       0x0
#define SLINK_COMMAND2_0_SS_SETUP_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SS_SETUP_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define SLINK_COMMAND2_0_SS_SETUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SS_SETUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 11 = chip select3 10 = chip select2 01 = chip select1 00 = chip select0(def)
#define SLINK_COMMAND2_0_SS_EN_SHIFT                    _MK_SHIFT_CONST(18)
#define SLINK_COMMAND2_0_SS_EN_FIELD                    (_MK_MASK_CONST(0x3) << SLINK_COMMAND2_0_SS_EN_SHIFT)
#define SLINK_COMMAND2_0_SS_EN_RANGE                    19:18
#define SLINK_COMMAND2_0_SS_EN_WOFFSET                  0x0
#define SLINK_COMMAND2_0_SS_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SS_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define SLINK_COMMAND2_0_SS_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SS_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SS_EN_CS0                      _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_SS_EN_CS1                      _MK_ENUM_CONST(1)
#define SLINK_COMMAND2_0_SS_EN_CS2                      _MK_ENUM_CONST(2)
#define SLINK_COMMAND2_0_SS_EN_CS3                      _MK_ENUM_CONST(3)

// 1 = CS active between two packets 0 = CS inactive between two packets
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_SHIFT                        _MK_SHIFT_CONST(17)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_FIELD                        (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_SHIFT)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_RANGE                        17:17
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_WOFFSET                      0x0
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_LOW                  _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_CS_ACTIVE_BETWEEN_HIGH                 _MK_ENUM_CONST(1)

// number of IDLE cycles between two packets
// 31 = thirty two cycles between 2 packets
#define SLINK_COMMAND2_0_INT_SIZE_SHIFT                 _MK_SHIFT_CONST(8)
#define SLINK_COMMAND2_0_INT_SIZE_FIELD                 (_MK_MASK_CONST(0x1f) << SLINK_COMMAND2_0_INT_SIZE_SHIFT)
#define SLINK_COMMAND2_0_INT_SIZE_RANGE                 12:8
#define SLINK_COMMAND2_0_INT_SIZE_WOFFSET                       0x0
#define SLINK_COMMAND2_0_INT_SIZE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_INT_SIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define SLINK_COMMAND2_0_INT_SIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_INT_SIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = Enable Modef   0 = Disable Modef (def)
#define SLINK_COMMAND2_0_MODFEN_SHIFT                   _MK_SHIFT_CONST(7)
#define SLINK_COMMAND2_0_MODFEN_FIELD                   (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_MODFEN_SHIFT)
#define SLINK_COMMAND2_0_MODFEN_RANGE                   7:7
#define SLINK_COMMAND2_0_MODFEN_WOFFSET                 0x0
#define SLINK_COMMAND2_0_MODFEN_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_MODFEN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_MODFEN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_MODFEN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_MODFEN_DISABLE                 _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_MODFEN_ENABLE                  _MK_ENUM_CONST(1)

// When set to 1 SLINK uses only one data line (mosi/miso) for Tx and Rx depending on Master/Slave mode.
// This has effect only when SPC0 is set to 1
// 1 = Enable Output buffer 0 = Disable Output buffer (def)
#define SLINK_COMMAND2_0_BIDIROE_SHIFT                  _MK_SHIFT_CONST(6)
#define SLINK_COMMAND2_0_BIDIROE_FIELD                  (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_BIDIROE_SHIFT)
#define SLINK_COMMAND2_0_BIDIROE_RANGE                  6:6
#define SLINK_COMMAND2_0_BIDIROE_WOFFSET                        0x0
#define SLINK_COMMAND2_0_BIDIROE_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_BIDIROE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_BIDIROE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_BIDIROE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_BIDIROE_DISABLE                        _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_BIDIROE_ENABLE                 _MK_ENUM_CONST(1)

// 1 = Enable SPIE interrupt 0 = Disable SPIE interrupt
#define SLINK_COMMAND2_0_SPIE_SHIFT                     _MK_SHIFT_CONST(4)
#define SLINK_COMMAND2_0_SPIE_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_SPIE_SHIFT)
#define SLINK_COMMAND2_0_SPIE_RANGE                     4:4
#define SLINK_COMMAND2_0_SPIE_WOFFSET                   0x0
#define SLINK_COMMAND2_0_SPIE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SPIE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_SPIE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SPIE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SPIE_DISABLE                   _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_SPIE_ENABLE                    _MK_ENUM_CONST(1)

// 1 = Enable 0 = Disable (def)
#define SLINK_COMMAND2_0_SSOE_SHIFT                     _MK_SHIFT_CONST(1)
#define SLINK_COMMAND2_0_SSOE_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_SSOE_SHIFT)
#define SLINK_COMMAND2_0_SSOE_RANGE                     1:1
#define SLINK_COMMAND2_0_SSOE_WOFFSET                   0x0
#define SLINK_COMMAND2_0_SSOE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SSOE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_SSOE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SSOE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_SSOE_DISABLE                   _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_SSOE_ENABLE                    _MK_ENUM_CONST(1)

//  1 = Transmit LSB first 0 = Transmit LSB last
#define SLINK_COMMAND2_0_LSBFE_SHIFT                    _MK_SHIFT_CONST(0)
#define SLINK_COMMAND2_0_LSBFE_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_COMMAND2_0_LSBFE_SHIFT)
#define SLINK_COMMAND2_0_LSBFE_RANGE                    0:0
#define SLINK_COMMAND2_0_LSBFE_WOFFSET                  0x0
#define SLINK_COMMAND2_0_LSBFE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_LSBFE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_COMMAND2_0_LSBFE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_LSBFE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_COMMAND2_0_LSBFE_LAST                     _MK_ENUM_CONST(0)
#define SLINK_COMMAND2_0_LSBFE_FIRST                    _MK_ENUM_CONST(1)


// Register SLINK_STATUS_0  
#define SLINK_STATUS_0                  _MK_ADDR_CONST(0x8)
#define SLINK_STATUS_0_SECURE                   0x0
#define SLINK_STATUS_0_WORD_COUNT                       0x1
#define SLINK_STATUS_0_RESET_VAL                        _MK_MASK_CONST(0xa00000)
#define SLINK_STATUS_0_RESET_MASK                       _MK_MASK_CONST(0xfffdffff)
#define SLINK_STATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_READ_MASK                        _MK_MASK_CONST(0xfffdffff)
#define SLINK_STATUS_0_WRITE_MASK                       _MK_MASK_CONST(0xfffdffff)
//  1 = Controller is Busy 0 =  Controller is Free
#define SLINK_STATUS_0_BSY_SHIFT                        _MK_SHIFT_CONST(31)
#define SLINK_STATUS_0_BSY_FIELD                        (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_BSY_SHIFT)
#define SLINK_STATUS_0_BSY_RANGE                        31:31
#define SLINK_STATUS_0_BSY_WOFFSET                      0x0
#define SLINK_STATUS_0_BSY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_BSY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_BSY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_BSY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_BSY_IDLE                 _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_BSY_BUSY                 _MK_ENUM_CONST(1)

// 1= contoller is Ready for transfer 0 = controller is Busy. Write 1 to clear the flag
#define SLINK_STATUS_0_RDY_SHIFT                        _MK_SHIFT_CONST(30)
#define SLINK_STATUS_0_RDY_FIELD                        (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_RDY_SHIFT)
#define SLINK_STATUS_0_RDY_RANGE                        30:30
#define SLINK_STATUS_0_RDY_WOFFSET                      0x0
#define SLINK_STATUS_0_RDY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RDY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RDY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RDY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RDY_NOT_READY                    _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_RDY_READY                        _MK_ENUM_CONST(1)

// Will be set to 1 by HW when Errors such as Underflow/overflow occurs.Write 1 to clear the flag
#define SLINK_STATUS_0_ERR_SHIFT                        _MK_SHIFT_CONST(29)
#define SLINK_STATUS_0_ERR_FIELD                        (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_ERR_SHIFT)
#define SLINK_STATUS_0_ERR_RANGE                        29:29
#define SLINK_STATUS_0_ERR_WOFFSET                      0x0
#define SLINK_STATUS_0_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_ERR_OK                   _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_ERR_ERROR                        _MK_ENUM_CONST(1)

// SCLK input signal State
#define SLINK_STATUS_0_SCLK_SHIFT                       _MK_SHIFT_CONST(28)
#define SLINK_STATUS_0_SCLK_FIELD                       (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_SCLK_SHIFT)
#define SLINK_STATUS_0_SCLK_RANGE                       28:28
#define SLINK_STATUS_0_SCLK_WOFFSET                     0x0
#define SLINK_STATUS_0_SCLK_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_SCLK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_SCLK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_SCLK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_SCLK_LOW                 _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_SCLK_HIGH                        _MK_ENUM_CONST(1)

// Flush the RX FIFO
#define SLINK_STATUS_0_RX_FLUSH_SHIFT                   _MK_SHIFT_CONST(27)
#define SLINK_STATUS_0_RX_FLUSH_FIELD                   (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_RX_FLUSH_SHIFT)
#define SLINK_STATUS_0_RX_FLUSH_RANGE                   27:27
#define SLINK_STATUS_0_RX_FLUSH_WOFFSET                 0x0
#define SLINK_STATUS_0_RX_FLUSH_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_FLUSH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RX_FLUSH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_FLUSH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_FLUSH_NOP                     _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_RX_FLUSH_FLUSH                   _MK_ENUM_CONST(1)

// Flush the TX FIFO
#define SLINK_STATUS_0_TX_FLUSH_SHIFT                   _MK_SHIFT_CONST(26)
#define SLINK_STATUS_0_TX_FLUSH_FIELD                   (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_TX_FLUSH_SHIFT)
#define SLINK_STATUS_0_TX_FLUSH_RANGE                   26:26
#define SLINK_STATUS_0_TX_FLUSH_WOFFSET                 0x0
#define SLINK_STATUS_0_TX_FLUSH_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_FLUSH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_TX_FLUSH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_FLUSH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_FLUSH_NOP                     _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_TX_FLUSH_FLUSH                   _MK_ENUM_CONST(1)

// RX FIFO Overflow
#define SLINK_STATUS_0_RX_OVF_SHIFT                     _MK_SHIFT_CONST(25)
#define SLINK_STATUS_0_RX_OVF_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_RX_OVF_SHIFT)
#define SLINK_STATUS_0_RX_OVF_RANGE                     25:25
#define SLINK_STATUS_0_RX_OVF_WOFFSET                   0x0
#define SLINK_STATUS_0_RX_OVF_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_OVF_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RX_OVF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_OVF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_OVF_OK                        _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_RX_OVF_ERROR                     _MK_ENUM_CONST(1)

// TX FIFO Underflow
#define SLINK_STATUS_0_TX_UNF_SHIFT                     _MK_SHIFT_CONST(24)
#define SLINK_STATUS_0_TX_UNF_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_TX_UNF_SHIFT)
#define SLINK_STATUS_0_TX_UNF_RANGE                     24:24
#define SLINK_STATUS_0_TX_UNF_WOFFSET                   0x0
#define SLINK_STATUS_0_TX_UNF_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_UNF_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_TX_UNF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_UNF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_UNF_OK                        _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_TX_UNF_ERROR                     _MK_ENUM_CONST(1)

// RX FIFO Empty
#define SLINK_STATUS_0_RX_EMPTY_SHIFT                   _MK_SHIFT_CONST(23)
#define SLINK_STATUS_0_RX_EMPTY_FIELD                   (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_RX_EMPTY_SHIFT)
#define SLINK_STATUS_0_RX_EMPTY_RANGE                   23:23
#define SLINK_STATUS_0_RX_EMPTY_WOFFSET                 0x0
#define SLINK_STATUS_0_RX_EMPTY_DEFAULT                 _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RX_EMPTY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RX_EMPTY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_EMPTY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_EMPTY_NOT_EMPTY                       _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_RX_EMPTY_EMPTY                   _MK_ENUM_CONST(1)

// RX FIFO Full
#define SLINK_STATUS_0_RX_FULL_SHIFT                    _MK_SHIFT_CONST(22)
#define SLINK_STATUS_0_RX_FULL_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_RX_FULL_SHIFT)
#define SLINK_STATUS_0_RX_FULL_RANGE                    22:22
#define SLINK_STATUS_0_RX_FULL_WOFFSET                  0x0
#define SLINK_STATUS_0_RX_FULL_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_FULL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RX_FULL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_FULL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_FULL_NOT_FULL                 _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_RX_FULL_FULL                     _MK_ENUM_CONST(1)

// TX FIFO Empty
#define SLINK_STATUS_0_TX_EMPTY_SHIFT                   _MK_SHIFT_CONST(21)
#define SLINK_STATUS_0_TX_EMPTY_FIELD                   (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_TX_EMPTY_SHIFT)
#define SLINK_STATUS_0_TX_EMPTY_RANGE                   21:21
#define SLINK_STATUS_0_TX_EMPTY_WOFFSET                 0x0
#define SLINK_STATUS_0_TX_EMPTY_DEFAULT                 _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_TX_EMPTY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_TX_EMPTY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_EMPTY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_EMPTY_NOT_EMPTY                       _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_TX_EMPTY_EMPTY                   _MK_ENUM_CONST(1)

// TX FIFO Full
#define SLINK_STATUS_0_TX_FULL_SHIFT                    _MK_SHIFT_CONST(20)
#define SLINK_STATUS_0_TX_FULL_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_TX_FULL_SHIFT)
#define SLINK_STATUS_0_TX_FULL_RANGE                    20:20
#define SLINK_STATUS_0_TX_FULL_WOFFSET                  0x0
#define SLINK_STATUS_0_TX_FULL_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_FULL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_TX_FULL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_FULL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_FULL_NOT_FULL                 _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_TX_FULL_FULL                     _MK_ENUM_CONST(1)

// TX FIFO Overflow
#define SLINK_STATUS_0_TX_OVF_SHIFT                     _MK_SHIFT_CONST(19)
#define SLINK_STATUS_0_TX_OVF_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_TX_OVF_SHIFT)
#define SLINK_STATUS_0_TX_OVF_RANGE                     19:19
#define SLINK_STATUS_0_TX_OVF_WOFFSET                   0x0
#define SLINK_STATUS_0_TX_OVF_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_OVF_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_TX_OVF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_OVF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_TX_OVF_OK                        _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_TX_OVF_ERROR                     _MK_ENUM_CONST(1)

// RX FIFO Underflow
#define SLINK_STATUS_0_RX_UNF_SHIFT                     _MK_SHIFT_CONST(18)
#define SLINK_STATUS_0_RX_UNF_FIELD                     (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_RX_UNF_SHIFT)
#define SLINK_STATUS_0_RX_UNF_RANGE                     18:18
#define SLINK_STATUS_0_RX_UNF_WOFFSET                   0x0
#define SLINK_STATUS_0_RX_UNF_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_UNF_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_RX_UNF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_UNF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_RX_UNF_OK                        _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_RX_UNF_ERROR                     _MK_ENUM_CONST(1)

// Mode fault
#define SLINK_STATUS_0_MODF_SHIFT                       _MK_SHIFT_CONST(16)
#define SLINK_STATUS_0_MODF_FIELD                       (_MK_MASK_CONST(0x1) << SLINK_STATUS_0_MODF_SHIFT)
#define SLINK_STATUS_0_MODF_RANGE                       16:16
#define SLINK_STATUS_0_MODF_WOFFSET                     0x0
#define SLINK_STATUS_0_MODF_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_MODF_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SLINK_STATUS_0_MODF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_MODF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_MODF_OK                  _MK_ENUM_CONST(0)
#define SLINK_STATUS_0_MODF_ERROR                       _MK_ENUM_CONST(1)

// number of blocks transferred (BLOCK count) during dma
#define SLINK_STATUS_0_BLK_CNT_SHIFT                    _MK_SHIFT_CONST(0)
#define SLINK_STATUS_0_BLK_CNT_FIELD                    (_MK_MASK_CONST(0xffff) << SLINK_STATUS_0_BLK_CNT_SHIFT)
#define SLINK_STATUS_0_BLK_CNT_RANGE                    15:0
#define SLINK_STATUS_0_BLK_CNT_WOFFSET                  0x0
#define SLINK_STATUS_0_BLK_CNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_BLK_CNT_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define SLINK_STATUS_0_BLK_CNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_BLK_CNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// In GO mode indicates number of words transferred (word count) 
#define SLINK_STATUS_0_WORD_SHIFT                       _MK_SHIFT_CONST(5)
#define SLINK_STATUS_0_WORD_FIELD                       (_MK_MASK_CONST(0x1f) << SLINK_STATUS_0_WORD_SHIFT)
#define SLINK_STATUS_0_WORD_RANGE                       9:5
#define SLINK_STATUS_0_WORD_WOFFSET                     0x0
#define SLINK_STATUS_0_WORD_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_WORD_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define SLINK_STATUS_0_WORD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_WORD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// In Go mode indicates mumber of bits trasnferred (bit count)
#define SLINK_STATUS_0_COUNT_SHIFT                      _MK_SHIFT_CONST(0)
#define SLINK_STATUS_0_COUNT_FIELD                      (_MK_MASK_CONST(0x1f) << SLINK_STATUS_0_COUNT_SHIFT)
#define SLINK_STATUS_0_COUNT_RANGE                      4:0
#define SLINK_STATUS_0_COUNT_WOFFSET                    0x0
#define SLINK_STATUS_0_COUNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_COUNT_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define SLINK_STATUS_0_COUNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_STATUS_0_COUNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 12 [0xc] 

// Register SLINK_MAS_DATA_0  
#define SLINK_MAS_DATA_0                        _MK_ADDR_CONST(0x10)
#define SLINK_MAS_DATA_0_SECURE                         0x0
#define SLINK_MAS_DATA_0_WORD_COUNT                     0x1
#define SLINK_MAS_DATA_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SLINK_MAS_DATA_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define SLINK_MAS_DATA_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SLINK_MAS_DATA_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SLINK_MAS_DATA_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define SLINK_MAS_DATA_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Tx/Rx Shift Pattern
#define SLINK_MAS_DATA_0_MASTER_BUFFER_SHIFT                    _MK_SHIFT_CONST(0)
#define SLINK_MAS_DATA_0_MASTER_BUFFER_FIELD                    (_MK_MASK_CONST(0xffffffff) << SLINK_MAS_DATA_0_MASTER_BUFFER_SHIFT)
#define SLINK_MAS_DATA_0_MASTER_BUFFER_RANGE                    31:0
#define SLINK_MAS_DATA_0_MASTER_BUFFER_WOFFSET                  0x0
#define SLINK_MAS_DATA_0_MASTER_BUFFER_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_MAS_DATA_0_MASTER_BUFFER_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define SLINK_MAS_DATA_0_MASTER_BUFFER_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_MAS_DATA_0_MASTER_BUFFER_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register SLINK_SLAVE_DATA_0  
#define SLINK_SLAVE_DATA_0                      _MK_ADDR_CONST(0x14)
#define SLINK_SLAVE_DATA_0_SECURE                       0x0
#define SLINK_SLAVE_DATA_0_WORD_COUNT                   0x1
#define SLINK_SLAVE_DATA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define SLINK_SLAVE_DATA_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define SLINK_SLAVE_DATA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define SLINK_SLAVE_DATA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SLINK_SLAVE_DATA_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define SLINK_SLAVE_DATA_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Tx/Rx Shift Pattern
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_SHIFT                   _MK_SHIFT_CONST(0)
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_FIELD                   (_MK_MASK_CONST(0xffffffff) << SLINK_SLAVE_DATA_0_SLAVE_BUFFER_SHIFT)
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_RANGE                   31:0
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_WOFFSET                 0x0
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_SLAVE_DATA_0_SLAVE_BUFFER_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register SLINK_DMA_CTL_0  
#define SLINK_DMA_CTL_0                 _MK_ADDR_CONST(0x18)
#define SLINK_DMA_CTL_0_SECURE                  0x0
#define SLINK_DMA_CTL_0_WORD_COUNT                      0x1
#define SLINK_DMA_CTL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_RESET_MASK                      _MK_MASK_CONST(0x8c7fffff)
#define SLINK_DMA_CTL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_READ_MASK                       _MK_MASK_CONST(0x8c7fffff)
#define SLINK_DMA_CTL_0_WRITE_MASK                      _MK_MASK_CONST(0x8c7fffff)
//  1 = DMA mode is enabled, 0 = DMA disabled
#define SLINK_DMA_CTL_0_DMA_EN_SHIFT                    _MK_SHIFT_CONST(31)
#define SLINK_DMA_CTL_0_DMA_EN_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_DMA_CTL_0_DMA_EN_SHIFT)
#define SLINK_DMA_CTL_0_DMA_EN_RANGE                    31:31
#define SLINK_DMA_CTL_0_DMA_EN_WOFFSET                  0x0
#define SLINK_DMA_CTL_0_DMA_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_DMA_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_DMA_CTL_0_DMA_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_DMA_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_DMA_EN_DISABLE                  _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_DMA_EN_ENABLE                   _MK_ENUM_CONST(1)

// Interrupt enable on receive completion.
// 1 = Enable interrupt generation at the end of a receive transfer.
// 0 = Disable interrupt generation for receive.
#define SLINK_DMA_CTL_0_IE_RXC_SHIFT                    _MK_SHIFT_CONST(27)
#define SLINK_DMA_CTL_0_IE_RXC_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_DMA_CTL_0_IE_RXC_SHIFT)
#define SLINK_DMA_CTL_0_IE_RXC_RANGE                    27:27
#define SLINK_DMA_CTL_0_IE_RXC_WOFFSET                  0x0
#define SLINK_DMA_CTL_0_IE_RXC_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_IE_RXC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_DMA_CTL_0_IE_RXC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_IE_RXC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_IE_RXC_DISABLE                  _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_IE_RXC_ENABLE                   _MK_ENUM_CONST(1)

// Interrupt enable on transmit completion.
// 1 = Enable interrupt generation at the end of a transmit transfer.
// 0 = Disable interrupt generation for transmit.
#define SLINK_DMA_CTL_0_IE_TXC_SHIFT                    _MK_SHIFT_CONST(26)
#define SLINK_DMA_CTL_0_IE_TXC_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_DMA_CTL_0_IE_TXC_SHIFT)
#define SLINK_DMA_CTL_0_IE_TXC_RANGE                    26:26
#define SLINK_DMA_CTL_0_IE_TXC_WOFFSET                  0x0
#define SLINK_DMA_CTL_0_IE_TXC_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_IE_TXC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_DMA_CTL_0_IE_TXC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_IE_TXC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_IE_TXC_DISABLE                  _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_IE_TXC_ENABLE                   _MK_ENUM_CONST(1)

// Specifies the packet size during the DMA mode
//             00      = 4 bits in a pack
//           01      = 8bits in a pack
//            10      = 16 in a pack
//               10      = 32 in a pack
#define SLINK_DMA_CTL_0_PACK_SIZE_SHIFT                 _MK_SHIFT_CONST(21)
#define SLINK_DMA_CTL_0_PACK_SIZE_FIELD                 (_MK_MASK_CONST(0x3) << SLINK_DMA_CTL_0_PACK_SIZE_SHIFT)
#define SLINK_DMA_CTL_0_PACK_SIZE_RANGE                 22:21
#define SLINK_DMA_CTL_0_PACK_SIZE_WOFFSET                       0x0
#define SLINK_DMA_CTL_0_PACK_SIZE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_PACK_SIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define SLINK_DMA_CTL_0_PACK_SIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_PACK_SIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_PACK_SIZE_PACK4                 _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_PACK_SIZE_PACK8                 _MK_ENUM_CONST(1)
#define SLINK_DMA_CTL_0_PACK_SIZE_PACK16                        _MK_ENUM_CONST(2)
#define SLINK_DMA_CTL_0_PACK_SIZE_PACK32                        _MK_ENUM_CONST(3)

// Packed mode enable bit.
//  1 = Packed mode is enabled. This is only valid if BIT_LENGTH in SBCX_COMMAND register is set to 3, 7, 15 or 31
// When enabled, all 32-bits of data in the FIFO contains valid
// data packets of either 8-bit or 16-bit length.
// 0 = Packed mode is disabled.
#define SLINK_DMA_CTL_0_PACKED_SHIFT                    _MK_SHIFT_CONST(20)
#define SLINK_DMA_CTL_0_PACKED_FIELD                    (_MK_MASK_CONST(0x1) << SLINK_DMA_CTL_0_PACKED_SHIFT)
#define SLINK_DMA_CTL_0_PACKED_RANGE                    20:20
#define SLINK_DMA_CTL_0_PACKED_WOFFSET                  0x0
#define SLINK_DMA_CTL_0_PACKED_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_PACKED_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SLINK_DMA_CTL_0_PACKED_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_PACKED_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_PACKED_DISABLE                  _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_PACKED_ENABLE                   _MK_ENUM_CONST(1)

// Receive FIFO trigger level.
// 00: 1 word. DMA trigger is asserted whenever there is at least 1 word in the RX FIFO.
// 01: 4 word. DMA trigger is asserted when there are at least 4 words in the RX FIFO.
// 10: 8 word. DMA trigger is asserted when there are at least 8 words in the RX FIFO.
// 11: 16 word. DMA trigger is asserted when there are at least 16 words in the RX FIFO.
#define SLINK_DMA_CTL_0_RX_TRIG_SHIFT                   _MK_SHIFT_CONST(18)
#define SLINK_DMA_CTL_0_RX_TRIG_FIELD                   (_MK_MASK_CONST(0x3) << SLINK_DMA_CTL_0_RX_TRIG_SHIFT)
#define SLINK_DMA_CTL_0_RX_TRIG_RANGE                   19:18
#define SLINK_DMA_CTL_0_RX_TRIG_WOFFSET                 0x0
#define SLINK_DMA_CTL_0_RX_TRIG_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_RX_TRIG_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define SLINK_DMA_CTL_0_RX_TRIG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_RX_TRIG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_RX_TRIG_TRIG1                   _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_RX_TRIG_TRIG4                   _MK_ENUM_CONST(1)
#define SLINK_DMA_CTL_0_RX_TRIG_TRIG8                   _MK_ENUM_CONST(2)
#define SLINK_DMA_CTL_0_RX_TRIG_TRIG16                  _MK_ENUM_CONST(3)

// Transmit FIFO trigger level.
// 00: 1 word. DMA trigger is asserted whenever there is at least 1 word in the TX FIFO.
// 01: 4 word. DMA trigger is asserted when there are at least 4 words in the TX FIFO.
// 10: 8 word. DMA trigger is asserted when there are at least 8 words in the TX FIFO.
// 11: 16 word. DMA trigger is asserted when there are at least 16 words in the TX FIFO.
#define SLINK_DMA_CTL_0_TX_TRIG_SHIFT                   _MK_SHIFT_CONST(16)
#define SLINK_DMA_CTL_0_TX_TRIG_FIELD                   (_MK_MASK_CONST(0x3) << SLINK_DMA_CTL_0_TX_TRIG_SHIFT)
#define SLINK_DMA_CTL_0_TX_TRIG_RANGE                   17:16
#define SLINK_DMA_CTL_0_TX_TRIG_WOFFSET                 0x0
#define SLINK_DMA_CTL_0_TX_TRIG_DEFAULT                 _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_TX_TRIG_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define SLINK_DMA_CTL_0_TX_TRIG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_TX_TRIG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_TX_TRIG_TRIG1                   _MK_ENUM_CONST(0)
#define SLINK_DMA_CTL_0_TX_TRIG_TRIG4                   _MK_ENUM_CONST(1)
#define SLINK_DMA_CTL_0_TX_TRIG_TRIG8                   _MK_ENUM_CONST(2)
#define SLINK_DMA_CTL_0_TX_TRIG_TRIG16                  _MK_ENUM_CONST(3)

// N = N+1 packets
// number of packets should be aligned in the packed mode trasnfers.
// packed mode     --> Number of packets
//    3                                        multiple of 8
//    7                                   multiple of 4
//    15                          multiple of 2
//    31                          from 0 to N
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_SHIFT                    _MK_SHIFT_CONST(0)
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_FIELD                    (_MK_MASK_CONST(0xffff) << SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_SHIFT)
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_RANGE                    15:0
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_WOFFSET                  0x0
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SLINK_DMA_CTL_0_DMA_BLOCK_SIZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register SLINK_STATUS2_0  
#define SLINK_STATUS2_0                 _MK_ADDR_CONST(0x1c)
#define SLINK_STATUS2_0_SECURE                  0x0
#define SLINK_STATUS2_0_WORD_COUNT                      0x1
#define SLINK_STATUS2_0_RESET_VAL                       _MK_MASK_CONST(0x20)
#define SLINK_STATUS2_0_RESET_MASK                      _MK_MASK_CONST(0x3f003f)
#define SLINK_STATUS2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SLINK_STATUS2_0_READ_MASK                       _MK_MASK_CONST(0x3f003f)
#define SLINK_STATUS2_0_WRITE_MASK                      _MK_MASK_CONST(0x3f003f)
// Indicates the number of words in the receive FIFO 
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_SHIFT                        _MK_SHIFT_CONST(16)
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_FIELD                        (_MK_MASK_CONST(0x3f) << SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_SHIFT)
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_RANGE                        21:16
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_WOFFSET                      0x0
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SLINK_STATUS2_0_RX_FIFO_FULL_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Indicates the number of empty slots in the transmit FIFO 
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_SHIFT                       _MK_SHIFT_CONST(0)
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_FIELD                       (_MK_MASK_CONST(0x3f) << SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_SHIFT)
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_RANGE                       5:0
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_WOFFSET                     0x0
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_DEFAULT                     _MK_MASK_CONST(0x20)
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SLINK_STATUS2_0_TX_FIFO_EMPTY_COUNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Reserved address 32 [0x20] 

// Reserved address 36 [0x24] 

// Reserved address 40 [0x28] 

// Reserved address 44 [0x2c] 

// Reserved address 48 [0x30] 

// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 

// Reserved address 60 [0x3c] 

// Reserved address 64 [0x40] 

// Reserved address 68 [0x44] 

// Reserved address 72 [0x48] 

// Reserved address 76 [0x4c] 

// Reserved address 80 [0x50] 

// Reserved address 84 [0x54] 

// Reserved address 88 [0x58] 

// Reserved address 92 [0x5c] 

// Reserved address 96 [0x60] 

// Reserved address 100 [0x64] 

// Reserved address 104 [0x68] 

// Reserved address 108 [0x6c] 

// Reserved address 112 [0x70] 

// Reserved address 116 [0x74] 

// Reserved address 120 [0x78] 

// Reserved address 124 [0x7c] 

// Reserved address 128 [0x80] 

// Reserved address 132 [0x84] 

// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Reserved address 144 [0x90] 

// Reserved address 148 [0x94] 

// Reserved address 152 [0x98] 

// Reserved address 156 [0x9c] 

// Reserved address 160 [0xa0] 

// Reserved address 164 [0xa4] 

// Reserved address 168 [0xa8] 

// Reserved address 172 [0xac] 

// Reserved address 176 [0xb0] 

// Reserved address 180 [0xb4] 

// Reserved address 184 [0xb8] 

// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Reserved address 208 [0xd0] 

// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Reserved address 220 [0xdc] 

// Reserved address 224 [0xe0] 

// Reserved address 228 [0xe4] 

// Reserved address 232 [0xe8] 

// Reserved address 236 [0xec] 

// Reserved address 240 [0xf0] 

// Reserved address 244 [0xf4] 

// Reserved address 248 [0xf8] 

// Reserved address 252 [0xfc] 

// Register SLINK_TX_FIFO_0  
#define SLINK_TX_FIFO_0                 _MK_ADDR_CONST(0x100)
#define SLINK_TX_FIFO_0_SECURE                  0x0
#define SLINK_TX_FIFO_0_WORD_COUNT                      0x1
#define SLINK_TX_FIFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SLINK_TX_FIFO_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define SLINK_TX_FIFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SLINK_TX_FIFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SLINK_TX_FIFO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define SLINK_TX_FIFO_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Tx/Rx Shift Pattern
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_SHIFT                  _MK_SHIFT_CONST(0)
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_FIELD                  (_MK_MASK_CONST(0xffffffff) << SLINK_TX_FIFO_0_TX_FIFO_REGISTER_SHIFT)
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_RANGE                  31:0
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_WOFFSET                        0x0
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_TX_FIFO_0_TX_FIFO_REGISTER_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 260 [0x104] 

// Reserved address 264 [0x108] 

// Reserved address 268 [0x10c] 

// Reserved address 272 [0x110] 

// Reserved address 276 [0x114] 

// Reserved address 280 [0x118] 

// Reserved address 284 [0x11c] 

// Reserved address 288 [0x120] 

// Reserved address 292 [0x124] 

// Reserved address 296 [0x128] 

// Reserved address 300 [0x12c] 

// Reserved address 304 [0x130] 

// Reserved address 308 [0x134] 

// Reserved address 312 [0x138] 

// Reserved address 316 [0x13c] 

// Reserved address 320 [0x140] 

// Reserved address 324 [0x144] 

// Reserved address 328 [0x148] 

// Reserved address 332 [0x14c] 

// Reserved address 336 [0x150] 

// Reserved address 340 [0x154] 

// Reserved address 344 [0x158] 

// Reserved address 348 [0x15c] 

// Reserved address 352 [0x160] 

// Reserved address 356 [0x164] 

// Reserved address 360 [0x168] 

// Reserved address 364 [0x16c] 

// Reserved address 368 [0x170] 

// Reserved address 372 [0x174] 

// Reserved address 376 [0x178] 

// Reserved address 380 [0x17c] 

// Register SLINK_RX_FIFO_0  
#define SLINK_RX_FIFO_0                 _MK_ADDR_CONST(0x180)
#define SLINK_RX_FIFO_0_SECURE                  0x0
#define SLINK_RX_FIFO_0_WORD_COUNT                      0x1
#define SLINK_RX_FIFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SLINK_RX_FIFO_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define SLINK_RX_FIFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SLINK_RX_FIFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SLINK_RX_FIFO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define SLINK_RX_FIFO_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Tx/Rx Shift Pattern
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_SHIFT                  _MK_SHIFT_CONST(0)
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_FIELD                  (_MK_MASK_CONST(0xffffffff) << SLINK_RX_FIFO_0_RX_FIFO_REGISTER_SHIFT)
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_RANGE                  31:0
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_WOFFSET                        0x0
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_DEFAULT                        _MK_MASK_CONST(0x0)
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SLINK_RX_FIFO_0_RX_FIFO_REGISTER_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARSLINK_REGS(_op_) \
_op_(SLINK_COMMAND_0) \
_op_(SLINK_COMMAND2_0) \
_op_(SLINK_STATUS_0) \
_op_(SLINK_MAS_DATA_0) \
_op_(SLINK_SLAVE_DATA_0) \
_op_(SLINK_DMA_CTL_0) \
_op_(SLINK_STATUS2_0) \
_op_(SLINK_TX_FIFO_0) \
_op_(SLINK_RX_FIFO_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_SLINK      0x00000000

//
// ARSLINK REGISTER BANKS
//

#define SLINK0_FIRST_REG 0x0000 // SLINK_COMMAND_0
#define SLINK0_LAST_REG 0x0008 // SLINK_STATUS_0
#define SLINK1_FIRST_REG 0x0010 // SLINK_MAS_DATA_0
#define SLINK1_LAST_REG 0x001c // SLINK_STATUS2_0
#define SLINK2_FIRST_REG 0x0100 // SLINK_TX_FIFO_0
#define SLINK2_LAST_REG 0x0100 // SLINK_TX_FIFO_0
#define SLINK3_FIRST_REG 0x0180 // SLINK_RX_FIFO_0
#define SLINK3_LAST_REG 0x0180 // SLINK_RX_FIFO_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARSLINK_H_INC_
