/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARVI_H_INC_
#define ___ARVI_H_INC_
// --------------------------------------------------------------------------
//
// Copyright (c) 2004, NVIDIA Corp.
// All Rights Reserved.
//
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
//
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
//
// --------------------------------------------------------------------------
//
// align 256;
// --------------------------------------------------------------------------
//
// Copyright (c) 2004, NVIDIA Corp.
// All Rights Reserved.
//
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
//
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
//
// --------------------------------------------------------------------------
//
// Video Camera Interface register definition
//
// The Video Camera Interface takes input data from the VI port or from host.
// Data from VI port can be in the following format:
//  a. ITU-R BT.656: 1-byte/clock U8Y8V8Y8 format with embedded syncs in the data stream.
//  b. YUV422: 1-byte/clock U8Y8V8Y8 format with H sync on VHS pin and V sync on VVS pin.
//  c. Bayer Pattern (currently not supported): R8G8, G8B8 format with H sync on VHS pin and
//     V sync on VVS pin.
//  For case b and c, it is also possible to generate H sync and V sync internally in VI
//  module. These internally generated H sync and V sync can be output to the external device
//  and also used internally by the VI module.
// Data from Host can be in the following format:
//  a. YUV422: non-planar 32-bit U8Y8V8Y8 format going through Y-FIFO.
//  b. YUV420: planar 32-bit Y, U, V format going through Y-FIFO, U-FIFO, V-FIFO
//     correspondingly.
// **** In the future, data from host should come from command buffer interface where YUV420
//      to YUV422 conversion, if necessary, should be done using the command buffer.
//      It may not be necessary to convert YUV420 to YUV422 if there is no image processing
//      needed.
//
// The processing stages are:
//  a. Horizontal low-pass filtering
//  b. Horizontal down-scaling with or without horizontal averaging
//  c. Vertical down-scaling with or without vertical averaging
//  d. YUV to RGB Color Space Conversion
//
// Output can be sent to memory (typically for previewing the video image on the display) and/or
// can be sent to Encoder Pre-Processor module to be encoded.
//
// Interface to memory is a normal Block Write or a YUV Block Write interface with option
// for horizontal flip, vertical flip, and XY transpose. Data to be stored in memory can be
// in 16-bit RGB format with optional dithering, YUV422 non-planar, and YUV422/420 planar.
// If output data is stored as YUV420 planar format, the chroma data averaging can be optionally
// performed for each pair of input lines.
// Normal block write is used when output data is in RGB or YUV non-planar format.
// YUV block write is used when output data is YUV planar format.
//
// Output data stored in memory is stored in one buffer set: video buffer 0.
// Output buffer set 0 consists of a programmable number of buffers (from 1 to 255) defined by
// VB0_COUNT parameter.
// Each output buffer consists of programmable number of lines (max 1 frame) defined by
// VB0_V_SIZE parameter which should be even number when data is stored in YUV420 format.
// VB0_H_SIZE parameter determines the line stride (in pixels) and VB0_BUFFER_STRIDE
// determines the buffer stride. The number of active pixels per line in the output buffer
// depends on the input video horizontal active period and the scaling factor and should
// typically not more than the line stride.
// When output DMA request is enabled, the encoder will send a request to send the output
// buffers to the host. Request will be sent after each output buffer is filled and also at the
// end of each encoded frame.
// Note that at the end of frame, the encoded data may not end at output buffer boundary.
// The encoder will send the start address of the buffer to be transferred via the output DMA
// and the correct size of the buffer with each request.
// These are 32-bit registers that can be written/read from host register interface.
// AP15 flow control
// For AP15, we will not use host1xRDMA engine. VI will write into output buffer as is. SW will
// use SYNCPT_OP_DONE as an indicator of one VI output buffer is ready for read. After SW
// consumes one buffer, SW will write to BUFFER_RELEASE register.
// EPP has an internal counter. Every buffer filed will increament the buffer, every write from
// SW to BUFFER_RELEASE register will decrease this counter. VI will stall input bus if:
// counter >= EPP_OUTPUT_BUFFER_COUNT - 1
// For SW to use this flow control correctly, SW has to release all the buffers that locked by
// VI to maintain synchronizations of SW and VI. For example, after flow control is enabled,
// VI output 4 buffers, our flowControlBufferCount = 4. SW only need 2 of them. SW should
// write to BUFFER_RELEASE register 4 times before switch VI for other stream capturing. There
// is no reset of this counter or wrap around. This buffer will be zero after reset. VI
// RTL does provide a EPP_DEBUG_CONTROL_FLOW_COUNTER register, but it is for debug only.
// This apply to both Output1 and Output2.
// suggested syncpt programming sequence: mail from sep.7th, 2007
// -ISP single shot is definitely broken.  The current ECO is probably not correct.
// When VI receives EOF from ISP (in single shot mode), we should squash subsequent
// vsyncs but NOT hsyncs or data.
// -We should test what happens if ISP gets too many lines in a frame
// We think that the following sequence will work in all cases...
// enable continuous vi op_done
// while(1) {
//      program pipe
//      program stream defines for entire pipe
//      invoke single shot
//      issue start_write
//      wait start_write
//      issue reg_wr_safe
//  flush buffer
//      wait op_done
//  trigger next unit
//  wait reg_write_safe
// }
// syncpt commentes:
//
// VI has two different types of syncpt, single-shot and continuous.
// Single-shot syncpts are requested by SW via a write to the one of the INCR_SYNCPT registers.
// When the condition becomes true, the syncpt is returned.  Continuous syncpts are enabled by
// a write to a CONT_SYNCPT register, and will be returned whenever the condition becomes true,
// and does not require SW to do an INCR_SYNCPT write.
//
// single-shot synpct: There are three registers related to single-shot syncpt,
//   VI_OUT_1_INCR_SYNCPT - applies to VI Memory Channel 1
//   VI_OUT_2_INCR_SYNCPT - applies to VI Memory Channel 2
//   VI_MISC_INCR_SYNPCT  - applies to non-memory related conditions
//
// condition: There are 5 conditions for VI_OUT_1_INCR_SYNCPT and VI_OUT_2_INCR_SYNCPT
//   0 -- immediate : syncpt index will be returned immediately when VI_OUT_1/2_INCR_SYNCPT is written.
//   1 -- OP_DONE: syncpt index will be returned when the corresponding output is idle, either output1
//        or output2. This syncpt is level triggered.
//   2 -- RD_DONE:  this is treated the same as OP_DONE condition
//   3 -- REG_WR_SAFE: when all the resources defined in RESOURCE_DEFINE register are all idle, the
//        syncpt index will be returned. This synpct is level triggered.
//   4 -- START_WRITE: when the first pixel is written to memory, either from camera or host, the syncpt
//        index will be returned. This syncpt is edge triggered.
// condition: There are 9 conditions for VI_MISC_INCR_SYNCPT
//            single-shot syncpts (excpet immediate) are not supported on the MISC syncpt.
//   0 -- immediate: syncpt index will be returned immediately when VI_MISC_INCR_SYNCPT is written.
//        This is a level triggered syncpt.
//
// continuous syncpt: There are eight continuous syncpt in VI. Each of them can be enable by set the
// ENABLE bit along with syncpt index field.
// Whenever a continous syncpt is enabled, the corresponding single-shot syncpt may not be used.
//
// VI_CONT_SYNCPT_OUT_1:
//      Condition for syncpt return is OP_DONE from output 1.
// VI_CONT_SYNCPT_OUT_2:
//      Condition for syncpt return is OP_DONE from output 1.
// VI_CONT_SYNCPT_VIP_VSYNC:
//      syncpt index will be returned when the first vsync from VIP input is received. This is an
//      edge triggered syncpt.
// VI_CONT_SYNCPT_VI2EPP:
//      This condition will forward syncpt to EPP whenever data is sent to EPP. It will forward once per
//      EPP buffer. The syncpt will sent to EPP at the first line of the buffer, and after every
//      LINES_PER_BUFFER lines (as defined by the EPP_LINES_PER_BUFFER register). EPP will return the syncpt
//      when the last byte of a buffer is written into memory(tag returned).
// VI_CONT_SYNCPT_CSI_PPA_FRAME_START:
//      The condition for this syncpt is CSI PPA port received a frame start.
// VI_CONT_SYNCPT_CSI_PPA_FRAME_END:
//      The condition for this syncpt is CSI PPA port received a frame end.
// VI_CONT_SYNCPT_CSI_PPB_FRAME_START:
//      The condition for this syncpt is CSI PPB port received a frame start. MISC_CSI_PPB_FRAME_START.
// VI_CONT_SYNCPT_CSI_PPB_FRAME_END:
//      The condition for this syncpt is CSI PPB port received a frame end.
//
// REG_WR_SAFE's "safe" condition is defined by the VI_STREAM_1_RESOURCE_DEFINE (for OUT_1) and
// VI_STREAM_2_RESOURCE_DEFINE (for OUT_2).  The syncpt will return when all the requested resources are IDLE.
// If no resources are requested, it will return immediately.
//
// Since REG_WR_SAFE is level triggered, it should be used in conjuction with START_WRITE.  In the format of:
//      INCR_SYNCPT <START_WRITE>
//      WAIT (START_WRITE)
//      INCR_SYNCPT <REG_WR_SAFE>
//
// Continuous syncpt always use OP_DONE as condition. The mapping of continuous syncpt to single-shot syncpt:
//   VI_CONT_SYNCPT_OUT_1                              mapped to VI_OUT_1_INCR_SYNCPT condition OP_DONE
//   VI_CONT_SYNCPT_OUT_2                              mapped to VI_OUT_2_INCR_SYNCPT condition OP_DONE
//   VI_CONT_SYNCPT_VIP_VSYN                        mapped to VI_MISC_INCR_SYNCPT condition MISC_VIP_VSYNC
//   VI_CONT_SYNCPT_CSI_PPA_FRAME_START mapped to VI_MISC_INCR_SYNCPT condition MISC_CSI_PPA_FRAME_START
//   VI_CONT_SYNCPT_CSI_PPA_FRAME_END     mapped to VI_MISC_INCR_SYNCPT condition MISC_CSI_PPA_FRAME_END
//   VI_CONT_SYNCPT_CSI_PPB_FRAME_START mapped to VI_MISC_INCR_SYNCPT condition MISC_CSI_PPB_FRAME_START
//   VI_CONT_SYNCPT_CSI_PPB_FRAME_END     mapped to VI_MISC_INCR_SYNCPT condition MISC_CSI_PPB_FRAME_END
//   VI_CONT_SYNCPT_VI2EPP                             mapped to EPP_INCR_SYNCPT condition OP_DONE
// Can not program continuous syncpt with mapping single_shot syncpt conditions. It is fine to program continuous
// syncpt with other syncpt conditions. For example:
//      enable VI_CONT_OUT_1 with VI_OUT_1_INCR_SYNCPT condition REG_WR_SAFE  -- ok
//      enable VI_CONT_OUT_2 with VI_OUT_1_INCR_SYNCPT condition OP_DONE      -- ok
//      enable VI_CONT_VIP_VSYNC with VI_MISC_INCR_SYNCPT condition VIP_VSYNC -- not ok
//      enable VI_CONT_OUT1 with VI_OUT_1_INCR_SYNCPT condition OP_DONE       -- not ok
//
#define NV_VI_OUT_1_INCR_SYNCPT_NB_CONDS        5
// --------------------------------------------------------------------------
// 
// Copyright (c) 2004, NVIDIA Corp.
// All Rights Reserved.
// 
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
// 
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
// 
// --------------------------------------------------------------------------
// 

// Register VI_OUT_1_INCR_SYNCPT_0  
#define VI_OUT_1_INCR_SYNCPT_0                  _MK_ADDR_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_SECURE                   0x0
#define VI_OUT_1_INCR_SYNCPT_0_WORD_COUNT                       0x1
#define VI_OUT_1_INCR_SYNCPT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define VI_OUT_1_INCR_SYNCPT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_OUT_1_INCR_SYNCPT_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
// Condition mapped from raise/wait
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_SHIFT                 _MK_SHIFT_CONST(8)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_FIELD                 (_MK_MASK_CONST(0xff) << VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_SHIFT)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_RANGE                 15:8
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_WOFFSET                       0x0
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_IMMEDIATE                     _MK_ENUM_CONST(0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_OP_DONE                       _MK_ENUM_CONST(1)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_RD_DONE                       _MK_ENUM_CONST(2)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_REG_WR_SAFE                   _MK_ENUM_CONST(3)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_START_WRITE                   _MK_ENUM_CONST(4)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_5                        _MK_ENUM_CONST(5)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_6                        _MK_ENUM_CONST(6)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_7                        _MK_ENUM_CONST(7)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_8                        _MK_ENUM_CONST(8)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_9                        _MK_ENUM_CONST(9)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_10                       _MK_ENUM_CONST(10)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_11                       _MK_ENUM_CONST(11)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_12                       _MK_ENUM_CONST(12)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_13                       _MK_ENUM_CONST(13)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_14                       _MK_ENUM_CONST(14)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_COND_COND_15                       _MK_ENUM_CONST(15)

// syncpt index value
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_FIELD                 (_MK_MASK_CONST(0xff) << VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_SHIFT)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_RANGE                 7:0
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_WOFFSET                       0x0
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_0_OUT_1_INDX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_OUT_1_INCR_SYNCPT_CNTRL_0  
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0                    _MK_ADDR_CONST(0x1)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_SECURE                     0x0
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_WORD_COUNT                         0x1
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_RESET_MASK                         _MK_MASK_CONST(0x101)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_READ_MASK                  _MK_MASK_CONST(0x101)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_WRITE_MASK                         _MK_MASK_CONST(0x101)
// If NO_STALL is 1, then when fifos are full,
// INCR_SYNCPT methods will be dropped and the
// INCR_SYNCPT_ERROR[COND] bit will be set.
// If NO_STALL is 0, then when fifos are full,
// the client host interface will be stalled.
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_FIELD                   (_MK_MASK_CONST(0x1) << VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_SHIFT)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_RANGE                   8:8
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_WOFFSET                 0x0
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_NO_STALL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// If SOFT_RESET is set, then all internal state
// of the client syncpt block will be reset.
// To do soft reset, first set SOFT_RESET of
// all host1x clients affected, then clear all
// SOFT_RESETs.
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_FIELD                 (_MK_MASK_CONST(0x1) << VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_SHIFT)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_RANGE                 0:0
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_WOFFSET                       0x0
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_CNTRL_0_OUT_1_INCR_SYNCPT_SOFT_RESET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_OUT_1_INCR_SYNCPT_ERROR_0  
#define VI_OUT_1_INCR_SYNCPT_ERROR_0                    _MK_ADDR_CONST(0x2)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_SECURE                     0x0
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_WORD_COUNT                         0x1
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// COND_STATUS[COND] is set if the fifo for COND overflows.
// This bit is sticky and will remain set until cleared.
// Cleared by writing 1.
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_FIELD                    (_MK_MASK_CONST(0xffffffff) << VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_SHIFT)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_RANGE                    31:0
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_WOFFSET                  0x0
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_1_INCR_SYNCPT_ERROR_0_OUT_1_COND_STATUS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// reserve locations for future expansion

// Reserved address 3 [0x3] 

// Reserved address 4 [0x4] 

// Reserved address 5 [0x5] 

// Reserved address 6 [0x6] 

// Reserved address 7 [0x7] 
// just in case names were redefined using macros
#define NV_VI_OUT_2_INCR_SYNCPT_NB_CONDS        5
// --------------------------------------------------------------------------
// 
// Copyright (c) 2004, NVIDIA Corp.
// All Rights Reserved.
// 
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
// 
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
// 
// --------------------------------------------------------------------------
// 

// Register VI_OUT_2_INCR_SYNCPT_0  
#define VI_OUT_2_INCR_SYNCPT_0                  _MK_ADDR_CONST(0x8)
#define VI_OUT_2_INCR_SYNCPT_0_SECURE                   0x0
#define VI_OUT_2_INCR_SYNCPT_0_WORD_COUNT                       0x1
#define VI_OUT_2_INCR_SYNCPT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define VI_OUT_2_INCR_SYNCPT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_OUT_2_INCR_SYNCPT_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
// Condition mapped from raise/wait
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_SHIFT                 _MK_SHIFT_CONST(8)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_FIELD                 (_MK_MASK_CONST(0xff) << VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_SHIFT)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_RANGE                 15:8
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_WOFFSET                       0x0
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_IMMEDIATE                     _MK_ENUM_CONST(0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_OP_DONE                       _MK_ENUM_CONST(1)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_RD_DONE                       _MK_ENUM_CONST(2)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_REG_WR_SAFE                   _MK_ENUM_CONST(3)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_START_WRITE                   _MK_ENUM_CONST(4)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_5                        _MK_ENUM_CONST(5)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_6                        _MK_ENUM_CONST(6)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_7                        _MK_ENUM_CONST(7)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_8                        _MK_ENUM_CONST(8)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_9                        _MK_ENUM_CONST(9)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_10                       _MK_ENUM_CONST(10)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_11                       _MK_ENUM_CONST(11)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_12                       _MK_ENUM_CONST(12)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_13                       _MK_ENUM_CONST(13)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_14                       _MK_ENUM_CONST(14)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_COND_COND_15                       _MK_ENUM_CONST(15)

// syncpt index value
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_FIELD                 (_MK_MASK_CONST(0xff) << VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_SHIFT)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_RANGE                 7:0
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_WOFFSET                       0x0
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_0_OUT_2_INDX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_OUT_2_INCR_SYNCPT_CNTRL_0  
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0                    _MK_ADDR_CONST(0x9)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_SECURE                     0x0
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_WORD_COUNT                         0x1
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_RESET_MASK                         _MK_MASK_CONST(0x101)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_READ_MASK                  _MK_MASK_CONST(0x101)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_WRITE_MASK                         _MK_MASK_CONST(0x101)
// If NO_STALL is 1, then when fifos are full,
// INCR_SYNCPT methods will be dropped and the
// INCR_SYNCPT_ERROR[COND] bit will be set.
// If NO_STALL is 0, then when fifos are full,
// the client host interface will be stalled.
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_FIELD                   (_MK_MASK_CONST(0x1) << VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_SHIFT)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_RANGE                   8:8
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_WOFFSET                 0x0
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_NO_STALL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// If SOFT_RESET is set, then all internal state
// of the client syncpt block will be reset.
// To do soft reset, first set SOFT_RESET of
// all host1x clients affected, then clear all
// SOFT_RESETs.
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_FIELD                 (_MK_MASK_CONST(0x1) << VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_SHIFT)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_RANGE                 0:0
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_WOFFSET                       0x0
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_CNTRL_0_OUT_2_INCR_SYNCPT_SOFT_RESET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_OUT_2_INCR_SYNCPT_ERROR_0  
#define VI_OUT_2_INCR_SYNCPT_ERROR_0                    _MK_ADDR_CONST(0xa)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_SECURE                     0x0
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_WORD_COUNT                         0x1
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// COND_STATUS[COND] is set if the fifo for COND overflows.
// This bit is sticky and will remain set until cleared.
// Cleared by writing 1.
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_FIELD                    (_MK_MASK_CONST(0xffffffff) << VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_SHIFT)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_RANGE                    31:0
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_WOFFSET                  0x0
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_OUT_2_INCR_SYNCPT_ERROR_0_OUT_2_COND_STATUS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// reserve locations for future expansion

// Reserved address 11 [0xb] 

// Reserved address 12 [0xc] 

// Reserved address 13 [0xd] 

// Reserved address 14 [0xe] 

// Reserved address 15 [0xf] 
// just in case names were redefined using macros
#define NV_VI_MISC_INCR_SYNCPT_NB_CONDS 9
// --------------------------------------------------------------------------
// 
// Copyright (c) 2004, NVIDIA Corp.
// All Rights Reserved.
// 
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
// 
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
// 
// --------------------------------------------------------------------------
// 

// Register VI_MISC_INCR_SYNCPT_0  
#define VI_MISC_INCR_SYNCPT_0                   _MK_ADDR_CONST(0x10)
#define VI_MISC_INCR_SYNCPT_0_SECURE                    0x0
#define VI_MISC_INCR_SYNCPT_0_WORD_COUNT                        0x1
#define VI_MISC_INCR_SYNCPT_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define VI_MISC_INCR_SYNCPT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_READ_MASK                         _MK_MASK_CONST(0xffff)
#define VI_MISC_INCR_SYNCPT_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
// Condition mapped from raise/wait
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_FIELD                   (_MK_MASK_CONST(0xff) << VI_MISC_INCR_SYNCPT_0_MISC_COND_SHIFT)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_RANGE                   15:8
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_WOFFSET                 0x0
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_IMMEDIATE                       _MK_ENUM_CONST(0)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_OP_DONE                 _MK_ENUM_CONST(1)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_RD_DONE                 _MK_ENUM_CONST(2)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_REG_WR_SAFE                     _MK_ENUM_CONST(3)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_MISC_VIP_VSYNC                  _MK_ENUM_CONST(4)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_MISC_CSI_PPA_FRAME_START                        _MK_ENUM_CONST(5)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_MISC_CSI_PPA_FRAME_END                  _MK_ENUM_CONST(6)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_MISC_CSI_PPB_FRAME_START                        _MK_ENUM_CONST(7)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_MISC_CSI_PPB_FRAME_END                  _MK_ENUM_CONST(8)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_9                  _MK_ENUM_CONST(9)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_10                 _MK_ENUM_CONST(10)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_11                 _MK_ENUM_CONST(11)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_12                 _MK_ENUM_CONST(12)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_13                 _MK_ENUM_CONST(13)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_14                 _MK_ENUM_CONST(14)
#define VI_MISC_INCR_SYNCPT_0_MISC_COND_COND_15                 _MK_ENUM_CONST(15)

// syncpt index value
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_FIELD                   (_MK_MASK_CONST(0xff) << VI_MISC_INCR_SYNCPT_0_MISC_INDX_SHIFT)
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_RANGE                   7:0
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_WOFFSET                 0x0
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_0_MISC_INDX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_MISC_INCR_SYNCPT_CNTRL_0  
#define VI_MISC_INCR_SYNCPT_CNTRL_0                     _MK_ADDR_CONST(0x11)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_SECURE                      0x0
#define VI_MISC_INCR_SYNCPT_CNTRL_0_WORD_COUNT                  0x1
#define VI_MISC_INCR_SYNCPT_CNTRL_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_RESET_MASK                  _MK_MASK_CONST(0x101)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_READ_MASK                   _MK_MASK_CONST(0x101)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_WRITE_MASK                  _MK_MASK_CONST(0x101)
// If NO_STALL is 1, then when fifos are full,
// INCR_SYNCPT methods will be dropped and the
// INCR_SYNCPT_ERROR[COND] bit will be set.
// If NO_STALL is 0, then when fifos are full,
// the client host interface will be stalled.
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_FIELD                     (_MK_MASK_CONST(0x1) << VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_SHIFT)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_RANGE                     8:8
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_WOFFSET                   0x0
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_NO_STALL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// If SOFT_RESET is set, then all internal state
// of the client syncpt block will be reset.
// To do soft reset, first set SOFT_RESET of
// all host1x clients affected, then clear all
// SOFT_RESETs.
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_FIELD                   (_MK_MASK_CONST(0x1) << VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_SHIFT)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_RANGE                   0:0
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_WOFFSET                 0x0
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_CNTRL_0_MISC_INCR_SYNCPT_SOFT_RESET_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_MISC_INCR_SYNCPT_ERROR_0  
#define VI_MISC_INCR_SYNCPT_ERROR_0                     _MK_ADDR_CONST(0x12)
#define VI_MISC_INCR_SYNCPT_ERROR_0_SECURE                      0x0
#define VI_MISC_INCR_SYNCPT_ERROR_0_WORD_COUNT                  0x1
#define VI_MISC_INCR_SYNCPT_ERROR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define VI_MISC_INCR_SYNCPT_ERROR_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// COND_STATUS[COND] is set if the fifo for COND overflows.
// This bit is sticky and will remain set until cleared.
// Cleared by writing 1.
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_SHIFT)
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_RANGE                      31:0
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_WOFFSET                    0x0
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MISC_INCR_SYNCPT_ERROR_0_MISC_COND_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// reserve locations for future expansion

// Reserved address 19 [0x13] 

// Reserved address 20 [0x14] 

// Reserved address 21 [0x15] 

// Reserved address 22 [0x16] 

// Reserved address 23 [0x17] 
// just in case names were redefined using macros

// Register VI_CONT_SYNCPT_OUT_1_0  
#define VI_CONT_SYNCPT_OUT_1_0                  _MK_ADDR_CONST(0x18)
#define VI_CONT_SYNCPT_OUT_1_0_SECURE                   0x0
#define VI_CONT_SYNCPT_OUT_1_0_WORD_COUNT                       0x1
#define VI_CONT_SYNCPT_OUT_1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_RESET_MASK                       _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_OUT_1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_READ_MASK                        _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_OUT_1_0_WRITE_MASK                       _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_FIELD                 (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_SHIFT)
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_RANGE                 7:0
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_WOFFSET                       0x0
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_INDX_OUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// on host read bus every time OUT_1 condition is true and OUT_1_EN is set
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_FIELD                   (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_SHIFT)
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_RANGE                   8:8
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_WOFFSET                 0x0
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_1_0_EN_OUT_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_OUT_2_0  
#define VI_CONT_SYNCPT_OUT_2_0                  _MK_ADDR_CONST(0x19)
#define VI_CONT_SYNCPT_OUT_2_0_SECURE                   0x0
#define VI_CONT_SYNCPT_OUT_2_0_WORD_COUNT                       0x1
#define VI_CONT_SYNCPT_OUT_2_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_RESET_MASK                       _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_OUT_2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_READ_MASK                        _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_OUT_2_0_WRITE_MASK                       _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_FIELD                 (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_SHIFT)
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_RANGE                 7:0
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_WOFFSET                       0x0
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_INDX_OUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// on host read bus every time OUT_2 condition is true and OUT_2_EN is set
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_FIELD                   (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_SHIFT)
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_RANGE                   8:8
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_WOFFSET                 0x0
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_OUT_2_0_EN_OUT_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_VIP_VSYNC_0  
#define VI_CONT_SYNCPT_VIP_VSYNC_0                      _MK_ADDR_CONST(0x1a)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_SECURE                       0x0
#define VI_CONT_SYNCPT_VIP_VSYNC_0_WORD_COUNT                   0x1
#define VI_CONT_SYNCPT_VIP_VSYNC_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_RESET_MASK                   _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_READ_MASK                    _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_WRITE_MASK                   _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_FIELD                 (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_SHIFT)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_RANGE                 7:0
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_WOFFSET                       0x0
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_INDX_VIP_VSYNC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// on host read bus every time VSYNC condition is true and EN_VSYNC is set
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_FIELD                   (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_SHIFT)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_RANGE                   8:8
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_WOFFSET                 0x0
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VIP_VSYNC_0_EN_VIP_VSYNC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_VI2EPP_0  
#define VI_CONT_SYNCPT_VI2EPP_0                 _MK_ADDR_CONST(0x1b)
#define VI_CONT_SYNCPT_VI2EPP_0_SECURE                  0x0
#define VI_CONT_SYNCPT_VI2EPP_0_WORD_COUNT                      0x1
#define VI_CONT_SYNCPT_VI2EPP_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_RESET_MASK                      _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_VI2EPP_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_READ_MASK                       _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_VI2EPP_0_WRITE_MASK                      _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_FIELD                       (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_SHIFT)
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_RANGE                       7:0
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_WOFFSET                     0x0
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_INDX_VI2EPP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// on host read bus every time VI2EPP condition is true and EN_VSYNC is set
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_SHIFT                 _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_FIELD                 (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_SHIFT)
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_RANGE                 8:8
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_WOFFSET                       0x0
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_VI2EPP_0_EN_VI2EPP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0  
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0                    _MK_ADDR_CONST(0x1c)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_SECURE                     0x0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_WORD_COUNT                         0x1
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_RESET_MASK                         _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_READ_MASK                  _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_WRITE_MASK                         _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_FIELD                     (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_RANGE                     7:0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_WOFFSET                   0x0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_INDX_CSI_PPA_FRAME_START_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// on host read bus every time CSI_PPA_FRAME_START condition is true and EN_VSYNC is set
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_SHIFT                       _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_FIELD                       (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_RANGE                       8:8
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_WOFFSET                     0x0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_START_0_EN_CSI_PPA_FRAME_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0  
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0                      _MK_ADDR_CONST(0x1d)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_SECURE                       0x0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_WORD_COUNT                   0x1
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_RESET_MASK                   _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_READ_MASK                    _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_WRITE_MASK                   _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_FIELD                 (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_RANGE                 7:0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_WOFFSET                       0x0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_INDX_CSI_PPA_FRAME_END_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// on host read bus every time CSI_PPA_FRAME_END condition is true and EN_VSYNC is set
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_FIELD                   (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_RANGE                   8:8
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_WOFFSET                 0x0
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPA_FRAME_END_0_EN_CSI_PPA_FRAME_END_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0  
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0                    _MK_ADDR_CONST(0x1e)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_SECURE                     0x0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_WORD_COUNT                         0x1
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_RESET_MASK                         _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_READ_MASK                  _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_WRITE_MASK                         _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_FIELD                     (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_RANGE                     7:0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_WOFFSET                   0x0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_INDX_CSI_PPB_FRAME_START_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// on host read bus every time CSI_PPB_FRAME_START condition is true and EN_VSYNC is set
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_SHIFT                       _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_FIELD                       (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_RANGE                       8:8
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_WOFFSET                     0x0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_START_0_EN_CSI_PPB_FRAME_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0  
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0                      _MK_ADDR_CONST(0x1f)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_SECURE                       0x0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_WORD_COUNT                   0x1
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_RESET_MASK                   _MK_MASK_CONST(0x100)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_READ_MASK                    _MK_MASK_CONST(0x1ff)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_WRITE_MASK                   _MK_MASK_CONST(0x1ff)
// return INDX (set HOST_CLRD packet TYPE field to SYNCPT)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_FIELD                 (_MK_MASK_CONST(0xff) << VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_RANGE                 7:0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_WOFFSET                       0x0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_INDX_CSI_PPB_FRAME_END_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// on host read bus every time CSI_PPB_FRAME_END condition is true and EN_VSYNC is set
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_FIELD                   (_MK_MASK_CONST(0x1) << VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_SHIFT)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_RANGE                   8:8
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_WOFFSET                 0x0
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CONT_SYNCPT_CSI_PPB_FRAME_END_0_EN_CSI_PPB_FRAME_END_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Context switch register.  Should be common to all modules.  Includes the
// current channel/class (which is writable by SW) and the next channel/class
// (which the hardware sets when it receives a context switch).
// Context switch works like this:
// Any context switch request triggers an interrupt to the host and causes the
// new channel/class to be stored in NEXT_CHANNEL/NEXT_CLASS (see
// vmod/chexample).  SW sees that there is a context switch interrupt and does
// the necessary operations to make the module ready to receive traffic from
// the new context.  It clears the context switch interrupt and writes
// CURR_CHANNEL/CLASS to the same value as NEXT_CHANNEL/CLASS, which causes a
// context switch acknowledge packet to be sent to the host.  This completes
// the context switch and allows the host to continue sending data to the
// module.
// Context switches can also be pre-loaded.  If CURR_CLASS/CHANNEL are written
// and updated to the next CLASS/CHANNEL before the context switch request
// occurs, an acknowledge will be generated by the module and no interrupt will
// be triggered.  This is one way for software to avoid dealing with context
// switch interrupts.
// Another way to avoid context switch interrupts is to set the AUTO_ACK bit.
// This bit tells the module to automatically acknowledge any incoming context
// switch requests without triggering an interrupt.  CURR_* and NEXT_* will be
// updated by the module so they will always be current.

// Register VI_CTXSW_0  
#define VI_CTXSW_0                      _MK_ADDR_CONST(0x20)
#define VI_CTXSW_0_SECURE                       0x0
#define VI_CTXSW_0_WORD_COUNT                   0x1
#define VI_CTXSW_0_RESET_VAL                    _MK_MASK_CONST(0xf000f800)
#define VI_CTXSW_0_RESET_MASK                   _MK_MASK_CONST(0xf3fffbff)
#define VI_CTXSW_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_READ_MASK                    _MK_MASK_CONST(0xf3fffbff)
#define VI_CTXSW_0_WRITE_MASK                   _MK_MASK_CONST(0xfbff)
// Current working class
#define VI_CTXSW_0_CURR_CLASS_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_CTXSW_0_CURR_CLASS_FIELD                     (_MK_MASK_CONST(0x3ff) << VI_CTXSW_0_CURR_CLASS_SHIFT)
#define VI_CTXSW_0_CURR_CLASS_RANGE                     9:0
#define VI_CTXSW_0_CURR_CLASS_WOFFSET                   0x0
#define VI_CTXSW_0_CURR_CLASS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_CURR_CLASS_DEFAULT_MASK                      _MK_MASK_CONST(0x3ff)
#define VI_CTXSW_0_CURR_CLASS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_CURR_CLASS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Automatically acknowledge any incoming context switch requests
#define VI_CTXSW_0_AUTO_ACK_SHIFT                       _MK_SHIFT_CONST(11)
#define VI_CTXSW_0_AUTO_ACK_FIELD                       (_MK_MASK_CONST(0x1) << VI_CTXSW_0_AUTO_ACK_SHIFT)
#define VI_CTXSW_0_AUTO_ACK_RANGE                       11:11
#define VI_CTXSW_0_AUTO_ACK_WOFFSET                     0x0
#define VI_CTXSW_0_AUTO_ACK_DEFAULT                     _MK_MASK_CONST(0x1)
#define VI_CTXSW_0_AUTO_ACK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_CTXSW_0_AUTO_ACK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_AUTO_ACK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_AUTO_ACK_MANUAL                      _MK_ENUM_CONST(0)
#define VI_CTXSW_0_AUTO_ACK_AUTOACK                     _MK_ENUM_CONST(1)

// Current working channel, reset to 'invalid'
#define VI_CTXSW_0_CURR_CHANNEL_SHIFT                   _MK_SHIFT_CONST(12)
#define VI_CTXSW_0_CURR_CHANNEL_FIELD                   (_MK_MASK_CONST(0xf) << VI_CTXSW_0_CURR_CHANNEL_SHIFT)
#define VI_CTXSW_0_CURR_CHANNEL_RANGE                   15:12
#define VI_CTXSW_0_CURR_CHANNEL_WOFFSET                 0x0
#define VI_CTXSW_0_CURR_CHANNEL_DEFAULT                 _MK_MASK_CONST(0xf)
#define VI_CTXSW_0_CURR_CHANNEL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define VI_CTXSW_0_CURR_CHANNEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_CURR_CHANNEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Next requested class
#define VI_CTXSW_0_NEXT_CLASS_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_CTXSW_0_NEXT_CLASS_FIELD                     (_MK_MASK_CONST(0x3ff) << VI_CTXSW_0_NEXT_CLASS_SHIFT)
#define VI_CTXSW_0_NEXT_CLASS_RANGE                     25:16
#define VI_CTXSW_0_NEXT_CLASS_WOFFSET                   0x0
#define VI_CTXSW_0_NEXT_CLASS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_NEXT_CLASS_DEFAULT_MASK                      _MK_MASK_CONST(0x3ff)
#define VI_CTXSW_0_NEXT_CLASS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_NEXT_CLASS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Next requested channel
#define VI_CTXSW_0_NEXT_CHANNEL_SHIFT                   _MK_SHIFT_CONST(28)
#define VI_CTXSW_0_NEXT_CHANNEL_FIELD                   (_MK_MASK_CONST(0xf) << VI_CTXSW_0_NEXT_CHANNEL_SHIFT)
#define VI_CTXSW_0_NEXT_CHANNEL_RANGE                   31:28
#define VI_CTXSW_0_NEXT_CHANNEL_WOFFSET                 0x0
#define VI_CTXSW_0_NEXT_CHANNEL_DEFAULT                 _MK_MASK_CONST(0xf)
#define VI_CTXSW_0_NEXT_CHANNEL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define VI_CTXSW_0_NEXT_CHANNEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CTXSW_0_NEXT_CHANNEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_INTSTATUS_0  
#define VI_INTSTATUS_0                  _MK_ADDR_CONST(0x21)
#define VI_INTSTATUS_0_SECURE                   0x0
#define VI_INTSTATUS_0_WORD_COUNT                       0x1
#define VI_INTSTATUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_INTSTATUS_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define VI_INTSTATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_INTSTATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTSTATUS_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define VI_INTSTATUS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
// Context switch interrupt status (clear on write)
#define VI_INTSTATUS_0_CTXSW_INT_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_INTSTATUS_0_CTXSW_INT_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTSTATUS_0_CTXSW_INT_SHIFT)
#define VI_INTSTATUS_0_CTXSW_INT_RANGE                  0:0
#define VI_INTSTATUS_0_CTXSW_INT_WOFFSET                        0x0
#define VI_INTSTATUS_0_CTXSW_INT_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTSTATUS_0_CTXSW_INT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTSTATUS_0_CTXSW_INT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTSTATUS_0_CTXSW_INT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// For Parallel VIP input, limitation for vsync and hsync has to be followed to avoid ISP hang for AP15:
// SW must always program parallel cameras (including the VIP pattern generator) in a way that
// avoids simultaneous hsync and vsync active edges. copied from bug:361730

// Register VI_VI_INPUT_CONTROL_0  // VI Input Control
#define VI_VI_INPUT_CONTROL_0                   _MK_ADDR_CONST(0x22)
#define VI_VI_INPUT_CONTROL_0_SECURE                    0x0
#define VI_VI_INPUT_CONTROL_0_WORD_COUNT                        0x1
#define VI_VI_INPUT_CONTROL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_RESET_MASK                        _MK_MASK_CONST(0x7f801fff)
#define VI_VI_INPUT_CONTROL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_READ_MASK                         _MK_MASK_CONST(0x7f801fff)
#define VI_VI_INPUT_CONTROL_0_WRITE_MASK                        _MK_MASK_CONST(0x7f801fff)
// Host Input Enable   0= DISABLED
//   1= ENABLED
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_SHIFT)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_RANGE                   0:0
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_WOFFSET                 0x0
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_HOST_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VIP Input Enable   0= DISABLED
//   1= ENABLED
// This bit turn on clocks for VIP input logic. This
//   bit has to be enabled before CAMERA_CONTROL's
//   VIP_ENABLE bit for any VIP logic to start!
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(1)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_SHIFT)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_RANGE                    1:1
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_WOFFSET                  0x0
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_VIP_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// Input port data Format  (effective if input source is VI Port)
//   0000= YUV422 or ITU-R BT.656
//   0001= Reserved 1
//   0010= Bayer Pattern, enables ISP
//   0011= Reserved 2
//   0100= Pattern A, written directly to memory
//   0101= Pattern B, written directly to memory
//   0110= Pattern C, written directly to memory
//   0111= Pattern C, do not remove the 0xFF, 0x02
//   1000= Pattern D, ISDB-T input
//   1001= YUV420NP, written directly to memory as YUV420P
//   1010= RGB565, written directly to EPP
//   1011= RGB888, written directly to EPP
//   1100= RGB444, written directly to EPP
//   1101= CSI,    written directly to CSI
//         For YUV420NP no cropping will be done.
//         For RGB565,RGB888,RGB444 written to EPP
//         all cropping will be done in the EPP.
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_SHIFT                   _MK_SHIFT_CONST(2)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_FIELD                   (_MK_MASK_CONST(0xf) << VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_SHIFT)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_RANGE                   5:2
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_WOFFSET                 0x0
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_YUV422                  _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_RESERVED_1                      _MK_ENUM_CONST(1)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_BAYER                   _MK_ENUM_CONST(2)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_RESERVED_2                      _MK_ENUM_CONST(3)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_PATTERN_A                       _MK_ENUM_CONST(4)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_PATTERN_B                       _MK_ENUM_CONST(5)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_PATTERN_C                       _MK_ENUM_CONST(6)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_PATTERN_C_RAW                   _MK_ENUM_CONST(7)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_PATTERN_D                       _MK_ENUM_CONST(8)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_YUV420                  _MK_ENUM_CONST(9)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_RGB565                  _MK_ENUM_CONST(10)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_RGB888                  _MK_ENUM_CONST(11)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_RGB444                  _MK_ENUM_CONST(12)
#define VI_VI_INPUT_CONTROL_0_INPUT_PORT_FORMAT_CSI                     _MK_ENUM_CONST(13)

// Host data Format  (effective if input source is host)
//   00= Non-planar YUV422
//      (only Y-FIFO is used)
//   01= Planar YUV420
//      (Y-FIFO, U-FIFO, V-FIFO are used)
//   10= Bayer 8-bit  - enables ISP
//   11= Bayer 12-bit - enables ISP
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_SHIFT                 _MK_SHIFT_CONST(6)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_FIELD                 (_MK_MASK_CONST(0x3) << VI_VI_INPUT_CONTROL_0_HOST_FORMAT_SHIFT)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_RANGE                 7:6
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_WOFFSET                       0x0
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_NONPLANAR                     _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_PLANAR                        _MK_ENUM_CONST(1)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_BAYER8                        _MK_ENUM_CONST(2)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_BAYER12                       _MK_ENUM_CONST(3)

// YUV Input Format This is applicable when input source is
// VI Port and format is YUV422/ITU-R BT.656
// or when input source is host and host
// format is non-planar YUV422.
//  8 bits per component
//   00= UYVY => Y1_V0_Y0_U0 MSB to LSB 32bit mapping
//   01= VYUY => Y1_U0_Y0_V0
//   10= YUYV => V0_Y1_U0_Y0
//   11= YVYU => U0_Y1_V0_Y0
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_FIELD                    (_MK_MASK_CONST(0x3) << VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_SHIFT)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_RANGE                    9:8
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_WOFFSET                  0x0
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_UYVY                     _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_VYUY                     _MK_ENUM_CONST(1)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_YUYV                     _MK_ENUM_CONST(2)
#define VI_VI_INPUT_CONTROL_0_YUV_INPUT_FORMAT_YVYU                     _MK_ENUM_CONST(3)

// Select a data source input to HOST (extension field).  (use when input source is host)
//  000= Source is selected with HOST_FORMAT field (backward compatible)
//  001= Bayer 10 bpp: 2 16-bit values packed into 32-bit, LSbit aligned {6'b0, bayer, 6'b0, bayer} (to ISP)
//  010= Bayer 14 bpp: 2 16-bit values packed into 32-bit, LSbit aligned {2'b0, bayer, 2'b0, bayer} (to ISP)
//  011= RGB565             (to EPP)
//  100= MSB Alpha + RGB888 (to EPP)
//  101= MSB Alpha + BGR888 (to EPP)
//  110= CSI                (to CSI)
//  111= reserved
// 22:13 reserved
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_SHIFT                     _MK_SHIFT_CONST(10)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_FIELD                     (_MK_MASK_CONST(0x7) << VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_SHIFT)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_RANGE                     12:10
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_WOFFSET                   0x0
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_USE_HOST_FORMAT                   _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_BAYER10                   _MK_ENUM_CONST(1)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_BAYER14                   _MK_ENUM_CONST(2)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_RGB565                    _MK_ENUM_CONST(3)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_ARGB8888                  _MK_ENUM_CONST(4)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_ABGR8888                  _MK_ENUM_CONST(5)
#define VI_VI_INPUT_CONTROL_0_HOST_FORMAT_EXT_CSI                       _MK_ENUM_CONST(6)

// VHS input signal active edge which is used  as horizontal reference of input data.
//  VHS input inversion is evaluated first
//  before determining active edge.
//   0= Rising edge of VHS is active edge.
//      For ITU-R BT.656 data, leading edge of
//      horizontal sync is the active edge.
//   1= Falling edge of VHS is active edge
//      For ITU-R BT.656 data, trailing edge
//      of horizontal sync is the active edge.
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_SHIFT                 _MK_SHIFT_CONST(23)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_FIELD                 (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_SHIFT)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_RANGE                 23:23
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_WOFFSET                       0x0
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_RISING                        _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_VHS_IN_EDGE_FALLING                       _MK_ENUM_CONST(1)

// VVS input signal active edge which is used  as vertical reference of input data
//  VVS input inversion is evaluated first
//  before determining active edge.
//   0= Rising edge of VVS is active edge
//      For ITU-R BT.656 data, leading edge of
//      vertical sync is the active edge.
//   1= Falling edge of VVS is active edge
//      For ITU-R BT.656 data, trailing edge
//      of vertical sync is the active edge.
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_SHIFT                 _MK_SHIFT_CONST(24)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_FIELD                 (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_SHIFT)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_RANGE                 24:24
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_WOFFSET                       0x0
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_RISING                        _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_VVS_IN_EDGE_FALLING                       _MK_ENUM_CONST(1)

// Horizontal and Vertical Sync Format  (effective if VIDEO_SOURCE is VIP)
//   00= horizontal sync comes from VHS pin
//       and vertical sync comes from VVS pin
//       consistent with standard YUV422 data
//       format.
//       In this case, VHS_Input_Control and
//       VVS_Input_Control must be enabled.
//   01= horizontal and vertical syncs are
//       decoded from the received video data
//       bytes as specified in ITU-R BT.656
//       (CCIR656) standard.
//   10= horizontal and vertical syncs are
//       generated internally and they are
//       output on VHS and VVS pins if VHS and
//       VVS are in output mode.
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_SHIFT                 _MK_SHIFT_CONST(25)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_FIELD                 (_MK_MASK_CONST(0x3) << VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_SHIFT)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_RANGE                 26:25
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_WOFFSET                       0x0
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_YUV422                        _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_ITU656                        _MK_ENUM_CONST(1)
#define VI_VI_INPUT_CONTROL_0_SYNC_FORMAT_INTHVS                        _MK_ENUM_CONST(2)

// Interlaced video Field Detection  (effective if VIDEO_SOURCE is VIP)
//   0= Disabled (top field only)
//   1= Enabled
//      When H/V syncs are decoded per ITU-R
//      BT.656 standard, odd/even field is
//      detected from the control bytes.
//      When H/V syncs come from VHS/VVS pins
//      (YUV422), odd/even field is detected
//      from the position of VVS active edge
//      with respect to VHS active pulse.
//      This bit should be disabled for non-
//      interlaced source or when H/V syncs
//      are generated internally.
//  If VIDEO_SOURCE is HOST, field information
//  is always specified by host.
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_SHIFT                        _MK_SHIFT_CONST(27)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_FIELD                        (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_FIELD_DETECT_SHIFT)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_RANGE                        27:27
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_WOFFSET                      0x0
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_DISABLED                     _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_FIELD_DETECT_ENABLED                      _MK_ENUM_CONST(1)

// Odd/Even Field type  (effective for interlaced video source)
//   0= Top field is odd field
//   1= Top field is even field
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_SHIFT                  _MK_SHIFT_CONST(28)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_FIELD_TYPE_SHIFT)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_RANGE                  28:28
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_WOFFSET                        0x0
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_TOPODD                 _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_FIELD_TYPE_TOPEVEN                        _MK_ENUM_CONST(1)

// Horizontal Counter   0= Enabled
//   1= Disabled (reset to 0)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_SHIFT                   _MK_SHIFT_CONST(29)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_FIELD                   (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_H_COUNTER_SHIFT)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_RANGE                   29:29
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_WOFFSET                 0x0
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_ENABLED                 _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_H_COUNTER_DISABLED                        _MK_ENUM_CONST(1)

// Vertical Counter   0= Enabled
//   1= Disabled (reset to 0)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_SHIFT                   _MK_SHIFT_CONST(30)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_FIELD                   (_MK_MASK_CONST(0x1) << VI_VI_INPUT_CONTROL_0_V_COUNTER_SHIFT)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_RANGE                   30:30
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_WOFFSET                 0x0
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_ENABLED                 _MK_ENUM_CONST(0)
#define VI_VI_INPUT_CONTROL_0_V_COUNTER_DISABLED                        _MK_ENUM_CONST(1)


// Register VI_VI_CORE_CONTROL_0  // VI Core Control and Output to EPP/ISP
#define VI_VI_CORE_CONTROL_0                    _MK_ADDR_CONST(0x23)
#define VI_VI_CORE_CONTROL_0_SECURE                     0x0
#define VI_VI_CORE_CONTROL_0_WORD_COUNT                         0x1
#define VI_VI_CORE_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0x7ff0f7f)
#define VI_VI_CORE_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0x7ef0f7f)
#define VI_VI_CORE_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0x7ff0f7f)
// Output to ISP  Enable data output to ISP
//   00= Output to ISP is disabled
//   01= Parallel Video Input Port data
//   10= Host I/F data
//   11= reserved
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_FIELD                        (_MK_MASK_CONST(0x3) << VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_SHIFT)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_RANGE                        1:0
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_DISABLED                     _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_VIP                  _MK_ENUM_CONST(1)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_HOST                 _MK_ENUM_CONST(2)

// Output to EPP enable  VI can output a YUV pixel stream to
//  Encoder Pre-Processor (EPP) module
//   000= Output to EPP is disabled
//   001= YUV444 stream after down-scaling
//   010= YUV444 stream before down-scaling
//        WARNING: FOR YUV444PRE, only the selects
//        in INPUT_TO_CORE are supported.  Selects from
//        INPUT_TO_CORE_EXT are not supported since they
//        are duplicated in the CSI* selections of this field.
//   011= YUV444 stream from ISP, no LPF or down-scaling
//   100= RGB565,RGB444,RGB888 from VIP, no LPF or down-scaling
//   101= RGB565,RGB888 from Host
//   110= CSI_PPA
//   111= CSI_PPB
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_SHIFT                        _MK_SHIFT_CONST(2)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_FIELD                        (_MK_MASK_CONST(0x7) << VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_SHIFT)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_RANGE                        4:2
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_DISABLED                     _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_YUV444POST                   _MK_ENUM_CONST(1)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_YUV444PRE                    _MK_ENUM_CONST(2)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_YUV444ISP                    _MK_ENUM_CONST(3)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_RGB                  _MK_ENUM_CONST(4)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_HOST_RGB                     _MK_ENUM_CONST(5)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_CSI_PPA                      _MK_ENUM_CONST(6)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_EPP_CSI_PPB                      _MK_ENUM_CONST(7)

// Downsample from YUV444 to YUV422   00 = Cosited, take even UV's for each two Y's.
//   01 = Cosited, take odd UV's for each two Y's. (Not implemented)
//   10 = Non Cosited, take even U and odd V, use for Bayer passthru
//   11 = Averaged, average the odd and even UVs. (Not Implemented)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_SHIFT                       _MK_SHIFT_CONST(5)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_FIELD                       (_MK_MASK_CONST(0x3) << VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_SHIFT)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_RANGE                       6:5
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_WOFFSET                     0x0
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_COSITED_EVEN                        _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_COSITED_ODD                 _MK_ENUM_CONST(1)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_NONCOSITED                  _MK_ENUM_CONST(2)
#define VI_VI_CORE_CONTROL_0_ISP_DOWNSAMPLE_AVERAGED                    _MK_ENUM_CONST(3)

// Input to VI Core  Select between possible data input sources
//   00= Parallel Video Input Port data
//   01= Host I/F data
//   10= ISP data, from 444 to 422 converter
//   11= reserved
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_SHIFT                        _MK_SHIFT_CONST(8)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_FIELD                        (_MK_MASK_CONST(0x3) << VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_SHIFT)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_RANGE                        9:8
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_VIP                  _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_HOST                 _MK_ENUM_CONST(1)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_ISP                  _MK_ENUM_CONST(2)

// Planar Conversion Module Input select   0= YUV422 after down-scaling, POST core
//   1= YUV422 before down-scaling, PRE core
//
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_SHIFT                        _MK_SHIFT_CONST(10)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_FIELD                        (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_SHIFT)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_RANGE                        10:10
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_YUV422POST                   _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_PLANAR_CONV_INPUT_SEL_YUV422PRE                    _MK_ENUM_CONST(1)

// Color Space Conversion Input select   0= YUV422 after down-scaling, POST core
//   1= YUV422 before down-scaling, PRE core
// 15:12 reserved
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_SHIFT                        _MK_SHIFT_CONST(11)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_FIELD                        (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_SHIFT)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_RANGE                        11:11
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_YUV422POST                   _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_CSC_INPUT_SEL_YUV422PRE                    _MK_ENUM_CONST(1)

// Horizontal Averaging   0= disabled, H_DOWNSCALING can be used
//      to enable horizontal downscaling
//   1= enabled, H_DOWNSCALING is ignored
//      and horizontal downscaling is
//      controlled by H_AVG_FACTOR
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_H_AVERAGING_SHIFT)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_RANGE                  16:16
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_WOFFSET                        0x0
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_DISABLED                       _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_H_AVERAGING_ENABLED                        _MK_ENUM_CONST(1)

// Horizontal Down-scaling  (effective if H_AVERAGING is DISABLED)
//   0= disabled
//   1= enabled and controlled by H_DOWN_M
//      and H_DOWN_N parameters
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_SHIFT                        _MK_SHIFT_CONST(17)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_FIELD                        (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_H_DOWNSCALING_SHIFT)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_RANGE                        17:17
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_DISABLED                     _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_H_DOWNSCALING_ENABLED                      _MK_ENUM_CONST(1)

// Vertical Averaging   0= disabled, V_DOWNSCALING can be used
//      to enable vertical downscaling
//   1= enabled, V_DOWNSCALING is ignored
//      and vertical downscaling is
//      controlled by V_AVG_FACTOR
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_SHIFT                  _MK_SHIFT_CONST(18)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_V_AVERAGING_SHIFT)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_RANGE                  18:18
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_WOFFSET                        0x0
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_DISABLED                       _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_V_AVERAGING_ENABLED                        _MK_ENUM_CONST(1)

// Vertical Down-scaling  (effective if V_AVERAGING is DISABLED)
//   0= disabled
//   1= enabled and controlled by V_DOWN_M
//      and V_DOWN_N parameters
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_SHIFT                        _MK_SHIFT_CONST(19)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_FIELD                        (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_V_DOWNSCALING_SHIFT)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_RANGE                        19:19
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_WOFFSET                      0x0
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_DISABLED                     _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_V_DOWNSCALING_ENABLED                      _MK_ENUM_CONST(1)

// ISP Host data stall capability is enabled by default  Use this bit to disable the host data stall capability
//   0= disabled - default allows for VI to turn off
//                 the ISP clock to stall the Host.
//   1= enabled - to turn off the VI's ability to stall the Host
//                when data from ISP comes from Host.
//
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_SHIFT                   _MK_SHIFT_CONST(20)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_FIELD                   (_MK_MASK_CONST(0x1) << VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_SHIFT)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_RANGE                   20:20
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_WOFFSET                 0x0
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_DISABLED                        _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_ISP_HOST_STALL_OFF_ENABLED                 _MK_ENUM_CONST(1)

// Select a data source output to ISP (extension field).
//   000= Source is selected with OUTPUT_TO_ISP field (backward compatible)
//   001= CSI Pixel Parser A
//   010= CSI Pixel Parser B
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_SHIFT                    _MK_SHIFT_CONST(21)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_FIELD                    (_MK_MASK_CONST(0x7) << VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_SHIFT)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_RANGE                    23:21
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_WOFFSET                  0x0
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_USE_OUTPUT_TO_ISP                        _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_CSI_PPA                  _MK_ENUM_CONST(1)
#define VI_VI_CORE_CONTROL_0_OUTPUT_TO_ISP_EXT_CSI_PPB                  _MK_ENUM_CONST(2)

// Select a data source input to core (extension field).
//   000= Source is selected with INPUT_TO_CORE field (backward compatible)
//   001= CSI_PPA data in YUV444NP format
//   010= CSI_PPA data in YUV422NP format
//   011= CSI_PPB data in YUV444NP format
//   100= CSI_PPB data in YUV422NP format
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_SHIFT                    _MK_SHIFT_CONST(24)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_FIELD                    (_MK_MASK_CONST(0x7) << VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_SHIFT)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_RANGE                    26:24
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_WOFFSET                  0x0
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_USE_INPUT_TO_CORE                        _MK_ENUM_CONST(0)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_CSI_PPA_YUV444                   _MK_ENUM_CONST(1)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_CSI_PPA_YUV422                   _MK_ENUM_CONST(2)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_CSI_PPB_YUV444                   _MK_ENUM_CONST(3)
#define VI_VI_CORE_CONTROL_0_INPUT_TO_CORE_EXT_CSI_PPB_YUV422                   _MK_ENUM_CONST(4)


// Register VI_VI_FIRST_OUTPUT_CONTROL_0  // VI Output Control of YUV/RGB and YUV420P
#define VI_VI_FIRST_OUTPUT_CONTROL_0                    _MK_ADDR_CONST(0x24)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_SECURE                     0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_WORD_COUNT                         0x1
#define VI_VI_FIRST_OUTPUT_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0x3f0107)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0x3f0107)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0x3f0107)
// Output data Format  Take from the CSC Unit:
//   000= 16-bit RGB (B5G6R5)
//   001= 16-bit RGB (B5G6R5) Dithered
//        (This is currently NOT implemented)
//   010= 24-bit RGB (B8G8R8)
//  Take from the YUV422 Core output path:
//      (Same thing as using YUV422PRE and YUV_SOURCE==CORE_OUTPUT)
//   011= YUV422 non-planar (U8Y8V8Y8) after down-scaling, POST
//  Take from the YUV422 paths: (see YUV_SOURCE field)
//   100= YUV422 non-planar (U8Y8V8Y8) before down-scaling, PRE
//   101= YUV422 Planar
//   110= YUV420 Planar
//   111= YUV420 Planar with Averaging
//        (UV is averaged for each line pair)
// 7:3 reserved
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_FIELD                        (_MK_MASK_CONST(0x7) << VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_RANGE                        2:0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_WOFFSET                      0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_RGB16                        _MK_ENUM_CONST(0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_RGB16D                       _MK_ENUM_CONST(1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_RGB24                        _MK_ENUM_CONST(2)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_YUV422POST                   _MK_ENUM_CONST(3)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_YUV422PRE                    _MK_ENUM_CONST(4)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_YUV422P                      _MK_ENUM_CONST(5)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_YUV420P                      _MK_ENUM_CONST(6)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_FORMAT_YUV420PA                     _MK_ENUM_CONST(7)

// For Planar Output Only, enabling this register  duplicates the last pixel of each line when
//  the output width is set to an odd number of pixels.
//  Used when JPEGE/MPEGE which requires valid data filled
//  to the word(16-bit) boundary.
//  The Buffer Horizontal Size (Line Stride) must be
//  set to accomodate the extra pixel.
//  Example: Disabled - y0,y1,y2,y3,y4
//           Enabled - y0,y1,y2,y3,y4,y4
// 15:9 reserved
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_SHIFT                       _MK_SHIFT_CONST(8)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_RANGE                       8:8
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_WOFFSET                     0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_DISABLED                    _MK_ENUM_CONST(0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_LAST_PIXEL_DUPLICATION_ENABLED                     _MK_ENUM_CONST(1)

// Output Byte Swap  (effective if input source is host)
//   0= disabled
//   1= enabled
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_RANGE                     16:16
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_WOFFSET                   0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_DISABLED                  _MK_ENUM_CONST(0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_OUTPUT_BYTE_SWAP_ENABLED                   _MK_ENUM_CONST(1)

// YUV Output Format This is applicable when output format is
// non-planar YUV422.
//   00= UYVY => Y1_V0_Y1_U0 MSB to LSB 32bit mapping
//   01= VYUY => Y1_U0_Y1_V0
//   10= YUYV => V0_Y1_U0_Y0
//   11= YVYU => U0_Y1_V0_Y0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_SHIFT                    _MK_SHIFT_CONST(17)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_FIELD                    (_MK_MASK_CONST(0x3) << VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_RANGE                    18:17
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_WOFFSET                  0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_UYVY                     _MK_ENUM_CONST(0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_VYUY                     _MK_ENUM_CONST(1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_YUYV                     _MK_ENUM_CONST(2)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_YUV_OUTPUT_FORMAT_YVYU                     _MK_ENUM_CONST(3)

//  H-direction in internal memory
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_SHIFT                  _MK_SHIFT_CONST(19)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_RANGE                  19:19
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_WOFFSET                        0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_H_DIRECTION_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  V-direction in internal memory
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_SHIFT                  _MK_SHIFT_CONST(20)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_RANGE                  20:20
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_WOFFSET                        0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_V_DIRECTION_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  XY-Swap in internal memory
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_SHIFT                      _MK_SHIFT_CONST(21)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_SHIFT)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_RANGE                      21:21
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_WOFFSET                    0x0
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_FIRST_OUTPUT_CONTROL_0_XY_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_VI_SECOND_OUTPUT_CONTROL_0  // VI Second Output Control of YUV422NP and RGB
#define VI_VI_SECOND_OUTPUT_CONTROL_0                   _MK_ADDR_CONST(0x25)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECURE                    0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_WORD_COUNT                        0x1
#define VI_VI_SECOND_OUTPUT_CONTROL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_RESET_MASK                        _MK_MASK_CONST(0x3f000f)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_READ_MASK                         _MK_MASK_CONST(0x3f000f)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_WRITE_MASK                        _MK_MASK_CONST(0x3f000f)
// Secondary Output to MC  Use case: when VI needs to send decimated preview data
//  and at the same time send non-decimated data
//  to the memory for StretchBLT, meanwhile the StretchBLT
//  is sending EPP stretched data to be encoded.
//  Only YUV422, RGB888, RGB565 is supported
//
//  Take from the CSC Unit
//  0000= 16-bit RGB (B5G6R5), all RGB data can be pre or
//        post decimated depending on mux select programming
//        on the input to the Color Space Converter
//  0001= 16-bit RGB (B5G6R5) Dithered
//        (This is currently NOT implemented)
//  0010= 24-bit RGB (B8G8R8)
//  Take from the YUV422 Core output path:
//      (Same thing as using YUV422PRE and YUV_SOURCE==CORE_OUTPUT)
//  0011= YUV422 stream after down-scaling, POST
//  Take from the YUV422 paths: (see YUV_SOURCE field)
//  0100= YUV422 stream before down-scaling, PRE
//  Take from the WriteBuffer interface logic, which is used for JPEG Stream
//  0101= JPEG Stream (Pattern A,B,C)
//  0110= VIP Bayer     direct to memory as a 16-bit value {6'b0, VIP_pad[9:0]}
//  0111= CSI_PPA Bayer direct to memory as a 16-bit value {6'b0, CSI_SVD[15:6]}
//  1000= CSI_PPB Bayer direct to memory as a 16-bit value {6'b0, CSI_SVD[15:6]}
//  VIP_BAYER_DIRECT: Bayer data is written unmodified to memory
//  as a 16-bit quantity.  Bit0 of incoming data is placed in
//  bit0 of the 16-bit memory location. Upper bits are padded with 0.
// 15:4 reserved
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_FIELD                        (_MK_MASK_CONST(0xf) << VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_SHIFT)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_RANGE                        3:0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_WOFFSET                      0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_RGB16                        _MK_ENUM_CONST(0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_RGB16D                       _MK_ENUM_CONST(1)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_RGB24                        _MK_ENUM_CONST(2)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_YUV422POST                   _MK_ENUM_CONST(3)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_YUV422PRE                    _MK_ENUM_CONST(4)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_JPEG_STREAM                  _MK_ENUM_CONST(5)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_VIP_BAYER                    _MK_ENUM_CONST(6)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_CSI_PPA_BAYER                        _MK_ENUM_CONST(7)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_CSI_PPB_BAYER                        _MK_ENUM_CONST(8)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_FORMAT_VIP_BAYER_DIRECT                     _MK_ENUM_CONST(9)

// Output Byte Swap  (effective if input source is host)
//   0= disabled
//   1= enabled
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_SHIFT)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_RANGE                     16:16
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_WOFFSET                   0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_DISABLED                  _MK_ENUM_CONST(0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_OUTPUT_BYTE_SWAP_ENABLED                   _MK_ENUM_CONST(1)

// YUV Second Output Format This is applicable when output format is
// non-planar YUV422.
//   00= UYVY => Y1_V0_Y1_U0 MSB to LSB 32bit mapping
//   01= VYUY => Y1_U0_Y1_V0
//   10= YUYV => V0_Y1_U0_Y0
//   11= YVYU => U0_Y1_V0_Y0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_SHIFT                    _MK_SHIFT_CONST(17)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_FIELD                    (_MK_MASK_CONST(0x3) << VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_SHIFT)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_RANGE                    18:17
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_WOFFSET                  0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_UYVY                     _MK_ENUM_CONST(0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_VYUY                     _MK_ENUM_CONST(1)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_YUYV                     _MK_ENUM_CONST(2)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_YUV_SECOND_OUTPUT_FORMAT_YVYU                     _MK_ENUM_CONST(3)

//  Second output's H-direction in internal memory
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_SHIFT                  _MK_SHIFT_CONST(19)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_SHIFT)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_RANGE                  19:19
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_WOFFSET                        0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_H_DIRECTION_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  Second output's V-direction in internal memory
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_SHIFT                  _MK_SHIFT_CONST(20)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_SHIFT)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_RANGE                  20:20
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_WOFFSET                        0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_V_DIRECTION_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  Second output's XY-Swap in internal memory
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_SHIFT                      _MK_SHIFT_CONST(21)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_SHIFT)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_RANGE                      21:21
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_WOFFSET                    0x0
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_SECOND_OUTPUT_CONTROL_0_SECOND_XY_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Input Frame Width and Height give the total input data dimensions.  The VI input stage will cull/clip
// pixels outside the Active Region (see register VI_HOST_H_ACTIVE & VI_HOST_V_ACTIVE).  The amount of data
// per frame is expected to be INPUT_WIDTH * INPUT_HEIGHT * the bytes per pixel (determined from the
// INPUT_HOST_FORMAT). For Planar, the BPP is 1 for the Y fifo, 1/2 for U and V. For non planar it is 2.
// The Bayer data is treated as 1 byte per pixel, so if it is more, then the input width and the H_ACTIVE
// should be scaled accordingly, so that internally generated hsync and vsyncs for ISP are correct.
// For Bayer input, it is important to insert blanking data for horizontal and vertical, allowing ISP to do
// side band calculations.

// Register VI_HOST_INPUT_FRAME_SIZE_0  // Host Input Frame Width
#define VI_HOST_INPUT_FRAME_SIZE_0                      _MK_ADDR_CONST(0x26)
#define VI_HOST_INPUT_FRAME_SIZE_0_SECURE                       0x0
#define VI_HOST_INPUT_FRAME_SIZE_0_WORD_COUNT                   0x1
#define VI_HOST_INPUT_FRAME_SIZE_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_READ_MASK                    _MK_MASK_CONST(0x1fff1fff)
#define VI_HOST_INPUT_FRAME_SIZE_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff1fff)
// Specifies in terms of pixels the width of
// the input data coming from host.
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_SHIFT)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_RANGE                      12:0
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_WOFFSET                    0x0
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Host Input Frame Height
// Specifies in terms of lines the height of
// the input data coming from host.
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_SHIFT)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_RANGE                     28:16
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_WOFFSET                   0x0
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_HOST_INPUT_FRAME_SIZE_0_INPUT_FRAME_HEIGHT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// This register defines the horizontal active area of the input video source with respect to
// the internally generated horizontal sync.  (This is for data coming in from host.)

// Register VI_HOST_H_ACTIVE_0  // VI Horizontal Active
#define VI_HOST_H_ACTIVE_0                      _MK_ADDR_CONST(0x27)
#define VI_HOST_H_ACTIVE_0_SECURE                       0x0
#define VI_HOST_H_ACTIVE_0_WORD_COUNT                   0x1
#define VI_HOST_H_ACTIVE_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_READ_MASK                    _MK_MASK_CONST(0x1fff1fff)
#define VI_HOST_H_ACTIVE_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff1fff)
// Horizontal Active Start (offset to active)
//  This parameter specifies the number of
//  pixels to be discarded until the first
//  active pixel. If programmed to 0, the
//  first active pixel is the first pixel popped
//  from the Host YUV FIFO.
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_FIELD                    (_MK_MASK_CONST(0x1fff) << VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_SHIFT)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_RANGE                    12:0
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_WOFFSET                  0x0
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_START_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Horizontal Active Period
//  This parameter specifies the number of
//  pixels in the horizontal active area.
//  H_ACTIVE_START + H_ACTIVE_PERIOD should be
//  less than 2^NV_VI_H_IN (or 8192) This parameter
//  should be programmed with an even number
//  (bit 16 is ignored internally).
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_FIELD                   (_MK_MASK_CONST(0x1fff) << VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_SHIFT)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_RANGE                   28:16
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_WOFFSET                 0x0
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_HOST_H_ACTIVE_0_HOST_H_ACTIVE_PERIOD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// This register defines the vertical active area of the input video source with respect to
// the internally generated vertical sync.  (This is for data coming in from host.)

// Register VI_HOST_V_ACTIVE_0  // Vertical Active
#define VI_HOST_V_ACTIVE_0                      _MK_ADDR_CONST(0x28)
#define VI_HOST_V_ACTIVE_0_SECURE                       0x0
#define VI_HOST_V_ACTIVE_0_WORD_COUNT                   0x1
#define VI_HOST_V_ACTIVE_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_READ_MASK                    _MK_MASK_CONST(0x1fff1fff)
#define VI_HOST_V_ACTIVE_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff1fff)
// Vertical Active Start (offset to active)
//  This parameter specifies the number of
//  horizontal sync active edges from vertical
//  sync active edge to the first vertical
//  active line. If programmed to 0, the
//  first active line starts after the first
//  horizontal sync active edge following
//  the vertical sync active edge.
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_FIELD                    (_MK_MASK_CONST(0x1fff) << VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_SHIFT)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_RANGE                    12:0
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_WOFFSET                  0x0
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_START_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Vertical Active Period
//  This parameter specifies the number of
//  lines in the vertical active area.
//  V_ACTIVE_START + V_ACTIVE_PERIOD should be
//  less than 2^NV_VI_V_IN (or 8192).
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_FIELD                   (_MK_MASK_CONST(0x1fff) << VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_SHIFT)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_RANGE                   28:16
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_WOFFSET                 0x0
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_HOST_V_ACTIVE_0_HOST_V_ACTIVE_PERIOD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// This register defines the horizontal active area of the input video source with respect to
//  horizontal sync. (This is for VIP data.)

// Register VI_VIP_H_ACTIVE_0  // VI Horizontal Active
#define VI_VIP_H_ACTIVE_0                       _MK_ADDR_CONST(0x29)
#define VI_VIP_H_ACTIVE_0_SECURE                        0x0
#define VI_VIP_H_ACTIVE_0_WORD_COUNT                    0x1
#define VI_VIP_H_ACTIVE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_READ_MASK                     _MK_MASK_CONST(0x1fff1fff)
#define VI_VIP_H_ACTIVE_0_WRITE_MASK                    _MK_MASK_CONST(0x1fff1fff)
// Horizontal Active Start (offset to active)
//  This parameter specifies the number of
//  clock active edges from horizontal
//  sync active edge to the first horizontal
//  active pixel. If programmed to 0, the
//  first active line starts after the first
//  active clock edge following the horizontal
//  sync active edge.
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_SHIFT)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_RANGE                      12:0
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_WOFFSET                    0x0
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Horizontal Active Period
//  This parameter specifies the number of
//  pixels in the horizontal active area.
//  Bug #178631
//  The value is the END of the active region,
//  so PERIOD-START = active area
//  This parameter should be programmed
//  with an even number
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_SHIFT)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_RANGE                     28:16
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VIP_H_ACTIVE_0_VIP_H_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// This register defines the vertical active area of the input video source with respect to
//  vertical sync. (This is for VIP data.)

// Register VI_VIP_V_ACTIVE_0  // Vertical Active
#define VI_VIP_V_ACTIVE_0                       _MK_ADDR_CONST(0x2a)
#define VI_VIP_V_ACTIVE_0_SECURE                        0x0
#define VI_VIP_V_ACTIVE_0_WORD_COUNT                    0x1
#define VI_VIP_V_ACTIVE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_READ_MASK                     _MK_MASK_CONST(0x1fff1fff)
#define VI_VIP_V_ACTIVE_0_WRITE_MASK                    _MK_MASK_CONST(0x1fff1fff)
// Vertical Active Start (offset to active)
//  This parameter specifies the number of
//  horizontal sync active edges from vertical
//  sync active edge to the first vertical
//  active line. If programmed to 0, the
//  first active line starts after the first
//  horizontal sync active edge following
//  the vertical sync active edge.
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_SHIFT)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_RANGE                      12:0
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_WOFFSET                    0x0
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Vertical Active Period
//  This parameter specifies the number of
//  lines in the vertical active area.
//  Bug #178631
//  The value is the END of the active region,
//  so PERIOD-START = active area
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_SHIFT)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_RANGE                     28:16
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VIP_V_ACTIVE_0_VIP_V_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_VI_PEER_CONTROL_0  // VI Peer to Peer Control
// For all fields:
//   00= Disabled
//   01= First memory
//   10= Second memory
//   11= not defined
#define VI_VI_PEER_CONTROL_0                    _MK_ADDR_CONST(0x2b)
#define VI_VI_PEER_CONTROL_0_SECURE                     0x0
#define VI_VI_PEER_CONTROL_0_WORD_COUNT                         0x1
#define VI_VI_PEER_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define VI_VI_PEER_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define VI_VI_PEER_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0xff)
// VI to Display Control Bus enable  VI will send a valid buffer signal
//  along with Y,U,V buffer addresses
//  and Frame Start and Frame End
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_FIELD                      (_MK_MASK_CONST(0x3) << VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_SHIFT)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_RANGE                      1:0
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_WOFFSET                    0x0
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_DISABLED                   _MK_ENUM_CONST(0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_FIRST                      _MK_ENUM_CONST(1)
#define VI_VI_PEER_CONTROL_0_DISPLAY_CONTROL_SECOND                     _MK_ENUM_CONST(2)

// VI to JPEGE & MPEGE Control Bus enable  VI will send a valid buffer signal
//  along with buffer index
//  and Frame Start and Frame End
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_SHIFT                      _MK_SHIFT_CONST(2)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_FIELD                      (_MK_MASK_CONST(0x3) << VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_SHIFT)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_RANGE                      3:2
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_WOFFSET                    0x0
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_DISABLED                   _MK_ENUM_CONST(0)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_FIRST                      _MK_ENUM_CONST(1)
#define VI_VI_PEER_CONTROL_0_ENCODER_CONTROL_SECOND                     _MK_ENUM_CONST(2)

// VI to StretchBLT Control Bus enable  VI will send a valid buffer signal
//  along with buffer index
//  and Frame Start and Frame End
//  The VI to SB control bus is separate from
//  the VI to JPEGE/MPEGE bus.  This control
//  bus is controlled by the "2nd Output to
//  MC" write client interface.
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_SHIFT                   _MK_SHIFT_CONST(4)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_FIELD                   (_MK_MASK_CONST(0x3) << VI_VI_PEER_CONTROL_0_SB_CONTROL_SHIFT)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_RANGE                   5:4
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_WOFFSET                 0x0
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_DISABLED                        _MK_ENUM_CONST(0)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_FIRST                   _MK_ENUM_CONST(1)
#define VI_VI_PEER_CONTROL_0_SB_CONTROL_SECOND                  _MK_ENUM_CONST(2)

// VI to Display B Control Bus enable  VI will send a valid buffer signal
//  along with Y,U,V buffer addresses
//  and Frame Start and Frame End
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_SHIFT                    _MK_SHIFT_CONST(6)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_FIELD                    (_MK_MASK_CONST(0x3) << VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_SHIFT)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_RANGE                    7:6
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_WOFFSET                  0x0
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_DISABLED                 _MK_ENUM_CONST(0)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_FIRST                    _MK_ENUM_CONST(1)
#define VI_VI_PEER_CONTROL_0_DISPLAY_B_CONTROL_SECOND                   _MK_ENUM_CONST(2)


// Register VI_VI_DMA_SELECT_0  // Host DMA select
#define VI_VI_DMA_SELECT_0                      _MK_ADDR_CONST(0x2c)
#define VI_VI_DMA_SELECT_0_SECURE                       0x0
#define VI_VI_DMA_SELECT_0_WORD_COUNT                   0x1
#define VI_VI_DMA_SELECT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_VI_DMA_SELECT_0_RESET_MASK                   _MK_MASK_CONST(0x3)
#define VI_VI_DMA_SELECT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_VI_DMA_SELECT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_DMA_SELECT_0_READ_MASK                    _MK_MASK_CONST(0x3)
#define VI_VI_DMA_SELECT_0_WRITE_MASK                   _MK_MASK_CONST(0x3)
// Host DMA Request enable at end of block  Request to host DMA can be enabled every
//  time a block of video input data is
//  written to memory.
//   00= Disabled
//   01= Write Buffer DMA for RAW data stream
//   10= First memory
//   11= Second memory
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_FIELD                    (_MK_MASK_CONST(0x3) << VI_VI_DMA_SELECT_0_DMA_REQUEST_SHIFT)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_RANGE                    1:0
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_WOFFSET                  0x0
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_DISABLED                 _MK_ENUM_CONST(0)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_STREAM                   _MK_ENUM_CONST(1)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_FIRST                    _MK_ENUM_CONST(2)
#define VI_VI_DMA_SELECT_0_DMA_REQUEST_SECOND                   _MK_ENUM_CONST(3)


// Register VI_HOST_DMA_WRITE_BUFFER_0  // Host DMA Write Buffer Configuration Registers
#define VI_HOST_DMA_WRITE_BUFFER_0                      _MK_ADDR_CONST(0x2d)
#define VI_HOST_DMA_WRITE_BUFFER_0_SECURE                       0x0
#define VI_HOST_DMA_WRITE_BUFFER_0_WORD_COUNT                   0x1
#define VI_HOST_DMA_WRITE_BUFFER_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_RESET_MASK                   _MK_MASK_CONST(0xe000000)
#define VI_HOST_DMA_WRITE_BUFFER_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_READ_MASK                    _MK_MASK_CONST(0xfffffff)
#define VI_HOST_DMA_WRITE_BUFFER_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffff)
// Buffer Size
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_FIELD                    (_MK_MASK_CONST(0xffff) << VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_SHIFT)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_RANGE                    15:0
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_WOFFSET                  0x0
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_SIZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Buffer Number
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_FIELD                  (_MK_MASK_CONST(0x1ff) << VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_SHIFT)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_RANGE                  24:16
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_WOFFSET                        0x0
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_BUFFER_NUMBER_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// DMA Enable
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_SHIFT                     _MK_SHIFT_CONST(25)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_FIELD                     (_MK_MASK_CONST(0x1) << VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_SHIFT)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_RANGE                     25:25
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_WOFFSET                   0x0
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_DISABLED                  _MK_ENUM_CONST(0)
#define VI_HOST_DMA_WRITE_BUFFER_0_DMA_ENABLE_ENABLED                   _MK_ENUM_CONST(1)

// Data source selection 00= VIP     (backward compatible)
// 01= CSI_PPA
// 10= CSI_PPB
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_SHIFT                     _MK_SHIFT_CONST(26)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_FIELD                     (_MK_MASK_CONST(0x3) << VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_SHIFT)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_RANGE                     27:26
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_WOFFSET                   0x0
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_VIP                       _MK_ENUM_CONST(0)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_CSI_PPA                   _MK_ENUM_CONST(1)
#define VI_HOST_DMA_WRITE_BUFFER_0_SOURCE_SEL_CSI_PPB                   _MK_ENUM_CONST(2)


// Register VI_HOST_DMA_BASE_ADDRESS_0  // Host DMA Write Buffer Configuration Registers
#define VI_HOST_DMA_BASE_ADDRESS_0                      _MK_ADDR_CONST(0x2e)
#define VI_HOST_DMA_BASE_ADDRESS_0_SECURE                       0x0
#define VI_HOST_DMA_BASE_ADDRESS_0_WORD_COUNT                   0x1
#define VI_HOST_DMA_BASE_ADDRESS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define VI_HOST_DMA_BASE_ADDRESS_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Base Address
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_FIELD                  (_MK_MASK_CONST(0xffffffff) << VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_SHIFT)
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_RANGE                  31:0
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_WOFFSET                        0x0
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_BASE_ADDRESS_0_DMA_BASE_ADDR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_HOST_DMA_WRITE_BUFFER_STATUS_0  // Host DMA Write Buffer Status Register
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0                       _MK_ADDR_CONST(0x2f)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_SECURE                        0x0
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WORD_COUNT                    0x1
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x7ffffff)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Read Only
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_FIELD                       (_MK_MASK_CONST(0x7ffffff) << VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_SHIFT)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_RANGE                       26:0
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_WOFFSET                     0x0
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_BUFFER_STATUS_0_WB_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0  // Host DMA Write Buffer Pending Buffer Count
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0                       _MK_ADDR_CONST(0x30)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_SECURE                        0x0
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_WORD_COUNT                    0x1
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_READ_MASK                     _MK_MASK_CONST(0x1ff)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Read Only
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_FIELD                   (_MK_MASK_CONST(0x1ff) << VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_SHIFT)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_RANGE                   8:0
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_WOFFSET                 0x0
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_HOST_DMA_WRITE_PEND_BUFCOUNT_0_PEND_BUFCOUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// FIRST OUTPUT Registers
// These registers are used to setup the first of two memory outputs for VI
// Address Y, U, V; Frame size; Count; Size (line stride and block height); and Buffer Stride

// Register VI_VB0_START_ADDRESS_FIRST_0  // Video Buffer O Start Address for First Output
#define VI_VB0_START_ADDRESS_FIRST_0                    _MK_ADDR_CONST(0x31)
#define VI_VB0_START_ADDRESS_FIRST_0_SECURE                     0x0
#define VI_VB0_START_ADDRESS_FIRST_0_WORD_COUNT                         0x1
#define VI_VB0_START_ADDRESS_FIRST_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define VI_VB0_START_ADDRESS_FIRST_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
//  This is byte address of video buffer 0 if
//  output data format is RGB or YUV non-planar.
//  This is byte address of video buffer 0
//  Y-plane if output data format is YUV planar.
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_FIELD                  (_MK_MASK_CONST(0xffffffff) << VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_SHIFT)
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_RANGE                  31:0
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_WOFFSET                        0x0
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_FIRST_0_VB0_START_ADDRESS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// BASE address is used in Tiling mode. BASE address always points to the left_upper cornor
// of a surface. A surface can contain multiple buffers, in circular_buffer case.
// Write to the BASE address register with cause corresponding internal buffer index set back
// to zero.

// Register VI_VB0_BASE_ADDRESS_FIRST_0  // Video Buffer O BASE Address for First Output
#define VI_VB0_BASE_ADDRESS_FIRST_0                     _MK_ADDR_CONST(0x32)
#define VI_VB0_BASE_ADDRESS_FIRST_0_SECURE                      0x0
#define VI_VB0_BASE_ADDRESS_FIRST_0_WORD_COUNT                  0x1
#define VI_VB0_BASE_ADDRESS_FIRST_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define VI_VB0_BASE_ADDRESS_FIRST_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
//  This is the first byte address of video
//  buffer 0.
//  This is byte address of video buffer 0
//  Y-plane if output data format is planar.
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_FIELD                    (_MK_MASK_CONST(0xffffffff) << VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_SHIFT)
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_RANGE                    31:0
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_WOFFSET                  0x0
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_FIRST_0_VB0_BASE_ADDRESS_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register VI_VB0_START_ADDRESS_U_0  // Video Buffer O Start Address U (linked to First Output)
#define VI_VB0_START_ADDRESS_U_0                        _MK_ADDR_CONST(0x33)
#define VI_VB0_START_ADDRESS_U_0_SECURE                         0x0
#define VI_VB0_START_ADDRESS_U_0_WORD_COUNT                     0x1
#define VI_VB0_START_ADDRESS_U_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define VI_VB0_START_ADDRESS_U_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
//  This is byte address of video buffer 0
//  U-plane if output data format is YUV planar.
//  output data format is YUV planar.
//  Due to clock gating, the primary
//  OUTPUT_TO_MEMORY must be enabled and the
//  OUTPUT_FORMAT must be set to a planar format
//  prior to writing this register
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_SHIFT)
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_RANGE                      31:0
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_WOFFSET                    0x0
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_U_0_VB0_START_ADDRESS_U_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_VB0_BASE_ADDRESS_U_0  // Video Buffer O BASE Address U
//(linked to First Output)
#define VI_VB0_BASE_ADDRESS_U_0                 _MK_ADDR_CONST(0x34)
#define VI_VB0_BASE_ADDRESS_U_0_SECURE                  0x0
#define VI_VB0_BASE_ADDRESS_U_0_WORD_COUNT                      0x1
#define VI_VB0_BASE_ADDRESS_U_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define VI_VB0_BASE_ADDRESS_U_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
//  This is the first byte address of video
//  buffer 0 U-plane if output data format
//  is planar.
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_FIELD                        (_MK_MASK_CONST(0xffffffff) << VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_SHIFT)
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_RANGE                        31:0
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_WOFFSET                      0x0
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_U_0_VB0_BASE_ADDRESS_U_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_VB0_START_ADDRESS_V_0  // Video Buffer O Start Address V (linked to First Output)
#define VI_VB0_START_ADDRESS_V_0                        _MK_ADDR_CONST(0x35)
#define VI_VB0_START_ADDRESS_V_0_SECURE                         0x0
#define VI_VB0_START_ADDRESS_V_0_WORD_COUNT                     0x1
#define VI_VB0_START_ADDRESS_V_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define VI_VB0_START_ADDRESS_V_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
//  This is byte address of video buffer 0
//  V-plane if output data format is YUV planar.
//  output data format is YUV planar.
//  Due to clock gating, the primary
//  OUTPUT_TO_MEMORY must be enabled and the
//  OUTPUT_FORMAT must be set to a planar format
//  prior to writing this register
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_SHIFT)
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_RANGE                      31:0
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_WOFFSET                    0x0
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_V_0_VB0_START_ADDRESS_V_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_VB0_BASE_ADDRESS_V_0  // Video Buffer O BASE Address V
//(linked to First Output)
#define VI_VB0_BASE_ADDRESS_V_0                 _MK_ADDR_CONST(0x36)
#define VI_VB0_BASE_ADDRESS_V_0_SECURE                  0x0
#define VI_VB0_BASE_ADDRESS_V_0_WORD_COUNT                      0x1
#define VI_VB0_BASE_ADDRESS_V_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define VI_VB0_BASE_ADDRESS_V_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
//  This is byte address of video buffer 0
//  V-plane if output data format is YUV planar.
//  output data format is YUV planar.
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_FIELD                        (_MK_MASK_CONST(0xffffffff) << VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_SHIFT)
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_RANGE                        31:0
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_WOFFSET                      0x0
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_V_0_VB0_BASE_ADDRESS_V_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_VB0_SCRATCH_ADDRESS_UV_0  // Video Buffer O Scratch Address UV (linked to First Output)
#define VI_VB0_SCRATCH_ADDRESS_UV_0                     _MK_ADDR_CONST(0x37)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_SECURE                      0x0
#define VI_VB0_SCRATCH_ADDRESS_UV_0_WORD_COUNT                  0x1
#define VI_VB0_SCRATCH_ADDRESS_UV_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
//  If OUTPUT_FORMAT is YUV420PA, this is used.
//  This is byte address of video buffer 0
//  UV intermediate data is saved here during the
//  YUV422 to YUV420PA conversion.
//  The size allocated needs to match the
//  FIRST_FRAME_WIDTH register setting
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_FIELD                        (_MK_MASK_CONST(0xffffffff) << VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_SHIFT)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_RANGE                        31:0
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_WOFFSET                      0x0
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VB0_SCRATCH_ADDRESS_UV_0_VB0_SCRATCH_ADDRESS_UV_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_FIRST_OUTPUT_FRAME_SIZE_0  // Width and height of first output frame
// This is the size of the frame being written to memory.
// Apply decimation or averaging to calculate the output frame
// size.  Whether or not downscaling is used specify whatever the
// size of the frame being written to memory.
#define VI_FIRST_OUTPUT_FRAME_SIZE_0                    _MK_ADDR_CONST(0x38)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_SECURE                     0x0
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_WORD_COUNT                         0x1
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_READ_MASK                  _MK_MASK_CONST(0x1fff1fff)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_WRITE_MASK                         _MK_MASK_CONST(0x1fff1fff)
// frame width in pixel which VI needs to process
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_FIELD                    (_MK_MASK_CONST(0x1fff) << VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_SHIFT)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_RANGE                    12:0
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_WOFFSET                  0x0
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_WIDTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// frame height in lines which VI needs to process
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_FIELD                   (_MK_MASK_CONST(0x1fff) << VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_SHIFT)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_RANGE                   28:16
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_WOFFSET                 0x0
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_FIRST_OUTPUT_FRAME_SIZE_0_FIRST_FRAME_HEIGHT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_VB0_COUNT_FIRST_0  // Video Buffer Set 0 Count for First Output
#define VI_VB0_COUNT_FIRST_0                    _MK_ADDR_CONST(0x39)
#define VI_VB0_COUNT_FIRST_0_SECURE                     0x0
#define VI_VB0_COUNT_FIRST_0_WORD_COUNT                         0x1
#define VI_VB0_COUNT_FIRST_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define VI_VB0_COUNT_FIRST_0_WRITE_MASK                         _MK_MASK_CONST(0xff)
// Video Buffer Set 0 Count
//  This specifies the number of buffers in
//  video buffer set 0.
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_FIELD                  (_MK_MASK_CONST(0xff) << VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_SHIFT)
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_RANGE                  7:0
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_WOFFSET                        0x0
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_FIRST_0_VB0_COUNT_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_VB0_SIZE_FIRST_0  // Video Buffer Set 0 Size for First Output
#define VI_VB0_SIZE_FIRST_0                     _MK_ADDR_CONST(0x3a)
#define VI_VB0_SIZE_FIRST_0_SECURE                      0x0
#define VI_VB0_SIZE_FIRST_0_WORD_COUNT                  0x1
#define VI_VB0_SIZE_FIRST_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_READ_MASK                   _MK_MASK_CONST(0x1fff1fff)
#define VI_VB0_SIZE_FIRST_0_WRITE_MASK                  _MK_MASK_CONST(0x1fff1fff)
// Video Buffer Set 0 Horizontal Size
//  This parameter specifies the line stride
//  (in pixels) for lines in the video buffer
//  set 0.
//  For YUV non-planar format, this parameter
//  must be programmed as multiple of 2 pixels
//  (bit 0 is ignored).
//  For YUV planar format, this parameter
//  must be programmed as multiple of 8 pixels
//  (bits 2-0 are ignored) and it specifies the
//  luma line stride or twice the chroma line
//  stride.
//  This value will be divided by 2 for chroma
//  buffers for YUV422 and YUV420 planar formats
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_FIELD                  (_MK_MASK_CONST(0x1fff) << VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_SHIFT)
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_RANGE                  12:0
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_WOFFSET                        0x0
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_VB0_H_SIZE_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Video Buffer Set 0 Vertical Size
//  This specifies the number of lines in each
//  buffer in video buffer set 0.
//  This value will be divided by 2 for chroma
//  buffers for YUV420 planar formats
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_FIELD                  (_MK_MASK_CONST(0x1fff) << VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_SHIFT)
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_RANGE                  28:16
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_WOFFSET                        0x0
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_FIRST_0_VB0_V_SIZE_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_VB0_BUFFER_STRIDE_FIRST_0  // Video Buffer Set 0 Buffer Stride
#define VI_VB0_BUFFER_STRIDE_FIRST_0                    _MK_ADDR_CONST(0x3b)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_SECURE                     0x0
#define VI_VB0_BUFFER_STRIDE_FIRST_0_WORD_COUNT                         0x1
#define VI_VB0_BUFFER_STRIDE_FIRST_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Video Buffer Set 0 Luma Buffer Stride
//  This is luma buffer stride (in bytes)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_FIELD                  (_MK_MASK_CONST(0x3fffffff) << VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_SHIFT)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_RANGE                  29:0
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_WOFFSET                        0x0
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_L_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Video Buffer Set 0 Chroma Buffer Stride   00= Equal to Luma Buffer Stride
//   01= Equal to Luma Buffer Stride divided by 2
//       in this case Luma Buffer Stride should
//       be multiple of 2 bytes.
//   10= Equal to Luma Buffer Stride divided by 4
//       in this case Luma Buffer Stride should
//       be multiple of 4 bytes.
//   1x= Reserved
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_SHIFT                  _MK_SHIFT_CONST(30)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_FIELD                  (_MK_MASK_CONST(0x3) << VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_SHIFT)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_RANGE                  31:30
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_WOFFSET                        0x0
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_CBS1X                  _MK_ENUM_CONST(0)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_CBS2X                  _MK_ENUM_CONST(1)
#define VI_VB0_BUFFER_STRIDE_FIRST_0_VB0_BUFFER_STRIDE_C_CBS4X                  _MK_ENUM_CONST(2)

// SECOND OUTPUT Registers
// These registers are used to setup the second of two memory outputs for VI
// Address; Frame size; Count; Size (line stride and block height); and Buffer Stride

// Register VI_VB0_START_ADDRESS_SECOND_0  // Video Buffer O Start Address for Second Output
#define VI_VB0_START_ADDRESS_SECOND_0                   _MK_ADDR_CONST(0x3c)
#define VI_VB0_START_ADDRESS_SECOND_0_SECURE                    0x0
#define VI_VB0_START_ADDRESS_SECOND_0_WORD_COUNT                        0x1
#define VI_VB0_START_ADDRESS_SECOND_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define VI_VB0_START_ADDRESS_SECOND_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
//  This is byte address of video buffer 0 if
//  output data format is RGB or YUV non-planar.
//  This is byte address of video buffer 0
//  This output data is read by the SB
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_FIELD                 (_MK_MASK_CONST(0xffffffff) << VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_SHIFT)
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_RANGE                 31:0
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_WOFFSET                       0x0
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_START_ADDRESS_SECOND_0_VB0_START_ADDRESS_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_VB0_BASE_ADDRESS_SECOND_0  // Video Buffer O Base Address for Second Output
#define VI_VB0_BASE_ADDRESS_SECOND_0                    _MK_ADDR_CONST(0x3d)
#define VI_VB0_BASE_ADDRESS_SECOND_0_SECURE                     0x0
#define VI_VB0_BASE_ADDRESS_SECOND_0_WORD_COUNT                         0x1
#define VI_VB0_BASE_ADDRESS_SECOND_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define VI_VB0_BASE_ADDRESS_SECOND_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
//  This is byte address of video buffer 0 if
//  output data format is RGB or non-planar.
//  This is the first byte address of video
//  buffer
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_FIELD                   (_MK_MASK_CONST(0xffffffff) << VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_SHIFT)
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_RANGE                   31:0
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_WOFFSET                 0x0
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VB0_BASE_ADDRESS_SECOND_0_VB0_BASE_ADDRESS_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_SECOND_OUTPUT_FRAME_SIZE_0  // width and height of second output frame
#define VI_SECOND_OUTPUT_FRAME_SIZE_0                   _MK_ADDR_CONST(0x3e)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECURE                    0x0
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_WORD_COUNT                        0x1
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_READ_MASK                         _MK_MASK_CONST(0x1fff1fff)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_WRITE_MASK                        _MK_MASK_CONST(0x1fff1fff)
// frame width in pixel which VI needs to process
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_FIELD                  (_MK_MASK_CONST(0x1fff) << VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_SHIFT)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_RANGE                  12:0
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_WOFFSET                        0x0
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_WIDTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// frame height in lines which VI needs to process
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_FIELD                 (_MK_MASK_CONST(0x1fff) << VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_SHIFT)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_RANGE                 28:16
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_WOFFSET                       0x0
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_SECOND_OUTPUT_FRAME_SIZE_0_SECOND_FRAME_HEIGHT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_VB0_COUNT_SECOND_0  // Video Buffer Set 0 Count for Second Output
#define VI_VB0_COUNT_SECOND_0                   _MK_ADDR_CONST(0x3f)
#define VI_VB0_COUNT_SECOND_0_SECURE                    0x0
#define VI_VB0_COUNT_SECOND_0_WORD_COUNT                        0x1
#define VI_VB0_COUNT_SECOND_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define VI_VB0_COUNT_SECOND_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
//
//  This specifies the number of buffers in
//  video buffer set 0.
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_FIELD                 (_MK_MASK_CONST(0xff) << VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_SHIFT)
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_RANGE                 7:0
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_WOFFSET                       0x0
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_COUNT_SECOND_0_VB0_COUNT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_VB0_SIZE_SECOND_0  // Video Buffer Set 0 Size for Second Output
#define VI_VB0_SIZE_SECOND_0                    _MK_ADDR_CONST(0x40)
#define VI_VB0_SIZE_SECOND_0_SECURE                     0x0
#define VI_VB0_SIZE_SECOND_0_WORD_COUNT                         0x1
#define VI_VB0_SIZE_SECOND_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_READ_MASK                  _MK_MASK_CONST(0x1fff1fff)
#define VI_VB0_SIZE_SECOND_0_WRITE_MASK                         _MK_MASK_CONST(0x1fff1fff)
// Video Buffer Set 0 Horizontal Size
//  This parameter specifies the line stride
//  (in pixels) for lines in the video buffer
//  set 0.
//  For YUV non-planar format, this parameter
//  must be programmed as multiple of 2 pixels
//  (bit 0 is ignored).
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_FIELD                 (_MK_MASK_CONST(0x1fff) << VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_SHIFT)
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_RANGE                 12:0
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_WOFFSET                       0x0
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_VB0_H_SIZE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Video Buffer Set 0 Vertical Size
//  This specifies the number of lines in each
//  buffer in video buffer set 0.
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_FIELD                 (_MK_MASK_CONST(0x1fff) << VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_SHIFT)
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_RANGE                 28:16
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_WOFFSET                       0x0
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_SIZE_SECOND_0_VB0_V_SIZE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_VB0_BUFFER_STRIDE_SECOND_0  // Video Buffer Set 0 Buffer Stride for Second Output
#define VI_VB0_BUFFER_STRIDE_SECOND_0                   _MK_ADDR_CONST(0x41)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_SECURE                    0x0
#define VI_VB0_BUFFER_STRIDE_SECOND_0_WORD_COUNT                        0x1
#define VI_VB0_BUFFER_STRIDE_SECOND_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_READ_MASK                         _MK_MASK_CONST(0x3fffffff)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_WRITE_MASK                        _MK_MASK_CONST(0x3fffffff)
// Video Buffer Set 0 Luma Buffer Stride
//  This is luma buffer stride (in bytes)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_FIELD                 (_MK_MASK_CONST(0x3fffffff) << VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_SHIFT)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_RANGE                 29:0
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_WOFFSET                       0x0
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_BUFFER_STRIDE_SECOND_0_VB0_BUFFER_STRIDE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register controls horizontal low-pass filtering which can be enabled to improve quality
// of the decimated image. The only valid programming values for this register are:
//   0x02400240          No filtering
//   0x0DBE092E          1-HPF^3
//   0x01B60126          1-HPF^2
//   0x05B70127          (1-HPF^2+LPF)/2
//   0x06480248          LPF
//   0x04910001          (LPF+LPF^2)/2
//   0x00900000          LPF^2
//   0x04980008          LPF^3
//   0x07980308          LPF^2 * (0.5,0,0.5)
//   0x07f80368          LPF * (0.5,0,0.5) * (2,-3,2)
// The above list is ordered from the widest band-pass filter to the narrowest band-pass filter.
#define VI_H_LPF_NO_FILTER      576
#define VI_H_LPF_ONE_MINUS_HPF_CUBED_C  3518
#define VI_H_LPF_ONE_MINUS_HPF_CUBED_L  2350
#define VI_H_LPF_ONE_MINUS_HPF_SQUARED_C        438
#define VI_H_LPF_ONE_MINUS_HPF_SQUARED_L        294
#define VI_H_LPF_ONE_MINUS_HPF_SQUARED_PLUS_LPF_C       1463
#define VI_H_LPF_ONE_MINUS_HPF_SQUARED_PLUS_LPF_L       295
#define VI_H_LPF_LPF_C  1608
#define VI_H_LPF_LPF_L  584
#define VI_H_LPF_LPF_PLUS_LPF_SQUARED_C 1169
#define VI_H_LPF_LPF_PLUS_LPF_SQUARED_L 1
#define VI_H_LPF_LPF_SQUARED_C  144
#define VI_H_LPF_LPF_SQUARED_L  0
#define VI_H_LPF_LPF_CUBED_C    1176
#define VI_H_LPF_LPF_CUBED_L    8
#define VI_H_LPF_LPF_SQUARED_SCALED_C   1944
#define VI_H_LPF_LPF_SQUARED_SCALED_L   776
#define VI_H_LPF_LPF_SQUARED_SCALED2_C  2040
#define VI_H_LPF_LPF_SQUARED_SCALED2_L  872

// Register VI_H_LPF_CONTROL_0  // VI Horizontal Low-Pass Filter (LPF) Control
#define VI_H_LPF_CONTROL_0                      _MK_ADDR_CONST(0x42)
#define VI_H_LPF_CONTROL_0_SECURE                       0x0
#define VI_H_LPF_CONTROL_0_WORD_COUNT                   0x1
#define VI_H_LPF_CONTROL_0_RESET_VAL                    _MK_MASK_CONST(0x2400240)
#define VI_H_LPF_CONTROL_0_RESET_MASK                   _MK_MASK_CONST(0x1fff1fff)
#define VI_H_LPF_CONTROL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_H_LPF_CONTROL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_H_LPF_CONTROL_0_READ_MASK                    _MK_MASK_CONST(0x1fff1fff)
#define VI_H_LPF_CONTROL_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff1fff)
// Horizontal LPF Luminance filter
//  This controls low pass filter for Y data.
#define VI_H_LPF_CONTROL_0_H_LPF_L_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_H_LPF_CONTROL_0_H_LPF_L_FIELD                        (_MK_MASK_CONST(0x1fff) << VI_H_LPF_CONTROL_0_H_LPF_L_SHIFT)
#define VI_H_LPF_CONTROL_0_H_LPF_L_RANGE                        12:0
#define VI_H_LPF_CONTROL_0_H_LPF_L_WOFFSET                      0x0
#define VI_H_LPF_CONTROL_0_H_LPF_L_DEFAULT                      _MK_MASK_CONST(0x240)
#define VI_H_LPF_CONTROL_0_H_LPF_L_DEFAULT_MASK                 _MK_MASK_CONST(0x1fff)
#define VI_H_LPF_CONTROL_0_H_LPF_L_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_H_LPF_CONTROL_0_H_LPF_L_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Horizontal LPF Chrominance filter
//  This controls low pass filter for U V data.
#define VI_H_LPF_CONTROL_0_H_LPF_C_SHIFT                        _MK_SHIFT_CONST(16)
#define VI_H_LPF_CONTROL_0_H_LPF_C_FIELD                        (_MK_MASK_CONST(0x1fff) << VI_H_LPF_CONTROL_0_H_LPF_C_SHIFT)
#define VI_H_LPF_CONTROL_0_H_LPF_C_RANGE                        28:16
#define VI_H_LPF_CONTROL_0_H_LPF_C_WOFFSET                      0x0
#define VI_H_LPF_CONTROL_0_H_LPF_C_DEFAULT                      _MK_MASK_CONST(0x240)
#define VI_H_LPF_CONTROL_0_H_LPF_C_DEFAULT_MASK                 _MK_MASK_CONST(0x1fff)
#define VI_H_LPF_CONTROL_0_H_LPF_C_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_H_LPF_CONTROL_0_H_LPF_C_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Horizontal pixel processing starts with horizontal low-pass filtering.
// Following horizontal low-pass filtering, horizontal down-scaling (decimation) can then be
// performed with or without horizontal averaging.
// If horizontal down-scaling (decimation) is performed without horizontal averaging, the
// down-scaling factor is specified by input active period and output frame size.  Because the
// VI has two input methods (VIP and HOST) and two memory outputs, there are mux selects to indicate
// which registers to use in calculating the input and output frame sizes.
// If horizontal down-scaling is performed with horizontal averaging, the down-scaling factors
// are limited to few factors determined by H_AVG_CONTROL.  When enabling averaging PLEASE be careful
// that the input and output ratios match the formula for the averaging decimation ratio exactly to the
// pixel/line. The formula for each of the Averaging Decimation Ratio is as follows:
//
// Averaging Decimation Formalae
// x = input size
// y(x) = output size
// 2-pixel averaging and 1/2 downscaling: y(x) = Floor(x/2)
// 4-pixel averaging and 1/3 downscaling: y(x) = Floor((x-1)/3)
// 4-pixel averaging and 1/4 downscaling: y(x) = Floor(x/4)
// 8-pixel averaging and 1/7 downscaling: y(x) = Floor((x-1)/7)
// 8-pixel averaging and 1/8 downscaling: y(x) = Floor(x/8)
//
// Horizontal Decimation Algorithm:
// The Horizontal Decimator decides which pixels to drop by using a simple DDA algorithm.
// The accumulator will continue to add the value of the output width (numerator) for each
// pixel until the sum is equal or greater than the input width (denominator).  When the sum
// is greater or equal to the input width (denominator), the hardware will flag that pixel as
// a pixel to be written out to memory.  At the same time, the input width (denominator) will
// be subtracted from the sum and the difference will be loaded back into the accumulator for
// the next line.  By default the accumulator is initialized with 0's upon reset.  However the
// user can set the H_DEC_INIT_VAL to initialize the accumulator with a certain value from
// 0 to the input width (denominator).  Any H_DEC_INIT_VAL that is greater or equal to the
// difference of the input width (denominator) and the output width (numerator) will cause the
// first pixel to be written out to memory.  This register shifts the phase of the decimation
// pattern.

// Register VI_H_DOWNSCALE_CONTROL_0  // VI Horizontal Down-scaling Control
#define VI_H_DOWNSCALE_CONTROL_0                        _MK_ADDR_CONST(0x43)
#define VI_H_DOWNSCALE_CONTROL_0_SECURE                         0x0
#define VI_H_DOWNSCALE_CONTROL_0_WORD_COUNT                     0x1
#define VI_H_DOWNSCALE_CONTROL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_RESET_MASK                     _MK_MASK_CONST(0x1fff000c)
#define VI_H_DOWNSCALE_CONTROL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_READ_MASK                      _MK_MASK_CONST(0x1fff070f)
#define VI_H_DOWNSCALE_CONTROL_0_WRITE_MASK                     _MK_MASK_CONST(0x1fff070f)
// Input Horizontal Size Select  Selects between the VIP and HOST input active
//  area widths for the denominator in the
//  downscaling ratio.  Uses VIP_H_ACTIVE_PERIOD or
//  HOST_H_ACTIVE_PERIOD, which is the width of the
//  data after cropping.  This is effective only when
//  H_AVERAGING is DISABLED and H_DOWNSCALING is
//  ENABLED.
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_FIELD                 (_MK_MASK_CONST(0x1) << VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_SHIFT)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_RANGE                 0:0
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_WOFFSET                       0x0
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_VIP                   _MK_ENUM_CONST(0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_HOST                  _MK_ENUM_CONST(1)

// Output Horizontal Size Select  Selects between the first and second memory output
//  frame widths for the numerator in the downscaling
//  ratio.  Uses FIRST_FRAME_WIDTH or
//  SECOND_FRAME_WIDTH.
//  This is effective
//  only when H_AVERAGING is DISABLED and
//  H_DOWNSCALING is ENABLED.
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_SHIFT                        _MK_SHIFT_CONST(1)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_FIELD                        (_MK_MASK_CONST(0x1) << VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_SHIFT)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_RANGE                        1:1
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_WOFFSET                      0x0
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_FIRST                        _MK_ENUM_CONST(0)
#define VI_H_DOWNSCALE_CONTROL_0_OUTPUT_H_SIZE_SEL_SECOND                       _MK_ENUM_CONST(1)

//  Selects input horizontal size into scalers (extension field)
//  00= Hor. size selected with INPUT_H_SIZE_SEL field (backward compatible)
//  01= Hor. size of CSI_PPA is provided by CSI_PPA_H_ACTIVE register
//  10= Hor. size of CSI_PPB is provided by CSI_PPB_H_ACTIVE register
//  11= Hor. size of ISP     is provided by ISP_H_ACTIVE     register
// 7:4 reserved
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_SHIFT                     _MK_SHIFT_CONST(2)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_FIELD                     (_MK_MASK_CONST(0x3) << VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_SHIFT)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_RANGE                     3:2
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_WOFFSET                   0x0
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_USE_INPUT_H_SIZE_SEL                      _MK_ENUM_CONST(0)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_CSI_PPA                   _MK_ENUM_CONST(1)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_CSI_PPB                   _MK_ENUM_CONST(2)
#define VI_H_DOWNSCALE_CONTROL_0_INPUT_H_SIZE_SEL_EXT_ISP                       _MK_ENUM_CONST(3)

// Horizontal Averaging Control  This specifies the number of pixels to
//  average and to decimate horizontally.
//   000= 2-pixel averaging and 1/2 down-scaling
//   001= 4-pixel averaging and 1/3 down-scaling
//   010= 4-pixel averaging and 1/4 down-scaling
//   011= 8-pixel averaging and 1/7 down-scaling
//   100= 8-pixel averaging and 1/8 down-scaling
//   other= reserved
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_FIELD                    (_MK_MASK_CONST(0x7) << VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_SHIFT)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_RANGE                    10:8
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_WOFFSET                  0x0
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_A2D2                     _MK_ENUM_CONST(0)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_A4D3                     _MK_ENUM_CONST(1)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_A4D4                     _MK_ENUM_CONST(2)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_A8D7                     _MK_ENUM_CONST(3)
#define VI_H_DOWNSCALE_CONTROL_0_H_AVG_CONTROL_A8D8                     _MK_ENUM_CONST(4)

// Horizontal Decimation Accumulator Initial Value
//  The user may initialized the H-Dec accumulator with
//  a value between 0-(H_ACTIVE_PERIOD) to change the phase
//  of the decimation pattern.  This will allow the user
//  to decide which is the first pixel to keep.
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_FIELD                   (_MK_MASK_CONST(0x1fff) << VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_SHIFT)
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_RANGE                   28:16
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_WOFFSET                 0x0
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1fff)
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_H_DOWNSCALE_CONTROL_0_H_DEC_INIT_VAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Vertical processing consists of optional vertical down-scaling (decimation) which can be
// performed with or without vertical averaging.
// If vertical down-scaling (decimation) is performed without vertical averaging, the
// down-scaling factor is specified by input active period and output frame size.  Because the
// VI has two input methods (VIP and HOST) and two memory outputs, there are mux selects to indicate
// which registers to use in calculating the input and output frame sizes.
// If horizontal down-scaling is performed with vertical averaging, the down-scaling factors
// are limited to few factors determined by V_AVG_CONTROL.  When enabling averaging PLEASE be careful
// that the input and output ratios match the formula for the averaging decimation ratio exactly to the
// pixel/line. The formula for each of the Averaging Decimation Ratio is as follows:
//
// Averaging Decimation Formalae
// x = input size
// y(x) = output size
// 2-pixel averaging and 1/2 downscaling: y(x) = Floor(x/2)
// 4-pixel averaging and 1/3 downscaling: y(x) = Floor((x-1)/3)
// 4-pixel averaging and 1/4 downscaling: y(x) = Floor(x/4)
// 8-pixel averaging and 1/7 downscaling: y(x) = Floor((x-1)/7)
// 8-pixel averaging and 1/8 downscaling: y(x) = Floor(x/8)
//
// Vertical Decimation Algorithm: (same as the Horizontal Decimation Algorithm)
// The Vertical Decimator decides which pixels to drop by using a simple DDA algorithm.
// The accumulator will continue to add the value of the output height (numerator) for each
// line until the sum is equal or greater than the input height (denominator).  When the sum
// is greater or equal to the input height (denominator), the hardware will flag that line as
// a line to be written out to memory.  At the same time, the input height (denominator) will
// be subtracted from the sum and the difference will be loaded back into the accumulator for
// the next line.  By default the accumulator is initialized with 0's upon reset.  However the
// user can set the V_DEC_INIT_VAL to initialize the accumulator with a certain value from
// 0 to the input height (denominator).  Any V_DEC_INIT_VAL that is greater or equal to the
// difference of the input height (denominator) and the output height (numerator) will cause the
// first line to be written out to memory.  This register shifts the phase of the decimation
// pattern.

// Register VI_V_DOWNSCALE_CONTROL_0  // VI Vertical Down-scaling Control
#define VI_V_DOWNSCALE_CONTROL_0                        _MK_ADDR_CONST(0x44)
#define VI_V_DOWNSCALE_CONTROL_0_SECURE                         0x0
#define VI_V_DOWNSCALE_CONTROL_0_WORD_COUNT                     0x1
#define VI_V_DOWNSCALE_CONTROL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_RESET_MASK                     _MK_MASK_CONST(0x1fff000c)
#define VI_V_DOWNSCALE_CONTROL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_READ_MASK                      _MK_MASK_CONST(0x1fff370f)
#define VI_V_DOWNSCALE_CONTROL_0_WRITE_MASK                     _MK_MASK_CONST(0x1fff370f)
// Input Vertical Size Select  Selects between the VIP and HOST input active
//  area heights for the denominator in the
//  downscaling ratio.  Uses VIP_V_ACTIVE_PERIOD or
//  HOST_V_ACTIVE_PERIOD, which is the height of the
//  data after cropping.  This is effective only when
//  V_AVERAGING is DISABLED and V_DOWNSCALING is
//  ENABLED.
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_FIELD                 (_MK_MASK_CONST(0x1) << VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_RANGE                 0:0
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_WOFFSET                       0x0
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_VIP                   _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_HOST                  _MK_ENUM_CONST(1)

// Output Vertical Size Select  Selects between the first and second memory output
//  frame heights for the numerator in the downscaling
//  ratio.  Uses FIRST_FRAME_HEIGHT or
//  SECOND_FRAME_HEIGHT.
//  This is effective
//  only when V_AVERAGING is DISABLED and
//  V_DOWNSCALING is ENABLED.
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_SHIFT                        _MK_SHIFT_CONST(1)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_FIELD                        (_MK_MASK_CONST(0x1) << VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_RANGE                        1:1
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_WOFFSET                      0x0
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_FIRST                        _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_OUTPUT_V_SIZE_SEL_SECOND                       _MK_ENUM_CONST(1)

//  Selects input vertical size into scalers (extension field)
//  00= Vert. size selected with INPUT_V_SIZE_SEL field (backward compatible)
//  01= Vert. size of CSI_PPA is provided by CSI_PPA_V_ACTIVE register
//  10= Vert. size of CSI_PPB is provided by CSI_PPB_V_ACTIVE register
//  11= Vert. size of ISP     is provided by ISP_V_ACTIVE     register
// 7:4 reserved
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_SHIFT                     _MK_SHIFT_CONST(2)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_FIELD                     (_MK_MASK_CONST(0x3) << VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_RANGE                     3:2
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_WOFFSET                   0x0
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_USE_INPUT_V_SIZE_SEL                      _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_CSI_PPA                   _MK_ENUM_CONST(1)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_CSI_PPB                   _MK_ENUM_CONST(2)
#define VI_V_DOWNSCALE_CONTROL_0_INPUT_V_SIZE_SEL_EXT_ISP                       _MK_ENUM_CONST(3)

// Vertical Averaging Control  This specifies the number of lines to
//  average and to decimate vertically.
//   000= 2-line averaging and 1/2 down-scaling
//   001= 4-line averaging and 1/3 down-scaling
//   010= 4-line averaging and 1/4 down-scaling
//   011= 8-line averaging and 1/7 down-scaling
//   100= 8-line averaging and 1/8 down-scaling
//   other= reserved
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_FIELD                    (_MK_MASK_CONST(0x7) << VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_RANGE                    10:8
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_WOFFSET                  0x0
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_A2D2                     _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_A4D3                     _MK_ENUM_CONST(1)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_A4D4                     _MK_ENUM_CONST(2)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_A8D7                     _MK_ENUM_CONST(3)
#define VI_V_DOWNSCALE_CONTROL_0_V_AVG_CONTROL_A8D8                     _MK_ENUM_CONST(4)

// Flexible Vertical Scaling   0 = disabled, V_AVG_CONTROL specifies both
//       vertical averaging and down-scaling
//       factor.
//   1 = enabled, fixed 2-line averaging with
//       vertical downscaling controlled by
//       V_DOWN_N and V_DOWN_D.
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_SHIFT                  _MK_SHIFT_CONST(12)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_FIELD                  (_MK_MASK_CONST(0x1) << VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_RANGE                  12:12
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_WOFFSET                        0x0
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_FLEXIBLE_VSCALE_ENABLED                        _MK_ENUM_CONST(1)

// Multi-Tap Vertical Averaging Filter   0 = disabled
//   1 = enabled
//  This will enable the Multi-Tap filtering
//  when the Vertical Averaging is enabled.
//  The filter settings will depend on the
//  V_AVG_CONTROL value.
//  000 - 3 Taps (1,2,1)/4
//  001 - 5 Taps (1,2,2,2,1)/8
//  010 - 6 Taps (1,1,2,2,1,1)/8
//  011 - 11 Taps (1,1,1,2,2,2,2,2,1,1,1)/16
//  100 - 12 Taps (1,1,1,1,2,2,2,2,1,1,1,1)/16
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_SHIFT                   _MK_SHIFT_CONST(13)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_FIELD                   (_MK_MASK_CONST(0x1) << VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_RANGE                   13:13
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_WOFFSET                 0x0
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_DISABLED                        _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_MULTI_TAP_V_AVG_FILTER_ENABLED                 _MK_ENUM_CONST(1)

// Vertical Decimation Accumulator Initial Value
//  The user may initialized the V-Dec accumulator with
//  a value between 0-(V_ACTIVE_PERIOD) to change the phase
//  of the decimation pattern.  This will allow the user
//  to decide which is the first line to keep.
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_FIELD                   (_MK_MASK_CONST(0x1fff) << VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_RANGE                   28:16
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_WOFFSET                 0x0
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1fff)
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_V_DEC_INIT_VAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Specifies whether odd/even field affects vertical  decimation.
//   0 = disabled - odd/even field affects the vertical downscaling
//   1 = enabled - field is ignored in vertical downscaling
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_SHIFT                     _MK_SHIFT_CONST(28)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_FIELD                     (_MK_MASK_CONST(0x1) << VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_SHIFT)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_RANGE                     28:28
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_WOFFSET                   0x0
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_DISABLED                  _MK_ENUM_CONST(0)
#define VI_V_DOWNSCALE_CONTROL_0_IGNORE_FIELD_ENABLED                   _MK_ENUM_CONST(1)

// Color Space Conversion coefficients.
// The CSC can be used for YUV to RGB conversion with brightness and hue/saturation control.
// For Y color, the Y offset is applied first and saturation (clipping) is performed
//   immediately after the Y offset is applied.
//   R = sat(KYRGB * sat(Y + YOF) + KUR * U + KVR * V)
//   G = sat(KYRGB * sat(Y + YOF) + KUG * U + KVG * V)
//   B = sat(KYRGB * sat(Y + YOF) + KUB * U + KVB * V)
// Saturation and rounding is performed in the range of 0 to 255 for the above equations.
//
// Typical values are:
//   YOF = -16.000, KYRGB =  1.1644
//   KUR =  0.0000, KVR   = -1.5960
//   KUG = -0.3918, KVG   = -0.8130
//   KUB =  2.0172, KVB   =  0.0000
//   KUR and KVB are typically 0.0000 but they may be programmed non-zero for hue rotation.
//
// The CSC can also take RGB input, in which case YOF, KVB, KUG, KUR should be programmed to 0
//   and KYRGB will be forced to 0 by the hardware for generating R and B. KYRGB will not be
//   forced to 0 for generating G. KVR, KYRGB, and KUB can be programmed to 1.0 or used as
//   gain control for R, G, B correspondingly.
// Note that color value ranges from 0 to 255 for Y, R, G, B and -128 to 127 for U and V.

// Register VI_CSC_Y_0  // CSC Y Offset and Gain
#define VI_CSC_Y_0                      _MK_ADDR_CONST(0x45)
#define VI_CSC_Y_0_SECURE                       0x0
#define VI_CSC_Y_0_WORD_COUNT                   0x1
#define VI_CSC_Y_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_READ_MASK                    _MK_MASK_CONST(0x3ff00ff)
#define VI_CSC_Y_0_WRITE_MASK                   _MK_MASK_CONST(0x3ff00ff)
// Y Offset in s.7.0 format
#define VI_CSC_Y_0_YOF_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_CSC_Y_0_YOF_FIELD                    (_MK_MASK_CONST(0xff) << VI_CSC_Y_0_YOF_SHIFT)
#define VI_CSC_Y_0_YOF_RANGE                    7:0
#define VI_CSC_Y_0_YOF_WOFFSET                  0x0
#define VI_CSC_Y_0_YOF_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_YOF_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_YOF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_YOF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Y Gain for R, G, B colors in 2.8 format
#define VI_CSC_Y_0_KYRGB_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_CSC_Y_0_KYRGB_FIELD                  (_MK_MASK_CONST(0x3ff) << VI_CSC_Y_0_KYRGB_SHIFT)
#define VI_CSC_Y_0_KYRGB_RANGE                  25:16
#define VI_CSC_Y_0_KYRGB_WOFFSET                        0x0
#define VI_CSC_Y_0_KYRGB_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_KYRGB_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_KYRGB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CSC_Y_0_KYRGB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_CSC_UV_R_0  // CSC U & V coefficent for R
#define VI_CSC_UV_R_0                   _MK_ADDR_CONST(0x46)
#define VI_CSC_UV_R_0_SECURE                    0x0
#define VI_CSC_UV_R_0_WORD_COUNT                        0x1
#define VI_CSC_UV_R_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_READ_MASK                         _MK_MASK_CONST(0x7ff07ff)
#define VI_CSC_UV_R_0_WRITE_MASK                        _MK_MASK_CONST(0x7ff07ff)
// U coefficients for R in s.2.8 format
#define VI_CSC_UV_R_0_KUR_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CSC_UV_R_0_KUR_FIELD                 (_MK_MASK_CONST(0x7ff) << VI_CSC_UV_R_0_KUR_SHIFT)
#define VI_CSC_UV_R_0_KUR_RANGE                 10:0
#define VI_CSC_UV_R_0_KUR_WOFFSET                       0x0
#define VI_CSC_UV_R_0_KUR_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_KUR_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_KUR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_KUR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// V coefficients for R in s.2.8 format
#define VI_CSC_UV_R_0_KVR_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_CSC_UV_R_0_KVR_FIELD                 (_MK_MASK_CONST(0x7ff) << VI_CSC_UV_R_0_KVR_SHIFT)
#define VI_CSC_UV_R_0_KVR_RANGE                 26:16
#define VI_CSC_UV_R_0_KVR_WOFFSET                       0x0
#define VI_CSC_UV_R_0_KVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_KVR_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_KVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_R_0_KVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_CSC_UV_G_0  // CSC U & V coefficent for G
#define VI_CSC_UV_G_0                   _MK_ADDR_CONST(0x47)
#define VI_CSC_UV_G_0_SECURE                    0x0
#define VI_CSC_UV_G_0_WORD_COUNT                        0x1
#define VI_CSC_UV_G_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_READ_MASK                         _MK_MASK_CONST(0x3ff03ff)
#define VI_CSC_UV_G_0_WRITE_MASK                        _MK_MASK_CONST(0x3ff03ff)
// U coefficients for G in s.1.8 format
#define VI_CSC_UV_G_0_KUG_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CSC_UV_G_0_KUG_FIELD                 (_MK_MASK_CONST(0x3ff) << VI_CSC_UV_G_0_KUG_SHIFT)
#define VI_CSC_UV_G_0_KUG_RANGE                 9:0
#define VI_CSC_UV_G_0_KUG_WOFFSET                       0x0
#define VI_CSC_UV_G_0_KUG_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_KUG_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_KUG_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_KUG_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// V coefficients for G in s.1.8 format
#define VI_CSC_UV_G_0_KVG_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_CSC_UV_G_0_KVG_FIELD                 (_MK_MASK_CONST(0x3ff) << VI_CSC_UV_G_0_KVG_SHIFT)
#define VI_CSC_UV_G_0_KVG_RANGE                 25:16
#define VI_CSC_UV_G_0_KVG_WOFFSET                       0x0
#define VI_CSC_UV_G_0_KVG_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_KVG_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_KVG_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_G_0_KVG_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_CSC_UV_B_0  // CSC U & V coefficent for B
#define VI_CSC_UV_B_0                   _MK_ADDR_CONST(0x48)
#define VI_CSC_UV_B_0_SECURE                    0x0
#define VI_CSC_UV_B_0_WORD_COUNT                        0x1
#define VI_CSC_UV_B_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_READ_MASK                         _MK_MASK_CONST(0x7ff07ff)
#define VI_CSC_UV_B_0_WRITE_MASK                        _MK_MASK_CONST(0x7ff07ff)
// U coefficients for B in s.2.8 format
#define VI_CSC_UV_B_0_KUB_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_CSC_UV_B_0_KUB_FIELD                 (_MK_MASK_CONST(0x7ff) << VI_CSC_UV_B_0_KUB_SHIFT)
#define VI_CSC_UV_B_0_KUB_RANGE                 10:0
#define VI_CSC_UV_B_0_KUB_WOFFSET                       0x0
#define VI_CSC_UV_B_0_KUB_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_KUB_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_KUB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_KUB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// V coefficients for B in s.2.8 format
#define VI_CSC_UV_B_0_KVB_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_CSC_UV_B_0_KVB_FIELD                 (_MK_MASK_CONST(0x7ff) << VI_CSC_UV_B_0_KVB_SHIFT)
#define VI_CSC_UV_B_0_KVB_RANGE                 26:16
#define VI_CSC_UV_B_0_KVB_WOFFSET                       0x0
#define VI_CSC_UV_B_0_KVB_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_KVB_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_KVB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSC_UV_B_0_KVB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_CSC_ALPHA_0  // RGB Color Space Converter Alpha value
#define VI_CSC_ALPHA_0                  _MK_ADDR_CONST(0x49)
#define VI_CSC_ALPHA_0_SECURE                   0x0
#define VI_CSC_ALPHA_0_WORD_COUNT                       0x1
#define VI_CSC_ALPHA_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_CSC_ALPHA_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define VI_CSC_ALPHA_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_CSC_ALPHA_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSC_ALPHA_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define VI_CSC_ALPHA_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// When output format to memory is selected
//  for RGB888, the pixel data is 32-bit aligned
//  The value programmed here will be appended to the
//  RGB888 data as the 8 MSBs and can be used as an
//  alpha value.
#define VI_CSC_ALPHA_0_RGB888_ALPHA_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_CSC_ALPHA_0_RGB888_ALPHA_FIELD                       (_MK_MASK_CONST(0xff) << VI_CSC_ALPHA_0_RGB888_ALPHA_SHIFT)
#define VI_CSC_ALPHA_0_RGB888_ALPHA_RANGE                       7:0
#define VI_CSC_ALPHA_0_RGB888_ALPHA_WOFFSET                     0x0
#define VI_CSC_ALPHA_0_RGB888_ALPHA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CSC_ALPHA_0_RGB888_ALPHA_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define VI_CSC_ALPHA_0_RGB888_ALPHA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CSC_ALPHA_0_RGB888_ALPHA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register VI_HOST_VSYNC_0  // Valid when INPUT_SOURCE is HOST
#define VI_HOST_VSYNC_0                 _MK_ADDR_CONST(0x4a)
#define VI_HOST_VSYNC_0_SECURE                  0x0
#define VI_HOST_VSYNC_0_WORD_COUNT                      0x1
#define VI_HOST_VSYNC_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define VI_HOST_VSYNC_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// This triggers VI's internal VSYNC generation
// Always write once to this register with '1'
// before writing the Frame's data to Y_FIFO_DATA
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_FIELD                        (_MK_MASK_CONST(0x1) << VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_SHIFT)
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_RANGE                        0:0
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_WOFFSET                      0x0
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_HOST_VSYNC_0_HOST_VSYNC_TRIGGER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// **** This eventually needs to be moved to command buffer interface.
// This register is used initialize VI module when INPUT_SOURCE is HOST.
// **** This register has a dual use purpose.  Host input VSYNC is created by
// writing to this register.

// Register VI_COMMAND_0  // VI Command
#define VI_COMMAND_0                    _MK_ADDR_CONST(0x4b)
#define VI_COMMAND_0_SECURE                     0x0
#define VI_COMMAND_0_WORD_COUNT                         0x1
#define VI_COMMAND_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_RESET_MASK                         _MK_MASK_CONST(0x1)
#define VI_COMMAND_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_READ_MASK                  _MK_MASK_CONST(0x1fff0f01)
#define VI_COMMAND_0_WRITE_MASK                         _MK_MASK_CONST(0x1fff0f01)
// Process Odd/Even field  (effective when INPUT_SOURCE is HOST)
//  Writing to this bit will initialize VI
//  to receive one field of video.
//   0= odd field
//   1= even field
#define VI_COMMAND_0_PROCESS_FIELD_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_COMMAND_0_PROCESS_FIELD_FIELD                        (_MK_MASK_CONST(0x1) << VI_COMMAND_0_PROCESS_FIELD_SHIFT)
#define VI_COMMAND_0_PROCESS_FIELD_RANGE                        0:0
#define VI_COMMAND_0_PROCESS_FIELD_WOFFSET                      0x0
#define VI_COMMAND_0_PROCESS_FIELD_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_PROCESS_FIELD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_COMMAND_0_PROCESS_FIELD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_PROCESS_FIELD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_PROCESS_FIELD_ODD                  _MK_ENUM_CONST(0)
#define VI_COMMAND_0_PROCESS_FIELD_EVEN                 _MK_ENUM_CONST(1)

// Y-FIFO Threshold
//  This specifies maximum number of filled
//  locations in Y-FIFO for the Y-FIFO Threshold
//  Status bit.
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_FIELD                     (_MK_MASK_CONST(0xf) << VI_COMMAND_0_Y_FIFO_THRESHOLD_SHIFT)
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_RANGE                     11:8
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_WOFFSET                   0x0
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_Y_FIFO_THRESHOLD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Vertical Counter Threshold
//  This specifies a threshold which, when
//  exceeded, would generate the vertical
//  counter interrupt if the interrupt is
//  enabled. This is used to detect the case
//  when the host is sending too many input data
//  than expected by VI module.
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_FIELD                  (_MK_MASK_CONST(0x1fff) << VI_COMMAND_0_V_COUNTER_THRESHOLD_SHIFT)
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_RANGE                  28:16
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_WOFFSET                        0x0
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_COMMAND_0_V_COUNTER_THRESHOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// **** This is not needed if host input video goes through command buffer interface.

// Register VI_HOST_FIFO_STATUS_0  // Host FIFO status
#define VI_HOST_FIFO_STATUS_0                   _MK_ADDR_CONST(0x4c)
#define VI_HOST_FIFO_STATUS_0_SECURE                    0x0
#define VI_HOST_FIFO_STATUS_0_WORD_COUNT                        0x1
#define VI_HOST_FIFO_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_READ_MASK                         _MK_MASK_CONST(0x770f)
#define VI_HOST_FIFO_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// This indicates the number of filled locations
//  in Y-FIFO. If the returned value is 4'h0, the
//  fifo is empty and if the returned value is
//  4'hF then the fifo is full.
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_FIELD                       (_MK_MASK_CONST(0xf) << VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_SHIFT)
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_RANGE                       3:0
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_WOFFSET                     0x0
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_Y_FIFO_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// This indicates the number of filled locations
//  in U-FIFO. If the returned value is 3'h0, the
//  fifo is empty and if the returned value is
//  3'h7 then the fifo is full.
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_SHIFT                       _MK_SHIFT_CONST(8)
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_FIELD                       (_MK_MASK_CONST(0x7) << VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_SHIFT)
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_RANGE                       10:8
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_WOFFSET                     0x0
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_U_FIFO_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// This indicates the number of filled locations
//  in V-FIFO. If the returned value is 3'h0, the
//  fifo is empty and if the returned value is
//  3'h7 then the fifo is full.
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_SHIFT                       _MK_SHIFT_CONST(12)
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_FIELD                       (_MK_MASK_CONST(0x7) << VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_SHIFT)
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_RANGE                       14:12
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_WOFFSET                     0x0
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_HOST_FIFO_STATUS_0_V_FIFO_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register VI_INTERRUPT_MASK_0  // Interrupt Mask
#define VI_INTERRUPT_MASK_0                     _MK_ADDR_CONST(0x4d)
#define VI_INTERRUPT_MASK_0_SECURE                      0x0
#define VI_INTERRUPT_MASK_0_WORD_COUNT                  0x1
#define VI_INTERRUPT_MASK_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RESET_MASK                  _MK_MASK_CONST(0x1fefffff)
#define VI_INTERRUPT_MASK_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_READ_MASK                   _MK_MASK_CONST(0x1fefffff)
#define VI_INTERRUPT_MASK_0_WRITE_MASK                  _MK_MASK_CONST(0x1fefffff)
// VD8 pin Interrupt Mask  This bit controls interrupt when VD8
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VD8_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_RANGE                  0:0
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VD8_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// VD9 pin Interrupt Mask  This bit controls interrupt when VD9
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_SHIFT                  _MK_SHIFT_CONST(1)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VD9_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_RANGE                  1:1
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VD9_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// VD10 pin Interrupt Mask  This bit controls interrupt when VD10
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_SHIFT                 _MK_SHIFT_CONST(2)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VD10_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_RANGE                 2:2
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_WOFFSET                       0x0
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VD10_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// VD11 pin Interrupt Mask  This bit controls interrupt when VD11
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_SHIFT                 _MK_SHIFT_CONST(3)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VD11_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_RANGE                 3:3
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_WOFFSET                       0x0
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VD11_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// VGP4 pin Interrupt Mask  This bit controls interrupt when VGP4
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_SHIFT                 _MK_SHIFT_CONST(4)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VGP4_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_RANGE                 4:4
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_WOFFSET                       0x0
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VGP4_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// VGP5 pin Interrupt Mask  This bit controls interrupt when VGP5
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_SHIFT                 _MK_SHIFT_CONST(5)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VGP5_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_RANGE                 5:5
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_WOFFSET                       0x0
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VGP5_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// VGP6 pin Interrupt Mask  This bit controls interrupt when VGP6
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_SHIFT                 _MK_SHIFT_CONST(6)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VGP6_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_RANGE                 6:6
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_WOFFSET                       0x0
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VGP6_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// VHS pin Interrupt Mask  This bit controls interrupt when VHS
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_SHIFT                  _MK_SHIFT_CONST(7)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VHS_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_RANGE                  7:7
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VHS_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// VVS pin Interrupt Mask  This bit controls interrupt when VVS
//  rising/falling edge is detected.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_SHIFT                  _MK_SHIFT_CONST(8)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_VVS_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_RANGE                  8:8
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_VVS_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// Vertical Counter Interrupt Mask  (effective when VIDEO_SOURCE is HOST)
//  This bit controls interrupt when the
//  vertical counter threshold is reached.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_SHIFT                    _MK_SHIFT_CONST(9)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_RANGE                    9:9
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_WOFFSET                  0x0
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_V_COUNTER_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Y-FIFO Threshold Interrupt Mask  This bit controls interrupt when the number
//  of filled locations in Y-FIFO is equal or
//  greater than the Y_FIFO_THRESHOLD value.
//  This bit should be set to 1 only when
//  INPUT_SOURCE is HOST.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_SHIFT                  _MK_SHIFT_CONST(10)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_RANGE                  10:10
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_Y_THRESHOLD_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// Buffer Done First Output Interrupt Mask  This bit controls interrupt when the
//  First Output to memory has written
//  a buffer to memory.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_SHIFT                  _MK_SHIFT_CONST(11)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_RANGE                  11:11
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_BUFFER_FIRST_OUTPUT_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// Frame Done First Output Interrupt Mask  This bit controls interrupt when the
//  First Output to memory has written
//  a frame to memory.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_SHIFT                   _MK_SHIFT_CONST(12)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_RANGE                   12:12
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_WOFFSET                 0x0
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_FRAME_FIRST_OUTPUT_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Buffer Done Second Output Interrupt Mask  This bit controls interrupt when the
//  Second Output to memory has written
//  a buffer to memory.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_SHIFT                 _MK_SHIFT_CONST(13)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_RANGE                 13:13
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_WOFFSET                       0x0
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_BUFFER_SECOND_OUTPUT_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Buffer Done Second Output Interrupt Mask  This bit controls interrupt when the
//  Second Output to memory has written
//  a frame to memory.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_SHIFT                  _MK_SHIFT_CONST(14)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_RANGE                  14:14
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_WOFFSET                        0x0
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_FRAME_SECOND_OUTPUT_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// VI to EPP Error Interrupt Mask  This bit controls interrupt when the
//  VI drops data to the EPP because the
//  EPP is stalling the vi2epp bus and
//  data is coming from the pins
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(15)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_RANGE                    15:15
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_WOFFSET                  0x0
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_EPP_ERROR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// YUV420PA Error Interrupt Mask  This bit controls interrupt when the
//  VI does not average data because the
//  line buffer data is not ready from the
//  memory controller.  The VI will write
//  unaveraged data and will write the U,V
//  data from the even line in such cases.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_SHIFT                       _MK_SHIFT_CONST(16)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_RANGE                       16:16
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_WOFFSET                     0x0
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_YUV420PA_ERROR_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// VI to Peer stall - First Memory Output  This bit controls interrupt when the
//  VI drops peer bus packet(s) because the
//  peer is stalling the first output peer
//  bus and data is coming from the pins
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_SHIFT                      _MK_SHIFT_CONST(17)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_RANGE                      17:17
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_WOFFSET                    0x0
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_DISABLED                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_PEER_STALL_INT_MASK_ENABLED                    _MK_ENUM_CONST(1)

// VI to Peer stall - Second Memory Output  This bit controls interrupt when the
//  VI drops peer bus packet(s) because the
//  peer is stalling the second output peer
//  bus and data is coming from the pins
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_SHIFT                     _MK_SHIFT_CONST(18)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_RANGE                     18:18
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_WOFFSET                   0x0
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_PEER_STALL_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Write Buffer DMA to VI Stalls VI and causes an error  This bit controls interrupt when the
//  VI drops raw 8-bit stream data because
//  the Write Buffer DMA is stalling.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_SHIFT                    _MK_SHIFT_CONST(19)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_RANGE                    19:19
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_WOFFSET                  0x0
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_DMA_STALL_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Stream 1 raise  This bit controls interrupt when the
//  the Stream 1 Raise is enabled and
//  returned
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_SHIFT                       _MK_SHIFT_CONST(21)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_RANGE                       21:21
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_WOFFSET                     0x0
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_1_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// Stream 2 raise  This bit controls interrupt when the
//  the Stream 2 Raise is enabled and
//  returned
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_SHIFT                       _MK_SHIFT_CONST(22)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_RANGE                       22:22
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_WOFFSET                     0x0
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_RAISE_STREAM_2_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// This bit controls interrupt when the
//  ISDB-T vi input gets an upstream error.
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(23)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_RANGE                    23:23
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_WOFFSET                  0x0
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_TS_UPSTREAM_ERROR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// This bit controls interrupt when the
//  ISDB-T input get an underrun error
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(24)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_RANGE                    24:24
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_WOFFSET                  0x0
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_TS_UNDERRUN_ERROR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// This bit controls interrupt when the
//  ISDB-T input get an overrun error
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(25)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_RANGE                     25:25
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_WOFFSET                   0x0
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_TS_OVERRUN_ERROR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// This bit controls interrupt when the
//  ISDB-T input get a packet which means
//  FEC+BODY in totalsize but FEC and BODY
//  do not match FEC_SIZE and BODY_SIZE
//   0= Disabled
//   1= Enabled
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_SHIFT                      _MK_SHIFT_CONST(26)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_RANGE                      26:26
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_WOFFSET                    0x0
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_DISABLED                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_TS_OTHER_PROTOCOL_ERROR_INT_MASK_ENABLED                    _MK_ENUM_CONST(1)

// This bit controls interrupt when VI drops
// data to MC.
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_SHIFT                    _MK_SHIFT_CONST(27)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_RANGE                    27:27
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_WOFFSET                  0x0
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_FIRST_OUTPUT_DROP_MC_DATA_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// This bit controls interrupt when VI drops
// data to MC.
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_SHIFT                   _MK_SHIFT_CONST(28)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_SHIFT)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_RANGE                   28:28
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_WOFFSET                 0x0
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)
#define VI_INTERRUPT_MASK_0_SECOND_OUTPUT_DROP_MC_DATA_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)


// Register VI_INTERRUPT_TYPE_SELECT_0  // Interrupt Type Select
#define VI_INTERRUPT_TYPE_SELECT_0                      _MK_ADDR_CONST(0x4e)
#define VI_INTERRUPT_TYPE_SELECT_0_SECURE                       0x0
#define VI_INTERRUPT_TYPE_SELECT_0_WORD_COUNT                   0x1
#define VI_INTERRUPT_TYPE_SELECT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_RESET_MASK                   _MK_MASK_CONST(0x1ff)
#define VI_INTERRUPT_TYPE_SELECT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_READ_MASK                    _MK_MASK_CONST(0x1ff)
#define VI_INTERRUPT_TYPE_SELECT_0_WRITE_MASK                   _MK_MASK_CONST(0x1ff)
// VD8 pin Interrupt Type  This bit controls interrupt VD8
//  if edge or level type
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_RANGE                   0:0
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_WOFFSET                 0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD8_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)

// VD9 pin Interrupt Type  This bit controls interrupt VD9
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(1)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_RANGE                   1:1
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_WOFFSET                 0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD9_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)

// VD10 pin Interrupt Type  This bit controls interrupt VD10
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_SHIFT                  _MK_SHIFT_CONST(2)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_RANGE                  2:2
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_WOFFSET                        0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_EDGE                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD10_INT_TYPE_LEVEL                  _MK_ENUM_CONST(1)

// VD11 pin Interrupt Type  This bit controls interrupt VD11
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_SHIFT                  _MK_SHIFT_CONST(3)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_RANGE                  3:3
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_WOFFSET                        0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_EDGE                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VD11_INT_TYPE_LEVEL                  _MK_ENUM_CONST(1)

// VGP4 pin Interrupt Type  This bit controls interrupt VGP4
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_SHIFT                  _MK_SHIFT_CONST(4)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_RANGE                  4:4
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_WOFFSET                        0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_EDGE                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP4_INT_TYPE_LEVEL                  _MK_ENUM_CONST(1)

// VGP5 pin Interrupt Type  This bit controls interrupt VGP5
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_SHIFT                  _MK_SHIFT_CONST(5)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_RANGE                  5:5
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_WOFFSET                        0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_EDGE                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP5_INT_TYPE_LEVEL                  _MK_ENUM_CONST(1)

// VGP6 pin Interrupt Type  This bit controls interrupt VGP6
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_SHIFT                  _MK_SHIFT_CONST(6)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_RANGE                  6:6
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_WOFFSET                        0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_EDGE                   _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VGP6_INT_TYPE_LEVEL                  _MK_ENUM_CONST(1)

// VHS pin Interrupt Type  This bit controls interrupt VHS
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(7)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_RANGE                   7:7
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_WOFFSET                 0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VHS_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)

// VVS pin Interrupt Type  This bit controls interrupt VVS
//   0= Edge type
//   1= Level type
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_SHIFT)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_RANGE                   8:8
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_WOFFSET                 0x0
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_TYPE_SELECT_0_VVS_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)


// Register VI_INTERRUPT_POLARITY_SELECT_0  // Interrupt Polarity Select
#define VI_INTERRUPT_POLARITY_SELECT_0                  _MK_ADDR_CONST(0x4f)
#define VI_INTERRUPT_POLARITY_SELECT_0_SECURE                   0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_WORD_COUNT                       0x1
#define VI_INTERRUPT_POLARITY_SELECT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_RESET_MASK                       _MK_MASK_CONST(0x1ff)
#define VI_INTERRUPT_POLARITY_SELECT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_READ_MASK                        _MK_MASK_CONST(0x1ff)
#define VI_INTERRUPT_POLARITY_SELECT_0_WRITE_MASK                       _MK_MASK_CONST(0x1ff)
// VD8 pin Interrupt Type  This bit controls interrupt VD8
//  if edge or level type
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_RANGE                   0:0
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_WOFFSET                 0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD8_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// VD9 pin Interrupt Type  This bit controls interrupt VD9
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_RANGE                   1:1
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_WOFFSET                 0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD9_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// VD10 pin Interrupt Type  This bit controls interrupt VD10
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(2)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_RANGE                  2:2
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_WOFFSET                        0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD10_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// VD11 pin Interrupt Type  This bit controls interrupt VD11
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(3)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_RANGE                  3:3
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_WOFFSET                        0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VD11_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// VGP4 pin Interrupt Type  This bit controls interrupt VGP4
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(4)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_RANGE                  4:4
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_WOFFSET                        0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP4_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// VGP5 pin Interrupt Type  This bit controls interrupt VGP5
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(5)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_RANGE                  5:5
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_WOFFSET                        0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP5_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// VGP6 pin Interrupt Type  This bit controls interrupt VGP6
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(6)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_RANGE                  6:6
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_WOFFSET                        0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VGP6_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// VHS pin Interrupt Type  This bit controls interrupt VHS
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(7)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_RANGE                   7:7
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_WOFFSET                 0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VHS_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// VVS pin Interrupt Type  This bit controls interrupt VVS
//   0= falling edge or low level
//   1= rising edge or high level
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_SHIFT)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_RANGE                   8:8
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_WOFFSET                 0x0
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_POLARITY_SELECT_0_VVS_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// This register returns interrupt status when read. Except for bits 15-14, when this register
// is written, the interrupt status corresponding to the bits written with 1 will be reset.
// Interrupt status corresponding to the bits written with 0 will be left unchanged.
// **** The following disclaimer is from SCx - not sure why they're needed ... interrupt should
//      not be generated when the corresponding interrupt enable bit is disabled.
// Note that interrupt status bits can be set even when their corresponding interrupt enable
// bits, in VI10R, are cleared. When these bits are set and their corresponding interrupt
// enable bits are set, an interrupt is generated. The interrupt can be cleared, or left
// unchanged, by writing 1, or 0, respectively to the corresponding bits in this register.
// Clearing the interrupt status bits does not affect the interrupt enable bits.

// Register VI_INTERRUPT_STATUS_0  // Interrupt Enable
#define VI_INTERRUPT_STATUS_0                   _MK_ADDR_CONST(0x50)
#define VI_INTERRUPT_STATUS_0_SECURE                    0x0
#define VI_INTERRUPT_STATUS_0_WORD_COUNT                        0x1
#define VI_INTERRUPT_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_READ_MASK                         _MK_MASK_CONST(0x1fffffff)
#define VI_INTERRUPT_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// VD8 pin Interrupt Status  This bit controls interrupt when VD8
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_RANGE                      0:0
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VD8_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// VD9 pin Interrupt Status  This bit controls interrupt when VD9
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(1)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_RANGE                      1:1
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VD9_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// VD10 pin Interrupt Status  This bit controls interrupt when VD10
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_SHIFT                     _MK_SHIFT_CONST(2)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_RANGE                     2:2
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_WOFFSET                   0x0
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_NOINTR                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VD10_INT_STATUS_INTR                      _MK_ENUM_CONST(1)

// VD11 pin Interrupt Status  This bit controls interrupt when VD11
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_SHIFT                     _MK_SHIFT_CONST(3)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_RANGE                     3:3
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_WOFFSET                   0x0
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_NOINTR                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VD11_INT_STATUS_INTR                      _MK_ENUM_CONST(1)

// VGP4 pin Interrupt Status  This bit controls interrupt when VGP4
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_RANGE                     4:4
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_WOFFSET                   0x0
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_NOINTR                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VGP4_INT_STATUS_INTR                      _MK_ENUM_CONST(1)

// VGP5 pin Interrupt Status  This bit controls interrupt when VGP5
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_SHIFT                     _MK_SHIFT_CONST(5)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_RANGE                     5:5
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_WOFFSET                   0x0
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_NOINTR                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VGP5_INT_STATUS_INTR                      _MK_ENUM_CONST(1)

// VGP6 pin Interrupt Status  This bit controls interrupt when VGP6
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_SHIFT                     _MK_SHIFT_CONST(6)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_RANGE                     6:6
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_WOFFSET                   0x0
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_NOINTR                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VGP6_INT_STATUS_INTR                      _MK_ENUM_CONST(1)

// VHS pin Interrupt Status  This bit controls interrupt when VHS
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(7)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_RANGE                      7:7
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VHS_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// VVS pin Interrupt Status  This bit controls interrupt when VVS
//  rising/falling edge is detected.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(8)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_RANGE                      8:8
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_VVS_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// Vertical Counter Interrupt Status  (effective when VIDEO_SOURCE is HOST)
//  This bit controls interrupt when the
//  vertical counter threshold is reached.
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_SHIFT                        _MK_SHIFT_CONST(9)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_RANGE                        9:9
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_NOINTR                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_V_COUNTER_INT_STATUS_INTR                 _MK_ENUM_CONST(1)

// Y-FIFO Threshold Interrupt Enable  This bit controls interrupt when the number
//  of filled locations in Y-FIFO is equal or
//  greater than the Y_FIFO_THRESHOLD value.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(10)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_RANGE                      10:10
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_Y_THRESHOLD_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// Buffer Done First Output Interrupt Status  This bit is set when a buffer has been
//  written to memory by the first output.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(11)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_RANGE                      11:11
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_BUFFER_FIRST_OUTPUT_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// Frame Done First Output Interrupt Status  This bit is set when a frame has been
//  written to memory by the first output.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_SHIFT                       _MK_SHIFT_CONST(12)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_FIELD                       (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_RANGE                       12:12
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_WOFFSET                     0x0
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_NOINTR                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_FRAME_FIRST_OUTPUT_INT_STATUS_INTR                        _MK_ENUM_CONST(1)

// Buffer Done Second Output Interrupt Status  This bit is set when a buffer has been
//  written to memory by the second output.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_SHIFT                     _MK_SHIFT_CONST(13)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_RANGE                     13:13
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_WOFFSET                   0x0
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_NOINTR                    _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_BUFFER_SECOND_OUTPUT_INT_STATUS_INTR                      _MK_ENUM_CONST(1)

// Frame Done Second Output Interrupt Status  This bit is set when a frame has been
//  written to memory by the second output.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(14)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_RANGE                      14:14
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_WOFFSET                    0x0
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_NOINTR                     _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_FRAME_SECOND_OUTPUT_INT_STATUS_INTR                       _MK_ENUM_CONST(1)

// VI to EPP Error Interrupt Enable  This bit controls interrupt when the
//  VI drops data to the EPP because the
//  EPP is stalling the vi2epp bus and
//  data is coming from the pins
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_SHIFT                        _MK_SHIFT_CONST(15)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_RANGE                        15:15
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_NOINTR                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_EPP_ERROR_INT_STATUS_INTR                 _MK_ENUM_CONST(1)

// YUV420PA Error Interrupt Enable This bit shows the status of if the
//  VI does not average data because the
//  line buffer data is not ready from the
//  memory controller.  The VI will write
//  unaveraged data and will write the U,V
//  data from the even line in such cases.
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_RANGE                   16:16
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_WOFFSET                 0x0
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_NOINTR                  _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_YUV420PA_ERROR_INT_STATUS_INTR                    _MK_ENUM_CONST(1)

// This bit shows the status of if the
//  VI dropped a buffer packet to the
//  peer communicating with the first memory
//  output
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_SHIFT                  _MK_SHIFT_CONST(17)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_RANGE                  17:17
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_WOFFSET                        0x0
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_NOINTR                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_PEER_STALL_INT_STATUS_INTR                   _MK_ENUM_CONST(1)

// This bit shows the status of if the
//  VI dropped a buffer packet to the
//  peer communicating with the second memory
//  output
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_SHIFT                 _MK_SHIFT_CONST(18)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_RANGE                 18:18
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_WOFFSET                       0x0
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_NOINTR                        _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_PEER_STALL_INT_STATUS_INTR                  _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  VI drops data to the Write Buffer DMA
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_SHIFT                        _MK_SHIFT_CONST(19)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_RANGE                        19:19
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_NOINTR                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_DMA_STALL_INT_STATUS_INTR                 _MK_ENUM_CONST(1)

// Top or Bottom Field Status  This bit specifies whether the last received
//  video data field is top field or bottom
//  field as defined by FIELD_TYPE bit. This bit
//  is forced to 0 if FIELD_DETECT is DISABLED
//  when VIDEO_SOURCE is VIP.
//  This bit cannot be reset by software by
//  writing a 1.
//   0= Bottom field received
//   1= Top field received
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_SHIFT                        _MK_SHIFT_CONST(20)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_FIELD_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_RANGE                        20:20
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_BOTTOM                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_FIELD_STATUS_TOP                  _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  Raise Stream 1 returns to the Host
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_SHIFT                   _MK_SHIFT_CONST(21)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_RANGE                   21:21
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_WOFFSET                 0x0
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_NOINTR                  _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_1_INT_STATUS_INTR                    _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  Raise Stream 2 returns to the Host
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_SHIFT                   _MK_SHIFT_CONST(22)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_FIELD                   (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_RANGE                   22:22
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_WOFFSET                 0x0
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_NOINTR                  _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_RAISE_STREAM_2_INT_STATUS_INTR                    _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  ISDB-T vi input gets an upstream error (error from the tuner)
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_SHIFT                        _MK_SHIFT_CONST(23)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_RANGE                        23:23
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_NOINTR                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_TS_UPSTREAM_ERROR_INT_STATUS_INTR                 _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  ISDB-T input get an underrun error (START condition detected
//  prior to receiving a full packet)
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_SHIFT                        _MK_SHIFT_CONST(24)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_RANGE                        24:24
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_NOINTR                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_TS_UNDERRUN_ERROR_INT_STATUS_INTR                 _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  ISDB-T input get an overrun error (more bytes in packet than specified
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_SHIFT                 _MK_SHIFT_CONST(25)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_FIELD                 (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_RANGE                 25:25
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_WOFFSET                       0x0
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_NOINTR                        _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_TS_OVERRUN_ERROR_INT_STATUS_INTR                  _MK_ENUM_CONST(1)

// This bit shows the status of the condition when the
//  ISDB-T input an other protocol error (ex:
//  total packet received is FEC_SIZE+BODY_SIZE but
//  the individual FEC portion != FEC_SIZE and
//  the individual BODY portion != BODY_SIZE
//   0= Interrupt not detected
//   1= Interrupt detected
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_SHIFT                  _MK_SHIFT_CONST(26)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_FIELD                  (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_RANGE                  26:26
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_WOFFSET                        0x0
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_NOINTR                 _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_TS_OTHER_PROTOCOL_ERROR_INT_STATUS_INTR                   _MK_ENUM_CONST(1)

// If FIRST_OUTPUT is dropping data to MC, INTR
//   will be set.
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_SHIFT                        _MK_SHIFT_CONST(27)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_FIELD                        (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_RANGE                        27:27
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_WOFFSET                      0x0
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_NOINTR                       _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_FIRST_OUTPUT_DROP_MC_DATA_INT_STATUS_INTR                 _MK_ENUM_CONST(1)

// If SECOND_OUTPUT is dropping data to MC, INTR
//   will be set.
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_SHIFT                       _MK_SHIFT_CONST(28)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_FIELD                       (_MK_MASK_CONST(0x1) << VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_SHIFT)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_RANGE                       28:28
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_WOFFSET                     0x0
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_NOINTR                      _MK_ENUM_CONST(0)
#define VI_INTERRUPT_STATUS_0_SECOND_OUTPUT_DROP_MC_DATA_INT_STATUS_INTR                        _MK_ENUM_CONST(1)


// Register VI_VIP_INPUT_STATUS_0  // Video Input Port status
#define VI_VIP_INPUT_STATUS_0                   _MK_ADDR_CONST(0x51)
#define VI_VIP_INPUT_STATUS_0_SECURE                    0x0
#define VI_VIP_INPUT_STATUS_0_WORD_COUNT                        0x1
#define VI_VIP_INPUT_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define VI_VIP_INPUT_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// The number of lines received (hsyncs)
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_FIELD                  (_MK_MASK_CONST(0xffff) << VI_VIP_INPUT_STATUS_0_LINE_COUNT_SHIFT)
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_RANGE                  15:0
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_WOFFSET                        0x0
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_LINE_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// The number of frames received (vsyncs)
// Any write to this register, clears.
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_FIELD                 (_MK_MASK_CONST(0xffff) << VI_VIP_INPUT_STATUS_0_FRAME_COUNT_SHIFT)
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_RANGE                 31:16
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_WOFFSET                       0x0
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VIP_INPUT_STATUS_0_FRAME_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_VIDEO_BUFFER_STATUS_0  // Interrupt Enable
#define VI_VIDEO_BUFFER_STATUS_0                        _MK_ADDR_CONST(0x52)
#define VI_VIDEO_BUFFER_STATUS_0_SECURE                         0x0
#define VI_VIDEO_BUFFER_STATUS_0_WORD_COUNT                     0x1
#define VI_VIDEO_BUFFER_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_READ_MASK                      _MK_MASK_CONST(0xfffff)
#define VI_VIDEO_BUFFER_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Buffer status
//  This specifies the buffer number of the
//  the last video data field written to memory
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_FIELD                        (_MK_MASK_CONST(0xff) << VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_SHIFT)
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_RANGE                        7:0
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_WOFFSET                      0x0
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_FIRST_VIDEO_BUFFER_STATUS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Buffer status
//  This specifies the buffer number of the
//  the last video data field written to memory
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_SHIFT                       _MK_SHIFT_CONST(8)
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_FIELD                       (_MK_MASK_CONST(0xff) << VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_SHIFT)
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_RANGE                       15:8
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_WOFFSET                     0x0
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_SECOND_VIDEO_BUFFER_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Write count of the Raw Stream Write FIFO
//  This is the fifo used to synchronize the
//  data coming from pads into the vi clock domain.
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_FIELD                   (_MK_MASK_CONST(0xf) << VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_SHIFT)
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_RANGE                   19:16
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_WOFFSET                 0x0
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VIDEO_BUFFER_STATUS_0_RAW_STREAM_WRITE_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// This register controls VHS and VVS output when H/V syncs are generated internally in the
// VI module (VIDEO_SOURCE is VIP and SYNC_FORMAT is INTHVS).
// The generated VHS and VVS signal can be sent to external video source device and used
// to synchronize the video data transfer from the video source to the VI module. VHS and VVS
// pin should be configured in output mode to output the internally generated H/V syncs.
// Also in this case, the internally generate H/V syncs can be used by the VI module
// as horizontal and vertical reference signals for the incoming video data.

// Register VI_SYNC_OUTPUT_0  // VI H and V sync Output control
#define VI_SYNC_OUTPUT_0                        _MK_ADDR_CONST(0x53)
#define VI_SYNC_OUTPUT_0_SECURE                         0x0
#define VI_SYNC_OUTPUT_0_WORD_COUNT                     0x1
#define VI_SYNC_OUTPUT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define VI_SYNC_OUTPUT_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// This specifies VHS output pulse width in
//  term of number of VI clock cycles.
//  Programmed value is actual value - 1 so
//  valid value ranges from 1 to 8.
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_FIELD                 (_MK_MASK_CONST(0x7) << VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_SHIFT)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_RANGE                 2:0
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_WOFFSET                       0x0
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_WIDTH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This specifies VHS output pulse period in
//  term of number of VI clock cycles.
//  Programmed value is actual value - 1 so
//  valid value ranges from 32 to 8192.
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_SHIFT                        _MK_SHIFT_CONST(3)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_FIELD                        (_MK_MASK_CONST(0x1fff) << VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_SHIFT)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_RANGE                        15:3
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_WOFFSET                      0x0
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VHS_OUTPUT_PERIOD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// This specifies VVS output pulse width in
//  term of number of VHS cycles.
//  Programmed value is actual value - 1 so
//  valid value ranges from 1 to 8.
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_FIELD                 (_MK_MASK_CONST(0x7) << VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_SHIFT)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_RANGE                 18:16
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_WOFFSET                       0x0
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_WIDTH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This specifies VVS output pulse period in
//  term of number of VHS cycles.
//  Programmed value is actual value - 1 so
//  valid value ranges from 2 to 4096.
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_SHIFT                        _MK_SHIFT_CONST(19)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_FIELD                        (_MK_MASK_CONST(0x1fff) << VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_SHIFT)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_RANGE                        31:19
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_WOFFSET                      0x0
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_SYNC_OUTPUT_0_VVS_OUTPUT_PERIOD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_VVS_OUTPUT_DELAY_0  // VI V sync Output Delay
#define VI_VVS_OUTPUT_DELAY_0                   _MK_ADDR_CONST(0x54)
#define VI_VVS_OUTPUT_DELAY_0_SECURE                    0x0
#define VI_VVS_OUTPUT_DELAY_0_WORD_COUNT                        0x1
#define VI_VVS_OUTPUT_DELAY_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_READ_MASK                         _MK_MASK_CONST(0xf)
#define VI_VVS_OUTPUT_DELAY_0_WRITE_MASK                        _MK_MASK_CONST(0xf)
// This specifies the number of VI clock cycles
//  from leading edge of VHS to leading edge of
//  VVS.
//  Programmed value is actual value + 2 so
//  valid value ranges from -2 to 13.
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_FIELD                    (_MK_MASK_CONST(0xf) << VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_SHIFT)
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_RANGE                    3:0
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_WOFFSET                  0x0
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_VVS_OUTPUT_DELAY_0_VVS_OUTPUT_DELAY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// VI Pulse Width Modulation signal generation
// PWM signal generation logic can generate up to 128 pulses per line internally and the PWM
//  pulse select registers determines which of the 128 pulses will be output. Any of the 128
//  internally generated pulse can be independently selected as output if they occur within
//  one line time.
// PWM signal can be output on the VGP6 pin if VGP6 output is enabled and the output select
//  is set to PWM.
// The PWM will be triggered by the first vsync after the PWM_ENABLE bit has been set.

// Register VI_PWM_CONTROL_0  // VI Pulse Width Modulation Control
#define VI_PWM_CONTROL_0                        _MK_ADDR_CONST(0x55)
#define VI_PWM_CONTROL_0_SECURE                         0x0
#define VI_PWM_CONTROL_0_WORD_COUNT                     0x1
#define VI_PWM_CONTROL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_RESET_MASK                     _MK_MASK_CONST(0xff30ff11)
#define VI_PWM_CONTROL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_READ_MASK                      _MK_MASK_CONST(0xff30ff11)
#define VI_PWM_CONTROL_0_WRITE_MASK                     _MK_MASK_CONST(0xff30ff11)
// PWM Enable  0= Disabled
//  1= Enabled
#define VI_PWM_CONTROL_0_PWM_ENABLE_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_PWM_CONTROL_0_PWM_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << VI_PWM_CONTROL_0_PWM_ENABLE_SHIFT)
#define VI_PWM_CONTROL_0_PWM_ENABLE_RANGE                       0:0
#define VI_PWM_CONTROL_0_PWM_ENABLE_WOFFSET                     0x0
#define VI_PWM_CONTROL_0_PWM_ENABLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_PWM_CONTROL_0_PWM_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_ENABLE_DISABLED                    _MK_ENUM_CONST(0)
#define VI_PWM_CONTROL_0_PWM_ENABLE_ENABLED                     _MK_ENUM_CONST(1)

// PWM Direction  0= Incrementing
//  1= Decrementing
#define VI_PWM_CONTROL_0_PWM_DIRECTION_SHIFT                    _MK_SHIFT_CONST(4)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_FIELD                    (_MK_MASK_CONST(0x1) << VI_PWM_CONTROL_0_PWM_DIRECTION_SHIFT)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_RANGE                    4:4
#define VI_PWM_CONTROL_0_PWM_DIRECTION_WOFFSET                  0x0
#define VI_PWM_CONTROL_0_PWM_DIRECTION_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_INCR                     _MK_ENUM_CONST(0)
#define VI_PWM_CONTROL_0_PWM_DIRECTION_DECR                     _MK_ENUM_CONST(1)

// PWM High Pulse (1 to 16)
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_SHIFT                   _MK_SHIFT_CONST(8)
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_FIELD                   (_MK_MASK_CONST(0xf) << VI_PWM_CONTROL_0_PWM_HIGH_PULSE_SHIFT)
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_RANGE                   11:8
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_WOFFSET                 0x0
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_HIGH_PULSE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// PWM Low Pulse  (1 to 16)
// 19:16 reserved
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_SHIFT                    _MK_SHIFT_CONST(12)
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_FIELD                    (_MK_MASK_CONST(0xf) << VI_PWM_CONTROL_0_PWM_LOW_PULSE_SHIFT)
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_RANGE                    15:12
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_WOFFSET                  0x0
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_LOW_PULSE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// PWM Mode Continous - after PWM is turned on, continue
//              through the PWM's 128 cycles
//              repeatedly until the pwm is turned off.
// Single - after PWM is turned on, cycle once through
//          the 128 cycles and stop.
// Counter - after PWM is turned on, cycle through
//           the 128 cycles PWM_COUNTER number of
//           times then stop.
// 23:22 reserved
#define VI_PWM_CONTROL_0_PWM_MODE_SHIFT                 _MK_SHIFT_CONST(20)
#define VI_PWM_CONTROL_0_PWM_MODE_FIELD                 (_MK_MASK_CONST(0x3) << VI_PWM_CONTROL_0_PWM_MODE_SHIFT)
#define VI_PWM_CONTROL_0_PWM_MODE_RANGE                 21:20
#define VI_PWM_CONTROL_0_PWM_MODE_WOFFSET                       0x0
#define VI_PWM_CONTROL_0_PWM_MODE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_MODE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define VI_PWM_CONTROL_0_PWM_MODE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_MODE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_MODE_CONTINUOUS                    _MK_ENUM_CONST(0)
#define VI_PWM_CONTROL_0_PWM_MODE_SINGLE                        _MK_ENUM_CONST(1)
#define VI_PWM_CONTROL_0_PWM_MODE_COUNTER                       _MK_ENUM_CONST(2)

// PWM Counter
//  8-bit value used when PWM_MODE is set to COUNTER
//  to determine how many times the PWM will cycle
//  through the 128 cycles
//  before stopping.
#define VI_PWM_CONTROL_0_PWM_COUNTER_SHIFT                      _MK_SHIFT_CONST(24)
#define VI_PWM_CONTROL_0_PWM_COUNTER_FIELD                      (_MK_MASK_CONST(0xff) << VI_PWM_CONTROL_0_PWM_COUNTER_SHIFT)
#define VI_PWM_CONTROL_0_PWM_COUNTER_RANGE                      31:24
#define VI_PWM_CONTROL_0_PWM_COUNTER_WOFFSET                    0x0
#define VI_PWM_CONTROL_0_PWM_COUNTER_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_COUNTER_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define VI_PWM_CONTROL_0_PWM_COUNTER_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PWM_CONTROL_0_PWM_COUNTER_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// The next 4 registers select which of the internal 128 pulses to be output.
//  Each bit in the four registers correspond to one internal pulse.

// Register VI_PWM_SELECT_PULSE_A_0  // PWM Pulse Select A
#define VI_PWM_SELECT_PULSE_A_0                 _MK_ADDR_CONST(0x56)
#define VI_PWM_SELECT_PULSE_A_0_SECURE                  0x0
#define VI_PWM_SELECT_PULSE_A_0_WORD_COUNT                      0x1
#define VI_PWM_SELECT_PULSE_A_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define VI_PWM_SELECT_PULSE_A_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// PWM Select bits 31 to 0
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_SHIFT)
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_RANGE                      31:0
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_WOFFSET                    0x0
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_A_0_PWM_SELECT_A_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_PWM_SELECT_PULSE_B_0  // PWM Pulse Select B
#define VI_PWM_SELECT_PULSE_B_0                 _MK_ADDR_CONST(0x57)
#define VI_PWM_SELECT_PULSE_B_0_SECURE                  0x0
#define VI_PWM_SELECT_PULSE_B_0_WORD_COUNT                      0x1
#define VI_PWM_SELECT_PULSE_B_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define VI_PWM_SELECT_PULSE_B_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// PWM Select bits 63 to 32
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_SHIFT)
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_RANGE                      31:0
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_WOFFSET                    0x0
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_B_0_PWM_SELECT_B_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_PWM_SELECT_PULSE_C_0  // PWM Pulse Select C
#define VI_PWM_SELECT_PULSE_C_0                 _MK_ADDR_CONST(0x58)
#define VI_PWM_SELECT_PULSE_C_0_SECURE                  0x0
#define VI_PWM_SELECT_PULSE_C_0_WORD_COUNT                      0x1
#define VI_PWM_SELECT_PULSE_C_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define VI_PWM_SELECT_PULSE_C_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// PWM Select bits 95 to 64
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_SHIFT)
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_RANGE                      31:0
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_WOFFSET                    0x0
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_C_0_PWM_SELECT_C_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_PWM_SELECT_PULSE_D_0  // PWM Pulse Select D
#define VI_PWM_SELECT_PULSE_D_0                 _MK_ADDR_CONST(0x59)
#define VI_PWM_SELECT_PULSE_D_0_SECURE                  0x0
#define VI_PWM_SELECT_PULSE_D_0_WORD_COUNT                      0x1
#define VI_PWM_SELECT_PULSE_D_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define VI_PWM_SELECT_PULSE_D_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// PWM Select bits 127 to 96
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_FIELD                      (_MK_MASK_CONST(0xffffffff) << VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_SHIFT)
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_RANGE                      31:0
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_WOFFSET                    0x0
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PWM_SELECT_PULSE_D_0_PWM_SELECT_D_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_VI_DATA_INPUT_CONTROL_0  // VI Input Mask
#define VI_VI_DATA_INPUT_CONTROL_0                      _MK_ADDR_CONST(0x5a)
#define VI_VI_DATA_INPUT_CONTROL_0_SECURE                       0x0
#define VI_VI_DATA_INPUT_CONTROL_0_WORD_COUNT                   0x1
#define VI_VI_DATA_INPUT_CONTROL_0_RESET_VAL                    _MK_MASK_CONST(0xfff)
#define VI_VI_DATA_INPUT_CONTROL_0_RESET_MASK                   _MK_MASK_CONST(0xfff)
#define VI_VI_DATA_INPUT_CONTROL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_VI_DATA_INPUT_CONTROL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VI_DATA_INPUT_CONTROL_0_READ_MASK                    _MK_MASK_CONST(0xfff)
#define VI_VI_DATA_INPUT_CONTROL_0_WRITE_MASK                   _MK_MASK_CONST(0xfff)
// Mask the VD[11:0] pin inputs to the VI core and ISP
// The mask is not applied to the Host GPIO read value
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_FIELD                     (_MK_MASK_CONST(0xfff) << VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_SHIFT)
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_RANGE                     11:0
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_WOFFSET                   0x0
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_DEFAULT                   _MK_MASK_CONST(0xfff)
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0xfff)
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_DATA_INPUT_CONTROL_0_VI_DATA_INPUT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_PIN_INPUT_ENABLE_0  // VI pins Input Enable
#define VI_PIN_INPUT_ENABLE_0                   _MK_ADDR_CONST(0x5b)
#define VI_PIN_INPUT_ENABLE_0_SECURE                    0x0
#define VI_PIN_INPUT_ENABLE_0_WORD_COUNT                        0x1
#define VI_PIN_INPUT_ENABLE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_RESET_MASK                        _MK_MASK_CONST(0x3fefff)
#define VI_PIN_INPUT_ENABLE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_READ_MASK                         _MK_MASK_CONST(0x3fefff)
#define VI_PIN_INPUT_ENABLE_0_WRITE_MASK                        _MK_MASK_CONST(0x3fefff)
// VD0 pin Input Enable  This bit controls VD0 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_RANGE                    0:0
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD0_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD1 pin Input Enable  This bit controls VD1 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(1)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_RANGE                    1:1
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD1_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD2 pin Input Enable  This bit controls VD2 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(2)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_RANGE                    2:2
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD2_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD3 pin Input Enable  This bit controls VD3 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(3)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_RANGE                    3:3
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD3_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD4 pin Input Enable  This bit controls VD4 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(4)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_RANGE                    4:4
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD4_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD5 pin Input Enable  This bit controls VD5 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(5)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_RANGE                    5:5
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD5_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD6 pin Input Enable  This bit controls VD6 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(6)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_RANGE                    6:6
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD6_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD7 pin Input Enable  This bit controls VD7 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(7)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_RANGE                    7:7
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD7_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD8 pin Input Enable  This bit controls VD7 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_RANGE                    8:8
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD8_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD9 pin Input Enable  This bit controls VD7 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(9)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_RANGE                    9:9
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD9_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VD10 pin Input Enable  This bit controls VD7 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(10)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_RANGE                   10:10
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD10_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VD11 pin Input Enable  This bit controls VD7 pin input.
//   0= Disabled
//   1= Enabled
// 12 reserved
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(11)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_RANGE                   11:11
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VD11_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VHS pin Input Enable  This bit controls VHS pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(13)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_RANGE                    13:13
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VHS_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VVS pin Input Enable  This bit controls VVS pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_SHIFT                    _MK_SHIFT_CONST(14)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_RANGE                    14:14
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_WOFFSET                  0x0
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VVS_INPUT_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// VGP0 pin Input Enable  This bit controls VGP0 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(15)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_RANGE                   15:15
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP0_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VGP1 pin Input Enable  This bit controls VGP1 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_RANGE                   16:16
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP1_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VGP2 pin Input Enable  This bit controls VGP2 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(17)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_RANGE                   17:17
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP2_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VGP3 pin Input Enable  This bit controls VGP3 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_RANGE                   18:18
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP3_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VGP4 pin Input Enable  This bit controls VGP4 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(19)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_RANGE                   19:19
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP4_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VGP5 pin Input Enable  This bit controls VGP5 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(20)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_RANGE                   20:20
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP5_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// VGP6 pin Input Enable  This bit controls VGP6 pin input.
//   0= Disabled
//   1= Enabled
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_SHIFT                   _MK_SHIFT_CONST(21)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_SHIFT)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_RANGE                   21:21
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_WOFFSET                 0x0
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define VI_PIN_INPUT_ENABLE_0_VGP6_INPUT_ENABLE_ENABLED                 _MK_ENUM_CONST(1)


// Register VI_PIN_OUTPUT_ENABLE_0  // VI pins Output Enable
#define VI_PIN_OUTPUT_ENABLE_0                  _MK_ADDR_CONST(0x5c)
#define VI_PIN_OUTPUT_ENABLE_0_SECURE                   0x0
#define VI_PIN_OUTPUT_ENABLE_0_WORD_COUNT                       0x1
#define VI_PIN_OUTPUT_ENABLE_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_RESET_MASK                       _MK_MASK_CONST(0x3fffff)
#define VI_PIN_OUTPUT_ENABLE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_READ_MASK                        _MK_MASK_CONST(0x3fffff)
#define VI_PIN_OUTPUT_ENABLE_0_WRITE_MASK                       _MK_MASK_CONST(0x3fffff)
// VD0 pin Output Enable  This bit controls VD0 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_RANGE                  0:0
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD0_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD1 pin Output Enable  This bit controls VD1 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_RANGE                  1:1
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD1_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD2 pin Output Enable  This bit controls VD2 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_RANGE                  2:2
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD2_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD3 pin Output Enable  This bit controls VD3 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_RANGE                  3:3
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD3_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD4 pin Output Enable  This bit controls VD4 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_RANGE                  4:4
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD4_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD5 pin Output Enable  This bit controls VD5 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_RANGE                  5:5
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD5_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD6 pin Output Enable  This bit controls VD6 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_RANGE                  6:6
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD6_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD7 pin Output Enable  This bit controls VD7 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_RANGE                  7:7
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD7_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD8 pin Output Enable  This bit controls VD7 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(8)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_RANGE                  8:8
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD8_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD9 pin Output Enable  This bit controls VD7 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(9)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_RANGE                  9:9
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD9_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VD10 pin Output Enable  This bit controls VD7 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(10)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_RANGE                 10:10
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD10_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VD11 pin Output Enable  This bit controls VD7 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(11)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_RANGE                 11:11
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VD11_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VSCK pin Output Enable  This bit controls VSCK pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(12)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_RANGE                 12:12
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VSCK_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VHS pin Output Enable  This bit controls VHS pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(13)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_RANGE                  13:13
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VHS_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VVS pin Output Enable  This bit controls VVS pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_SHIFT                  _MK_SHIFT_CONST(14)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_RANGE                  14:14
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_WOFFSET                        0x0
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VVS_OUTPUT_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// VGP0 pin Output Enable  This bit controls VGP0 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(15)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_RANGE                 15:15
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP0_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VGP1 pin Output Enable  This bit controls VGP1 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_RANGE                 16:16
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP1_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VGP2 pin Output Enable  This bit controls VGP2 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(17)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_RANGE                 17:17
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP2_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VGP3 pin Output Enable  This bit controls VGP3 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(18)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_RANGE                 18:18
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP3_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VGP4 pin Output Enable  This bit controls VGP4 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(19)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_RANGE                 19:19
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP4_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VGP5 pin Output Enable  This bit controls VGP5 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(20)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_RANGE                 20:20
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP5_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)

// VGP6 pin Output Enable  This bit controls VGP6 pin output.
//   0= Disabled
//   1= Enabled
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_SHIFT                 _MK_SHIFT_CONST(21)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_SHIFT)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_RANGE                 21:21
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_WOFFSET                       0x0
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_DISABLED                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_ENABLE_0_VGP6_OUTPUT_ENABLE_ENABLED                       _MK_ENUM_CONST(1)


// Register VI_PIN_INVERSION_0  // VI pins input/output Inversion
//    0  reserved
#define VI_PIN_INVERSION_0                      _MK_ADDR_CONST(0x5d)
#define VI_PIN_INVERSION_0_SECURE                       0x0
#define VI_PIN_INVERSION_0_WORD_COUNT                   0x1
#define VI_PIN_INVERSION_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_RESET_MASK                   _MK_MASK_CONST(0x70006)
#define VI_PIN_INVERSION_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_READ_MASK                    _MK_MASK_CONST(0x70006)
#define VI_PIN_INVERSION_0_WRITE_MASK                   _MK_MASK_CONST(0x70006)
// VHS pin Input Inversion   0= VHS input is not inverted
//      (VHS input is active high)
//   1= VHS input is inverted
//      (VHS input is active low)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_SHIFT                       _MK_SHIFT_CONST(1)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INVERSION_0_VHS_IN_INVERSION_SHIFT)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_RANGE                       1:1
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_WOFFSET                     0x0
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_DISABLED                    _MK_ENUM_CONST(0)
#define VI_PIN_INVERSION_0_VHS_IN_INVERSION_ENABLED                     _MK_ENUM_CONST(1)

// VVS pin Input Inversion   0= VVS input is not inverted
//      (VVS input is active high)
//   1= VVS input is inverted
//      (VVS input is active low)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_SHIFT                       _MK_SHIFT_CONST(2)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INVERSION_0_VVS_IN_INVERSION_SHIFT)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_RANGE                       2:2
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_WOFFSET                     0x0
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_DISABLED                    _MK_ENUM_CONST(0)
#define VI_PIN_INVERSION_0_VVS_IN_INVERSION_ENABLED                     _MK_ENUM_CONST(1)

// VSCK pin Output Inversion   0= VSCK output is not inverted
//   1= VSCK output is inverted
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_SHIFT)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_RANGE                     16:16
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_WOFFSET                   0x0
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_DISABLED                  _MK_ENUM_CONST(0)
#define VI_PIN_INVERSION_0_VSCK_OUT_INVERSION_ENABLED                   _MK_ENUM_CONST(1)

// VHS pin Output Inversion   0= VHS output is not inverted
//      (VHS output is active high)
//   1= VHS output is inverted
//      (VHS output is active low)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_SHIFT                      _MK_SHIFT_CONST(17)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_INVERSION_0_VHS_OUT_INVERSION_SHIFT)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_RANGE                      17:17
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_WOFFSET                    0x0
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_DISABLED                   _MK_ENUM_CONST(0)
#define VI_PIN_INVERSION_0_VHS_OUT_INVERSION_ENABLED                    _MK_ENUM_CONST(1)

// VVS pin Output Inversion   0= VVS output is not inverted
//      (VVS output is active high)
//   1= VVS output is inverted
//      (VVS output is active low)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_SHIFT                      _MK_SHIFT_CONST(18)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_INVERSION_0_VVS_OUT_INVERSION_SHIFT)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_RANGE                      18:18
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_WOFFSET                    0x0
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_DISABLED                   _MK_ENUM_CONST(0)
#define VI_PIN_INVERSION_0_VVS_OUT_INVERSION_ENABLED                    _MK_ENUM_CONST(1)

// This register contains input data when the video camera interface pins are used as
// general-purpose input pins. The pin data read from this register is not affected by
// the pin input inversion bits.

// Register VI_PIN_INPUT_DATA_0  // VI pins Input Data
#define VI_PIN_INPUT_DATA_0                     _MK_ADDR_CONST(0x5e)
#define VI_PIN_INPUT_DATA_0_SECURE                      0x0
#define VI_PIN_INPUT_DATA_0_WORD_COUNT                  0x1
#define VI_PIN_INPUT_DATA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_READ_MASK                   _MK_MASK_CONST(0x3fffff)
#define VI_PIN_INPUT_DATA_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// VD0 pin Input Data
//  (effective if VD0_INPUT_ENABLE is ENABLED)
//   0= VD0 input low
//   1= VD0 input high
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_RANGE                        0:0
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD0_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD1 pin Input Data
//  (effective if VD1_INPUT_ENABLE is ENABLED)
//   0= VD1 input low
//   1= VD1 input high
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(1)
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_RANGE                        1:1
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD1_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD2 pin Input Data
//  (effective if VD2_INPUT_ENABLE is ENABLED)
//   0= VD2 input low
//   1= VD2 input high
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(2)
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_RANGE                        2:2
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD2_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD3 pin Input Data
//  (effective if VD3_INPUT_ENABLE is ENABLED)
//   0= VD3 input low
//   1= VD3 input high
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(3)
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_RANGE                        3:3
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD3_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD4 pin Input Data
//  (effective if VD4_INPUT_ENABLE is ENABLED)
//   0= VD4 input low
//   1= VD4 input high
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(4)
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_RANGE                        4:4
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD4_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD5 pin Input Data
//  (effective if VD5_INPUT_ENABLE is ENABLED)
//   0= VD5 input low
//   1= VD5 input high
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(5)
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_RANGE                        5:5
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD5_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD6 pin Input Data
//  (effective if VD6_INPUT_ENABLE is ENABLED)
//   0= VD6 input low
//   1= VD6 input high
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(6)
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_RANGE                        6:6
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD6_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD7 pin Input Data
//  (effective if VD7_INPUT_ENABLE is ENABLED)
//   0= VD7 input low
//   1= VD7 input high
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(7)
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_RANGE                        7:7
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD7_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD8 pin Input Data
//  (effective if VD8_INPUT_ENABLE is ENABLED)
//   0= VD8 input low
//   1= VD8 input high
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(8)
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_RANGE                        8:8
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD8_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD9 pin Input Data
//  (effective if VD9_INPUT_ENABLE is ENABLED)
//   0= VD9 input low
//   1= VD9 input high
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(9)
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_RANGE                        9:9
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD9_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VD10 pin Input Data
//  (effective if VD10_INPUT_ENABLE is ENABLED)
//   0= VD10 input low
//   1= VD10 input high
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(10)
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_RANGE                       10:10
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD10_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VD11 pin Input Data
//  (effective if VD11_INPUT_ENABLE is ENABLED)
//   0= VD11 input low
//   1= VD11 input high
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(11)
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_RANGE                       11:11
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VD11_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VSCK pin Input Data
//  (effective if VSCK_INPUT_ENABLE is ENABLED)
//   0= VSCK input low
//   1= VSCK input high
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(12)
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_RANGE                       12:12
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VSCK_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VHS pin Input Data
//  (effective if VHS_INPUT_ENABLE is ENABLED)
//   0= VHS input low
//   1= VHS input high
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(13)
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_RANGE                        13:13
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VHS_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VVS pin Input Data
//  (effective if VVS_INPUT_ENABLE is ENABLED)
//   0= VVS input low
//   1= VVS input high
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_SHIFT                        _MK_SHIFT_CONST(14)
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_FIELD                        (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_RANGE                        14:14
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_WOFFSET                      0x0
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VVS_INPUT_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VGP0 pin Input Data
//  (effective if VGP0_INPUT_ENABLE is ENABLED)
//   0= VGP0 input low
//   1= VGP0 input high
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(15)
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_RANGE                       15:15
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP0_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VGP1 pin Input Data
//  (effective if VGP1_INPUT_ENABLE is ENABLED)
//   0= VGP1 input low
//   1= VGP1 input high
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(16)
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_RANGE                       16:16
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP1_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VGP2 pin Input Data
//  (effective if VGP2_INPUT_ENABLE is ENABLED)
//   0= VGP2 input low
//   1= VGP2 input high
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(17)
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_RANGE                       17:17
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP2_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VGP3 pin Input Data
//  (effective if VGP3_INPUT_ENABLE is ENABLED)
//   0= VGP3 input low
//   1= VGP3 input high
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(18)
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_RANGE                       18:18
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP3_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VGP4 pin Input Data
//  (effective if VGP4_INPUT_ENABLE is ENABLED)
//   0= VGP4 input low
//   1= VGP4 input high
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(19)
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_RANGE                       19:19
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP4_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VGP5 pin Input Data
//  (effective if VGP5_INPUT_ENABLE is ENABLED)
//   0= VGP5 input low
//   1= VGP5 input high
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(20)
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_RANGE                       20:20
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP5_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VGP6 pin Input Data
//  (effective if VGP6_INPUT_ENABLE is ENABLED)
//   0= VGP6 input low
//   1= VGP6 input high
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_SHIFT                       _MK_SHIFT_CONST(21)
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_FIELD                       (_MK_MASK_CONST(0x1) << VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_SHIFT)
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_RANGE                       21:21
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_WOFFSET                     0x0
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_PIN_INPUT_DATA_0_VGP6_INPUT_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// This register contains output data when the video camera interface pins are used as
// general-purpose output pins. When a bit in this register is written, the data bits can be
// output on the corresponding pin if the corresponding pin output buffer is enabled and the
// pin output control select bits are programmed to output the bit in this register.
// The output signal at the pin IS affected by the corresponding pin output inversion bit.

// Register VI_PIN_OUTPUT_DATA_0  // VI pins Output Data
#define VI_PIN_OUTPUT_DATA_0                    _MK_ADDR_CONST(0x5f)
#define VI_PIN_OUTPUT_DATA_0_SECURE                     0x0
#define VI_PIN_OUTPUT_DATA_0_WORD_COUNT                         0x1
#define VI_PIN_OUTPUT_DATA_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_READ_MASK                  _MK_MASK_CONST(0x3fffff)
#define VI_PIN_OUTPUT_DATA_0_WRITE_MASK                         _MK_MASK_CONST(0x3fffff)
// VD0 pin Output Data
//  (effective if VD0_OUTPUT_ENABLE is ENABLED
//   and VD0_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_RANGE                      0:0
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD0_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD1 pin Output Data
//  (effective if VD1_OUTPUT_ENABLE is ENABLED
//   and VD1_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(1)
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_RANGE                      1:1
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD1_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD2 pin Output Data
//  (effective if VD2_OUTPUT_ENABLE is ENABLED
//   and VD2_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(2)
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_RANGE                      2:2
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD2_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD3 pin Output Data
//  (effective if VD3_OUTPUT_ENABLE is ENABLED
//   and VD3_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(3)
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_RANGE                      3:3
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD3_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD4 pin Output Data
//  (effective if VD4_OUTPUT_ENABLE is ENABLED
//   and VD4_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(4)
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_RANGE                      4:4
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD4_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD5 pin Output Data
//  (effective if VD5_OUTPUT_ENABLE is ENABLED
//   and VD5_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(5)
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_RANGE                      5:5
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD5_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD6 pin Output Data
//  (effective if VD6_OUTPUT_ENABLE is ENABLED
//   and VD6_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(6)
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_RANGE                      6:6
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD6_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD7 pin Output Data
//  (effective if VD7_OUTPUT_ENABLE is ENABLED
//   and VD7_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(7)
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_RANGE                      7:7
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD7_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD8 pin Output Data
//  (effective if VD8_OUTPUT_ENABLE is ENABLED
//   and VD8_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(8)
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_RANGE                      8:8
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD8_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD9 pin Output Data
//  (effective if VD9_OUTPUT_ENABLE is ENABLED
//   and VD9_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(9)
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_RANGE                      9:9
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD9_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VD10 pin Output Data
//  (effective if VD10_OUTPUT_ENABLE is ENABLED
//   and VD10_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(10)
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_RANGE                     10:10
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD10_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VD11 pin Output Data
//  (effective if VD11_OUTPUT_ENABLE is ENABLED
//   and VD11_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(11)
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_RANGE                     11:11
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VD11_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VSCK pin Output Data
//  (effective if VSCK_OUTPUT_ENABLE is ENABLED
//   and VSCK_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_RANGE                     12:12
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VSCK_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VHS pin Output Data
//  (effective if VHS_OUTPUT_ENABLE is ENABLED
//   and VHS_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(13)
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_RANGE                      13:13
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VHS_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VVS pin Output Data
//  (effective if VVS_OUTPUT_ENABLE is ENABLED
//   and VVS_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_SHIFT                      _MK_SHIFT_CONST(14)
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_RANGE                      14:14
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_WOFFSET                    0x0
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VVS_OUTPUT_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VGP0 pin Output Data
//  (effective if VGP0_OUTPUT_ENABLE is ENABLED
//   and VGP0_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(15)
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_RANGE                     15:15
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP0_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VGP1 pin Output Data
//  (effective if VGP1_OUTPUT_ENABLE is ENABLED
//   and VGP1_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_RANGE                     16:16
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP1_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VGP2 pin Output Data
//  (effective if VGP2_OUTPUT_ENABLE is ENABLED
//   and VGP2_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(17)
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_RANGE                     17:17
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP2_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VGP3 pin Output Data
//  (effective if VGP3_OUTPUT_ENABLE is ENABLED
//   and VGP3_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(18)
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_RANGE                     18:18
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP3_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VGP4 pin Output Data
//  (effective if VGP4_OUTPUT_ENABLE is ENABLED
//   and VGP4_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(19)
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_RANGE                     19:19
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP4_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VGP5 pin Output Data
//  (effective if VGP5_OUTPUT_ENABLE is ENABLED
//   and VGP5_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(20)
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_RANGE                     20:20
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP5_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VGP6 pin Output Data
//  (effective if VGP6_OUTPUT_ENABLE is ENABLED
//   and VGP6_OUTPUT_SELECT is DATA)
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_SHIFT                     _MK_SHIFT_CONST(21)
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_SHIFT)
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_RANGE                     21:21
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_WOFFSET                   0x0
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_DATA_0_VGP6_OUTPUT_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_PIN_OUTPUT_SELECT_0  // VI pins Output Select
// This is the mux select used at the Pad Macro
// For VCLK, VHSYNC, VVSYNC
// Selects between the register programmed GPIO outputs (set to 0)
// and the internally generated viclk, hsync, vsync (set to 1)
// For VGP1-VGP2
// Selects between the I^2C outputs (set to 0)
// and the VI register programmed GPIO outputs (set to 1)
// For VD0-VD11
// Reserved for future use
// data pins output will be driven by GPIO outputs if enabled
#define VI_PIN_OUTPUT_SELECT_0                  _MK_ADDR_CONST(0x60)
#define VI_PIN_OUTPUT_SELECT_0_SECURE                   0x0
#define VI_PIN_OUTPUT_SELECT_0_WORD_COUNT                       0x1
#define VI_PIN_OUTPUT_SELECT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_RESET_MASK                       _MK_MASK_CONST(0x3fffff)
#define VI_PIN_OUTPUT_SELECT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_READ_MASK                        _MK_MASK_CONST(0x3fffff)
#define VI_PIN_OUTPUT_SELECT_0_WRITE_MASK                       _MK_MASK_CONST(0x3fffff)
// Pin Output Select VD0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_RANGE                      0:0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD1
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_SHIFT                      _MK_SHIFT_CONST(1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_RANGE                      1:1
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD2
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_SHIFT                      _MK_SHIFT_CONST(2)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_RANGE                      2:2
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD3
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_SHIFT                      _MK_SHIFT_CONST(3)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_RANGE                      3:3
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD4
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_SHIFT                      _MK_SHIFT_CONST(4)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_RANGE                      4:4
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD5
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_SHIFT                      _MK_SHIFT_CONST(5)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_RANGE                      5:5
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD6
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_SHIFT                      _MK_SHIFT_CONST(6)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_RANGE                      6:6
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD7
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_SHIFT                      _MK_SHIFT_CONST(7)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_RANGE                      7:7
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD8
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_SHIFT                      _MK_SHIFT_CONST(8)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_RANGE                      8:8
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD9
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_SHIFT                      _MK_SHIFT_CONST(9)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_RANGE                      9:9
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VD10
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_SHIFT                     _MK_SHIFT_CONST(10)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_RANGE                     10:10
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VD11
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_SHIFT                     _MK_SHIFT_CONST(11)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_RANGE                     11:11
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vd11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VCLK
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_RANGE                     12:12
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vclk_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VHSYNC
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_SHIFT                      _MK_SHIFT_CONST(13)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_RANGE                      13:13
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vhs_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VVSYNC
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_SHIFT                      _MK_SHIFT_CONST(14)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_FIELD                      (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_RANGE                      14:14
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_WOFFSET                    0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vvs_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Pin Output Select VGP0
//  0 = VGP0 output register
//  1 = refclk
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_SHIFT                     _MK_SHIFT_CONST(15)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_RANGE                     15:15
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VGP1
//  0 = I^2C SCK pin
//  1 = 1'b0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_RANGE                     16:16
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VGP2
//  0 = I^2C SDA pin
//  1 = 1'b0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_SHIFT                     _MK_SHIFT_CONST(17)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_RANGE                     17:17
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VGP3
//  0 = VGP3 output register
//  1 = 1'b0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_SHIFT                     _MK_SHIFT_CONST(18)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_RANGE                     18:18
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VGP4
//  0 = VGP4 output register
//  1 = 1'b0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_SHIFT                     _MK_SHIFT_CONST(19)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_RANGE                     19:19
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VGP5
//  0 = VGP5 output register
//  1 = 1'b0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_SHIFT                     _MK_SHIFT_CONST(20)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_RANGE                     20:20
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pin Output Select VGP6   0= select VGP6 register data out
//   1= select PWM out
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_SHIFT                     _MK_SHIFT_CONST(21)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_FIELD                     (_MK_MASK_CONST(0x1) << VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_SHIFT)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_RANGE                     21:21
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_WOFFSET                   0x0
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_DATA                      _MK_ENUM_CONST(0)
#define VI_PIN_OUTPUT_SELECT_0_PIN_OUTPUT_SELECT_vgp6_PWM                       _MK_ENUM_CONST(1)

// raise vectors are received from host. If host is the input source, host will send
// a raise vector at the end of a line, and VI return it when that has been written to memory.
// A raise written when decimation or averaging is selected in vi, is not supported.
// If Video Input Port is the input source, host should program raise vectors to either raise
// at buffer end or at frame end.
// Since there are 2 memory outputs for vi, there are two separate raise vectors for buffer/frame.

// Register VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0  // raise vector at buffer end
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0                      _MK_ADDR_CONST(0x61)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_SECURE                       0x0
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_WORD_COUNT                   0x1
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_READ_MASK                    _MK_MASK_CONST(0x1f)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_WRITE_MASK                   _MK_MASK_CONST(0xf001f)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_FIELD                  (_MK_MASK_CONST(0x1f) << VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_SHIFT)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_RANGE                  4:0
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_WOFFSET                        0x0
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_VECTOR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_FIELD                 (_MK_MASK_CONST(0xf) << VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_SHIFT)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_RANGE                 19:16
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_WOFFSET                       0x0
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_FIRST_OUTPUT_0_RAISE_BUFFER_1_CHANNEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0  // raise vector at frame end
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0                       _MK_ADDR_CONST(0x62)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_SECURE                        0x0
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_WORD_COUNT                    0x1
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_WRITE_MASK                    _MK_MASK_CONST(0xf001f)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_FIELD                    (_MK_MASK_CONST(0x1f) << VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_SHIFT)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_RANGE                    4:0
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_WOFFSET                  0x0
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_VECTOR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_FIELD                   (_MK_MASK_CONST(0xf) << VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_SHIFT)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_RANGE                   19:16
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_WOFFSET                 0x0
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_FIRST_OUTPUT_0_RAISE_FRAME_1_CHANNEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0  // raise vector at buffer end
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0                     _MK_ADDR_CONST(0x63)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_SECURE                      0x0
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_WORD_COUNT                  0x1
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_READ_MASK                   _MK_MASK_CONST(0x1f)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_WRITE_MASK                  _MK_MASK_CONST(0xf001f)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_FIELD                 (_MK_MASK_CONST(0x1f) << VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_SHIFT)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_RANGE                 4:0
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_WOFFSET                       0x0
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_VECTOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_SHIFT                        _MK_SHIFT_CONST(16)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_FIELD                        (_MK_MASK_CONST(0xf) << VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_SHIFT)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_RANGE                        19:16
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_WOFFSET                      0x0
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_BUFFER_SECOND_OUTPUT_0_RAISE_BUFFER_2_CHANNEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0  // raise vector at frame end
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0                      _MK_ADDR_CONST(0x64)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_SECURE                       0x0
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_WORD_COUNT                   0x1
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_READ_MASK                    _MK_MASK_CONST(0x1f)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_WRITE_MASK                   _MK_MASK_CONST(0xf001f)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_FIELD                   (_MK_MASK_CONST(0x1f) << VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_SHIFT)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_RANGE                   4:0
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_WOFFSET                 0x0
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_FIELD                  (_MK_MASK_CONST(0xf) << VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_SHIFT)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_RANGE                  19:16
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_WOFFSET                        0x0
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_RAISE_VIP_FRAME_SECOND_OUTPUT_0_RAISE_FRAME_2_CHANNEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_RAISE_HOST_FIRST_OUTPUT_0  // raise vector when from host
#define VI_RAISE_HOST_FIRST_OUTPUT_0                    _MK_ADDR_CONST(0x65)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_SECURE                     0x0
#define VI_RAISE_HOST_FIRST_OUTPUT_0_WORD_COUNT                         0x1
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_READ_MASK                  _MK_MASK_CONST(0x1f)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_WRITE_MASK                         _MK_MASK_CONST(0xf001f)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_FIELD                  (_MK_MASK_CONST(0x1f) << VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_SHIFT)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_RANGE                  4:0
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_WOFFSET                        0x0
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_VECTOR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_FIELD                 (_MK_MASK_CONST(0xf) << VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_SHIFT)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_RANGE                 19:16
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_WOFFSET                       0x0
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_FIRST_OUTPUT_0_RAISE_HOST_1_CHANNEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register VI_RAISE_HOST_SECOND_OUTPUT_0  // raise vector when from host
#define VI_RAISE_HOST_SECOND_OUTPUT_0                   _MK_ADDR_CONST(0x66)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_SECURE                    0x0
#define VI_RAISE_HOST_SECOND_OUTPUT_0_WORD_COUNT                        0x1
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_READ_MASK                         _MK_MASK_CONST(0x1f)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_WRITE_MASK                        _MK_MASK_CONST(0xf001f)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_FIELD                 (_MK_MASK_CONST(0x1f) << VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_SHIFT)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_RANGE                 4:0
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_WOFFSET                       0x0
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_VECTOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_SHIFT                        _MK_SHIFT_CONST(16)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_FIELD                        (_MK_MASK_CONST(0xf) << VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_SHIFT)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_RANGE                        19:16
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_WOFFSET                      0x0
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RAISE_HOST_SECOND_OUTPUT_0_RAISE_HOST_2_CHANNEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// EPP receives the raise request via the Simple Stream Video Data bus
// see arepp.spec for details
// This raise needs to be written during the horizontal blanking period. (After end of line.)
// This is only valid if the input source is host.

// Register VI_RAISE_EPP_0  // raise vector at line end
#define VI_RAISE_EPP_0                  _MK_ADDR_CONST(0x67)
#define VI_RAISE_EPP_0_SECURE                   0x0
#define VI_RAISE_EPP_0_WORD_COUNT                       0x1
#define VI_RAISE_EPP_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_READ_MASK                        _MK_MASK_CONST(0x1f)
#define VI_RAISE_EPP_0_WRITE_MASK                       _MK_MASK_CONST(0xf001f)
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_FIELD                   (_MK_MASK_CONST(0x1f) << VI_RAISE_EPP_0_RAISE_EPP_VECTOR_SHIFT)
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_RANGE                   4:0
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_WOFFSET                 0x0
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RAISE_EPP_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_FIELD                  (_MK_MASK_CONST(0xf) << VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_SHIFT)
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_RANGE                  19:16
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_WOFFSET                        0x0
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_RAISE_EPP_0_RAISE_EPP_CHANNEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// For Parallel VIP input, limitation for vsync and hsync has to be followed to avoid ISP hang for AP15:
// SW must always program parallel cameras (including the VIP pattern generator) in a way that
// avoids simultaneous hsync and vsync active edges. copied from bug:361730

// Register VI_CAMERA_CONTROL_0  // VI camera control bits
#define VI_CAMERA_CONTROL_0                     _MK_ADDR_CONST(0x68)
#define VI_CAMERA_CONTROL_0_SECURE                      0x0
#define VI_CAMERA_CONTROL_0_WORD_COUNT                  0x1
#define VI_CAMERA_CONTROL_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_RESET_MASK                  _MK_MASK_CONST(0x7)
#define VI_CAMERA_CONTROL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_READ_MASK                   _MK_MASK_CONST(0x7)
#define VI_CAMERA_CONTROL_0_WRITE_MASK                  _MK_MASK_CONST(0x6)
// VI camera input module Enable   0= Ignored - use the STOP_CAPTURE to turn off the capturing
//   1= Enabled
// Write a 1'b1 to this register to enable
// the camera interface to start capturing data.
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << VI_CAMERA_CONTROL_0_VIP_ENABLE_SHIFT)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_RANGE                    0:0
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_WOFFSET                  0x0
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define VI_CAMERA_CONTROL_0_VIP_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

// Test Mode Enable   0= Disabled
//   1= Enabled
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_SHIFT                      _MK_SHIFT_CONST(1)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_SHIFT)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_RANGE                      1:1
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_WOFFSET                    0x0
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define VI_CAMERA_CONTROL_0_TEST_MODE_ENABLE_ENABLED                    _MK_ENUM_CONST(1)

// Disables camera capturing VI_ENABLE after the  next end of frame.
//   0= Disabled
//   1= Enabled
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_SHIFT                  _MK_SHIFT_CONST(2)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_FIELD                  (_MK_MASK_CONST(0x1) << VI_CAMERA_CONTROL_0_STOP_CAPTURE_SHIFT)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_RANGE                  2:2
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_WOFFSET                        0x0
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_DISABLED                       _MK_ENUM_CONST(0)
#define VI_CAMERA_CONTROL_0_STOP_CAPTURE_ENABLED                        _MK_ENUM_CONST(1)

// **** Enable bit should be to host together with other module enables in NV flow.
// **** Test mode is not needed in NV flow but the enable bit can be replaced with debug bus
//      enable.

// Register VI_VI_ENABLE_0  // VI Enables
#define VI_VI_ENABLE_0                  _MK_ADDR_CONST(0x69)
#define VI_VI_ENABLE_0_SECURE                   0x0
#define VI_VI_ENABLE_0_WORD_COUNT                       0x1
#define VI_VI_ENABLE_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_0_RESET_MASK                       _MK_MASK_CONST(0x3)
#define VI_VI_ENABLE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_READ_MASK                        _MK_MASK_CONST(0x3)
#define VI_VI_ENABLE_0_WRITE_MASK                       _MK_MASK_CONST(0x3)
// First Output to Memory   0= Enabled
//   1= Disabled
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_FIELD                     (_MK_MASK_CONST(0x1) << VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_SHIFT)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_RANGE                     0:0
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_WOFFSET                   0x0
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_DEFAULT                   _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_ENABLED                   _MK_ENUM_CONST(0)
#define VI_VI_ENABLE_0_FIRST_OUTPUT_TO_MEMORY_DISABLED                  _MK_ENUM_CONST(1)

// SW enable flow control for output1
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_SHIFT                       _MK_SHIFT_CONST(1)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_SHIFT)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_RANGE                       1:1
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_WOFFSET                     0x0
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_DISABLE                     _MK_ENUM_CONST(0)
#define VI_VI_ENABLE_0_SW_FLOW_CONTROL_OUT1_ENABLE                      _MK_ENUM_CONST(1)


// Register VI_VI_ENABLE_2_0  // VI Enables second output
#define VI_VI_ENABLE_2_0                        _MK_ADDR_CONST(0x6a)
#define VI_VI_ENABLE_2_0_SECURE                         0x0
#define VI_VI_ENABLE_2_0_WORD_COUNT                     0x1
#define VI_VI_ENABLE_2_0_RESET_VAL                      _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_2_0_RESET_MASK                     _MK_MASK_CONST(0x3)
#define VI_VI_ENABLE_2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_READ_MASK                      _MK_MASK_CONST(0x3)
#define VI_VI_ENABLE_2_0_WRITE_MASK                     _MK_MASK_CONST(0x3)
// Second Output to Memory   0= Enabled
//   1= Disabled
//  Disabling output to memory may be set
//  if only output to encoder pre-processor
//  is needed. This will also power-down
//  all logic which is only used to send
//  output data to memory.
//   0= Disabled
//   1= Enabled
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_FIELD                  (_MK_MASK_CONST(0x1) << VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_SHIFT)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_RANGE                  0:0
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_WOFFSET                        0x0
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_DEFAULT                        _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_ENABLED                        _MK_ENUM_CONST(0)
#define VI_VI_ENABLE_2_0_SECOND_OUTPUT_TO_MEMORY_DISABLED                       _MK_ENUM_CONST(1)

// SW enable flow control for output2
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_SHIFT                     _MK_SHIFT_CONST(1)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_FIELD                     (_MK_MASK_CONST(0x1) << VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_SHIFT)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_RANGE                     1:1
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_WOFFSET                   0x0
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_DISABLE                   _MK_ENUM_CONST(0)
#define VI_VI_ENABLE_2_0_SW_FLOW_CONTROL_OUT2_ENABLE                    _MK_ENUM_CONST(1)


// Register VI_VI_RAISE_0  // VI Enables second output
#define VI_VI_RAISE_0                   _MK_ADDR_CONST(0x6b)
#define VI_VI_RAISE_0_SECURE                    0x0
#define VI_VI_RAISE_0_WORD_COUNT                        0x1
#define VI_VI_RAISE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_VI_RAISE_0_RESET_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_RAISE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_VI_RAISE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VI_RAISE_0_READ_MASK                         _MK_MASK_CONST(0x1)
#define VI_VI_RAISE_0_WRITE_MASK                        _MK_MASK_CONST(0x1)
// Makes Raises edge triggered not level sensitive  i.e. only return raise at the end of frame, not
//  in the middle of the v-blank time.
//   0= Disabled
//   1= Enabled
#define VI_VI_RAISE_0_RAISE_ON_EDGE_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_RAISE_0_RAISE_ON_EDGE_SHIFT)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_RANGE                       0:0
#define VI_VI_RAISE_0_RAISE_ON_EDGE_WOFFSET                     0x0
#define VI_VI_RAISE_0_RAISE_ON_EDGE_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_DISABLED                    _MK_ENUM_CONST(0)
#define VI_VI_RAISE_0_RAISE_ON_EDGE_ENABLED                     _MK_ENUM_CONST(1)

// **** Host YUV FIFO offsets.  This register space is used for Host Video Data writes.
// **** YUV 4:2:0 planar for re-encoding as well as YUV 4:2:2 data

// Register VI_Y_FIFO_WRITE_0  // YUV 4:2:0 Planar Y-FIFO, YUV 4:2:2 non-Planar YUV FIFO
#define VI_Y_FIFO_WRITE_0                       _MK_ADDR_CONST(0x6c)
#define VI_Y_FIFO_WRITE_0_SECURE                        0x0
#define VI_Y_FIFO_WRITE_0_WORD_COUNT                    0x1
#define VI_Y_FIFO_WRITE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_Y_FIFO_WRITE_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define VI_Y_FIFO_WRITE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_Y_FIFO_WRITE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_Y_FIFO_WRITE_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define VI_Y_FIFO_WRITE_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_FIELD                     (_MK_MASK_CONST(0xffffffff) << VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_SHIFT)
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_RANGE                     31:0
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_WOFFSET                   0x0
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_Y_FIFO_WRITE_0_Y_FIFO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_U_FIFO_WRITE_0  // YUV 4:2:0 Planar U-FIFO
#define VI_U_FIFO_WRITE_0                       _MK_ADDR_CONST(0x6d)
#define VI_U_FIFO_WRITE_0_SECURE                        0x0
#define VI_U_FIFO_WRITE_0_WORD_COUNT                    0x1
#define VI_U_FIFO_WRITE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_U_FIFO_WRITE_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define VI_U_FIFO_WRITE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_U_FIFO_WRITE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_U_FIFO_WRITE_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define VI_U_FIFO_WRITE_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_FIELD                     (_MK_MASK_CONST(0xffffffff) << VI_U_FIFO_WRITE_0_U_FIFO_DATA_SHIFT)
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_RANGE                     31:0
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_WOFFSET                   0x0
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_U_FIFO_WRITE_0_U_FIFO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_V_FIFO_WRITE_0  // YUV 4:2:0 Planar V-FIFO
#define VI_V_FIFO_WRITE_0                       _MK_ADDR_CONST(0x6e)
#define VI_V_FIFO_WRITE_0_SECURE                        0x0
#define VI_V_FIFO_WRITE_0_WORD_COUNT                    0x1
#define VI_V_FIFO_WRITE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_V_FIFO_WRITE_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define VI_V_FIFO_WRITE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_V_FIFO_WRITE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_V_FIFO_WRITE_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define VI_V_FIFO_WRITE_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_FIELD                     (_MK_MASK_CONST(0xffffffff) << VI_V_FIFO_WRITE_0_V_FIFO_DATA_SHIFT)
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_RANGE                     31:0
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_WOFFSET                   0x0
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_V_FIFO_WRITE_0_V_FIFO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Memory Client Interface Async Fifo Optimization Register
// Memory Client Interface Fifo Control Register.
// The registers below allow to optimize the synchronization timing in
// the memory client asynchronous fifos. When they can be used depend on
// the client and memory controller clock ratio.
// Additionally, the RDMC_RDFAST/RDCL_RDFAST fields can increase power
// consumption if the asynchronous fifo is implemented as a real ram.
// There is no power impact on latch-based fifos. Flipflop-based fifos
// do not use these fields.
// See recommended settings below.
//
// !! IMPORTANT !!
// The register fields can only be changed when the memory client async
// fifos are empty.
//
// The register field ending with WRCL_MCLE2X (if any) can be set to improve
// async fifo synchronization on the write side by one client clock cycle if
// the memory controller clock frequency is less or equal to twice the client
// clock frequency:
//
//      mcclk_freq <= 2 * clientclk_freq
//
// The register field ending with WRMC_CLLE2X (if any) can be set to improve
// async fifo synchronization on the write side by one memory controller clock
// cycle if the client clock frequency is less or equal to twice the memory
// controller clock frequency:
//
//      clientclk_freq <= 2 * mcclk_freq
//
// The register field ending with RDMC_RDFAST (if any) can be set to improve async
// fifo synchronization on the read side by one memory controller clock cycle.
//
// !! WARNING !!
// RDMC_RDFAST can be used along with WRCL_MCLE2X only when:
//
//       mcclk_freq <= clientclk_freq
//
// The register field ending with RDCL_RDFAST (if any) can be set to improve async
// fifo synchronization on the read side by one client clock cycle.
//
// !! WARNING !!
// RDCL_RDFAST can be used along with WRMC_CLLE2X only when:
//
//       clientclk_freq <= mcclk_freq
//
// RECOMMENDED SETTINGS
// # Client writing to fifo, memory controller reading from fifo
// - mcclk_freq <= clientclk_freq
//     You can enable both RDMC_RDFAST and WRCL_CLLE2X. If one of the fifos is
//     a real ram and power is a concern, you should avoid enabling RDMC_RDFAST.
// - clientclk_freq < mcclk_freq <= 2 * clientclk_freq
//     You can enable RDMC_RDFAST or WRCL_MCLE2X, but because the client clock
//     is slower, you should enable only WRCL_MCLE2X.
// - 2 * clientclk_freq < mcclk_freq
//     You can only enable RDMC_RDFAST. If one of the fifos is a real ram and
//     power is a concern, you should avoid enabling RDMC_RDFAST.
//
// # Memory controller writing to fifo, client reading from fifo
// - clientclk_freq <= mcclk_freq
//     You can enable both RDCL_RDFAST and WRMC_CLLE2X. If one of the fifos is
//     a real ram and power is a concern, you should avoid enabling RDCL_RDFAST.
// - mcclk_freq < clientclk_freq <= 2 * mcclk_freq
//     You can enable RDCL_RDFAST or WRMC_CLLE2X, but because the memory controller
//     clock is slower, you should enable only WRMC_CLLE2X.
// - 2 * mcclk_freq < clientclk_freq
//     You can only enable RDCL_RDFAST. If one of the fifos is a real ram and
//     power is a concern, you should avoid enabling RDCL_RDFAST.
//

// Register VI_VI_MCCIF_FIFOCTRL_0  
#define VI_VI_MCCIF_FIFOCTRL_0                  _MK_ADDR_CONST(0x6f)
#define VI_VI_MCCIF_FIFOCTRL_0_SECURE                   0x0
#define VI_VI_MCCIF_FIFOCTRL_0_WORD_COUNT                       0x1
#define VI_VI_MCCIF_FIFOCTRL_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_RESET_MASK                       _MK_MASK_CONST(0xf)
#define VI_VI_MCCIF_FIFOCTRL_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_READ_MASK                        _MK_MASK_CONST(0xf)
#define VI_VI_MCCIF_FIFOCTRL_0_WRITE_MASK                       _MK_MASK_CONST(0xf)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_SHIFT)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_RANGE                       0:0
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_WOFFSET                     0x0
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_INIT_ENUM                   DISABLE
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_DISABLE                     _MK_ENUM_CONST(0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRCL_MCLE2X_ENABLE                      _MK_ENUM_CONST(1)

#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_SHIFT                       _MK_SHIFT_CONST(1)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_SHIFT)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_RANGE                       1:1
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_WOFFSET                     0x0
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_INIT_ENUM                   DISABLE
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_DISABLE                     _MK_ENUM_CONST(0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDMC_RDFAST_ENABLE                      _MK_ENUM_CONST(1)

#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_SHIFT                       _MK_SHIFT_CONST(2)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_SHIFT)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_RANGE                       2:2
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_WOFFSET                     0x0
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_INIT_ENUM                   DISABLE
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_DISABLE                     _MK_ENUM_CONST(0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_WRMC_CLLE2X_ENABLE                      _MK_ENUM_CONST(1)

#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_SHIFT                       _MK_SHIFT_CONST(3)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_FIELD                       (_MK_MASK_CONST(0x1) << VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_SHIFT)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_RANGE                       3:3
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_WOFFSET                     0x0
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_INIT_ENUM                   DISABLE
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_DISABLE                     _MK_ENUM_CONST(0)
#define VI_VI_MCCIF_FIFOCTRL_0_VI_MCCIF_RDCL_RDFAST_ENABLE                      _MK_ENUM_CONST(1)

// Write Coalescing Time-Out Register
// This register exists only for write clients. Reset value defaults to 
// to 50 for most clients, but may be different for certain clients.
// Write coalescing happens inside the memory client.
// Coalescing means two (NV_MC_MW/2)-bit requests are grouped together in one NV_MC_MW-bit request.
// The register value indicates how many cycles a first write request is going to wait
// for a subsequent one for possible coalescing. The coalescing can only happen
// if the request addresses are compatible. A value of zero means that coalescing is off
// and requests are sent right away to the memory controller.
// Write coalescing can have a very significant impact performance when accessing the internal memory,
// because its memory word is NV_MC_WM-bit wide. Grouping two half-word accesses is
// much more efficient, because the two accesses would actually have taken three cycles,
// due to a stall when accessing the same memory bank. It also reduces the number of
// accessing (one instead of two), freeing up internal memory bandwidth for other accesses.
// The impact on external memory accesses is not as significant as the burst access is for
// NV_MC_MW/2 bits. But a coalesced write guarantees two consecutive same page accesses
// which is good for external memory bandwidth utilization.
// The write coalescing time-out should be programmed depending on the client behavior.
// The first write is obviously delayed by an amount of client cycles equal to the time-out value.
// Note that writes tagged by the client (i.e. the client expects a write response, usually
// for coherency), and the last write of a block transfer are not delayed.
// They only have a one-cycle opportunity to get coalesced.
//

// Register VI_TIMEOUT_WCOAL_VI_0  
#define VI_TIMEOUT_WCOAL_VI_0                   _MK_ADDR_CONST(0x70)
#define VI_TIMEOUT_WCOAL_VI_0_SECURE                    0x0
#define VI_TIMEOUT_WCOAL_VI_0_WORD_COUNT                        0x1
#define VI_TIMEOUT_WCOAL_VI_0_RESET_VAL                         _MK_MASK_CONST(0x32323232)
#define VI_TIMEOUT_WCOAL_VI_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define VI_TIMEOUT_WCOAL_VI_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_TIMEOUT_WCOAL_VI_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_TIMEOUT_WCOAL_VI_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define VI_TIMEOUT_WCOAL_VI_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_FIELD                   (_MK_MASK_CONST(0xff) << VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_SHIFT)
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_RANGE                   7:0
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_WOFFSET                 0x0
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_DEFAULT                 _MK_MASK_CONST(0x32)
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_TIMEOUT_WCOAL_VI_0_VIWSB_WCOAL_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_SHIFT)
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_RANGE                    15:8
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_WOFFSET                  0x0
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x32)
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TIMEOUT_WCOAL_VI_0_VIWU_WCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(16)
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_SHIFT)
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_RANGE                    23:16
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_WOFFSET                  0x0
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x32)
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TIMEOUT_WCOAL_VI_0_VIWV_WCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(24)
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_SHIFT)
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_RANGE                    31:24
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_WOFFSET                  0x0
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x32)
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TIMEOUT_WCOAL_VI_0_VIWY_WCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Memory Client High-Priority Control Register
// This register exists only for clients with high-priority. Reset values are 0 (disabled).
// The high-priority should be enabled for hard real-time clients only. The values to program
// depend on the client bandwidth requirement and the client versus memory controllers clolck ratio.
// The high-priority is set if the number of entries in the return data fifo is under the threshold.
// The high-priority assertion can be delayed by a number of memory clock cycles indicated by the timer.
// This creates an hysteresis effect, avoiding setting the high-priority for very short periods of time,
// which may or may not be desirable.

// Register VI_MCCIF_VIRUV_HP_0  
#define VI_MCCIF_VIRUV_HP_0                     _MK_ADDR_CONST(0x71)
#define VI_MCCIF_VIRUV_HP_0_SECURE                      0x0
#define VI_MCCIF_VIRUV_HP_0_WORD_COUNT                  0x1
#define VI_MCCIF_VIRUV_HP_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_RESET_MASK                  _MK_MASK_CONST(0x3f000f)
#define VI_MCCIF_VIRUV_HP_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_READ_MASK                   _MK_MASK_CONST(0x3f000f)
#define VI_MCCIF_VIRUV_HP_0_WRITE_MASK                  _MK_MASK_CONST(0x3f000f)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_FIELD                     (_MK_MASK_CONST(0xf) << VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_SHIFT)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_RANGE                     3:0
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_WOFFSET                   0x0
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_FIELD                     (_MK_MASK_CONST(0x3f) << VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_SHIFT)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_RANGE                     21:16
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_WOFFSET                   0x0
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HP_0_CBR_VIRUV2MC_HPTM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Memory Client High-Priority Control Register
// This register exists only for clients with high-priority. Reset values are 0 (disabled).
// The high-priority should be enabled for hard real-time clients only. The values to program
// depend on the client bandwidth requirement and the client versus memory controllers clolck ratio.
// The high-priority is set if the number of entries in the data fifo is higher than the threshold.

// Register VI_MCCIF_VIWSB_HP_0  
#define VI_MCCIF_VIWSB_HP_0                     _MK_ADDR_CONST(0x72)
#define VI_MCCIF_VIWSB_HP_0_SECURE                      0x0
#define VI_MCCIF_VIWSB_HP_0_WORD_COUNT                  0x1
#define VI_MCCIF_VIWSB_HP_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HP_0_RESET_MASK                  _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWSB_HP_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HP_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HP_0_READ_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWSB_HP_0_WRITE_MASK                  _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_FIELD                     (_MK_MASK_CONST(0x7f) << VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_SHIFT)
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_RANGE                     6:0
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_WOFFSET                   0x0
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HP_0_CBW_VIWSB2MC_HPTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Memory Client High-Priority Control Register
// This register exists only for clients with high-priority. Reset values are 0 (disabled).
// The high-priority should be enabled for hard real-time clients only. The values to program
// depend on the client bandwidth requirement and the client versus memory controllers clolck ratio.
// The high-priority is set if the number of entries in the data fifo is higher than the threshold.

// Register VI_MCCIF_VIWU_HP_0  
#define VI_MCCIF_VIWU_HP_0                      _MK_ADDR_CONST(0x73)
#define VI_MCCIF_VIWU_HP_0_SECURE                       0x0
#define VI_MCCIF_VIWU_HP_0_WORD_COUNT                   0x1
#define VI_MCCIF_VIWU_HP_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HP_0_RESET_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWU_HP_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HP_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HP_0_READ_MASK                    _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWU_HP_0_WRITE_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_FIELD                       (_MK_MASK_CONST(0x7f) << VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_SHIFT)
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_RANGE                       6:0
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_WOFFSET                     0x0
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_DEFAULT_MASK                        _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HP_0_CBW_VIWU2MC_HPTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Memory Client High-Priority Control Register
// This register exists only for clients with high-priority. Reset values are 0 (disabled).
// The high-priority should be enabled for hard real-time clients only. The values to program
// depend on the client bandwidth requirement and the client versus memory controllers clolck ratio.
// The high-priority is set if the number of entries in the data fifo is higher than the threshold.

// Register VI_MCCIF_VIWV_HP_0  
#define VI_MCCIF_VIWV_HP_0                      _MK_ADDR_CONST(0x74)
#define VI_MCCIF_VIWV_HP_0_SECURE                       0x0
#define VI_MCCIF_VIWV_HP_0_WORD_COUNT                   0x1
#define VI_MCCIF_VIWV_HP_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HP_0_RESET_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWV_HP_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HP_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HP_0_READ_MASK                    _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWV_HP_0_WRITE_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_FIELD                       (_MK_MASK_CONST(0x7f) << VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_SHIFT)
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_RANGE                       6:0
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_WOFFSET                     0x0
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_DEFAULT_MASK                        _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HP_0_CBW_VIWV2MC_HPTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Memory Client High-Priority Control Register
// This register exists only for clients with high-priority. Reset values are 0 (disabled).
// The high-priority should be enabled for hard real-time clients only. The values to program
// depend on the client bandwidth requirement and the client versus memory controllers clolck ratio.
// The high-priority is set if the number of entries in the data fifo is higher than the threshold.

// Register VI_MCCIF_VIWY_HP_0  
#define VI_MCCIF_VIWY_HP_0                      _MK_ADDR_CONST(0x75)
#define VI_MCCIF_VIWY_HP_0_SECURE                       0x0
#define VI_MCCIF_VIWY_HP_0_WORD_COUNT                   0x1
#define VI_MCCIF_VIWY_HP_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HP_0_RESET_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWY_HP_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HP_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HP_0_READ_MASK                    _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWY_HP_0_WRITE_MASK                   _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_FIELD                       (_MK_MASK_CONST(0x7f) << VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_SHIFT)
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_RANGE                       6:0
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_WOFFSET                     0x0
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_DEFAULT_MASK                        _MK_MASK_CONST(0x7f)
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HP_0_CBW_VIWY2MC_HPTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// CSI Raise vectors

// Register VI_CSI_PPA_RAISE_FRAME_START_0  // CSI Pixel Parser A Raise
#define VI_CSI_PPA_RAISE_FRAME_START_0                  _MK_ADDR_CONST(0x76)
#define VI_CSI_PPA_RAISE_FRAME_START_0_SECURE                   0x0
#define VI_CSI_PPA_RAISE_FRAME_START_0_WORD_COUNT                       0x1
#define VI_CSI_PPA_RAISE_FRAME_START_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_READ_MASK                        _MK_MASK_CONST(0xfff1f)
#define VI_CSI_PPA_RAISE_FRAME_START_0_WRITE_MASK                       _MK_MASK_CONST(0xfff1f)
//   Raise returned by VI when CSI PPA
//   issues a frame start to consumer.
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_FIELD                   (_MK_MASK_CONST(0x1f) << VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_SHIFT)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_RANGE                   4:0
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_WOFFSET                 0x0
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//   Number of frame start since last raise >= count for raise to be returned
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_FIELD                    (_MK_MASK_CONST(0xff) << VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_SHIFT)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_RANGE                    15:8
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_WOFFSET                  0x0
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_COUNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//   Raise return channel
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_FIELD                  (_MK_MASK_CONST(0xf) << VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_SHIFT)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_RANGE                  19:16
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_WOFFSET                        0x0
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_START_0_CSI_PPA_RAISE_FRAME_START_CHANNEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_CSI_PPA_RAISE_FRAME_END_0  // CSI Pixel Parser A Raise
#define VI_CSI_PPA_RAISE_FRAME_END_0                    _MK_ADDR_CONST(0x77)
#define VI_CSI_PPA_RAISE_FRAME_END_0_SECURE                     0x0
#define VI_CSI_PPA_RAISE_FRAME_END_0_WORD_COUNT                         0x1
#define VI_CSI_PPA_RAISE_FRAME_END_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_READ_MASK                  _MK_MASK_CONST(0xfff1f)
#define VI_CSI_PPA_RAISE_FRAME_END_0_WRITE_MASK                         _MK_MASK_CONST(0xfff1f)
//   Raise returned by VI when CSI PPA
//   issues a frame end to consumer.
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_FIELD                       (_MK_MASK_CONST(0x1f) << VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_SHIFT)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_RANGE                       4:0
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_WOFFSET                     0x0
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//   Number of frame end since last raise >= count for raise to be returned
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_SHIFT                        _MK_SHIFT_CONST(8)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_FIELD                        (_MK_MASK_CONST(0xff) << VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_SHIFT)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_RANGE                        15:8
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_WOFFSET                      0x0
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//   Raise return channel
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_SHIFT                      _MK_SHIFT_CONST(16)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_FIELD                      (_MK_MASK_CONST(0xf) << VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_SHIFT)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_RANGE                      19:16
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_WOFFSET                    0x0
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_RAISE_FRAME_END_0_CSI_PPA_RAISE_FRAME_END_CHANNEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_CSI_PPB_RAISE_FRAME_START_0  // CSI Pixel Parser B Raise
#define VI_CSI_PPB_RAISE_FRAME_START_0                  _MK_ADDR_CONST(0x78)
#define VI_CSI_PPB_RAISE_FRAME_START_0_SECURE                   0x0
#define VI_CSI_PPB_RAISE_FRAME_START_0_WORD_COUNT                       0x1
#define VI_CSI_PPB_RAISE_FRAME_START_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_READ_MASK                        _MK_MASK_CONST(0xfff1f)
#define VI_CSI_PPB_RAISE_FRAME_START_0_WRITE_MASK                       _MK_MASK_CONST(0xfff1f)
//   Raise returned by VI when CSI PPB
//   issues a frame start to consumer.
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_FIELD                   (_MK_MASK_CONST(0x1f) << VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_SHIFT)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_RANGE                   4:0
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_WOFFSET                 0x0
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//   Number of frame start since last raise >= count for raise to be returned
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_SHIFT                    _MK_SHIFT_CONST(8)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_FIELD                    (_MK_MASK_CONST(0xff) << VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_SHIFT)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_RANGE                    15:8
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_WOFFSET                  0x0
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_COUNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//   Raise return channel
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_SHIFT                  _MK_SHIFT_CONST(16)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_FIELD                  (_MK_MASK_CONST(0xf) << VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_SHIFT)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_RANGE                  19:16
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_WOFFSET                        0x0
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_START_0_CSI_PPB_RAISE_FRAME_START_CHANNEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_CSI_PPB_RAISE_FRAME_END_0  // CSI Pixel Parser B Raise
#define VI_CSI_PPB_RAISE_FRAME_END_0                    _MK_ADDR_CONST(0x79)
#define VI_CSI_PPB_RAISE_FRAME_END_0_SECURE                     0x0
#define VI_CSI_PPB_RAISE_FRAME_END_0_WORD_COUNT                         0x1
#define VI_CSI_PPB_RAISE_FRAME_END_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_READ_MASK                  _MK_MASK_CONST(0xfff1f)
#define VI_CSI_PPB_RAISE_FRAME_END_0_WRITE_MASK                         _MK_MASK_CONST(0xfff1f)
//   Raise returned by VI when CSI PPB
//   issues a frame end to consumer.
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_FIELD                       (_MK_MASK_CONST(0x1f) << VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_SHIFT)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_RANGE                       4:0
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_WOFFSET                     0x0
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//   Number of frame end since last raise >= count for raise to be returned
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_SHIFT                        _MK_SHIFT_CONST(8)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_FIELD                        (_MK_MASK_CONST(0xff) << VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_SHIFT)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_RANGE                        15:8
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_WOFFSET                      0x0
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//   Raise return channel
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_SHIFT                      _MK_SHIFT_CONST(16)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_FIELD                      (_MK_MASK_CONST(0xf) << VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_SHIFT)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_RANGE                      19:16
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_WOFFSET                    0x0
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_RAISE_FRAME_END_0_CSI_PPB_RAISE_FRAME_END_CHANNEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// This register defines the horizontal captured (active) area of the input video source with respect to
//  horizontal sync. (This is for CSI data.)

// Register VI_CSI_PPA_H_ACTIVE_0  // VI Horizontal Active
#define VI_CSI_PPA_H_ACTIVE_0                   _MK_ADDR_CONST(0x7a)
#define VI_CSI_PPA_H_ACTIVE_0_SECURE                    0x0
#define VI_CSI_PPA_H_ACTIVE_0_WORD_COUNT                        0x1
#define VI_CSI_PPA_H_ACTIVE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_READ_MASK                         _MK_MASK_CONST(0x1fff1fff)
#define VI_CSI_PPA_H_ACTIVE_0_WRITE_MASK                        _MK_MASK_CONST(0x1fff1fff)
// Horizontal Active Start (offset to active)
//  This parameter specifies the number of
//  clock active edges from horizontal
//  sync active edge to the first horizontal
//  active pixel. If programmed to 0, the
//  first active line starts after the first
//  active clock edge following the horizontal
//  sync active edge.
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_SHIFT)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_RANGE                      12:0
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_WOFFSET                    0x0
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Horizontal Active Period
//  This parameter specifies the number of
//  pixels in the horizontal active area.
//  H_ACTIVE_START + H_ACTIVE_PERIOD should be
//  less than 2^NV_VI_H_IN (or 8192). This parameter
//  should be programmed with an even number
//  (bit 16 is ignored internally).
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_SHIFT)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_RANGE                     28:16
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_H_ACTIVE_0_CSI_PPA_H_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// This register defines the vertical captured (active) area of the input video source with respect to
//  vertical sync. (This is for CSI data.)

// Register VI_CSI_PPA_V_ACTIVE_0  // Vertical Active
#define VI_CSI_PPA_V_ACTIVE_0                   _MK_ADDR_CONST(0x7b)
#define VI_CSI_PPA_V_ACTIVE_0_SECURE                    0x0
#define VI_CSI_PPA_V_ACTIVE_0_WORD_COUNT                        0x1
#define VI_CSI_PPA_V_ACTIVE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_READ_MASK                         _MK_MASK_CONST(0x1fff1fff)
#define VI_CSI_PPA_V_ACTIVE_0_WRITE_MASK                        _MK_MASK_CONST(0x1fff1fff)
// Vertical Active Start (offset to active)
//  This parameter specifies the number of
//  horizontal sync active edges from vertical
//  sync active edge to the first vertical
//  active line. If programmed to 0, the
//  first active line starts after the first
//  horizontal sync active edge following
//  the vertical sync active edge.
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_SHIFT)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_RANGE                      12:0
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_WOFFSET                    0x0
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Vertical Active Period
//  This parameter specifies the number of
//  lines in the vertical active area.
//  V_ACTIVE_START + V_ACTIVE_PERIOD should be
//  less than 2^NV_VI_V_IN (or 8192).
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_SHIFT)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_RANGE                     28:16
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPA_V_ACTIVE_0_CSI_PPA_V_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// This register defines the horizontal captured (active) area of the input video source with respect to
//  horizontal sync. (This is for CSI data.)

// Register VI_CSI_PPB_H_ACTIVE_0  // VI Horizontal Active
#define VI_CSI_PPB_H_ACTIVE_0                   _MK_ADDR_CONST(0x7c)
#define VI_CSI_PPB_H_ACTIVE_0_SECURE                    0x0
#define VI_CSI_PPB_H_ACTIVE_0_WORD_COUNT                        0x1
#define VI_CSI_PPB_H_ACTIVE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_READ_MASK                         _MK_MASK_CONST(0x1fff1fff)
#define VI_CSI_PPB_H_ACTIVE_0_WRITE_MASK                        _MK_MASK_CONST(0x1fff1fff)
// Horizontal Active Start (offset to active)
//  This parameter specifies the number of
//  clock active edges from horizontal
//  sync active edge to the first horizontal
//  active pixel. If programmed to 0, the
//  first active line starts after the first
//  active clock edge following the horizontal
//  sync active edge.
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_SHIFT)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_RANGE                      12:0
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_WOFFSET                    0x0
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Horizontal Active Period
//  This parameter specifies the number of
//  pixels in the horizontal active area.
//  H_ACTIVE_START + H_ACTIVE_PERIOD should be
//  less than 2^NV_VI_H_IN (or 8192). This parameter
//  should be programmed with an even number
//  (bit 16 is ignored internally).
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_SHIFT)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_RANGE                     28:16
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_H_ACTIVE_0_CSI_PPB_H_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// This register defines the vertical captured (active) area of the input video source with respect to
//  vertical sync. (This is for CSI data.)

// Register VI_CSI_PPB_V_ACTIVE_0  // Vertical Active
#define VI_CSI_PPB_V_ACTIVE_0                   _MK_ADDR_CONST(0x7d)
#define VI_CSI_PPB_V_ACTIVE_0_SECURE                    0x0
#define VI_CSI_PPB_V_ACTIVE_0_WORD_COUNT                        0x1
#define VI_CSI_PPB_V_ACTIVE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_READ_MASK                         _MK_MASK_CONST(0x1fff1fff)
#define VI_CSI_PPB_V_ACTIVE_0_WRITE_MASK                        _MK_MASK_CONST(0x1fff1fff)
// Vertical Active Start (offset to active)
//  This parameter specifies the number of
//  horizontal sync active edges from vertical
//  sync active edge to the first vertical
//  active line. If programmed to 0, the
//  first active line starts after the first
//  horizontal sync active edge following
//  the vertical sync active edge.
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_FIELD                      (_MK_MASK_CONST(0x1fff) << VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_SHIFT)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_RANGE                      12:0
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_WOFFSET                    0x0
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Vertical Active Period
//  This parameter specifies the number of
//  lines in the vertical active area.
//  V_ACTIVE_START + V_ACTIVE_PERIOD should be
//  less than 2^NV_VI_V_IN (or 8192).
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(16)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_SHIFT)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_RANGE                     28:16
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_CSI_PPB_V_ACTIVE_0_CSI_PPB_V_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Used only with input from ISP: defines input image horizontal size in pixels

// Register VI_ISP_H_ACTIVE_0  // Used when an image comes from ISP
#define VI_ISP_H_ACTIVE_0                       _MK_ADDR_CONST(0x7e)
#define VI_ISP_H_ACTIVE_0_SECURE                        0x0
#define VI_ISP_H_ACTIVE_0_WORD_COUNT                    0x1
#define VI_ISP_H_ACTIVE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_READ_MASK                     _MK_MASK_CONST(0x1fff)
#define VI_ISP_H_ACTIVE_0_WRITE_MASK                    _MK_MASK_CONST(0x1fff)
// Horizontal image size in pixels coming out of ISP.
// Must be an even number (bit 0 is ignored).
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_SHIFT)
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_RANGE                     12:0
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_ISP_H_ACTIVE_0_ISP_H_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Used only with input from ISP: defines input image vertical size in lines

// Register VI_ISP_V_ACTIVE_0  // Used when an image comes from ISP
#define VI_ISP_V_ACTIVE_0                       _MK_ADDR_CONST(0x7f)
#define VI_ISP_V_ACTIVE_0_SECURE                        0x0
#define VI_ISP_V_ACTIVE_0_WORD_COUNT                    0x1
#define VI_ISP_V_ACTIVE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_READ_MASK                     _MK_MASK_CONST(0x1fff)
#define VI_ISP_V_ACTIVE_0_WRITE_MASK                    _MK_MASK_CONST(0x1fff)
// Vertical image size in lines coming out of ISP.
// Must be an even number (bit 0 is ignored).
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_SHIFT)
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_RANGE                     12:0
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_WOFFSET                   0x0
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_ISP_V_ACTIVE_0_ISP_V_ACTIVE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Stream raises ("safe to reprogram VI" raises)
// The I/O resources used by a data stream going through VI are indicated in STREAM_?_RESOURCE_DEFINE register.
// Once resources are set in this register,
// and after the start of the following picture,
// when ALL the stream's resources are done and idle processing that picture,
// a raise will be generated.
// It is then safe to reprogram VI's functional units involved in processing that stream.
//
// Two simultaneous data streams are supported, and they don't have to be mutually exclusive.
//
// When no resources are indicated for a stream, no raise is generated.

// Register VI_STREAM_1_RESOURCE_DEFINE_0  // defines resources used by stream 1.
// Field definition is: 0 = resource not used; 1 = resource used.
#define VI_STREAM_1_RESOURCE_DEFINE_0                   _MK_ADDR_CONST(0x80)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECURE                    0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_WORD_COUNT                        0x1
#define VI_STREAM_1_RESOURCE_DEFINE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_RESET_MASK                        _MK_MASK_CONST(0xfff)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_READ_MASK                         _MK_MASK_CONST(0xfff)
#define VI_STREAM_1_RESOURCE_DEFINE_0_WRITE_MASK                        _MK_MASK_CONST(0xfff)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_FIELD                 (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_RANGE                 0:0
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_WOFFSET                       0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_NOT_USED                      _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_VIP_INPUT_1_USED                  _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_SHIFT                        _MK_SHIFT_CONST(1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_FIELD                        (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_RANGE                        1:1
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_WOFFSET                      0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_NOT_USED                     _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_INPUT_1_USED                 _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_SHIFT                     _MK_SHIFT_CONST(2)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_RANGE                     2:2
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_WOFFSET                   0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_1_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_SHIFT                   _MK_SHIFT_CONST(3)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_FIELD                   (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_RANGE                   3:3
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_WOFFSET                 0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_NOT_USED                        _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_1_USED                    _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_RANGE                     4:4
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_WOFFSET                   0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_1_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_SHIFT                   _MK_SHIFT_CONST(5)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_FIELD                   (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_RANGE                   5:5
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_WOFFSET                 0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_NOT_USED                        _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_1_USED                    _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_SHIFT                 _MK_SHIFT_CONST(6)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_FIELD                 (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_RANGE                 6:6
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_WOFFSET                       0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_NOT_USED                      _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_ISP_INPUT_1_USED                  _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_SHIFT                      _MK_SHIFT_CONST(7)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_FIELD                      (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_RANGE                      7:7
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_WOFFSET                    0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_NOT_USED                   _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_FIRST_OUTPUT_1_USED                       _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_RANGE                     8:8
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_WOFFSET                   0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_SECOND_OUTPUT_1_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_SHIFT                     _MK_SHIFT_CONST(9)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_RANGE                     9:9
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_WOFFSET                   0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_1_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_SHIFT                        _MK_SHIFT_CONST(10)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_FIELD                        (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_RANGE                        10:10
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_WOFFSET                      0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_NOT_USED                     _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_EPP_OUTPUT_1_USED                 _MK_ENUM_CONST(1)

#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_SHIFT                    _MK_SHIFT_CONST(11)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_FIELD                    (_MK_MASK_CONST(0x1) << VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_SHIFT)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_RANGE                    11:11
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_WOFFSET                  0x0
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_NOT_USED                 _MK_ENUM_CONST(0)
#define VI_STREAM_1_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_1_USED                     _MK_ENUM_CONST(1)


// Register VI_STREAM_2_RESOURCE_DEFINE_0  // defines resources used by stream 2.
// Field definition is: 0 = resource not used; 1 = resource used.
#define VI_STREAM_2_RESOURCE_DEFINE_0                   _MK_ADDR_CONST(0x81)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECURE                    0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_WORD_COUNT                        0x1
#define VI_STREAM_2_RESOURCE_DEFINE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_RESET_MASK                        _MK_MASK_CONST(0xfff)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_READ_MASK                         _MK_MASK_CONST(0xfff)
#define VI_STREAM_2_RESOURCE_DEFINE_0_WRITE_MASK                        _MK_MASK_CONST(0xfff)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_SHIFT                 _MK_SHIFT_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_FIELD                 (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_RANGE                 0:0
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_WOFFSET                       0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_NOT_USED                      _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_VIP_INPUT_2_USED                  _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_SHIFT                        _MK_SHIFT_CONST(1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_FIELD                        (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_RANGE                        1:1
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_WOFFSET                      0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_NOT_USED                     _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_INPUT_2_USED                 _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_SHIFT                     _MK_SHIFT_CONST(2)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_RANGE                     2:2
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_WOFFSET                   0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_CROPPED_INPUT_2_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_SHIFT                   _MK_SHIFT_CONST(3)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_FIELD                   (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_RANGE                   3:3
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_WOFFSET                 0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_NOT_USED                        _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPA_UNCROPPED_INPUT_2_USED                    _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_RANGE                     4:4
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_WOFFSET                   0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_CROPPED_INPUT_2_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_SHIFT                   _MK_SHIFT_CONST(5)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_FIELD                   (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_RANGE                   5:5
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_WOFFSET                 0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_NOT_USED                        _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_CSI_PPB_UNCROPPED_INPUT_2_USED                    _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_SHIFT                 _MK_SHIFT_CONST(6)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_FIELD                 (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_RANGE                 6:6
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_WOFFSET                       0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_NOT_USED                      _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_ISP_INPUT_2_USED                  _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_SHIFT                      _MK_SHIFT_CONST(7)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_FIELD                      (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_RANGE                      7:7
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_WOFFSET                    0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_NOT_USED                   _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_FIRST_OUTPUT_2_USED                       _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_RANGE                     8:8
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_WOFFSET                   0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_SECOND_OUTPUT_2_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_SHIFT                     _MK_SHIFT_CONST(9)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_FIELD                     (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_RANGE                     9:9
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_WOFFSET                   0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_NOT_USED                  _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_VSYNC_OUTPUT_2_USED                      _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_SHIFT                        _MK_SHIFT_CONST(10)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_FIELD                        (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_RANGE                        10:10
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_WOFFSET                      0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_NOT_USED                     _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_EPP_OUTPUT_2_USED                 _MK_ENUM_CONST(1)

#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_SHIFT                    _MK_SHIFT_CONST(11)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_FIELD                    (_MK_MASK_CONST(0x1) << VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_SHIFT)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_RANGE                    11:11
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_WOFFSET                  0x0
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_NOT_USED                 _MK_ENUM_CONST(0)
#define VI_STREAM_2_RESOURCE_DEFINE_0_HOST_DMA_BUFFER_OUTPUT_2_USED                     _MK_ENUM_CONST(1)


// Register VI_RAISE_STREAM_1_DONE_0  // raise vector when all stream 1 resources,
// as defined by STREAM_1_RESOURCE_DEFINE register,
// become idle after the start of the following frame.
#define VI_RAISE_STREAM_1_DONE_0                        _MK_ADDR_CONST(0x82)
#define VI_RAISE_STREAM_1_DONE_0_SECURE                         0x0
#define VI_RAISE_STREAM_1_DONE_0_WORD_COUNT                     0x1
#define VI_RAISE_STREAM_1_DONE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_READ_MASK                      _MK_MASK_CONST(0x1f)
#define VI_RAISE_STREAM_1_DONE_0_WRITE_MASK                     _MK_MASK_CONST(0xf001f)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_FIELD                    (_MK_MASK_CONST(0x1f) << VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_SHIFT)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_RANGE                    4:0
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_WOFFSET                  0x0
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_VECTOR_STREAM_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_FIELD                   (_MK_MASK_CONST(0xf) << VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_SHIFT)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_RANGE                   19:16
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_WOFFSET                 0x0
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_1_DONE_0_RAISE_CHANNEL_STREAM_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register VI_RAISE_STREAM_2_DONE_0  // raise vector when all stream 2 resources,
// as defined by STREAM_2_RESOURCE_DEFINE register,
// become idle after the start of the following frame
#define VI_RAISE_STREAM_2_DONE_0                        _MK_ADDR_CONST(0x83)
#define VI_RAISE_STREAM_2_DONE_0_SECURE                         0x0
#define VI_RAISE_STREAM_2_DONE_0_WORD_COUNT                     0x1
#define VI_RAISE_STREAM_2_DONE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_READ_MASK                      _MK_MASK_CONST(0x1f)
#define VI_RAISE_STREAM_2_DONE_0_WRITE_MASK                     _MK_MASK_CONST(0xf001f)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_FIELD                    (_MK_MASK_CONST(0x1f) << VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_SHIFT)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_RANGE                    4:0
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_WOFFSET                  0x0
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_VECTOR_STREAM_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_SHIFT                   _MK_SHIFT_CONST(16)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_FIELD                   (_MK_MASK_CONST(0xf) << VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_SHIFT)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_RANGE                   19:16
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_WOFFSET                 0x0
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_RAISE_STREAM_2_DONE_0_RAISE_CHANNEL_STREAM_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// ISDB-T tuner mode register set
//   tuner/demodulator mode.

// Register VI_TS_MODE_0  // ISDB-T mode selection register
#define VI_TS_MODE_0                    _MK_ADDR_CONST(0x84)
#define VI_TS_MODE_0_SECURE                     0x0
#define VI_TS_MODE_0_WORD_COUNT                         0x1
#define VI_TS_MODE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_READ_MASK                  _MK_MASK_CONST(0x3f)
#define VI_TS_MODE_0_WRITE_MASK                         _MK_MASK_CONST(0x3f)
// This field indicates the global enable for ISDB-T protocol handling
#define VI_TS_MODE_0_ENABLE_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_TS_MODE_0_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << VI_TS_MODE_0_ENABLE_SHIFT)
#define VI_TS_MODE_0_ENABLE_RANGE                       0:0
#define VI_TS_MODE_0_ENABLE_WOFFSET                     0x0
#define VI_TS_MODE_0_ENABLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_ENABLE_DISABLED                    _MK_ENUM_CONST(0)
#define VI_TS_MODE_0_ENABLE_ENABLED                     _MK_ENUM_CONST(1)

// This field determines if input data is in serial or parallel format
#define VI_TS_MODE_0_INPUT_MODE_SHIFT                   _MK_SHIFT_CONST(1)
#define VI_TS_MODE_0_INPUT_MODE_FIELD                   (_MK_MASK_CONST(0x1) << VI_TS_MODE_0_INPUT_MODE_SHIFT)
#define VI_TS_MODE_0_INPUT_MODE_RANGE                   1:1
#define VI_TS_MODE_0_INPUT_MODE_WOFFSET                 0x0
#define VI_TS_MODE_0_INPUT_MODE_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_INPUT_MODE_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_INPUT_MODE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_INPUT_MODE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_INPUT_MODE_PARALLEL                        _MK_ENUM_CONST(0)
#define VI_TS_MODE_0_INPUT_MODE_SERIAL                  _MK_ENUM_CONST(1)

// This field selected the pin configuration used for VD[1]  NONE:     TS_ERROR is tied to 0
//            TS_PSYNC is tied to 0
//  TS_ERROR: TS_ERROR is on VD[1]
//            TS_PSYNC is tied to 0
//  TS_PSYNC: TS_ERROR is tied to 0
//            TS_PSYNC is on VD[1]
#define VI_TS_MODE_0_PROTOCOL_SELECT_SHIFT                      _MK_SHIFT_CONST(2)
#define VI_TS_MODE_0_PROTOCOL_SELECT_FIELD                      (_MK_MASK_CONST(0x3) << VI_TS_MODE_0_PROTOCOL_SELECT_SHIFT)
#define VI_TS_MODE_0_PROTOCOL_SELECT_RANGE                      3:2
#define VI_TS_MODE_0_PROTOCOL_SELECT_WOFFSET                    0x0
#define VI_TS_MODE_0_PROTOCOL_SELECT_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_PROTOCOL_SELECT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_PROTOCOL_SELECT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_PROTOCOL_SELECT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_PROTOCOL_SELECT_NONE                       _MK_ENUM_CONST(0)
#define VI_TS_MODE_0_PROTOCOL_SELECT_TS_ERROR                   _MK_ENUM_CONST(1)
#define VI_TS_MODE_0_PROTOCOL_SELECT_TS_PSYNC                   _MK_ENUM_CONST(2)
#define VI_TS_MODE_0_PROTOCOL_SELECT_RESERVED                   _MK_ENUM_CONST(3)

// This field selects the buffer flow control for the Write DMA RDMA:      The RDMA engine will release the buffers back to the WDMA
//            as the buffers are consumed
// NONE:      The VI will automatically release the buffer back to the
//            WMDA after each buffer ready is generated.
// CPU:       SW needs to write the TS_CPU_FLOW_CTL register to release
//            each buffer to the WDMA
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_SHIFT                    _MK_SHIFT_CONST(4)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_FIELD                    (_MK_MASK_CONST(0x3) << VI_TS_MODE_0_FLOW_CONTROL_MODE_SHIFT)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_RANGE                    5:4
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_WOFFSET                  0x0
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_RDMA                     _MK_ENUM_CONST(0)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_NONE                     _MK_ENUM_CONST(1)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_CPU                      _MK_ENUM_CONST(2)
#define VI_TS_MODE_0_FLOW_CONTROL_MODE_RESERVED                 _MK_ENUM_CONST(3)


// Register VI_TS_CONTROL_0  // ISDB-T mode control register
#define VI_TS_CONTROL_0                 _MK_ADDR_CONST(0x85)
#define VI_TS_CONTROL_0_SECURE                  0x0
#define VI_TS_CONTROL_0_WORD_COUNT                      0x1
#define VI_TS_CONTROL_0_RESET_VAL                       _MK_MASK_CONST(0x8)
#define VI_TS_CONTROL_0_RESET_MASK                      _MK_MASK_CONST(0x8)
#define VI_TS_CONTROL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_READ_MASK                       _MK_MASK_CONST(0x7fff00ff)
#define VI_TS_CONTROL_0_WRITE_MASK                      _MK_MASK_CONST(0x7fff00ff)
// This field indicates the polarity of TS_VALID. Only has affect when TS_MODE.ENABLE == ENABLED    LOW indicates that the polarity of TS_VALID is active low.
//    HIGH indicates that the polarity of TS_VALID is active high.
#define VI_TS_CONTROL_0_VALID_POLARITY_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_TS_CONTROL_0_VALID_POLARITY_FIELD                    (_MK_MASK_CONST(0x1) << VI_TS_CONTROL_0_VALID_POLARITY_SHIFT)
#define VI_TS_CONTROL_0_VALID_POLARITY_RANGE                    0:0
#define VI_TS_CONTROL_0_VALID_POLARITY_WOFFSET                  0x0
#define VI_TS_CONTROL_0_VALID_POLARITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_VALID_POLARITY_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_VALID_POLARITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_VALID_POLARITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_VALID_POLARITY_HIGH                     _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_VALID_POLARITY_LOW                      _MK_ENUM_CONST(1)

#define VI_TS_CONTROL_0_PSYNC_POLARITY_SHIFT                    _MK_SHIFT_CONST(1)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_FIELD                    (_MK_MASK_CONST(0x1) << VI_TS_CONTROL_0_PSYNC_POLARITY_SHIFT)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_RANGE                    1:1
#define VI_TS_CONTROL_0_PSYNC_POLARITY_WOFFSET                  0x0
#define VI_TS_CONTROL_0_PSYNC_POLARITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_HIGH                     _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_PSYNC_POLARITY_LOW                      _MK_ENUM_CONST(1)

#define VI_TS_CONTROL_0_ERROR_POLARITY_SHIFT                    _MK_SHIFT_CONST(2)
#define VI_TS_CONTROL_0_ERROR_POLARITY_FIELD                    (_MK_MASK_CONST(0x1) << VI_TS_CONTROL_0_ERROR_POLARITY_SHIFT)
#define VI_TS_CONTROL_0_ERROR_POLARITY_RANGE                    2:2
#define VI_TS_CONTROL_0_ERROR_POLARITY_WOFFSET                  0x0
#define VI_TS_CONTROL_0_ERROR_POLARITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_ERROR_POLARITY_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_ERROR_POLARITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_ERROR_POLARITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_ERROR_POLARITY_HIGH                     _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_ERROR_POLARITY_LOW                      _MK_ENUM_CONST(1)

#define VI_TS_CONTROL_0_CLK_POLARITY_SHIFT                      _MK_SHIFT_CONST(3)
#define VI_TS_CONTROL_0_CLK_POLARITY_FIELD                      (_MK_MASK_CONST(0x1) << VI_TS_CONTROL_0_CLK_POLARITY_SHIFT)
#define VI_TS_CONTROL_0_CLK_POLARITY_RANGE                      3:3
#define VI_TS_CONTROL_0_CLK_POLARITY_WOFFSET                    0x0
#define VI_TS_CONTROL_0_CLK_POLARITY_DEFAULT                    _MK_MASK_CONST(0x1)
#define VI_TS_CONTROL_0_CLK_POLARITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_TS_CONTROL_0_CLK_POLARITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_CLK_POLARITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_CLK_POLARITY_INIT_ENUM                  LOW
#define VI_TS_CONTROL_0_CLK_POLARITY_HIGH                       _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_CLK_POLARITY_LOW                        _MK_ENUM_CONST(1)

// This field defines how the START of packet condition is determined  PSYNC: PSYNC assertion rising edge
//  VALID: VALID assertion rising edge
//  BOTH:  PSYNC && VALID asserted rising edge
#define VI_TS_CONTROL_0_START_SELECT_SHIFT                      _MK_SHIFT_CONST(4)
#define VI_TS_CONTROL_0_START_SELECT_FIELD                      (_MK_MASK_CONST(0x3) << VI_TS_CONTROL_0_START_SELECT_SHIFT)
#define VI_TS_CONTROL_0_START_SELECT_RANGE                      5:4
#define VI_TS_CONTROL_0_START_SELECT_WOFFSET                    0x0
#define VI_TS_CONTROL_0_START_SELECT_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_START_SELECT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_START_SELECT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_START_SELECT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_START_SELECT_RESERVED                   _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_START_SELECT_PSYNC                      _MK_ENUM_CONST(1)
#define VI_TS_CONTROL_0_START_SELECT_VALID                      _MK_ENUM_CONST(2)
#define VI_TS_CONTROL_0_START_SELECT_BOTH                       _MK_ENUM_CONST(3)

// This field determines if VALID is used during BODY packet capture  IGNORE: the VALID signal is ignored during the capture
//  GATE: the VALID signal gates the capture of BODY data.
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_SHIFT                 _MK_SHIFT_CONST(6)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_FIELD                 (_MK_MASK_CONST(0x1) << VI_TS_CONTROL_0_BODY_VALID_SELECT_SHIFT)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_RANGE                 6:6
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_WOFFSET                       0x0
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_IGNORE                        _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_BODY_VALID_SELECT_GATE                  _MK_ENUM_CONST(1)

// This field determines is VI should store packets to memory that have been flagged as UPSTREAM_ERROR packets.
//  DISCARD: Do not store packets in memory
//  STORE:   Store UPSTREAM_ERROR packets in memory
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_SHIFT                 _MK_SHIFT_CONST(7)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_FIELD                 (_MK_MASK_CONST(0x1) << VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_SHIFT)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_RANGE                 7:7
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_WOFFSET                       0x0
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_DISCARD                       _MK_ENUM_CONST(0)
#define VI_TS_CONTROL_0_STORE_UPSTREAM_ERROR_PKTS_STORE                 _MK_ENUM_CONST(1)

// This field stores the number of BODY bytes to capture (including PSYNC)
#define VI_TS_CONTROL_0_BODY_SIZE_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_TS_CONTROL_0_BODY_SIZE_FIELD                 (_MK_MASK_CONST(0xff) << VI_TS_CONTROL_0_BODY_SIZE_SHIFT)
#define VI_TS_CONTROL_0_BODY_SIZE_RANGE                 23:16
#define VI_TS_CONTROL_0_BODY_SIZE_WOFFSET                       0x0
#define VI_TS_CONTROL_0_BODY_SIZE_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_SIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_SIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_BODY_SIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This field stores the number of FEC bytes to catpure (after the BODY has been captured)
#define VI_TS_CONTROL_0_FEC_SIZE_SHIFT                  _MK_SHIFT_CONST(24)
#define VI_TS_CONTROL_0_FEC_SIZE_FIELD                  (_MK_MASK_CONST(0x7f) << VI_TS_CONTROL_0_FEC_SIZE_SHIFT)
#define VI_TS_CONTROL_0_FEC_SIZE_RANGE                  30:24
#define VI_TS_CONTROL_0_FEC_SIZE_WOFFSET                        0x0
#define VI_TS_CONTROL_0_FEC_SIZE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_FEC_SIZE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_FEC_SIZE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_TS_CONTROL_0_FEC_SIZE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register VI_TS_PACKET_COUNT_0  // ISDB-T packet count register
#define VI_TS_PACKET_COUNT_0                    _MK_ADDR_CONST(0x86)
#define VI_TS_PACKET_COUNT_0_SECURE                     0x0
#define VI_TS_PACKET_COUNT_0_WORD_COUNT                         0x1
#define VI_TS_PACKET_COUNT_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_READ_MASK                  _MK_MASK_CONST(0x1ffff)
#define VI_TS_PACKET_COUNT_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// This field holds the current value of the received packet counter.  This counter increments
// in the presence of a new packet, regardless of whether it is flagged as an error
// The counter can be cleared by writing this register with 0's and can also
// be preloaded to any value by writing the preload value to the register.
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_FIELD                        (_MK_MASK_CONST(0xffff) << VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_SHIFT)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_RANGE                        15:0
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_WOFFSET                      0x0
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// This field is set to OVERFLOW when VALUE passes from 0xFFFF to 0x0000. It stays high until the CPU writes a zero to this bit to reset it.
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_SHIFT                       _MK_SHIFT_CONST(16)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_FIELD                       (_MK_MASK_CONST(0x1) << VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_SHIFT)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_RANGE                       16:16
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_WOFFSET                     0x0
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_NONE                        _MK_ENUM_CONST(0)
#define VI_TS_PACKET_COUNT_0_TS_PACKET_COUNT_VALUE_OVERFLOW_OVERFLOW                    _MK_ENUM_CONST(1)


// Register VI_TS_ERROR_COUNT_0  // ISDB-T error count register
#define VI_TS_ERROR_COUNT_0                     _MK_ADDR_CONST(0x87)
#define VI_TS_ERROR_COUNT_0_SECURE                      0x0
#define VI_TS_ERROR_COUNT_0_WORD_COUNT                  0x1
#define VI_TS_ERROR_COUNT_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_READ_MASK                   _MK_MASK_CONST(0x1ffff)
#define VI_TS_ERROR_COUNT_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// This field holds the current value of the error packet counter.  This counter increments in the
// presence of a packet flagged as error (see TS_ERROR)0000 or a detected protocol violation.
// The counter can be cleared by writing this register with 0's and can also
// be preloaded to any value by writing the preload value to the register.
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_SHIFT                  _MK_SHIFT_CONST(0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_FIELD                  (_MK_MASK_CONST(0xffff) << VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_SHIFT)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_RANGE                  15:0
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_WOFFSET                        0x0
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// This field is set to OVEFLOW when VALUE passes from 0xFFFF to 0x0000. It stays high until the CPU writes a zero to this bit to reset it.
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_SHIFT                 _MK_SHIFT_CONST(16)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_FIELD                 (_MK_MASK_CONST(0x1) << VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_SHIFT)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_RANGE                 16:16
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_WOFFSET                       0x0
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_NONE                  _MK_ENUM_CONST(0)
#define VI_TS_ERROR_COUNT_0_TS_ERROR_COUNT_VALUE_OVERFLOW_OVERFLOW                      _MK_ENUM_CONST(1)


// Register VI_TS_CPU_FLOW_CTL_0  // ISDB-T CPU flow control register
#define VI_TS_CPU_FLOW_CTL_0                    _MK_ADDR_CONST(0x88)
#define VI_TS_CPU_FLOW_CTL_0_SECURE                     0x0
#define VI_TS_CPU_FLOW_CTL_0_WORD_COUNT                         0x1
#define VI_TS_CPU_FLOW_CTL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define VI_TS_CPU_FLOW_CTL_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Used only when the FLOW_CONTROL_MODE register is set to CPU
// SW must write this register to release each buffer back to
// WDMA.  Failure to write this register when buffers are
// consumed will result in the WDMA stalling when it consumes all
// allocated/free buffers.
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_SHIFT                       _MK_SHIFT_CONST(0)
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_FIELD                       (_MK_MASK_CONST(0x1) << VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_SHIFT)
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_RANGE                       0:0
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_WOFFSET                     0x0
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_TS_CPU_FLOW_CTL_0_BUFFER_RELEASE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// We are using HOST_DMA_WRITE_BUFFER.BUFFER_SIZE (bytes) to hold the number of bytes in a buffer for ISDB-T mode.

// Register VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0  // Video Buffer Set 0 Chroma Buffer Stride.
// This feature was introduced in SC17,
// and represents an alternative value to using
// VB0_BUFFER_STRIDE_C.
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0                     _MK_ADDR_CONST(0x89)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_SECURE                      0x0
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_WORD_COUNT                  0x1
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_RESET_MASK                  _MK_MASK_CONST(0x80000000)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_READ_MASK                   _MK_MASK_CONST(0xbfffffff)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_WRITE_MASK                  _MK_MASK_CONST(0xbfffffff)
// Chroma buffer stride in bytes
// 30 reserved
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_FIELD                      (_MK_MASK_CONST(0x3fffffff) << VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SHIFT)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_RANGE                      29:0
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_WOFFSET                    0x0
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// select type of Chroma buffer stride: 0 = Use VB0_BUFFER_STRIDE_C, deriving chroma
// buffer stride from luma buffer stride
// (default and backward compatible to SC15).
// 1 = Use VB0_CHROMA_BUFFER_STRIDE.
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_SHIFT                       _MK_SHIFT_CONST(31)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_FIELD                       (_MK_MASK_CONST(0x1) << VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_SHIFT)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_RANGE                       31:31
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_WOFFSET                     0x0
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_RATIO                       _MK_ENUM_CONST(0)
#define VI_VB0_CHROMA_BUFFER_STRIDE_FIRST_0_VB0_CHROMA_BUFFER_STRIDE_SELECT_VALUE                       _MK_ENUM_CONST(1)


// Register VI_VB0_CHROMA_LINE_STRIDE_FIRST_0  // Video Buffer Set 0 chroma line stride for First Output of planar YUV formats
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0                       _MK_ADDR_CONST(0x8a)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_SECURE                        0x0
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_WORD_COUNT                    0x1
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_RESET_MASK                    _MK_MASK_CONST(0x80000000)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_READ_MASK                     _MK_MASK_CONST(0x80001fff)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_WRITE_MASK                    _MK_MASK_CONST(0x80001fff)
// Video Buffer Set 0 chroma horizontal size
//  This parameter specifies the chroma line stride
//  (in pixels) for lines in the video buffer
//  set 0.
//  this parameter
//  must be programmed as multiple of 4 pixels
//  (bits 1-0 are ignored).
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_FIELD                     (_MK_MASK_CONST(0x1fff) << VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_SHIFT)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_RANGE                     12:0
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_WOFFSET                   0x0
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_H_SIZE_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// select type of Chroma line stride: 0 = Use VB0_H_SIZE_1, deriving chroma line stride from luma line stride (default and backward compatible to SC15).
// 1 = Use VB0_CHROMA_H_SIZE_1.
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_SHIFT                   _MK_SHIFT_CONST(31)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_FIELD                   (_MK_MASK_CONST(0x1) << VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_SHIFT)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_RANGE                   31:31
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_WOFFSET                 0x0
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_RATIO                   _MK_ENUM_CONST(0)
#define VI_VB0_CHROMA_LINE_STRIDE_FIRST_0_VB0_CHROMA_LINE_STRIDE_SELECT_VALUE                   _MK_ENUM_CONST(1)

// this reg. is used for VI2EPP syncpt only.
// VI will based on num_lines = frame_height/EPP_NUM_OF_BUFFER_PER_FRAME,
// send vi2epp_trigger for every num_lines

// Register VI_EPP_LINES_PER_BUFFER_0  // number of buffers per output frame in EPP
#define VI_EPP_LINES_PER_BUFFER_0                       _MK_ADDR_CONST(0x8b)
#define VI_EPP_LINES_PER_BUFFER_0_SECURE                        0x0
#define VI_EPP_LINES_PER_BUFFER_0_WORD_COUNT                    0x1
#define VI_EPP_LINES_PER_BUFFER_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_READ_MASK                     _MK_MASK_CONST(0x1fff)
#define VI_EPP_LINES_PER_BUFFER_0_WRITE_MASK                    _MK_MASK_CONST(0x1fff)
// maximum 256 buffers per frame.
// linesPerBuffer = FLOOR(eppLineCount/eppBufferCount)
// linesPerBuffer must be > 2
// eppLineCount must take into account any cropping in EPP.
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_FIELD                        (_MK_MASK_CONST(0x1fff) << VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_SHIFT)
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_RANGE                        12:0
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_WOFFSET                      0x0
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_EPP_LINES_PER_BUFFER_0_LINES_PER_BUFFER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_BUFFER_RELEASE_OUTPUT1_0  // write to this register will decrease
// BUFFER_COUNTER by 1
#define VI_BUFFER_RELEASE_OUTPUT1_0                     _MK_ADDR_CONST(0x8c)
#define VI_BUFFER_RELEASE_OUTPUT1_0_SECURE                      0x0
#define VI_BUFFER_RELEASE_OUTPUT1_0_WORD_COUNT                  0x1
#define VI_BUFFER_RELEASE_OUTPUT1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define VI_BUFFER_RELEASE_OUTPUT1_0_WRITE_MASK                  _MK_MASK_CONST(0x1)
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_FIELD                        (_MK_MASK_CONST(0x1) << VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_SHIFT)
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_RANGE                        0:0
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_WOFFSET                      0x0
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT1_0_BUFFER_RELEASE_OUTPUT1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_BUFFER_RELEASE_OUTPUT2_0  
#define VI_BUFFER_RELEASE_OUTPUT2_0                     _MK_ADDR_CONST(0x8d)
#define VI_BUFFER_RELEASE_OUTPUT2_0_SECURE                      0x0
#define VI_BUFFER_RELEASE_OUTPUT2_0_WORD_COUNT                  0x1
#define VI_BUFFER_RELEASE_OUTPUT2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define VI_BUFFER_RELEASE_OUTPUT2_0_WRITE_MASK                  _MK_MASK_CONST(0x1)
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_FIELD                        (_MK_MASK_CONST(0x1) << VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_SHIFT)
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_RANGE                        0:0
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_WOFFSET                      0x0
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_BUFFER_RELEASE_OUTPUT2_0_BUFFER_RELEASE_OUTPUT2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0  // this is a debug register
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0                 _MK_ADDR_CONST(0x8e)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_SECURE                  0x0
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_WORD_COUNT                      0x1
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_FIELD                      (_MK_MASK_CONST(0xff) << VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_SHIFT)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_RANGE                      7:0
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_WOFFSET                    0x0
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT1_0_BUFFER_COUNT_OUTPUT1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0  
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0                 _MK_ADDR_CONST(0x8f)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_SECURE                  0x0
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_WORD_COUNT                      0x1
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_FIELD                      (_MK_MASK_CONST(0xff) << VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_SHIFT)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_RANGE                      7:0
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_WOFFSET                    0x0
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_DEBUG_FLOW_CONTROL_COUNTER_OUTPUT2_0_BUFFER_COUNT_OUTPUT2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// register for SW to write to terminate MC BW

// Register VI_TERMINATE_BW_FIRST_0  // write to this register will terminate
// MC on BW operation in FIRST output.
#define VI_TERMINATE_BW_FIRST_0                 _MK_ADDR_CONST(0x90)
#define VI_TERMINATE_BW_FIRST_0_SECURE                  0x0
#define VI_TERMINATE_BW_FIRST_0_WORD_COUNT                      0x1
#define VI_TERMINATE_BW_FIRST_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define VI_TERMINATE_BW_FIRST_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_SHIFT                        _MK_SHIFT_CONST(0)
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_FIELD                        (_MK_MASK_CONST(0x1) << VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_SHIFT)
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_RANGE                        0:0
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_WOFFSET                      0x0
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_DEFAULT                      _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_FIRST_0_TERMINATE_FIRST_BW_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register VI_TERMINATE_BW_SECOND_0  // write to this register will terminate
// MC on BW operationn in SECOND output.
#define VI_TERMINATE_BW_SECOND_0                        _MK_ADDR_CONST(0x91)
#define VI_TERMINATE_BW_SECOND_0_SECURE                         0x0
#define VI_TERMINATE_BW_SECOND_0_WORD_COUNT                     0x1
#define VI_TERMINATE_BW_SECOND_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define VI_TERMINATE_BW_SECOND_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_FIELD                      (_MK_MASK_CONST(0x1) << VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_SHIFT)
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_RANGE                      0:0
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_WOFFSET                    0x0
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_TERMINATE_BW_SECOND_0_TERMINATE_SECOND_BW_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// --------------------------------------------------------------------------
//
// Copyright (c) 2004-2005, NVIDIA Corp.
// All Rights Reserved.
//
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
//
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
//
// --------------------------------------------------------------------------
//
// Memory Controller Tiling definitions
//
//
//  To enable tiling for a buffer in your module you'll want to include
//  this spec file and then make use of either the ADD_TILE_MODE_REG_SPEC
//  or ADD_TILE_MODE_REG_FIELD_SPEC macro.
//
//  For the ADD_TILE_MODE_REG_SPEC macro, the regp arg is added to the
//  register name as a prefix to match the names of the other registers
//  for this buffer. The fldp is the field name prefix to make the name
//  unique so it works with arreggen generated reg blocks (e.g.):
//
//      // specify how addressing should occur for IB0 buffer
//      ADD_TILE_MODE_REG_SPEC(IB0, IB0);
//
//  There's also a REG_RW_SPEC version, if you need to specify a special
//  flag (e.g. rws for shadow, or rwt for trigger).
//  
//  For the ADD_TILE_MODE_REG_FIELD_SPEC macro, the fldp is the field
//  name prefix and bitpos arg describes the starting bit position for
//  this field within another register.
//
//  Like the register version, there's a REG_RW_FIELD_SPEC version if
//  you need to set explicit bits other than "rw".
//
//  Note: this requires having at least NV_MC_TILE_MODEWIDTH bits of
//  space available after bitpos (e.g.) in the register:
//
//      ADD_TILE_MODE_REG_FIELD_SPEC(REF, 16)   // This parameter specifies how addressing
//                                              // for the REF buffer should occur
//

// Register VI_VB0_FIRST_BUFFER_ADDR_MODE_0  
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0                 _MK_ADDR_CONST(0x92)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_SECURE                  0x0
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_WORD_COUNT                      0x1
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_RESET_MASK                      _MK_MASK_CONST(0x101)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_READ_MASK                       _MK_MASK_CONST(0x101)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_WRITE_MASK                      _MK_MASK_CONST(0x101)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_FIELD                      (_MK_MASK_CONST(0x1) << VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_SHIFT)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_RANGE                      0:0
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_WOFFSET                    0x0
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_DEFAULT                    _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_LINEAR                     _MK_ENUM_CONST(0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_Y1_TILE_MODE_TILED                      _MK_ENUM_CONST(1)

#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_FIELD                     (_MK_MASK_CONST(0x1) << VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_SHIFT)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_RANGE                     8:8
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_WOFFSET                   0x0
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_LINEAR                    _MK_ENUM_CONST(0)
#define VI_VB0_FIRST_BUFFER_ADDR_MODE_0_UV1_TILE_MODE_TILED                     _MK_ENUM_CONST(1)


// Register VI_VB0_SECOND_BUFFER_ADDR_MODE_0  
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0                        _MK_ADDR_CONST(0x93)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_SECURE                         0x0
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_WORD_COUNT                     0x1
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_FIELD                     (_MK_MASK_CONST(0x1) << VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_SHIFT)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_RANGE                     0:0
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_WOFFSET                   0x0
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_LINEAR                    _MK_ENUM_CONST(0)
#define VI_VB0_SECOND_BUFFER_ADDR_MODE_0_Y2_TILE_MODE_TILED                     _MK_ENUM_CONST(1)

//VIP Pattern Generator:
// The VIP pattern generator is new as of AP15.  When enabled, it overrides the inputs from
// the attached camera with internally generated pattern data, hsyncs, and vsyncs.  The
// purpose of the pattern generator is to facilitate regression testing of the VI driver and
// hardware without constraining the board level design.
//
// The pattern generator logic runs on the pd2vi_clock domain.  See the clock controller spec
// for information on how to enable a loopback from the vi_sensor clock to the pd2vi_clock.
//
// The user must program the pattern width, pattern height, and bayer select registers prior to
// enabling the pattern generator.  It is  illegal to change the values of those registers
// without first disabling the pattern generator.
//
// The pattern generator has no concept of blanking time.  The width and the height of the
// pattern should correspond to the full hblank+hactive and vblank+vactive
//

// Register VI_RESERVE_0_0  // reserved register for emergency ...
// bits[13:0] are reserved for
// VIP Pattern Gen (Pattern Width)
#define VI_RESERVE_0_0                  _MK_ADDR_CONST(0x94)
#define VI_RESERVE_0_0_SECURE                   0x0
#define VI_RESERVE_0_0_WORD_COUNT                       0x1
#define VI_RESERVE_0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_RESERVE_0_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
//  Program to *one less* than the desired
#define VI_RESERVE_0_0_nc_RESERVE_0_0_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_RESERVE_0_0_nc_RESERVE_0_0_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_0_0_nc_RESERVE_0_0_SHIFT)
#define VI_RESERVE_0_0_nc_RESERVE_0_0_RANGE                     3:0
#define VI_RESERVE_0_0_nc_RESERVE_0_0_WOFFSET                   0x0
#define VI_RESERVE_0_0_nc_RESERVE_0_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_0_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  pattern width in clocks. (note that
#define VI_RESERVE_0_0_nc_RESERVE_0_1_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_RESERVE_0_0_nc_RESERVE_0_1_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_0_0_nc_RESERVE_0_1_SHIFT)
#define VI_RESERVE_0_0_nc_RESERVE_0_1_RANGE                     7:4
#define VI_RESERVE_0_0_nc_RESERVE_0_1_WOFFSET                   0x0
#define VI_RESERVE_0_0_nc_RESERVE_0_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_1_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  there are 2 clocker per pixel for YUV422)
#define VI_RESERVE_0_0_nc_RESERVE_0_2_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_RESERVE_0_0_nc_RESERVE_0_2_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_0_0_nc_RESERVE_0_2_SHIFT)
#define VI_RESERVE_0_0_nc_RESERVE_0_2_RANGE                     11:8
#define VI_RESERVE_0_0_nc_RESERVE_0_2_WOFFSET                   0x0
#define VI_RESERVE_0_0_nc_RESERVE_0_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_2_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_0_0_nc_RESERVE_0_3_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_RESERVE_0_0_nc_RESERVE_0_3_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_0_0_nc_RESERVE_0_3_SHIFT)
#define VI_RESERVE_0_0_nc_RESERVE_0_3_RANGE                     15:12
#define VI_RESERVE_0_0_nc_RESERVE_0_3_WOFFSET                   0x0
#define VI_RESERVE_0_0_nc_RESERVE_0_3_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_3_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_0_0_nc_RESERVE_0_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_RESERVE_1_0  // reserved register for emergency ...
// bits[13:0] are reserved for
// VIP Pattern Gen (Pattern Height)
#define VI_RESERVE_1_0                  _MK_ADDR_CONST(0x95)
#define VI_RESERVE_1_0_SECURE                   0x0
#define VI_RESERVE_1_0_WORD_COUNT                       0x1
#define VI_RESERVE_1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_RESERVE_1_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
//  Program to *one less* than the desired
#define VI_RESERVE_1_0_nc_RESERVE_1_0_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_RESERVE_1_0_nc_RESERVE_1_0_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_1_0_nc_RESERVE_1_0_SHIFT)
#define VI_RESERVE_1_0_nc_RESERVE_1_0_RANGE                     3:0
#define VI_RESERVE_1_0_nc_RESERVE_1_0_WOFFSET                   0x0
#define VI_RESERVE_1_0_nc_RESERVE_1_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_0_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  pattern height in lines
#define VI_RESERVE_1_0_nc_RESERVE_1_1_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_RESERVE_1_0_nc_RESERVE_1_1_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_1_0_nc_RESERVE_1_1_SHIFT)
#define VI_RESERVE_1_0_nc_RESERVE_1_1_RANGE                     7:4
#define VI_RESERVE_1_0_nc_RESERVE_1_1_WOFFSET                   0x0
#define VI_RESERVE_1_0_nc_RESERVE_1_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_1_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_1_0_nc_RESERVE_1_2_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_RESERVE_1_0_nc_RESERVE_1_2_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_1_0_nc_RESERVE_1_2_SHIFT)
#define VI_RESERVE_1_0_nc_RESERVE_1_2_RANGE                     11:8
#define VI_RESERVE_1_0_nc_RESERVE_1_2_WOFFSET                   0x0
#define VI_RESERVE_1_0_nc_RESERVE_1_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_2_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_1_0_nc_RESERVE_1_3_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_RESERVE_1_0_nc_RESERVE_1_3_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_1_0_nc_RESERVE_1_3_SHIFT)
#define VI_RESERVE_1_0_nc_RESERVE_1_3_RANGE                     15:12
#define VI_RESERVE_1_0_nc_RESERVE_1_3_WOFFSET                   0x0
#define VI_RESERVE_1_0_nc_RESERVE_1_3_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_3_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_1_0_nc_RESERVE_1_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_RESERVE_2_0  // reserved register for emergency ...
// bit 0 is reserved for VIP Pattern Gen Enable
// bit 1 is reserved for VIP Pattern Gen BayerSelect
#define VI_RESERVE_2_0                  _MK_ADDR_CONST(0x96)
#define VI_RESERVE_2_0_SECURE                   0x0
#define VI_RESERVE_2_0_WORD_COUNT                       0x1
#define VI_RESERVE_2_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_RESET_MASK                       _MK_MASK_CONST(0xf)
#define VI_RESERVE_2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_RESERVE_2_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
// 1 for BAYER pattern and 0 for YUV pattern
#define VI_RESERVE_2_0_nc_RESERVE_2_0_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_RESERVE_2_0_nc_RESERVE_2_0_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_2_0_nc_RESERVE_2_0_SHIFT)
#define VI_RESERVE_2_0_nc_RESERVE_2_0_RANGE                     3:0
#define VI_RESERVE_2_0_nc_RESERVE_2_0_WOFFSET                   0x0
#define VI_RESERVE_2_0_nc_RESERVE_2_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_0_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define VI_RESERVE_2_0_nc_RESERVE_2_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_2_0_nc_RESERVE_2_1_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_RESERVE_2_0_nc_RESERVE_2_1_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_2_0_nc_RESERVE_2_1_SHIFT)
#define VI_RESERVE_2_0_nc_RESERVE_2_1_RANGE                     7:4
#define VI_RESERVE_2_0_nc_RESERVE_2_1_WOFFSET                   0x0
#define VI_RESERVE_2_0_nc_RESERVE_2_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_1_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_2_0_nc_RESERVE_2_2_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_RESERVE_2_0_nc_RESERVE_2_2_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_2_0_nc_RESERVE_2_2_SHIFT)
#define VI_RESERVE_2_0_nc_RESERVE_2_2_RANGE                     11:8
#define VI_RESERVE_2_0_nc_RESERVE_2_2_WOFFSET                   0x0
#define VI_RESERVE_2_0_nc_RESERVE_2_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_2_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_2_0_nc_RESERVE_2_3_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_RESERVE_2_0_nc_RESERVE_2_3_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_2_0_nc_RESERVE_2_3_SHIFT)
#define VI_RESERVE_2_0_nc_RESERVE_2_3_RANGE                     15:12
#define VI_RESERVE_2_0_nc_RESERVE_2_3_WOFFSET                   0x0
#define VI_RESERVE_2_0_nc_RESERVE_2_3_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_3_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_2_0_nc_RESERVE_2_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_RESERVE_3_0  // reserved register for emergency ...
#define VI_RESERVE_3_0                  _MK_ADDR_CONST(0x97)
#define VI_RESERVE_3_0_SECURE                   0x0
#define VI_RESERVE_3_0_WORD_COUNT                       0x1
#define VI_RESERVE_3_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_RESERVE_3_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
#define VI_RESERVE_3_0_nc_RESERVE_3_0_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_RESERVE_3_0_nc_RESERVE_3_0_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_3_0_nc_RESERVE_3_0_SHIFT)
#define VI_RESERVE_3_0_nc_RESERVE_3_0_RANGE                     3:0
#define VI_RESERVE_3_0_nc_RESERVE_3_0_WOFFSET                   0x0
#define VI_RESERVE_3_0_nc_RESERVE_3_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_0_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_3_0_nc_RESERVE_3_1_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_RESERVE_3_0_nc_RESERVE_3_1_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_3_0_nc_RESERVE_3_1_SHIFT)
#define VI_RESERVE_3_0_nc_RESERVE_3_1_RANGE                     7:4
#define VI_RESERVE_3_0_nc_RESERVE_3_1_WOFFSET                   0x0
#define VI_RESERVE_3_0_nc_RESERVE_3_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_1_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_3_0_nc_RESERVE_3_2_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_RESERVE_3_0_nc_RESERVE_3_2_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_3_0_nc_RESERVE_3_2_SHIFT)
#define VI_RESERVE_3_0_nc_RESERVE_3_2_RANGE                     11:8
#define VI_RESERVE_3_0_nc_RESERVE_3_2_WOFFSET                   0x0
#define VI_RESERVE_3_0_nc_RESERVE_3_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_2_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_3_0_nc_RESERVE_3_3_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_RESERVE_3_0_nc_RESERVE_3_3_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_3_0_nc_RESERVE_3_3_SHIFT)
#define VI_RESERVE_3_0_nc_RESERVE_3_3_RANGE                     15:12
#define VI_RESERVE_3_0_nc_RESERVE_3_3_WOFFSET                   0x0
#define VI_RESERVE_3_0_nc_RESERVE_3_3_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_3_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_3_0_nc_RESERVE_3_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register VI_RESERVE_4_0  // reserved register for emergency ...
#define VI_RESERVE_4_0                  _MK_ADDR_CONST(0x98)
#define VI_RESERVE_4_0_SECURE                   0x0
#define VI_RESERVE_4_0_WORD_COUNT                       0x1
#define VI_RESERVE_4_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define VI_RESERVE_4_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
#define VI_RESERVE_4_0_nc_RESERVE_4_0_SHIFT                     _MK_SHIFT_CONST(0)
#define VI_RESERVE_4_0_nc_RESERVE_4_0_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_4_0_nc_RESERVE_4_0_SHIFT)
#define VI_RESERVE_4_0_nc_RESERVE_4_0_RANGE                     3:0
#define VI_RESERVE_4_0_nc_RESERVE_4_0_WOFFSET                   0x0
#define VI_RESERVE_4_0_nc_RESERVE_4_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_0_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_4_0_nc_RESERVE_4_1_SHIFT                     _MK_SHIFT_CONST(4)
#define VI_RESERVE_4_0_nc_RESERVE_4_1_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_4_0_nc_RESERVE_4_1_SHIFT)
#define VI_RESERVE_4_0_nc_RESERVE_4_1_RANGE                     7:4
#define VI_RESERVE_4_0_nc_RESERVE_4_1_WOFFSET                   0x0
#define VI_RESERVE_4_0_nc_RESERVE_4_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_1_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_4_0_nc_RESERVE_4_2_SHIFT                     _MK_SHIFT_CONST(8)
#define VI_RESERVE_4_0_nc_RESERVE_4_2_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_4_0_nc_RESERVE_4_2_SHIFT)
#define VI_RESERVE_4_0_nc_RESERVE_4_2_RANGE                     11:8
#define VI_RESERVE_4_0_nc_RESERVE_4_2_WOFFSET                   0x0
#define VI_RESERVE_4_0_nc_RESERVE_4_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_2_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define VI_RESERVE_4_0_nc_RESERVE_4_3_SHIFT                     _MK_SHIFT_CONST(12)
#define VI_RESERVE_4_0_nc_RESERVE_4_3_FIELD                     (_MK_MASK_CONST(0xf) << VI_RESERVE_4_0_nc_RESERVE_4_3_SHIFT)
#define VI_RESERVE_4_0_nc_RESERVE_4_3_RANGE                     15:12
#define VI_RESERVE_4_0_nc_RESERVE_4_3_WOFFSET                   0x0
#define VI_RESERVE_4_0_nc_RESERVE_4_3_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_3_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define VI_RESERVE_4_0_nc_RESERVE_4_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Memory Client Interface Hysteresis Registers
// Memory Client Interface Fifo Control Register.
// The registers below allow to optimize the synchronization timing in
// the memory client asynchronous fifos. When they can be used depend on
// the client and memory controller clock ratio.
// Additionally, the RDMC_RDFAST/RDCL_RDFAST fields can increase power
// consumption if the asynchronous fifo is implemented as a real ram.
// There is no power impact on latch-based fifos. Flipflop-based fifos
// do not use these fields.
// See recommended settings below.
//
// !! IMPORTANT !!
// The register fields can only be changed when the memory client async
// fifos are empty.
//
// The register field ending with WRCL_MCLE2X (if any) can be set to improve
// async fifo synchronization on the write side by one client clock cycle if
// the memory controller clock frequency is less or equal to twice the client
// clock frequency:
//
//      mcclk_freq <= 2 * clientclk_freq
//
// The register field ending with WRMC_CLLE2X (if any) can be set to improve
// async fifo synchronization on the write side by one memory controller clock
// cycle if the client clock frequency is less or equal to twice the memory
// controller clock frequency:
//
//      clientclk_freq <= 2 * mcclk_freq
//
// The register field ending with RDMC_RDFAST (if any) can be set to improve async
// fifo synchronization on the read side by one memory controller clock cycle.
//
// !! WARNING !!
// RDMC_RDFAST can be used along with WRCL_MCLE2X only when:
//
//       mcclk_freq <= clientclk_freq
//
// The register field ending with RDCL_RDFAST (if any) can be set to improve async
// fifo synchronization on the read side by one client clock cycle.
//
// !! WARNING !!
// RDCL_RDFAST can be used along with WRMC_CLLE2X only when:
//
//       clientclk_freq <= mcclk_freq
//
// RECOMMENDED SETTINGS
// # Client writing to fifo, memory controller reading from fifo
// - mcclk_freq <= clientclk_freq
//     You can enable both RDMC_RDFAST and WRCL_CLLE2X. If one of the fifos is
//     a real ram and power is a concern, you should avoid enabling RDMC_RDFAST.
// - clientclk_freq < mcclk_freq <= 2 * clientclk_freq
//     You can enable RDMC_RDFAST or WRCL_MCLE2X, but because the client clock
//     is slower, you should enable only WRCL_MCLE2X.
// - 2 * clientclk_freq < mcclk_freq
//     You can only enable RDMC_RDFAST. If one of the fifos is a real ram and
//     power is a concern, you should avoid enabling RDMC_RDFAST.
//
// # Memory controller writing to fifo, client reading from fifo
// - clientclk_freq <= mcclk_freq
//     You can enable both RDCL_RDFAST and WRMC_CLLE2X. If one of the fifos is
//     a real ram and power is a concern, you should avoid enabling RDCL_RDFAST.
// - mcclk_freq < clientclk_freq <= 2 * mcclk_freq
//     You can enable RDCL_RDFAST or WRMC_CLLE2X, but because the memory controller
//     clock is slower, you should enable only WRMC_CLLE2X.
// - 2 * mcclk_freq < clientclk_freq
//     You can only enable RDCL_RDFAST. If one of the fifos is a real ram and
//     power is a concern, you should avoid enabling RDCL_RDFAST.
//
// Memory Client Hysteresis Control Register
// This register exists only for clients with hysteresis.
// BUG 505006: Hysteresis configuration can only be updated when memory traffic is idle.
// HYST_EN can be used to turn on or off the hysteresis logic.
// HYST_REQ_TH is the threshold of pending requests required
//   before allowing them to pass through
//   (overriden after HYST_REQ_TM cycles).
// Hysteresis logic will stop holding request after (1<<HYST_TM) cycles
//   (this should not have to be used and is only a WAR for
//   unexpected hangs).
// Deep hysteresis is a second level of hysteresis on a longer time-frame.
//   DHYST_TH is the size of the read burst (requests are held until there
//   is space for the entire burst in the return data fifo).
//   During a burst period, if there are no new requests after
//   DHYST_TM cycles, then the burst is terminated early.

// Register VI_MCCIF_VIRUV_HYST_0  
#define VI_MCCIF_VIRUV_HYST_0                   _MK_ADDR_CONST(0x99)
#define VI_MCCIF_VIRUV_HYST_0_SECURE                    0x0
#define VI_MCCIF_VIRUV_HYST_0_WORD_COUNT                        0x1
#define VI_MCCIF_VIRUV_HYST_0_RESET_VAL                         _MK_MASK_CONST(0xcf04ff06)
#define VI_MCCIF_VIRUV_HYST_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define VI_MCCIF_VIRUV_HYST_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define VI_MCCIF_VIRUV_HYST_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_FIELD                    (_MK_MASK_CONST(0xff) << VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_SHIFT)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_RANGE                    7:0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_WOFFSET                  0x0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_DEFAULT                  _MK_MASK_CONST(0x6)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_SHIFT                       _MK_SHIFT_CONST(8)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_FIELD                       (_MK_MASK_CONST(0xff) << VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_SHIFT)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_RANGE                       15:8
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_WOFFSET                     0x0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_DEFAULT                     _MK_MASK_CONST(0xff)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_SHIFT                       _MK_SHIFT_CONST(16)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_FIELD                       (_MK_MASK_CONST(0xff) << VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_SHIFT)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_RANGE                       23:16
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_WOFFSET                     0x0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_DEFAULT                     _MK_MASK_CONST(0x4)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_DHYST_TH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_SHIFT                        _MK_SHIFT_CONST(24)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_FIELD                        (_MK_MASK_CONST(0xf) << VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_SHIFT)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_RANGE                        27:24
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_WOFFSET                      0x0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_DEFAULT                      _MK_MASK_CONST(0xf)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_TM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_SHIFT                    _MK_SHIFT_CONST(28)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_FIELD                    (_MK_MASK_CONST(0x7) << VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_SHIFT)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_RANGE                    30:28
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_WOFFSET                  0x0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_DEFAULT                  _MK_MASK_CONST(0x4)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_REQ_TH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_SHIFT                        _MK_SHIFT_CONST(31)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_FIELD                        (_MK_MASK_CONST(0x1) << VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_SHIFT)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_RANGE                        31:31
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_WOFFSET                      0x0
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_DEFAULT                      _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_INIT_ENUM                    ENABLE
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_ENABLE                       _MK_ENUM_CONST(1)
#define VI_MCCIF_VIRUV_HYST_0_CBR_VIRUV2MC_HYST_EN_DISABLE                      _MK_ENUM_CONST(0)

// Memory Client Hysteresis Control Register
// This register exists only for clients with hysteresis.
// BUG 505006: Hysteresis configuration can only be updated when memory traffic is idle.
// HYST_EN can be used to turn on or off the hysteresis logic.
// HYST_REQ_TH is the threshold of pending requests required
//   before allowing them to pass through
//   (overriden after HYST_REQ_TM cycles).

// Register VI_MCCIF_VIWSB_HYST_0  
#define VI_MCCIF_VIWSB_HYST_0                   _MK_ADDR_CONST(0x9a)
#define VI_MCCIF_VIWSB_HYST_0_SECURE                    0x0
#define VI_MCCIF_VIWSB_HYST_0_WORD_COUNT                        0x1
#define VI_MCCIF_VIWSB_HYST_0_RESET_VAL                         _MK_MASK_CONST(0xc00001ff)
#define VI_MCCIF_VIWSB_HYST_0_RESET_MASK                        _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWSB_HYST_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HYST_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HYST_0_READ_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWSB_HYST_0_WRITE_MASK                        _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_SHIFT                    _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_FIELD                    (_MK_MASK_CONST(0xfff) << VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_SHIFT)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_RANGE                    11:0
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_WOFFSET                  0x0
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_DEFAULT                  _MK_MASK_CONST(0x1ff)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_DEFAULT_MASK                     _MK_MASK_CONST(0xfff)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_SHIFT                    _MK_SHIFT_CONST(28)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_FIELD                    (_MK_MASK_CONST(0x7) << VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_SHIFT)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_RANGE                    30:28
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_WOFFSET                  0x0
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_DEFAULT                  _MK_MASK_CONST(0x4)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_REQ_TH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_SHIFT                        _MK_SHIFT_CONST(31)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_FIELD                        (_MK_MASK_CONST(0x1) << VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_SHIFT)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_RANGE                        31:31
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_WOFFSET                      0x0
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_DEFAULT                      _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_INIT_ENUM                    ENABLE
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_ENABLE                       _MK_ENUM_CONST(1)
#define VI_MCCIF_VIWSB_HYST_0_CBW_VIWSB2MC_HYST_EN_DISABLE                      _MK_ENUM_CONST(0)

// Memory Client Hysteresis Control Register
// This register exists only for clients with hysteresis.
// BUG 505006: Hysteresis configuration can only be updated when memory traffic is idle.
// HYST_EN can be used to turn on or off the hysteresis logic.
// HYST_REQ_TH is the threshold of pending requests required
//   before allowing them to pass through
//   (overriden after HYST_REQ_TM cycles).

// Register VI_MCCIF_VIWU_HYST_0  
#define VI_MCCIF_VIWU_HYST_0                    _MK_ADDR_CONST(0x9b)
#define VI_MCCIF_VIWU_HYST_0_SECURE                     0x0
#define VI_MCCIF_VIWU_HYST_0_WORD_COUNT                         0x1
#define VI_MCCIF_VIWU_HYST_0_RESET_VAL                  _MK_MASK_CONST(0xc00001ff)
#define VI_MCCIF_VIWU_HYST_0_RESET_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWU_HYST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HYST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HYST_0_READ_MASK                  _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWU_HYST_0_WRITE_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_FIELD                      (_MK_MASK_CONST(0xfff) << VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_SHIFT)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_RANGE                      11:0
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_WOFFSET                    0x0
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_DEFAULT                    _MK_MASK_CONST(0x1ff)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_DEFAULT_MASK                       _MK_MASK_CONST(0xfff)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_SHIFT                      _MK_SHIFT_CONST(28)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_FIELD                      (_MK_MASK_CONST(0x7) << VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_SHIFT)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_RANGE                      30:28
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_WOFFSET                    0x0
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_DEFAULT                    _MK_MASK_CONST(0x4)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_REQ_TH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_SHIFT                  _MK_SHIFT_CONST(31)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_FIELD                  (_MK_MASK_CONST(0x1) << VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_SHIFT)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_RANGE                  31:31
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_WOFFSET                        0x0
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_INIT_ENUM                      ENABLE
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_ENABLE                 _MK_ENUM_CONST(1)
#define VI_MCCIF_VIWU_HYST_0_CBW_VIWU2MC_HYST_EN_DISABLE                        _MK_ENUM_CONST(0)

// Memory Client Hysteresis Control Register
// This register exists only for clients with hysteresis.
// BUG 505006: Hysteresis configuration can only be updated when memory traffic is idle.
// HYST_EN can be used to turn on or off the hysteresis logic.
// HYST_REQ_TH is the threshold of pending requests required
//   before allowing them to pass through
//   (overriden after HYST_REQ_TM cycles).

// Register VI_MCCIF_VIWV_HYST_0  
#define VI_MCCIF_VIWV_HYST_0                    _MK_ADDR_CONST(0x9c)
#define VI_MCCIF_VIWV_HYST_0_SECURE                     0x0
#define VI_MCCIF_VIWV_HYST_0_WORD_COUNT                         0x1
#define VI_MCCIF_VIWV_HYST_0_RESET_VAL                  _MK_MASK_CONST(0xc00001ff)
#define VI_MCCIF_VIWV_HYST_0_RESET_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWV_HYST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HYST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HYST_0_READ_MASK                  _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWV_HYST_0_WRITE_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_FIELD                      (_MK_MASK_CONST(0xfff) << VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_SHIFT)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_RANGE                      11:0
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_WOFFSET                    0x0
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_DEFAULT                    _MK_MASK_CONST(0x1ff)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_DEFAULT_MASK                       _MK_MASK_CONST(0xfff)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_SHIFT                      _MK_SHIFT_CONST(28)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_FIELD                      (_MK_MASK_CONST(0x7) << VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_SHIFT)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_RANGE                      30:28
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_WOFFSET                    0x0
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_DEFAULT                    _MK_MASK_CONST(0x4)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_REQ_TH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_SHIFT                  _MK_SHIFT_CONST(31)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_FIELD                  (_MK_MASK_CONST(0x1) << VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_SHIFT)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_RANGE                  31:31
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_WOFFSET                        0x0
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_INIT_ENUM                      ENABLE
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_ENABLE                 _MK_ENUM_CONST(1)
#define VI_MCCIF_VIWV_HYST_0_CBW_VIWV2MC_HYST_EN_DISABLE                        _MK_ENUM_CONST(0)

// Memory Client Hysteresis Control Register
// This register exists only for clients with hysteresis.
// BUG 505006: Hysteresis configuration can only be updated when memory traffic is idle.
// HYST_EN can be used to turn on or off the hysteresis logic.
// HYST_REQ_TH is the threshold of pending requests required
//   before allowing them to pass through
//   (overriden after HYST_REQ_TM cycles).

// Register VI_MCCIF_VIWY_HYST_0  
#define VI_MCCIF_VIWY_HYST_0                    _MK_ADDR_CONST(0x9d)
#define VI_MCCIF_VIWY_HYST_0_SECURE                     0x0
#define VI_MCCIF_VIWY_HYST_0_WORD_COUNT                         0x1
#define VI_MCCIF_VIWY_HYST_0_RESET_VAL                  _MK_MASK_CONST(0xc00001ff)
#define VI_MCCIF_VIWY_HYST_0_RESET_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWY_HYST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HYST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HYST_0_READ_MASK                  _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWY_HYST_0_WRITE_MASK                         _MK_MASK_CONST(0xf0000fff)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_SHIFT                      _MK_SHIFT_CONST(0)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_FIELD                      (_MK_MASK_CONST(0xfff) << VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_SHIFT)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_RANGE                      11:0
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_WOFFSET                    0x0
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_DEFAULT                    _MK_MASK_CONST(0x1ff)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_DEFAULT_MASK                       _MK_MASK_CONST(0xfff)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_SHIFT                      _MK_SHIFT_CONST(28)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_FIELD                      (_MK_MASK_CONST(0x7) << VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_SHIFT)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_RANGE                      30:28
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_WOFFSET                    0x0
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_DEFAULT                    _MK_MASK_CONST(0x4)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_REQ_TH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_SHIFT                  _MK_SHIFT_CONST(31)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_FIELD                  (_MK_MASK_CONST(0x1) << VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_SHIFT)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_RANGE                  31:31
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_WOFFSET                        0x0
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_INIT_ENUM                      ENABLE
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_ENABLE                 _MK_ENUM_CONST(1)
#define VI_MCCIF_VIWY_HYST_0_CBW_VIWY2MC_HYST_EN_DISABLE                        _MK_ENUM_CONST(0)

// CSI register spec
// --------------------------------------------------------------------------
// 
// Copyright (c) 2004, NVIDIA Corp.
// All Rights Reserved.
// 
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
// 
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
// 
// --------------------------------------------------------------------------
// 
// CSI (MIPI Camera Serial Interface) register definition

// Register CSI_VI_INPUT_STREAM_CONTROL_0  // VI Input Stream Control
#define CSI_VI_INPUT_STREAM_CONTROL_0                   _MK_ADDR_CONST(0x200)
#define CSI_VI_INPUT_STREAM_CONTROL_0_SECURE                    0x0
#define CSI_VI_INPUT_STREAM_CONTROL_0_WORD_COUNT                        0x1
#define CSI_VI_INPUT_STREAM_CONTROL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_READ_MASK                         _MK_MASK_CONST(0x80)
#define CSI_VI_INPUT_STREAM_CONTROL_0_WRITE_MASK                        _MK_MASK_CONST(0x80)
// VIP Start Frame Generation Don't use vi2csi_vip_vsync to generate start frame
// (SF), or end frame (EF) markers in the pixel parser
// output stream.
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_SHIFT                  _MK_SHIFT_CONST(7)
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_FIELD                  (_MK_MASK_CONST(0x1) << CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_SHIFT)
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_RANGE                  7:7
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_WOFFSET                        0x0
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_VSYNC_SF                       _MK_ENUM_CONST(0)    // // Pulses on vi2csi_vip_vsync will be used to
// generate start frame (SF) and end frame (EF) markers
// in the pixel parser output stream.
// In AP15, only payload_only mode is supported in
// the VIP input stream path, and this fields may 
// always be programmed to VSYNC_SF.

#define CSI_VI_INPUT_STREAM_CONTROL_0_VIP_SF_GEN_NO_VSYNC_SF                    _MK_ENUM_CONST(1)


// Reserved address 513 [0x201] 
// reserved for additional VI Input Stream control register
// in case it is needed in the future

// Register CSI_HOST_INPUT_STREAM_CONTROL_0  // Host Input Stream Control
#define CSI_HOST_INPUT_STREAM_CONTROL_0                 _MK_ADDR_CONST(0x202)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_SECURE                  0x0
#define CSI_HOST_INPUT_STREAM_CONTROL_0_WORD_COUNT                      0x1
#define CSI_HOST_INPUT_STREAM_CONTROL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_READ_MASK                       _MK_MASK_CONST(0x1fff018f)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_WRITE_MASK                      _MK_MASK_CONST(0x1fff008f)
// Host Data Format Data written to Y_FIFO_WRITE port should be in CSI
// packet format. To indicate end of packet a 1 should
// be written to HOST_END_OF_PACKET. A 1 should also be
// written to HOST_END_OF_PACKET before writing the first
// word of packet data to Y_FIFO_WRITE.
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_SHIFT                  _MK_SHIFT_CONST(0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_FIELD                  (_MK_MASK_CONST(0xf) << CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_SHIFT)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_RANGE                  3:0
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_WOFFSET                        0x0
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_PAYLOAD_ONLY                   _MK_ENUM_CONST(0)    // // Data written to Y_FIFO_WRITE port should be
// CSI line payload data only (no header, no footer,
// and  no short packets). A value of 1 should not
// be written to HOST_END_OF_PACKET (end of packet
// pulse only gets generated when a 1 is written to
// this bit). 
// First line will be indicated when one of the pixel
// parsers is first enabled with its 
// CSI_PPA/B_STREAM_SOURCE set to "HOST".
// The values in the following PIXEL_STREAM_A/B_CONTROL0 
// fields, for the pixel parser that is receiving host
// data, will be ignored;
// CSI_PPA/B_PACKET_HEADER overridden with "NOT_SENT",
// CSI_PPA/B_DATA_IDENTIFIER overridden with "DISABLED",
// CSI_PPA/B_WORD_COUNT_SELECT overridden with "REGISTER".
// CSI_PPA/B_CRC_CHECK overridden with "DISABLE",
// CSI_PPA/B_VIRTUAL_CHANNEL_ID,
// CSI_PPA/B_EMBEDDED_DATA_OPTIONS, and
// CSI_PPA/B_HEADER_EC_ENABLE.
// CSI_PPA/B_DATA_TYPE should be programmed with the 
// 6 bit data type that is to be used to interpret the
// stream. CSI_PPA/B_WORD_COUNT should be programmed with
// the number of bytes per line.

#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_DATA_FORMAT_PACKETS                        _MK_ENUM_CONST(1)

// Host Start Frame Generation Don't use CSI Host Line counter to generate start, or
// End, of Frame control outputs. This setting should only
// be used if HOST_DATA_FORMAT is set to PACKETS, and the
// Host data stream has frame sync packets.
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_SHIFT                       _MK_SHIFT_CONST(7)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_FIELD                       (_MK_MASK_CONST(0x1) << CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_SHIFT)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_RANGE                       7:7
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_WOFFSET                     0x0
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_LINE_COUNTER                        _MK_ENUM_CONST(0)    // // CSI Host Line counter will be used to generate Frame
// start and end control. To signal the start of the first
// frame the pixel parser will send a SF control, and
// signal start of frame mark, when it is first enabled
// with Host as its source. This setting should be used 
// when HOST_DATA_FORMAT is set to PAYLOAD_ONLY.

#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_SF_GEN_SHORT_PACKETS                       _MK_ENUM_CONST(1)

// Writing this bit with a 1 indicates End of Packet,
// when CSI Host data is being received in Packet Format.
// In Packet Format vi2csi_host_hsync is not used to 
// indicate beginning of packet.
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_SHIFT                        _MK_SHIFT_CONST(8)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_FIELD                        (_MK_MASK_CONST(0x1) << CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_SHIFT)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_RANGE                        8:8
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_WOFFSET                      0x0
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_END_OF_PACKET_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Host Frame Height
// Specifies the height of the host frame when the host
// is supplying CSI format payload only data to one of 
// the CSI pixel parsers.
// Programmed Value = number of lines - 1
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_SHIFT                 _MK_SHIFT_CONST(16)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_FIELD                 (_MK_MASK_CONST(0x1fff) << CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_SHIFT)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_RANGE                 28:16
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_WOFFSET                       0x0
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_HOST_INPUT_STREAM_CONTROL_0_HOST_FRAME_HEIGHT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 515 [0x203] 
// reserved for additional Host Input Stream control register
// in case it is needed in the future

// Register CSI_INPUT_STREAM_A_CONTROL_0  // CSI Input Stream A Control
#define CSI_INPUT_STREAM_A_CONTROL_0                    _MK_ADDR_CONST(0x204)
#define CSI_INPUT_STREAM_A_CONTROL_0_SECURE                     0x0
#define CSI_INPUT_STREAM_A_CONTROL_0_WORD_COUNT                         0x1
#define CSI_INPUT_STREAM_A_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x7f0001)
#define CSI_INPUT_STREAM_A_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0xff0013)
#define CSI_INPUT_STREAM_A_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0xff0013)
#define CSI_INPUT_STREAM_A_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0xff0013)
// CSI-A Data Lane
//   0= 1 data lane
//   1= 2 data lanes
//   2= 3 data lanes (not supported on SC17 & SC25)
//   3= 4 data lanes (not supported on SC17 & SC25)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_SHIFT                      _MK_SHIFT_CONST(0)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_FIELD                      (_MK_MASK_CONST(0x3) << CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_SHIFT)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_RANGE                      1:0
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_WOFFSET                    0x0
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_DEFAULT                    _MK_MASK_CONST(0x1)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_DATA_LANE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Enables skip packet threshold feature. Skip packet feature is enabled.
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_SHIFT                   _MK_SHIFT_CONST(4)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_SHIFT)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_RANGE                   4:4
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_WOFFSET                 0x0
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_DISABLE                 _MK_ENUM_CONST(0)    // // Skip packet feature is disabled.     

#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

// CSI-A Skip Packet Threshold
//  This value is compared against the internal
//  FIFO that buffer the input streams. A packet
//  will be skipped (discarded) if the pixel
//  stream processor is busy (probably due to
//  padding process of a short line) and the
//  number of entries in the internal FIFO
//  exceeds this threshold value. Note that
//  each entry in the internal FIFO buffer is
//  four bytes.
//  To turn off this feature, set the value
//  to its maximum value (all ones).
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_SHIFT                  _MK_SHIFT_CONST(16)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_FIELD                  (_MK_MASK_CONST(0xff) << CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_SHIFT)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_RANGE                  23:16
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_WOFFSET                        0x0
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_DEFAULT                        _MK_MASK_CONST(0x7f)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_A_CONTROL_0_CSI_A_SKIP_PACKET_THRESHOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 517 [0x205] 
// reserved for additional Input Stream control register
// in case it is needed in the future

// Register CSI_PIXEL_STREAM_A_CONTROL0_0  // CSI Pixel Stream A Control 0
#define CSI_PIXEL_STREAM_A_CONTROL0_0                   _MK_ADDR_CONST(0x206)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_SECURE                    0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_WORD_COUNT                        0x1
#define CSI_PIXEL_STREAM_A_CONTROL0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_RESET_MASK                        _MK_MASK_CONST(0x7)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_READ_MASK                         _MK_MASK_CONST(0x3b3ffff7)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_WRITE_MASK                        _MK_MASK_CONST(0x3b3ffff7)
// CSI Pixel Parser A Stream Source   Host
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_SHIFT                       _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_FIELD                       (_MK_MASK_CONST(0x7) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_RANGE                       2:0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_CSI_A                       _MK_ENUM_CONST(0)    // //   CSI Interface A

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_CSI_B                       _MK_ENUM_CONST(1)    // //   CSI Interface B

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_VI_PORT                     _MK_ENUM_CONST(6)    // //   VI port

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_STREAM_SOURCE_HOST                        _MK_ENUM_CONST(7)

// CSI Pixel Parser A Packet Header processing
//  This specifies whether packet header is
//  sent in the beginning of packet or not.      Packet header is sent.
//      This setting should be used if the
//      stream source is CSI Interface A or B.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_SHIFT                       _MK_SHIFT_CONST(4)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_FIELD                       (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_RANGE                       4:4
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_NOT_SENT                    _MK_ENUM_CONST(0)    // //      Packet header is not sent.
//      This setting should not be used if the
//      stream source is CSI Interface A or B.
//      Unless CSI-A, or CSI-B, is operating in a
//      stream capture debug mode.
//      In this case, CSI_PPA_DATA_TYPE specifies
//      the stream data format and the number
//      of bytes per line/packet is
//      specified by CSI_PPA_WORD_COUNT.
//      This implies that a packet footer
//      is also not sent.  In this case, no 
//      packet footer CRC check should be performed.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PACKET_HEADER_SENT                        _MK_ENUM_CONST(1)

// CSI Pixel Parser A Data Identifier (DI) byte processing
//  This parameter is effective only if packet
//  header is sent as part of the stream.      Enabled  - Data Identifier byte in
//      packet header should be compared against
//      the CSI_PPA_DATA_TYPE and the
//      CSI_PPA_VIRTUAL_CHANNEL_ID.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_SHIFT                     _MK_SHIFT_CONST(5)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_FIELD                     (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_RANGE                     5:5
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_DISABLED                  _MK_ENUM_CONST(0)    // //      Disabled - Data Identifier byte in
//      packet header should be ignored
//      (not checked against CSI_PPA_DATA_TYPE
//      and against CSI_PPA_VIRTUAL_CHANNEL_ID).
//      In this case, CSI_PPA_DATA_TYPE specifies
//      the stream data format.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_IDENTIFIER_ENABLED                   _MK_ENUM_CONST(1)

// CSI Pixel Parser A Word Count Select
//  This parameter is effective only if packet
//  header is sent as part of the stream.      The number of bytes per line is to be
//      extracted from Word Count field in the
//      packet header. Note that if the serial
//      link is not error free, programming this
//      bit to HEADER may be dangerous because 
//      the word count information in the header 
//      may be corrupted. 
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_SHIFT                   _MK_SHIFT_CONST(6)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_FIELD                   (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_RANGE                   6:6
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_REGISTER                        _MK_ENUM_CONST(0)    // //      Word Count in packet header is ignored
//      and the number of bytes per line/packet
//      is specified by CSI_PPA_WORD_COUNT. Payload
//      CRC check will not be valid if the word
//      count in CSI_PPA_WORD_COUNT is different 
//      than the count in the packet header.
//      It is recommended to always program
//      this bit to REGISTER and always program
//      CSI_PPA_WORD_COUNT.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_WORD_COUNT_SELECT_HEADER                  _MK_ENUM_CONST(1)

// CSI Pixel Parser A Data CRC Check
//  This parameter specifies whether the last
//  2 bytes of packet should be treated as
//  CRC checksum and used to perform CRC check
//  on the payload data. Note that in case there
//  are 2 bytes of data CRC at the end of the
//  packet, the packet word count does not
//  include the CRC bytes.      Data CRC Check is enabled.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_SHIFT                   _MK_SHIFT_CONST(7)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_RANGE                   7:7
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_DISABLE                 _MK_ENUM_CONST(0)    // //      Data CRC Check is disabled regardless
//      of whether there are CRC checksum at
//      the end of the packet.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_CRC_CHECK_ENABLE                  _MK_ENUM_CONST(1)

// CSI Pixel Parser A Data Type  This is CSI compatible data type as defined
//  in CSI specification. If the source stream
//  contains packet headers this value can be compared
//  to the CSI Data Type value in the 6 LSB of the
//  CSI Data Identifier (DI) byte. If the source stream
//  doesn't contain packet headers, or CSI_PPA_DATA_IDENTIFIER
//  is DISABLED, this value will be used to determine how
//  the stream will be converted to pixels.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_SHIFT                   _MK_SHIFT_CONST(8)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_FIELD                   (_MK_MASK_CONST(0x3f) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RANGE                   13:8
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_YUV420_8                        _MK_ENUM_CONST(24)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_YUV420_10                       _MK_ENUM_CONST(25)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_LEG_YUV420_8                    _MK_ENUM_CONST(26)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_YUV420CSPS_8                    _MK_ENUM_CONST(28)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_YUV420CSPS_10                   _MK_ENUM_CONST(29)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_YUV422_8                        _MK_ENUM_CONST(30)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_YUV422_10                       _MK_ENUM_CONST(31)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RGB444                  _MK_ENUM_CONST(32)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RGB555                  _MK_ENUM_CONST(33)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RGB565                  _MK_ENUM_CONST(34)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RGB666                  _MK_ENUM_CONST(35)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RGB888                  _MK_ENUM_CONST(36)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RAW6                    _MK_ENUM_CONST(40)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RAW7                    _MK_ENUM_CONST(41)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RAW8                    _MK_ENUM_CONST(42)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RAW10                   _MK_ENUM_CONST(43)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RAW12                   _MK_ENUM_CONST(44)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_RAW14                   _MK_ENUM_CONST(45)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_ARB_DT1                 _MK_ENUM_CONST(48)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_ARB_DT2                 _MK_ENUM_CONST(49)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_ARB_DT3                 _MK_ENUM_CONST(50)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_DATA_TYPE_ARB_DT4                 _MK_ENUM_CONST(51)

// CSI Pixel Parser A Virtual Channel Identifier  
//  This is CSI compatible virtual channel
//  identifier as defined in CSI specification.
//  If the source stream contains packet headers
//  and CSI_PPA_DATA_IDENTIFIER is ENABLED this
//  value will be compared to the CSI Virtual
//  Channel Identifier value in the 2 MSB of the
//  CSI Data Identifier (DI) byte. This value will
//  be ignored if the source stream doesn't contain
//  packet headers, or CSI_PPA_DATA_IDENTIFIER is 
//  DISABLED, then this value will be ignored.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_SHIFT                  _MK_SHIFT_CONST(14)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_FIELD                  (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_RANGE                  15:14
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_WOFFSET                        0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_ONE                    _MK_ENUM_CONST(0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_TWO                    _MK_ENUM_CONST(1)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_THREE                  _MK_ENUM_CONST(2)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_VIRTUAL_CHANNEL_ID_FOUR                   _MK_ENUM_CONST(3)

// CSI Pixel Parser A Output Format Options
//  This parameter specifies options for output data 
//  format.       Output for storing RAW data to memory through
//       ISP. Undefined LS color bits for RGB_666, 
//       RGB_565, RGB_555, and RGB_444, will be zeroed.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_SHIFT                       _MK_SHIFT_CONST(16)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_FIELD                       (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_RANGE                       19:16
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_ARBITRARY                   _MK_ENUM_CONST(0)    // //       Output as 8-bit arbitrary data stream
//       This may be used for compressed JPEG stream

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_PIXEL                       _MK_ENUM_CONST(1)    // //       Output the normal 1 pixel/clock. Undefined 
//       LS color bits for RGB_666, RGB_565, RGB_555,
//       and RGB_444, will be zeroed.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_PIXEL_REP                   _MK_ENUM_CONST(2)    // //       Same as PIXEL except MS color bits, for RGB_666, 
//       RGB_565, RGB_555, and RGB_444, will be 
//       replicated to their undefined LS bits.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_OUTPUT_FORMAT_OPTIONS_STORE                       _MK_ENUM_CONST(3)

// CSI Pixel Parser A Embedded Data Options 
//  This specifies how to deal with embedded
//  data within the specified input stream
//  assuming that the CSI_PPA_DATA_TYPE is not
//  embedded data and assuming that embedded
//  data is not already processed by other
//  CSI pixel stream processor.       output embedded data as 8-bpp arbitrary
//       data stream.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_SHIFT                       _MK_SHIFT_CONST(20)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_FIELD                       (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_RANGE                       21:20
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_DISCARD                     _MK_ENUM_CONST(0)    // //       discard (throw away) embedded data

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_EMBEDDED_DATA_OPTIONS_EMBEDDED                    _MK_ENUM_CONST(1)

// CSI Pixel Parser A Pad Short Line
//  This specifies how to deal with shorter than
//  expected line (the number of bytes received
//  is less than the specified word count)       short line is not padded (will output
//       less pixels than expected).
//       This option is not recommended and may
//       cause other modules that receives CSI
//       output stream to hang up.
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_SHIFT                      _MK_SHIFT_CONST(24)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_FIELD                      (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_RANGE                      25:24
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_WOFFSET                    0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_PAD0S                      _MK_ENUM_CONST(0)    // //       short line is padded by pixel of zeros
//       such that the expected number of output
//       pixels is correct. Due to the time
//       required to do the padding, subsequent
//       line packet maybe discarded and
//       therefore may cause a short frame
//       (total number of lines per frame is
//       less than expected).

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_PAD1S                      _MK_ENUM_CONST(1)    // //       short line is padded by pixel of ones
//       such that the expected number of output
//       pixels is correct. Due to the time
//       required to do the padding, subsequent
//       line packet maybe discarded and
//       therefore may cause a short frame
//       (total number of lines per frame is
//       less than expected).

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_SHORT_LINE_NOPAD                      _MK_ENUM_CONST(2)

// CSI Pixel Parser A Packet Header Error Correction Enable
//  This parameter specifies whether single bit
//  errors in the packet header will be
//  automatically corrected, or not.    Single bit errors in the header will not
//    be corrected. Header ECC check will still
//    set header ECC status bits and the packet
//    will be processed by Pixel Parser A. DISABLE
//    should not be used when processing interleaved
//    streams (Same stream going to both PPA and PPB).
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_SHIFT                    _MK_SHIFT_CONST(27)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_RANGE                    27:27
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_WOFFSET                  0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_ENABLE                   _MK_ENUM_CONST(0)    // //    Single bit errors in the header will be
//    automatically corrected.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_HEADER_EC_ENABLE_DISABLE                  _MK_ENUM_CONST(1)

// CSI Pixel Parser A Pad Frame
//  This specifies how to deal with frames that are
//  shorter (fewer lines) that expected. Short frames
//  are usually caused by line packets being dropped
//  because of packet errors. Expected frame height is
//  specified in PPA_EXP_FRAME_HEIGHT. To do padding the
//  value in CSI_PPA_WORD_COUNT needs to be set to the
//  number of input bytes in each line's payload.  Short frames will not be padded out.   
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_SHIFT                   _MK_SHIFT_CONST(28)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_FIELD                   (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_RANGE                   29:28
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_PAD0S                   _MK_ENUM_CONST(0)    // //  Lines of all zeros will be used to pad out frames
//  that are shorter than expected height. 
//  PPA_EXP_FRAME_HEIGHT must be programmed to
//  an appropriate value if this fields is set to PAD0S.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_PAD1S                   _MK_ENUM_CONST(1)    // //  Lines of all ones will be used to pad out frames
//  that are shorter than expected height.      
//  PPA_EXP_FRAME_HEIGHT must be programmed to
//  an appropriate value if this fields is set to PAD1S.

#define CSI_PIXEL_STREAM_A_CONTROL0_0_CSI_PPA_PAD_FRAME_NOPAD                   _MK_ENUM_CONST(2)


// Register CSI_PIXEL_STREAM_A_CONTROL1_0  // CSI Pixel Stream A Control 1
#define CSI_PIXEL_STREAM_A_CONTROL1_0                   _MK_ADDR_CONST(0x207)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_SECURE                    0x0
#define CSI_PIXEL_STREAM_A_CONTROL1_0_WORD_COUNT                        0x1
#define CSI_PIXEL_STREAM_A_CONTROL1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
// CSI Pixel Parser A Top Field Frame
//  This parameter specifies the frame number for 
//  top field detection for interlaced input video
//  stream. Top Field is indicated when each of the
//  least significant four bits of the frame number
//  that has a one in its mask bit matches the 
//  corresponding bit in this parameter. In other
//  words, Top Field is detected when the bitwise
//  AND of  
// ~(CSI_PPA_TOP_FIELD_FRAME ^ <frame number>) & CSI_PPA_TOP_FIELD_FRAME_MASK
//  is one. Frame Number is taken from the WC field
//  of the Frame Start short packet.
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_FIELD                     (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_RANGE                     3:0
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// CSI Pixel Parser A Top Field Frame Mask
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_FIELD                        (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_SHIFT)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_RANGE                        7:4
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_CONTROL1_0_CSI_PPA_TOP_FIELD_FRAME_MASK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PIXEL_STREAM_A_WORD_COUNT_0  // CSI Pixel Stream A Word Count
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0                 _MK_ADDR_CONST(0x208)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_SECURE                  0x0
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_WORD_COUNT                      0x1
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
// CSI Pixel Parser A Word Count
//  This parameter specifies the number of
//  bytes per line/packet in the case where
//  Word Count field in packet header is not
//  used or where packet header is not sent.
//  This count does not includes the additional
//  2 bytes of CRC checksum if data CRC check
//  is enabled. 
//  When the input stream comes from a CSI camera
//  port, this parameter must be programmed when 
//  CSI_PPA_PAD_SHORT_LINE is set to either PAD0S
//  or PAD1S, no matter whether CSI_PPA_WORD_COUNT_SELECT
//  is set to REGISTER or HEADER.
//  When the input stream comes from the host path
//  or from the VIP path, and the data mode is
//  PAYLOAD_ONLY, this count must be programmed.
// Given a line width of N pixels, the programming 
//  value of this parameters is as follows
//  --------------------------------------
//  data format            value
//  --------------------------------------
//  YUV420_8               N bytes
//  YUV420_10              N/4*5 bytes
//  LEG_YUV420_8           N/2*3 bytes
//  YUV422_8               N*2 bytes
//  YUV422_10              N/2*5 bytes
//  RGB888                 N*3 bytes 
//  RGB666                 N/4*9 bytes                 
//  RGB565                 N*2 bytes
//  RGB555                 N*2 bytes 
//  RGB444                 N*2 bytes 
//  RAW6                   N/4*3 bytes
//  RAW7                   N/8*7 bytes
//  RAW8                   N bytes 
//  RAW10                  N/4*5 bytes
//  RAW12                  N/2*3 bytes
//  RAW14                  N/4*7 bytes
//  ---------------------------------------
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_SHIFT                        _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_FIELD                        (_MK_MASK_CONST(0xffff) << CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_SHIFT)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_RANGE                        15:0
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_WORD_COUNT_0_CSI_PPA_WORD_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PIXEL_STREAM_A_GAP_0  // CSI Pixel Stream A Gap
#define CSI_PIXEL_STREAM_A_GAP_0                        _MK_ADDR_CONST(0x209)
#define CSI_PIXEL_STREAM_A_GAP_0_SECURE                         0x0
#define CSI_PIXEL_STREAM_A_GAP_0_WORD_COUNT                     0x1
#define CSI_PIXEL_STREAM_A_GAP_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define CSI_PIXEL_STREAM_A_GAP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define CSI_PIXEL_STREAM_A_GAP_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Minium number of viclk cycles from end of 
// previous line (Video_control = EL_DATA) to start
// of next line (Video_control = SL).
// This parameter is to ensure that minimum H-blank
// time requirement of VI/ISP is satisfied.
// This field takes effect only when the line gap 
// of the input stream is less than the specified
// value.
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_SHIFT                 _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_FIELD                 (_MK_MASK_CONST(0xffff) << CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_SHIFT)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_RANGE                 15:0
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_WOFFSET                       0x0
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_LINE_MIN_GAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minium number of viclk cycles from end of 
// frame (Video_control = EF) to start of next
// frame (Video_control = SF).
// This parameter is to ensure that minimum V-blank
// time requirement of VI/ISP is satisfied.
// This field takes effect only when the frame gap 
// of the input stream is less than the specified
// value.
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_SHIFT                        _MK_SHIFT_CONST(16)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_FIELD                        (_MK_MASK_CONST(0xffff) << CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_SHIFT)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_RANGE                        31:16
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_DEFAULT_MASK                 _MK_MASK_CONST(0xffff)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_A_GAP_0_PPA_FRAME_MIN_GAP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PIXEL_STREAM_PPA_COMMAND_0  // CSI Pixel Parser A Command
#define CSI_PIXEL_STREAM_PPA_COMMAND_0                  _MK_ADDR_CONST(0x20a)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_SECURE                   0x0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_WORD_COUNT                       0x1
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_RESET_MASK                       _MK_MASK_CONST(0x3)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_READ_MASK                        _MK_MASK_CONST(0xff17)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_WRITE_MASK                       _MK_MASK_CONST(0xff17)
// CSI Pixel Parser A Enable
//  This parameter controls CSI Pixel Parser A
//  to start or stop receiving data.       reset (disable immediately)
//  Enabling the pixel Parser does not enable 
//  the corresponding input source to receive 
//  data. If Pixel parser is enabled later than
//  the  corresponding input source, csi will keep
//  on rejecting incoming stream, till it encounters
//  a valid SF. 
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_FIELD                     (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_SHIFT)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_RANGE                     1:0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_NOP                       _MK_ENUM_CONST(0)    // //       no operation

#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_ENABLE                    _MK_ENUM_CONST(1)    // //       enable at the next frame start as
//       specified by the CSI Start Marker

#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_DISABLE                   _MK_ENUM_CONST(2)    // //       disable after current frame end and before
//       next frame start.

#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_ENABLE_RST                       _MK_ENUM_CONST(3)

// CSI Pixel Parser A Single Shot Mode SW should Clear it along with disabling the 
// CSI_PPA_ENABLE, once a frame is captured
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_SHIFT                        _MK_SHIFT_CONST(2)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_FIELD                        (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_SHIFT)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_RANGE                        2:2
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_DISABLE                      _MK_ENUM_CONST(0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_SINGLE_SHOT_ENABLE                       _MK_ENUM_CONST(1)

// CSI Pixel Parser A VSYNC Start Marker  start of frame is indicated when VSYNC signal 
//  is received. When the input stream is from the
//  VIP path and the data mode is PACKET, then this
//  field may be programmed to VSYNC.
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_SHIFT                 _MK_SHIFT_CONST(4)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_FIELD                 (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_SHIFT)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_RANGE                 4:4
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_WOFFSET                       0x0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_FSPKT                 _MK_ENUM_CONST(0)    // //  Start of frame is indicated when a Frame
//  Start short packet is received with a frame
//  number whose least significant four bits are
//  greater than, or equal to, 
//  CSI_PPA_START_MARKER_FRAME_MIN and less than,
//  or equal to, CSI_PPA_START_MARKER_FRAME_MAX.
//  When the input stream is from a CSI port, or 
//  from the host path, or from the VIP path and 
//  the data mode is PAYLOAD_ONLY, then this field
//  may be programmed to FSPKT.

#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_VSYNC_START_MARKER_VSYNC                 _MK_ENUM_CONST(1)

// CSI Pixel Parser A Start Marker Minimum
// Start Frame is indicated when Max condition below
// is met and the least significant four bits of the
// frame number are greater than, or equal to, this value.
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_SHIFT                     _MK_SHIFT_CONST(8)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_FIELD                     (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_SHIFT)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_RANGE                     11:8
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MIN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// CSI Pixel Parser A Start Marker Maximum
// Start Frame is indicated when Min condition above
// is met and the least significant four bits of the
// frame number are less than, or equal to, this value.
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_SHIFT                     _MK_SHIFT_CONST(12)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_FIELD                     (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_SHIFT)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_RANGE                     15:12
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPA_COMMAND_0_CSI_PPA_START_MARKER_FRAME_MAX_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 523 [0x20b] 

// Reserved address 524 [0x20c] 

// Reserved address 525 [0x20d] 

// Reserved address 526 [0x20e] 
// reserved for additional Pixel Parser control registers
// in case it is needed in the future

// Register CSI_INPUT_STREAM_B_CONTROL_0  // CSI Input Stream B Control
#define CSI_INPUT_STREAM_B_CONTROL_0                    _MK_ADDR_CONST(0x20f)
#define CSI_INPUT_STREAM_B_CONTROL_0_SECURE                     0x0
#define CSI_INPUT_STREAM_B_CONTROL_0_WORD_COUNT                         0x1
#define CSI_INPUT_STREAM_B_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x3f0000)
#define CSI_INPUT_STREAM_B_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0x7f0013)
#define CSI_INPUT_STREAM_B_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0x7f0013)
#define CSI_INPUT_STREAM_B_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0x7f0013)
// CSI-B Data Lane
//   0= 1 data lane
//   1= 2 data lanes (not supported on SC17 & SC25)
//   2= 3 data lanes (not supported on SC17 & SC25)
//   3= 4 data lanes (not supported on SC17 & SC25)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_SHIFT                      _MK_SHIFT_CONST(0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_FIELD                      (_MK_MASK_CONST(0x3) << CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_SHIFT)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_RANGE                      1:0
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_WOFFSET                    0x0
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_DATA_LANE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Enables skip packet threshold feature. Skip packet feature is enabled.
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_SHIFT                   _MK_SHIFT_CONST(4)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_SHIFT)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_RANGE                   4:4
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_WOFFSET                 0x0
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_DISABLE                 _MK_ENUM_CONST(0)    // // Skip packet feature is disabled.     

#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

// CSI-B Skip Packet Threshold
//  This value is compared against the internal
//  FIFO that buffer the input streams. A packet
//  will be skipped (discarded) if the pixel
//  stream processor is busy (probably due to
//  padding process of a short line) and the
//  number of entries in the internal FIFO
//  exceeds this threshold value. Note that
//  each entry in the internal FIFO buffer is
//  four bytes.
//  To turn off this feature, set the value
//  to its maximum value (all ones).
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_SHIFT                  _MK_SHIFT_CONST(16)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_FIELD                  (_MK_MASK_CONST(0x7f) << CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_SHIFT)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_RANGE                  22:16
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_WOFFSET                        0x0
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_DEFAULT                        _MK_MASK_CONST(0x3f)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x7f)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_INPUT_STREAM_B_CONTROL_0_CSI_B_SKIP_PACKET_THRESHOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 528 [0x210] 
// reserved for additional Input Stream control register
// in case it is needed in the future

// Register CSI_PIXEL_STREAM_B_CONTROL0_0  // CSI Pixel Stream A Control 0
#define CSI_PIXEL_STREAM_B_CONTROL0_0                   _MK_ADDR_CONST(0x211)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_SECURE                    0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_WORD_COUNT                        0x1
#define CSI_PIXEL_STREAM_B_CONTROL0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_RESET_MASK                        _MK_MASK_CONST(0x7)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_READ_MASK                         _MK_MASK_CONST(0x3b3ffff7)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_WRITE_MASK                        _MK_MASK_CONST(0x3b3ffff7)
// CSI Pixel Parser B Stream Source   Host
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_SHIFT                       _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_FIELD                       (_MK_MASK_CONST(0x7) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_RANGE                       2:0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_CSI_A                       _MK_ENUM_CONST(0)    // //   CSI Interface A

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_CSI_B                       _MK_ENUM_CONST(1)    // //   CSI Interface B

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_VI_PORT                     _MK_ENUM_CONST(6)    // //   VI port

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_STREAM_SOURCE_HOST                        _MK_ENUM_CONST(7)

// CSI Pixel Parser B Packet Header processing
//  This specifies whether packet header is
//  sent in the beginning of packet or not.      Packet header is sent.
//      This setting should be used if the
//      stream source is CSI Interface A or B.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_SHIFT                       _MK_SHIFT_CONST(4)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_FIELD                       (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_RANGE                       4:4
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_NOT_SENT                    _MK_ENUM_CONST(0)    // //      Packet header is not sent.
//      This setting should not be used if the
//      stream source is CSI Interface A or B.
//      Unless CSI-A, or CSI-B, is operating in a
//      stream capture debug mode.
//      In this case, CSI_PPB_DATA_TYPE specifies
//      the stream data format and the number
//      of bytes per line/packet is
//      specified by CSI_PPB_WORD_COUNT.
//      This implies that a packet footer
//      is also not sent.  In this case, no 
//      packet footer CRC check should be performed.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PACKET_HEADER_SENT                        _MK_ENUM_CONST(1)

// CSI Pixel Parser B Data Identifier (DI) byte processing
//  This parameter is effective only if packet
//  header is sent as part of the stream.      Enabled  - Data Identifier byte in
//      packet header should be compared against
//      the CSI_PPB_DATA_TYPE and the
//      CSI_PPB_VIRTUAL_CHANNEL_ID.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_SHIFT                     _MK_SHIFT_CONST(5)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_FIELD                     (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_RANGE                     5:5
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_DISABLED                  _MK_ENUM_CONST(0)    // //      Disabled - Data Identifier byte in
//      packet header should be ignored
//      (not checked against CSI_PPB_DATA_TYPE
//      and against CSI_PPB_VIRTUAL_CHANNEL_ID).
//      In this case, CSI_PPB_DATA_TYPE specifies
//      the stream data format.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_IDENTIFIER_ENABLED                   _MK_ENUM_CONST(1)

// CSI Pixel Parser B Word Count Select
//  This parameter is effective only if packet
//  header is sent as part of the stream.      The number of bytes per line is to be
//      extracted from Word Count field in the
//      packet header. Note that if the serial
//      link is not error free, programming this
//      bit to HEADER may be dangerous because 
//      the word count information in the header
//      may be corrupted. 
//
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_SHIFT                   _MK_SHIFT_CONST(6)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_FIELD                   (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_RANGE                   6:6
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_REGISTER                        _MK_ENUM_CONST(0)    // //      Word Count in packet header is ignored
//      and the number of bytes per line/packet
//      is specified by CSI_PPB_WORD_COUNT. Payload
//      CRC check will not be valid if the word
//      count in CSI_PPB_WORD_COUNT is different 
//      than the count in the packet header.
//      It is recommended to always program
//      this bit to REGISTER and always program
//      CSI_PPB_WORD_COUNT.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_WORD_COUNT_SELECT_HEADER                  _MK_ENUM_CONST(1)

// CSI Pixel Parser B Data CRC Check
//  This parameter specifies whether the last
//  2 bytes of packet should be treated as
//  CRC checksum and used to perform CRC check
//  on the payload data. Note that in case there
//  are 2 bytes of data CRC at the end of the
//  packet, the packet word count does not
//  include the CRC bytes.      Data CRC Check is enabled.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_SHIFT                   _MK_SHIFT_CONST(7)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_RANGE                   7:7
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_DISABLE                 _MK_ENUM_CONST(0)    // //      Data CRC Check is disabled regardless
//      of whether there are CRC checksum at
//      the end of the packet.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_CRC_CHECK_ENABLE                  _MK_ENUM_CONST(1)

// CSI Pixel Parser B Data Type  This is CSI compatible data type as defined
//  in CSI specification. If the source stream
//  contains packet headers this value can be compared
//  to the CSI Data Type value in the 6 LSB of the
//  CSI Data Identifier (DI) byte. If the source stream
//  doesn't contain packet headers, or CSI_PPB_DATA_IDENTIFIER
//  is DISABLED, this value will be used to determine how
//  the stream will be converted to pixels.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_SHIFT                   _MK_SHIFT_CONST(8)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_FIELD                   (_MK_MASK_CONST(0x3f) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RANGE                   13:8
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_YUV420_8                        _MK_ENUM_CONST(24)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_YUV420_10                       _MK_ENUM_CONST(25)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_LEG_YUV420_8                    _MK_ENUM_CONST(26)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_YUV420CSPS_8                    _MK_ENUM_CONST(28)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_YUV420CSPS_10                   _MK_ENUM_CONST(29)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_YUV422_8                        _MK_ENUM_CONST(30)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_YUV422_10                       _MK_ENUM_CONST(31)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RGB444                  _MK_ENUM_CONST(32)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RGB555                  _MK_ENUM_CONST(33)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RGB565                  _MK_ENUM_CONST(34)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RGB666                  _MK_ENUM_CONST(35)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RGB888                  _MK_ENUM_CONST(36)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RAW6                    _MK_ENUM_CONST(40)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RAW7                    _MK_ENUM_CONST(41)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RAW8                    _MK_ENUM_CONST(42)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RAW10                   _MK_ENUM_CONST(43)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RAW12                   _MK_ENUM_CONST(44)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_RAW14                   _MK_ENUM_CONST(45)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_ARB_DT1                 _MK_ENUM_CONST(48)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_ARB_DT2                 _MK_ENUM_CONST(49)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_ARB_DT3                 _MK_ENUM_CONST(50)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_DATA_TYPE_ARB_DT4                 _MK_ENUM_CONST(51)

// CSI Pixel Parser B Virtual Channel Identifier  
//  This is CSI compatible virtual channel
//  identifier as defined in CSI specification.
//  If the source stream contains packet headers
//  and CSI_PPB_DATA_IDENTIFIER is ENABLED this
//  value will be compared to the CSI Virtual
//  Channel Identifier value in the 2 MSB of the
//  CSI Data Identifier (DI) byte. This value will
//  be ignored if the source stream doesn't contain
//  packet headers, or CSI_PPB_DATA_IDENTIFIER is 
//  DISABLED, then this value will be ignored.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_SHIFT                  _MK_SHIFT_CONST(14)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_FIELD                  (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_RANGE                  15:14
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_WOFFSET                        0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_ONE                    _MK_ENUM_CONST(0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_TWO                    _MK_ENUM_CONST(1)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_THREE                  _MK_ENUM_CONST(2)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_VIRTUAL_CHANNEL_ID_FOUR                   _MK_ENUM_CONST(3)

// CSI Pixel Parser B Output Format Options
//  This parameter specifies output data format.       Output for storing RAW data to memory through
//       ISP. Undefined LS color bits for RGB_666, 
//       RGB_565, RGB_555, and RGB_444, will be zeroed.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_SHIFT                       _MK_SHIFT_CONST(16)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_FIELD                       (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_RANGE                       19:16
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_ARBITRARY                   _MK_ENUM_CONST(0)    // //       Output as 8-bit arbitrary data stream
//       This may be used for compressed JPEG stream

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_PIXEL                       _MK_ENUM_CONST(1)    // //       Output the normal 1 pixel/clock. Undefined 
//       LS color bits for RGB_666, RGB_565, RGB_555,
//       and RGB_444, will be zeroed.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_PIXEL_REP                   _MK_ENUM_CONST(2)    // //       Same as PIXEL except MS color bits, for RGB_666, 
//       RGB_565, RGB_555, and RGB_444, will be 
//       replicated to their undefined LS bits.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_OUTPUT_FORMAT_OPTIONS_STORE                       _MK_ENUM_CONST(3)

// CSI Pixel Parser B Embedded Data Options 
//  This specifies how to deal with embedded
//  data within the specified input stream
//  assuming that the CSI_PPB_DATA_TYPE is not
//  embedded data and assuming that embedded
//  data is not already processed by other
//  CSI pixel stream processor.       output embedded data as 8-bpp arbitrary
//       data stream.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_SHIFT                       _MK_SHIFT_CONST(20)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_FIELD                       (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_RANGE                       21:20
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_WOFFSET                     0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_DISCARD                     _MK_ENUM_CONST(0)    // //       discard (throw away) embedded data

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_EMBEDDED_DATA_OPTIONS_EMBEDDED                    _MK_ENUM_CONST(1)

// CSI Pixel Parser B Pad Short Line
//  This specifies how to deal with shorter than
//  expected line (the number of bytes received
//  is less than the specified word count)       short line is not padded (will output
//       less pixels than expected).
//       This option is not recommended and may
//       cause other modules that receives CSI
//       output stream to hang up.
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_SHIFT                      _MK_SHIFT_CONST(24)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_FIELD                      (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_RANGE                      25:24
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_WOFFSET                    0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_PAD0S                      _MK_ENUM_CONST(0)    // //       short line is padded by pixel of zeros
//       such that the expected number of output
//       pixels is correct. Due to the time
//       required to do the padding, subsequent
//       line packet maybe discarded and
//       therefore may cause a short frame
//       (total number of lines per frame is
//       less than expected).

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_PAD1S                      _MK_ENUM_CONST(1)    // //       short line is padded by pixel of ones
//       such that the expected number of output
//       pixels is correct. Due to the time
//       required to do the padding, subsequent
//       line packet maybe discarded and
//       therefore may cause a short frame
//       (total number of lines per frame is
//       less than expected).

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_SHORT_LINE_NOPAD                      _MK_ENUM_CONST(2)

// CSI Pixel Parser B Packet Header Error Correction Enable
//  This parameter specifies whether single bit
//  errors in the packet header will be
//  automatically corrected, or not.    Single bit errors in the header will not
//    be corrected. Header ECC check will still
//    set header ECC status bits and the packet
//    will be processed by Pixel Parser B. DISABLE
//    should not be used when processing interleaved
//    streams (Same stream going to both PPA and PPB).
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_SHIFT                    _MK_SHIFT_CONST(27)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_RANGE                    27:27
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_WOFFSET                  0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_ENABLE                   _MK_ENUM_CONST(0)    // //    Single bit errors in the header will be
//    automatically corrected.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_HEADER_EC_ENABLE_DISABLE                  _MK_ENUM_CONST(1)

// CSI Pixel Parser B Pad Frame
//  This specifies how to deal with frames that are
//  shorter (fewer lines) that expected. Short frames
//  are usually caused by line packets being dropped
//  because of packet errors. Expected frame height is
//  specified in PPB_EXP_FRAME_HEIGHT. To do padding the
//  value in CSI_PPB_WORD_COUNT needs to be set to the
//  number of input bytes in each lines payload.  Short frames will not be padded out.   
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_SHIFT                   _MK_SHIFT_CONST(28)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_FIELD                   (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_RANGE                   29:28
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_WOFFSET                 0x0
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_PAD0S                   _MK_ENUM_CONST(0)    // //  Lines of all zeros will be used to pad out frames
//  that are shorter than expected height.   
//  PPB_EXP_FRAME_HEIGHT must be programmed to
//  an appropriate value if this fields is set to PAD0S.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_PAD1S                   _MK_ENUM_CONST(1)    // //  Lines of all ones will be used to pad out frames
//  that are shorter than expected height.      
//  PPB_EXP_FRAME_HEIGHT must be programmed to
//  an appropriate value if this fields is set to PAD1S.

#define CSI_PIXEL_STREAM_B_CONTROL0_0_CSI_PPB_PAD_FRAME_NOPAD                   _MK_ENUM_CONST(2)


// Register CSI_PIXEL_STREAM_B_CONTROL1_0  // CSI Pixel Stream B Control 1
#define CSI_PIXEL_STREAM_B_CONTROL1_0                   _MK_ADDR_CONST(0x212)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_SECURE                    0x0
#define CSI_PIXEL_STREAM_B_CONTROL1_0_WORD_COUNT                        0x1
#define CSI_PIXEL_STREAM_B_CONTROL1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
// CSI Pixel Parser B Top Field Frame
//  This parameter specifies the frame number for 
//  top field detection for interlaced input video
//  stream. Top Field is indicated when each of the
//  least significant four bits of the frame number
//  that has a one in its mask bit matches the 
//  corresponding bit in this parameter. In other
//  words, Top Field is detected when the bitwise
//  AND of  
// ~(CSI_PPB_TOP_FIELD_FRAME ^ <frame number>) & CSI_PPB_TOP_FIELD_FRAME_MASK
//  is one. Frame Number is taken from the WC field
//  of the Frame Start short packet.
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_FIELD                     (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_RANGE                     3:0
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// CSI Pixel Parser B Top Field Frame Mask
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_FIELD                        (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_SHIFT)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_RANGE                        7:4
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_CONTROL1_0_CSI_PPB_TOP_FIELD_FRAME_MASK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PIXEL_STREAM_B_WORD_COUNT_0  // CSI Pixel Stream A Word Count
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0                 _MK_ADDR_CONST(0x213)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_SECURE                  0x0
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_WORD_COUNT                      0x1
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
// CSI Pixel Parser B Word Count
//  This parameter specifies the number of
//  bytes per line/packet in the case where
//  Word Count field in packet header is not
//  used or where packet header is not sent.
//  This count does not includes the additional
//  2 bytes of CRC checksum if data CRC check
//  is enabled.
//  When the input stream comes from a CSI camera
//  port, this parameter must be programmed when 
//  CSI_PPB_PAD_SHORT_LINE is set to either PAD0S
//  or PAD1S, no matter whether CSI_PPB_WORD_COUNT_SELECT
//  is set to REGISTER or HEADER.
//  When the input stream comes from the host path
//  or from the VIP path, and the data mode is
//  PAYLOAD_ONLY, this count must be programmed.
// Given a line width of N pixels, the programming 
//  value of this parameters is as follows
//  --------------------------------------
//  data format            value
//  --------------------------------------
//  YUV420_8               N bytes
//  YUV420_10              N/4*5 bytes
//  LEG_YUV420_8           N/2*3 bytes
//  YUV422_8               N*2 bytes
//  YUV422_10              N/2*5 bytes
//  RGB888                 N*3 bytes 
//  RGB666                 N/4*9 bytes                 
//  RGB565                 N*2 bytes
//  RGB555                 N*2 bytes 
//  RGB444                 N*2 bytes 
//  RAW6                   N/4*3 bytes
//  RAW7                   N/8*7 bytes
//  RAW8                   N bytes 
//  RAW10                  N/4*5 bytes
//  RAW12                  N/2*3 bytes
//  RAW14                  N/4*7 bytes
//  ---------------------------------------
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_SHIFT                        _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_FIELD                        (_MK_MASK_CONST(0xffff) << CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_SHIFT)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_RANGE                        15:0
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_WORD_COUNT_0_CSI_PPB_WORD_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PIXEL_STREAM_B_GAP_0  // CSI Pixel Stream B Gap
#define CSI_PIXEL_STREAM_B_GAP_0                        _MK_ADDR_CONST(0x214)
#define CSI_PIXEL_STREAM_B_GAP_0_SECURE                         0x0
#define CSI_PIXEL_STREAM_B_GAP_0_WORD_COUNT                     0x1
#define CSI_PIXEL_STREAM_B_GAP_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define CSI_PIXEL_STREAM_B_GAP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define CSI_PIXEL_STREAM_B_GAP_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Minium number of viclk cycles from end of 
// previous line (Video_control = EL_DATA) to start
// of next line (Video_control = SL).
// This parameter is to ensure that minimum H-blank
// time requirement of VI/ISP is satisfied.
// This field takes effect only when the line gap 
// of the input stream is less than the specified
// value.
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_SHIFT                 _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_FIELD                 (_MK_MASK_CONST(0xffff) << CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_SHIFT)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_RANGE                 15:0
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_WOFFSET                       0x0
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_LINE_MIN_GAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minium number of viclk cycles from end of 
// frame (Video_control = EF) to start of next
// frame (Video_control = SF).
// This parameter is to ensure that minimum V-blank
// time requirement of VI/ISP is satisfied.
// This field takes effect only when the frame gap 
// of the input stream is less than the specified
// value.
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_SHIFT                        _MK_SHIFT_CONST(16)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_FIELD                        (_MK_MASK_CONST(0xffff) << CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_SHIFT)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_RANGE                        31:16
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_DEFAULT_MASK                 _MK_MASK_CONST(0xffff)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_B_GAP_0_PPB_FRAME_MIN_GAP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PIXEL_STREAM_PPB_COMMAND_0  // CSI Pixel Parser B Command
#define CSI_PIXEL_STREAM_PPB_COMMAND_0                  _MK_ADDR_CONST(0x215)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_SECURE                   0x0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_WORD_COUNT                       0x1
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_RESET_MASK                       _MK_MASK_CONST(0x3)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_READ_MASK                        _MK_MASK_CONST(0xff17)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_WRITE_MASK                       _MK_MASK_CONST(0xff17)
// CSI Pixel Parser B Enable
//  This parameter controls CSI Pixel Parser B
//  to start or stop receiving data.       reset (disable immediately)
//  Enabling the pixel Parser does not enable 
//  the corresponding input source to receive 
//  data. If Pixel parser is enabled later than
//  the  corresponding input source, csi will keep
//  on rejecting incoming stream, till it encounters
//  a valid SF.
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_FIELD                     (_MK_MASK_CONST(0x3) << CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_SHIFT)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_RANGE                     1:0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_NOP                       _MK_ENUM_CONST(0)    // //       no operation

#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_ENABLE                    _MK_ENUM_CONST(1)    // //       enable at the next frame start as
//       specified by the CSI Start Marker

#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_DISABLE                   _MK_ENUM_CONST(2)    // //       disable after current frame end and before
//       next frame start.

#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_ENABLE_RST                       _MK_ENUM_CONST(3)

// CSI Pixel Parser B Single Shot Mode SW should Clear it alongwith disabling the 
// CSI_PPB_ENABLE, once a frame is captured
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_SHIFT                        _MK_SHIFT_CONST(2)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_FIELD                        (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_SHIFT)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_RANGE                        2:2
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_WOFFSET                      0x0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_DISABLE                      _MK_ENUM_CONST(0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_SINGLE_SHOT_ENABLE                       _MK_ENUM_CONST(1)

// CSI Pixel Parser B VSYNC Start Marker  Start of frame is indicated when VSYNC signal 
//  is received. When the input stream is from the
//  VIP path and the data mode is PACKET, then this
//  field may be programmed to VSYNC.
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_SHIFT                 _MK_SHIFT_CONST(4)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_FIELD                 (_MK_MASK_CONST(0x1) << CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_SHIFT)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_RANGE                 4:4
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_WOFFSET                       0x0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_FSPKT                 _MK_ENUM_CONST(0)    // //      Start of frame is indicated when a Frame
//    Start short packet is received with a frame
//    number who's least significant four bits are
//    greater than, or equal to, 
//    CSI_PPB_START_MARKER_FRAME_MIN and less than,
//    or equal to, CSI_PPB_START_MARKER_FRAME_MAX.
//  When the input stream is from a CSI port, or 
//  from the host path, or from the VIP path and 
//  the data mode is PAYLOAD_ONLY, then this field
//  may be programmed to FSPKT.

#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_VSYNC_START_MARKER_VSYNC                 _MK_ENUM_CONST(1)

// CSI Pixel Parser B Start Marker Minimum
// Start Frame is indicated when Max condition below
// is met and the least significant four bits of the
// frame number are greater than, or equal to, this value.
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_SHIFT                     _MK_SHIFT_CONST(8)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_FIELD                     (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_SHIFT)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_RANGE                     11:8
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MIN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// CSI Pixel Parser B Start Marker Maximum
// Start Frame is indicated when Min condition above
// is met and the least significant four bits of the
// frame number are less than, or equal to, this value.
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_SHIFT                     _MK_SHIFT_CONST(12)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_FIELD                     (_MK_MASK_CONST(0xf) << CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_SHIFT)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_RANGE                     15:12
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_WOFFSET                   0x0
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_PIXEL_STREAM_PPB_COMMAND_0_CSI_PPB_START_MARKER_FRAME_MAX_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 534 [0x216] 

// Reserved address 535 [0x217] 

// Reserved address 536 [0x218] 

// Reserved address 537 [0x219] 
// reserved for additional Pixel Parser control registers
// in case it is needed in the future

// Register CSI_PHY_CIL_COMMAND_0  // CSI Phy and CIL Command
#define CSI_PHY_CIL_COMMAND_0                   _MK_ADDR_CONST(0x21a)
#define CSI_PHY_CIL_COMMAND_0_SECURE                    0x0
#define CSI_PHY_CIL_COMMAND_0_WORD_COUNT                        0x1
#define CSI_PHY_CIL_COMMAND_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_RESET_MASK                        _MK_MASK_CONST(0x30003)
#define CSI_PHY_CIL_COMMAND_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_READ_MASK                         _MK_MASK_CONST(0x30003)
#define CSI_PHY_CIL_COMMAND_0_WRITE_MASK                        _MK_MASK_CONST(0x30003)
// CSI A Phy and CIL Enable
//  This parameter controls CSI A Phy and CIL
//  receiver to start or stop receiving data.    disable (reset)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_FIELD                        (_MK_MASK_CONST(0x3) << CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_SHIFT)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_RANGE                        1:0
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_WOFFSET                      0x0
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_NOP                  _MK_ENUM_CONST(0)    // //    no operation

#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_ENABLE                       _MK_ENUM_CONST(1)    // //    enable

#define CSI_PHY_CIL_COMMAND_0_CSI_A_PHY_CIL_ENABLE_DISABLE                      _MK_ENUM_CONST(2)

// CSI B Phy and CIL Enable
//  This parameter controls CSI B Phy and CIL
//  receiver to start or stop receiving data.    disable (reset)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_SHIFT                        _MK_SHIFT_CONST(16)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_FIELD                        (_MK_MASK_CONST(0x3) << CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_SHIFT)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_RANGE                        17:16
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_WOFFSET                      0x0
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_NOP                  _MK_ENUM_CONST(0)    // //    no operation

#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_ENABLE                       _MK_ENUM_CONST(1)    // //    enable

#define CSI_PHY_CIL_COMMAND_0_CSI_B_PHY_CIL_ENABLE_DISABLE                      _MK_ENUM_CONST(2)


// Register CSI_PHY_CILA_CONTROL0_0  // CSI-A Phy and CIL Control
#define CSI_PHY_CILA_CONTROL0_0                 _MK_ADDR_CONST(0x21b)
#define CSI_PHY_CILA_CONTROL0_0_SECURE                  0x0
#define CSI_PHY_CILA_CONTROL0_0_WORD_COUNT                      0x1
#define CSI_PHY_CILA_CONTROL0_0_RESET_VAL                       _MK_MASK_CONST(0x2)
#define CSI_PHY_CILA_CONTROL0_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define CSI_PHY_CILA_CONTROL0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define CSI_PHY_CILA_CONTROL0_0_WRITE_MASK                      _MK_MASK_CONST(0x3f)
// When moving from LP mode to High Speed (LP11->LP01->LP00),
// this setting determines how many csicil clock cycles (72 MHz
// lp clock cycles) to wait, after LP00, 
// before starting to look at the data.
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_SHIFT                   _MK_SHIFT_CONST(0)
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_FIELD                   (_MK_MASK_CONST(0xf) << CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_SHIFT)
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_RANGE                   3:0
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_WOFFSET                 0x0
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_DEFAULT                 _MK_MASK_CONST(0x2)
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_CILA_THS_SETTLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// The LP signals are sampled using csi_cil_clk.
// Normally this happens on 2 clock edges assuming
// the clock is running at least 50 Mhz.  If the
// clock needs to run slower, then this bit can be
// SET so that the sampling takes place on a single
// edge (clock rate is 25 Mhz min).  This sampling
// may not be as reliable so setting this bit is
// not recommended.
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_FIELD                        (_MK_MASK_CONST(0x1) << CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_SHIFT)
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_RANGE                        4:4
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_WOFFSET                      0x0
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_CILA_SINGLE_SAMPLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// The LP signals should sequence through LP11->LP01->LP00 state,
// to indicate to CLOCK CIL about the mode switching to HS Rx mode.
// In case Camera is enabled earlier than CIL , it is highly likely
// that camera sends this control sequence sooner than cil can detect it.
// Enabling this bit allows the CLOCK CIL to overlook the LP control sequence
// and step in HS Rx mode directly looking at LP00 only.
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_SHIFT                        _MK_SHIFT_CONST(5)
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_FIELD                        (_MK_MASK_CONST(0x1) << CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_SHIFT)
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_RANGE                        5:5
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_WOFFSET                      0x0
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CILA_CONTROL0_0_CILA_BYPASS_LP_SEQ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CSI_PHY_CILB_CONTROL0_0  // CSI-B Phy and CIL Control
#define CSI_PHY_CILB_CONTROL0_0                 _MK_ADDR_CONST(0x21c)
#define CSI_PHY_CILB_CONTROL0_0_SECURE                  0x0
#define CSI_PHY_CILB_CONTROL0_0_WORD_COUNT                      0x1
#define CSI_PHY_CILB_CONTROL0_0_RESET_VAL                       _MK_MASK_CONST(0x2)
#define CSI_PHY_CILB_CONTROL0_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define CSI_PHY_CILB_CONTROL0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define CSI_PHY_CILB_CONTROL0_0_WRITE_MASK                      _MK_MASK_CONST(0x3f)
// When moving from LP mode to High Speed (LP11->LP01->LP00),
// this setting determines how many  csicil clock cycles (72 MHz
// lp clock cycles) to wait, after LP00,
// before starting to look at the data.
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_SHIFT                   _MK_SHIFT_CONST(0)
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_FIELD                   (_MK_MASK_CONST(0xf) << CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_SHIFT)
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_RANGE                   3:0
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_WOFFSET                 0x0
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_DEFAULT                 _MK_MASK_CONST(0x2)
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_CILB_THS_SETTLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// see CILA_SINGLE_SAMPLE above
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_FIELD                        (_MK_MASK_CONST(0x1) << CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_SHIFT)
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_RANGE                        4:4
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_WOFFSET                      0x0
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_CILB_SINGLE_SAMPLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// see CILA_BYPASS_LP_SEQ above
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_SHIFT                        _MK_SHIFT_CONST(5)
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_FIELD                        (_MK_MASK_CONST(0x1) << CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_SHIFT)
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_RANGE                        5:5
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_WOFFSET                      0x0
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_PHY_CILB_CONTROL0_0_CILB_BYPASS_LP_SEQ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 541 [0x21d] 
// reserved for additional Input Stream control register
// in case it is needed in the future

// Register CSI_CSI_PIXEL_PARSER_STATUS_0  // Pixel Parser Status
// These status bits are cleared to
// zero when its bit position is written with one. For
// example write 0x2 to CSI_PIXEL_PARSER_STATUS will 
// clear only PPA_ILL_WD_CNT.
#define CSI_CSI_PIXEL_PARSER_STATUS_0                   _MK_ADDR_CONST(0x21e)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_SECURE                    0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_WORD_COUNT                        0x1
#define CSI_CSI_PIXEL_PARSER_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_READ_MASK                         _MK_MASK_CONST(0xcfffcfff)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Header Error Corrected, Set when a packet that was
// processed by PPA has a single bit header error. This error
// will be detected by the headers ECC, and corrected by
// it if header error correction is enabled 
// (CSI_A_HEADER_EC_ENABLE = 0). This flag will be set and 
// the packet will be processed even if the error is not
// corrected.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_RANGE                     0:0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_HDR_ERR_COR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Illegal Word Count, set when a line with a word count that
// doesn't generate an integer number of pixels (Unused bytes
// at the end of payload) is processed by PPA.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_SHIFT                      _MK_SHIFT_CONST(1)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_RANGE                      1:1
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_WOFFSET                    0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_ILL_WD_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Short Line Processed, Set when a line with a payload that
// is shorter than its packet header word count is processed
// by PPA.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_SHIFT                    _MK_SHIFT_CONST(2)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_RANGE                    2:2
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PROCESSED_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Short Line Packet Dropped, set when a in coming packet
// gets dropped because the input FIFO level reaches
// CSI_A_SKIP_PACKET_THRESHOLD when padding a short line.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_SHIFT                  _MK_SHIFT_CONST(3)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_RANGE                  3:3
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SL_PKT_DROPPED_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PayLoad CRC Error, Set when a packet that was processed by
// PPA had a payload CRC error.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_SHIFT                      _MK_SHIFT_CONST(4)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_RANGE                      4:4
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_WOFFSET                    0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_PL_CRC_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// FIFO Overflow, set when the fifo that is feeding packets
// to PPA overflows.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_SHIFT                       _MK_SHIFT_CONST(5)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_FIELD                       (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_RANGE                       5:5
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_WOFFSET                     0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_FIFO_OVRF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Stream Error, set when the control output of PPA doesn't
// follow the correct sequence. The correct sequence for CSI
// is: SF -> (SL_DATA or EF), SL_DATA -> (DATA or EL_DATA),
// DATA -> EL_DATA, EL_DATA -> (SL_DATA or EF), EF -> SF.
// Stream Errors can be caused by receiving a corrupted
// stream, or a CSI RTL bug.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_SHIFT                  _MK_SHIFT_CONST(6)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_RANGE                  6:6
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_STMERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Set when CSI-PPA receives a short frame. This bit gets
// set even if CSI_PPA_PAD_FRAME specifies that short frames
// are to be padded to the correct line length.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_SHIFT                     _MK_SHIFT_CONST(7)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_RANGE                     7:7
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SHORT_FRAME_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Set when CSI-PPA receives a SF when it is expecting an EF.
// This happens when EF of the frame gets corrupted before arriving CSI.
// CSI-PPA will insert a fake EF and the drop the current 
// frame with Correct SF.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_SHIFT                        _MK_SHIFT_CONST(8)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_FIELD                        (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_RANGE                        8:8
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_WOFFSET                      0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_EXTRA_SF_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Set when CSI-PPA receives a request to output a line
// that is not in the active part of the frame output. That
// is after EF and before SF, or before start marker is found.
// The interframe line will not be outputted by the Pixel 
// Parser.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_SHIFT                 _MK_SHIFT_CONST(9)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_RANGE                 9:9
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_INTERFRAME_LINE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// PPA Spare Status bit. This bit will get set when Pixel Parser
// A has a line timeout. Line timeout needs to be enabled by setting
// PPA_ENABLE_LINE_TIMEOUT and programming PPA_MAX_CLOCKS for
// the MAX clocks between lines.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_SHIFT                  _MK_SHIFT_CONST(10)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_RANGE                  10:10
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PPA Spare Status bit.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_SHIFT                  _MK_SHIFT_CONST(11)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_RANGE                  11:11
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPA_SPARE_STATUS_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Uncorrectable Header Error, Set when header parser A
// parses a header with a multi bit error. This error will
// be detected by the headers ECC, but can't be corrected.
// The packet will be discarded.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_SHIFT                     _MK_SHIFT_CONST(14)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_RANGE                     14:14
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPA_UNC_HDR_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Uncorrectable Header Error, Set when header parser B
// parses a header with a multi bit error. This error will
// be detected by the headers ECC, but can't be corrected.
// The packet will be discarded.a multi bit error. This error will
// be detected by the headers ECC, but can't be corrected.
// The packet will be discarded.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_SHIFT                     _MK_SHIFT_CONST(15)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_RANGE                     15:15
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPB_UNC_HDR_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Header Error Corrected, set when a packet that was
// processed by PPB has a single bit header error. This error
// will be detected by the headers ECC, and corrected by
// it if header error correction is enabled 
// (CSI_B_HEADER_EC_ENABLE = 0). This flag will be set and 
// the packet will be processed even if the error is not
// corrected.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_SHIFT                     _MK_SHIFT_CONST(16)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_RANGE                     16:16
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_HDR_ERR_COR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Illegal Word Count, set when a line with a word count that
// doesn't generate an integer number of pixels (Unused bytes
// at the end of payload) is processed by PPB.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_SHIFT                      _MK_SHIFT_CONST(17)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_RANGE                      17:17
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_WOFFSET                    0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_ILL_WD_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Short Line Processed, Set when a line with a payload that
// is shorter than its packet header word count is processed
// by PPB.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_SHIFT                    _MK_SHIFT_CONST(18)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_RANGE                    18:18
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PROCESSED_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Short Line Packet Dropped, set when a in coming packet
// gets dropped because the input FIFO level reaches
// CSI_B_SKIP_PACKET_THRESHOLD when padding a short line.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_SHIFT                  _MK_SHIFT_CONST(19)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_RANGE                  19:19
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SL_PKT_DROPPED_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PayLoad CRC Error, Set when a packet that was processed
// by PPB had a payload CRC error.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_SHIFT                      _MK_SHIFT_CONST(20)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_RANGE                      20:20
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_WOFFSET                    0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_PL_CRC_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// FIFO Overflow, set when the fifo that is feeding packets
// to PPB overflows.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_SHIFT                       _MK_SHIFT_CONST(21)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_FIELD                       (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_RANGE                       21:21
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_WOFFSET                     0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_FIFO_OVRF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Stream Error, set when the control output of PPB doesn't
// follow the correct sequence. The correct sequence for CSI
// is: SF -> (SL_DATA or EF), SL_DATA -> (DATA or EL_DATA),
// DATA -> EL_DATA, EL_DATA -> (SL_DATA or EF), EF -> SF.
// Stream Errors can be caused by receiving a corrupted
// stream, or a CSI RTL bug.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_SHIFT                  _MK_SHIFT_CONST(22)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_RANGE                  22:22
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_STMERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Set when CSI-PPB receives a short frame. This bit gets
// set even if CSI_PPB_PAD_FRAME specifies that short frames
// are to be padded to the correct line length.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_SHIFT                     _MK_SHIFT_CONST(23)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_RANGE                     23:23
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SHORT_FRAME_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Set when CSI-PPB receives a SF when it is expecting an EF. 
// This happens when EF of the frame gets corrupted before arriving CSI.
// CSI-PPB will insert a fake EF and the drop the current 
// frame with Correct SF.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_SHIFT                        _MK_SHIFT_CONST(24)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_FIELD                        (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_RANGE                        24:24
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_WOFFSET                      0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_EXTRA_SF_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Set when CSI-PPB receives a request to output a line
// that is not in the active part of the frame output. That
// is after EF and before SF, or before start marker is found.
// The interframe line will not be outputted by the Pixel 
// Parser.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_SHIFT                 _MK_SHIFT_CONST(25)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_RANGE                 25:25
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_INTERFRAME_LINE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// PPB Spare Status bit. This bit will get set when Pixel Parser
// B has a line timeout. Line timeout needs to be enabled by setting
// PPB_ENABLE_LINE_TIMEOUT and programming PPB_MAX_CLOCKS for
// the MAX clocks between lines.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_SHIFT                  _MK_SHIFT_CONST(26)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_RANGE                  26:26
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PPB Spare Status bit.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_SHIFT                  _MK_SHIFT_CONST(27)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_RANGE                  27:27
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_WOFFSET                        0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_PPB_SPARE_STATUS_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Uncorrectable Header Error, Set when the VI port header
// parser parses a header with a multi bit error. This error
// will be detected by the headers ECC, but can't be corrected.
// The packet will be discarded.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_SHIFT                     _MK_SHIFT_CONST(30)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_RANGE                     30:30
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPV_UNC_HDR_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Uncorrectable Header Error, Set when the Host port header
// parser parses a header with a multi bit error. This error
// will be detected by the headers ECC, but can't be corrected.
// The packet will be discarded.
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_SHIFT                     _MK_SHIFT_CONST(31)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_SHIFT)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_RANGE                     31:31
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_STATUS_0_HPH_UNC_HDR_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CSI_CSI_CIL_STATUS_0  // CSI Control and Interface Logic Status
// These status bits are cleared to
// zero when its bit position is written with one. For
// example write 0x2 to CSI_CIL_STATUS will clear only
// CILA_SOT_MB_ERR.
#define CSI_CSI_CIL_STATUS_0                    _MK_ADDR_CONST(0x21f)
#define CSI_CSI_CIL_STATUS_0_SECURE                     0x0
#define CSI_CSI_CIL_STATUS_0_WORD_COUNT                         0x1
#define CSI_CSI_CIL_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_READ_MASK                  _MK_MASK_CONST(0x1ff81ff)
#define CSI_CSI_CIL_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Start of Transmission Single Bit Error, set when CIL-A 
// detects a single bit error in one of the 
// packets Start of Transmission bytes. The packet will be
// sent to the CSI-A for processing.
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_RANGE                      0:0
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_WOFFSET                    0x0
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_SB_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Start of Transmission Multi Bit Error, set when CIL-A
// detects a multi bit start of transmission byte error in
// one of the packets SOT bytes. The packet will be discarded.
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_SHIFT                      _MK_SHIFT_CONST(1)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_RANGE                      1:1
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_WOFFSET                    0x0
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SOT_MB_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Sync Escape Error, set when CIL-A detects that the wrong 
// (non-multiple of 8) number of bits have been received for
// an Escape Command, or Data Byte.
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_SHIFT                    _MK_SHIFT_CONST(2)
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_RANGE                    2:2
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_WOFFSET                  0x0
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SYNC_ESC_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Escape Mode Entry Error, set when CIL-A detects an escape
// mode entry error. The Escape mode command byte will not be
// received.
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_SHIFT                   _MK_SHIFT_CONST(3)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_RANGE                   3:3
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_WOFFSET                 0x0
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_ENTRY_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Control Error, set when CIL-A detects LP state 01 or 10
// followed by a stop state (LP11) instead of transitioning
// into the Escape mode or Turn Around mode (LP00).
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_FIELD                        (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_RANGE                        4:4
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_WOFFSET                      0x0
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_CTRL_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Escape Mode Command Received, set when CIL-A receives an
// Escape Mode Command byte. The Command Byte can be read 
// from bits 7-0 of ESCAPE_MODE_COMMAND.
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_SHIFT                     _MK_SHIFT_CONST(5)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_RANGE                     5:5
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_WOFFSET                   0x0
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_CMD_REC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Escape Mode Data Received, set when CIL-A receives an
// Escape Mode Data byte. The Data Byte can be read 
// from bits 7-0 of ESCAPE_MODE_DATA. This status bit will
// will also be cleared when CILA_ESC_CMD_REC is set.
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_SHIFT                    _MK_SHIFT_CONST(6)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_RANGE                    6:6
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_WOFFSET                  0x0
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_ESC_DATA_REC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// CILA Spare Status bit.
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_SHIFT                  _MK_SHIFT_CONST(7)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_RANGE                  7:7
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_WOFFSET                        0x0
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// CILA Spare Status bit.
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_SHIFT                  _MK_SHIFT_CONST(8)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_RANGE                  8:8
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_WOFFSET                        0x0
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILA_SPARE_STATUS_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// MIPI Auto Calibrate done, set when the auto calibrate 
// sequence for MIPI pad bricks is done.
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_SHIFT                   _MK_SHIFT_CONST(15)
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_SHIFT)
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_RANGE                   15:15
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_WOFFSET                 0x0
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_MIPI_AUTO_CAL_DONE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Start of Transmission Single Bit Error, set when CIL-B
// detects a single bit error in one of the packets start
// of transmission bytes. The packet will be sent to CSI-B
// for processing.
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_SHIFT                      _MK_SHIFT_CONST(16)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_RANGE                      16:16
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_WOFFSET                    0x0
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_SB_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Start of Transmission Multi Bit Error, set when CIL-B
// detects a multi bit start of transmission byte error in
// one of the packets SOT bytes. The packet will be discarded.
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_SHIFT                      _MK_SHIFT_CONST(17)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_RANGE                      17:17
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_WOFFSET                    0x0
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SOT_MB_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Sync Escape Error, set when CIL-B detects that the wrong 
// (non-multiple of 8) number of bits have been received for
// an Escape Command, or Data Byte.
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_SHIFT                    _MK_SHIFT_CONST(18)
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_RANGE                    18:18
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_WOFFSET                  0x0
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SYNC_ESC_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Escape Mode Entry Error, set when CIL-B detects an Escape
// Mode Entry Error. The Escape mode command byte will not be
// received.
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_SHIFT                   _MK_SHIFT_CONST(19)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_RANGE                   19:19
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_WOFFSET                 0x0
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_ENTRY_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Control Error, set when CIL-B detects LP state 01 or 10
// followed by a stop state (LP11) instead of transitioning
// into the Escape mode or Turn Around mode (LP00)..
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_SHIFT                        _MK_SHIFT_CONST(20)
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_FIELD                        (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_RANGE                        20:20
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_WOFFSET                      0x0
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_CTRL_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Escape Mode Command Received, set when CIL-B receives an
// Escape Mode Command byte. The Command Byte can be read 
// from bits 23-16 of ESCAPE_MODE_COMMAND.
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_SHIFT                     _MK_SHIFT_CONST(21)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_RANGE                     21:21
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_WOFFSET                   0x0
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_CMD_REC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Escape Mode Data Received, set when CIL-B receives an
// Escape Mode Data byte. The Data Byte can be read 
// from bits 23-16 of ESCAPE_MODE_DATA. This status bit will
// will also be cleared when CILB_ESC_CMD_REC is set.
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_SHIFT                    _MK_SHIFT_CONST(22)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_RANGE                    22:22
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_WOFFSET                  0x0
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_ESC_DATA_REC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// CILB Spare Status bit.
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_SHIFT                  _MK_SHIFT_CONST(23)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_RANGE                  23:23
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_WOFFSET                        0x0
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// CILB Spare Status bit.
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_SHIFT                  _MK_SHIFT_CONST(24)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_SHIFT)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_RANGE                  24:24
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_WOFFSET                        0x0
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_STATUS_0_CILB_SPARE_STATUS_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0  // CSI Pixel Parser Interrupt Mask
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0                   _MK_ADDR_CONST(0x220)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_SECURE                    0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_WORD_COUNT                        0x1
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_RESET_MASK                        _MK_MASK_CONST(0xcfffcfff)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_READ_MASK                         _MK_MASK_CONST(0xcfffcfff)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_WRITE_MASK                        _MK_MASK_CONST(0xcfffcfff)
// Interrupt Mask for PPA_HDR_ERR_COR. Generate an interrupt when PPA_HDR_ERR_COR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_RANGE                    0:0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_HDR_ERR_COR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_HDR_ERR_COR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_ILL_WD_CNT. Generate an interrupt when PPA_ILL_WD_CNT
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_SHIFT                     _MK_SHIFT_CONST(1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_RANGE                     1:1
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_ILL_WD_CNT
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_ILL_WD_CNT_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_SL_PROCESSED. Generate an interrupt when PPA_SL_PROCESSED
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_SHIFT                   _MK_SHIFT_CONST(2)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_RANGE                   2:2
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_WOFFSET                 0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_SL_PROCESSED
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PROCESSED_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_SL_PKT_DROPPED. Generate an interrupt when PPA_SL_PKT_DROPPED
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_SHIFT                 _MK_SHIFT_CONST(3)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_RANGE                 3:3
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_SL_PKT_DROPPED
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SL_PKT_DROPPED_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_PL_CRC_ERR. Generate an interrupt when PPA_PL_CRC_ERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(4)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_RANGE                     4:4
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_PL_CRC_ERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_PL_CRC_ERR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_FIFO_OVRF. Generate an interrupt when PPA_FIFO_OVRF
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_SHIFT                      _MK_SHIFT_CONST(5)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_RANGE                      5:5
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_WOFFSET                    0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_DISABLED                   _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_FIFO_OVRF
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_FIFO_OVRF_INT_MASK_ENABLED                    _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_STMERR. Generate an interrupt when PPA_STMERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_SHIFT                 _MK_SHIFT_CONST(6)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_RANGE                 6:6
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_STMERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_STMERR_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_SHORT_FRAME. Generate an interrupt when PPA_SHORT_FRAME
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_SHIFT                    _MK_SHIFT_CONST(7)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_RANGE                    7:7
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_SHORT_FRAME
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SHORT_FRAME_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_EXTRA_SF. Generate an interrupt when PPA_EXTRA_SF
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_SHIFT                       _MK_SHIFT_CONST(8)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_RANGE                       8:8
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_WOFFSET                     0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_EXTRA_SF
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_EXTRA_SF_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_INTERFRAME_LINE. Generate an interrupt when PPA_INTERFRAME_LINE
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_SHIFT                        _MK_SHIFT_CONST(9)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_FIELD                        (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_RANGE                        9:9
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_WOFFSET                      0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_DISABLED                     _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_INTERFRAME_LINE
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_INTERFRAME_LINE_INT_MASK_ENABLED                      _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_SPARE_STATUS_1. Generate an interrupt when PPA_SPARE_STATUS_1
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_SHIFT                 _MK_SHIFT_CONST(10)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_RANGE                 10:10
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_SPARE_STATUS_1
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_1_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for PPA_SPARE_STATUS_2. Generate an interrupt when PPA_SPARE_STATUS_2
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_SHIFT                 _MK_SHIFT_CONST(11)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_RANGE                 11:11
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPA_SPARE_STATUS_2
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPA_SPARE_STATUS_2_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for HPA_UNC_HDR_ERR. Generate an interrupt when HPA_UNC_HDR_ERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(14)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_RANGE                    14:14
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when HPA_UNC_HDR_ERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPA_UNC_HDR_ERR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for HPB_UNC_HDR_ERR. Generate an interrupt when HPB_UNC_HDR_ERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(15)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_RANGE                    15:15
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when HPB_UNC_HDR_ERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPB_UNC_HDR_ERR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_HDR_ERR_COR. Generate an interrupt when PPB_HDR_ERR_COR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(16)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_RANGE                    16:16
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_HDR_ERR_COR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_HDR_ERR_COR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_ILL_WD_CNT. Generate an interrupt when PPB_ILL_WD_CNT
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_SHIFT                     _MK_SHIFT_CONST(17)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_RANGE                     17:17
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_ILL_WD_CNT
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_ILL_WD_CNT_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_SL_PROCESSED. Generate an interrupt when PPB_SL_PROCESSED
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_SHIFT                   _MK_SHIFT_CONST(18)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_RANGE                   18:18
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_WOFFSET                 0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_SL_PROCESSED
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PROCESSED_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_SL_PKT_DROPPED. Generate an interrupt when PPB_SL_PKT_DROPPED
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_SHIFT                 _MK_SHIFT_CONST(19)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_RANGE                 19:19
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_SL_PKT_DROPPED
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SL_PKT_DROPPED_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_PL_CRC_ERR. Generate an interrupt when PPB_PL_CRC_ERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(20)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_RANGE                     20:20
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_PL_CRC_ERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_PL_CRC_ERR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_FIFO_OVRF. Generate an interrupt when PPB_FIFO_OVRF
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_SHIFT                      _MK_SHIFT_CONST(21)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_RANGE                      21:21
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_WOFFSET                    0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_DISABLED                   _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_FIFO_OVRF
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_FIFO_OVRF_INT_MASK_ENABLED                    _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_STMERR. Generate an interrupt when PPB_STMERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_SHIFT                 _MK_SHIFT_CONST(22)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_RANGE                 22:22
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_STMERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_STMERR_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_SHORT_FRAME. Generate an interrupt when PPB_SHORT_FRAME
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_SHIFT                    _MK_SHIFT_CONST(23)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_RANGE                    23:23
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_SHORT_FRAME
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SHORT_FRAME_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_EXTRA_SF. Generate an interrupt when PPB_EXTRA_SF
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_SHIFT                       _MK_SHIFT_CONST(24)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_RANGE                       24:24
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_WOFFSET                     0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_EXTRA_SF
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_EXTRA_SF_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_INTERFRAME_LINE. Generate an interrupt when PPB_INTERFRAME_LINE
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_SHIFT                        _MK_SHIFT_CONST(25)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_FIELD                        (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_RANGE                        25:25
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_WOFFSET                      0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_DISABLED                     _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_INTERFRAME_LINE
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_INTERFRAME_LINE_INT_MASK_ENABLED                      _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_SPARE_STATUS_1. Generate an interrupt when PPB_SPARE_STATUS_1
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_SHIFT                 _MK_SHIFT_CONST(26)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_RANGE                 26:26
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_SPARE_STATUS_1
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_1_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for PPB_SPARE_STATUS_2. Generate an interrupt when PPB_SPARE_STATUS_2
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_SHIFT                 _MK_SHIFT_CONST(27)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_RANGE                 27:27
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when PPB_SPARE_STATUS_2
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_PPB_SPARE_STATUS_2_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for HPV_UNC_HDR_ERR. Generate an interrupt when HPV_UNC_HDR_ERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(30)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_RANGE                    30:30
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when HPV_UNC_HDR_ERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPV_UNC_HDR_ERR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for HPH_UNC_HDR_ERR. Generate an interrupt when HPH_UNC_HDR_ERR
// is set.
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_SHIFT                    _MK_SHIFT_CONST(31)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_SHIFT)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_RANGE                    31:31
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when HPH_UNC_HDR_ERR
// is set.

#define CSI_CSI_PIXEL_PARSER_INTERRUPT_MASK_0_HPH_UNC_HDR_ERR_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)


// Register CSI_CSI_CIL_INTERRUPT_MASK_0  // CSI Control and Interface Logic Interrupt Mask
#define CSI_CSI_CIL_INTERRUPT_MASK_0                    _MK_ADDR_CONST(0x221)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_SECURE                     0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_WORD_COUNT                         0x1
#define CSI_CSI_CIL_INTERRUPT_MASK_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_RESET_MASK                         _MK_MASK_CONST(0x1ff81ff)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_READ_MASK                  _MK_MASK_CONST(0x1ff81ff)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_WRITE_MASK                         _MK_MASK_CONST(0x1ff81ff)
// Interrupt Mask for CILA_SOT_SB_ERR. Generate an interrupt when CILA_SOT_SB_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_RANGE                     0:0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_SOT_SB_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_SB_ERR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_SOT_MB_ERR. Generate an interrupt when CILA_SOT_MB_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_RANGE                     1:1
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_SOT_MB_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SOT_MB_ERR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_SYNC_ESC_ERR. Generate an interrupt when CILA_SYNC_ESC_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_SHIFT                   _MK_SHIFT_CONST(2)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_RANGE                   2:2
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_WOFFSET                 0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_SYNC_ESC_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SYNC_ESC_ERR_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_ESC_ENTRY_ERR. Generate an interrupt when CILA_ESC_ENTRY_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_SHIFT                  _MK_SHIFT_CONST(3)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_RANGE                  3:3
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_WOFFSET                        0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_ESC_ENTRY_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_ENTRY_ERR_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_CTRL_ERR. Generate an interrupt when CILA_CTRL_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_SHIFT                       _MK_SHIFT_CONST(4)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_RANGE                       4:4
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_WOFFSET                     0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_CTRL_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_CTRL_ERR_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_ESC_CMD_REC. Generate an interrupt when CILA_ESC_CMD_REC
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_SHIFT                    _MK_SHIFT_CONST(5)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_RANGE                    5:5
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_ESC_CMD_REC
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_CMD_REC_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_ESC_DATA_REC. Generate an interrupt when CILA_ESC_DATA_REC
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_SHIFT                   _MK_SHIFT_CONST(6)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_RANGE                   6:6
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_WOFFSET                 0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_ESC_DATA_REC
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_ESC_DATA_REC_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_SPARE_STATUS_1. Generate an interrupt when CILA_SPARE_STATUS_1
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_SHIFT                 _MK_SHIFT_CONST(7)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_RANGE                 7:7
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_SPARE_STATUS_1
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_1_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for CILA_SPARE_STATUS_2. Generate an interrupt when CILA_SPARE_STATUS_2
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_SHIFT                 _MK_SHIFT_CONST(8)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_RANGE                 8:8
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILA_SPARE_STATUS_2
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILA_SPARE_STATUS_2_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for MIPI_AUTO_CAL_DONE. Generate an interrupt when MIPI_AUTO_CAL_DONE
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_SHIFT                  _MK_SHIFT_CONST(15)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_RANGE                  15:15
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_WOFFSET                        0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)    // // Don't generate an interrupt when MIPI_AUTO_CAL_DONE
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_MIPI_AUTO_CAL_DONE_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_SOT_SB_ERR. Generate an interrupt when CILB_SOT_SB_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(16)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_RANGE                     16:16
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_SOT_SB_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_SB_ERR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_SOT_MB_ERR. Generate an interrupt when CILB_SOT_MB_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_SHIFT                     _MK_SHIFT_CONST(17)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_RANGE                     17:17
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_WOFFSET                   0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_DISABLED                  _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_SOT_MB_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SOT_MB_ERR_INT_MASK_ENABLED                   _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_SYNC_ESC_ERR. Generate an interrupt when CILB_SYNC_ESC_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_SHIFT                   _MK_SHIFT_CONST(18)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_RANGE                   18:18
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_WOFFSET                 0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_SYNC_ESC_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SYNC_ESC_ERR_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_ESC_ENTRY_ERR. Generate an interrupt when CILB_ESC_ENTRY_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_SHIFT                  _MK_SHIFT_CONST(19)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_RANGE                  19:19
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_WOFFSET                        0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_DISABLED                       _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_ESC_ENTRY_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_ENTRY_ERR_INT_MASK_ENABLED                        _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_CTRL_ERR. Generate an interrupt when CILB_CTRL_ERR
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_SHIFT                       _MK_SHIFT_CONST(20)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_RANGE                       20:20
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_WOFFSET                     0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_DISABLED                    _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_CTRL_ERR
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_CTRL_ERR_INT_MASK_ENABLED                     _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_ESC_CMD_REC. Generate an interrupt when CILB_ESC_CMD_REC
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_SHIFT                    _MK_SHIFT_CONST(21)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_FIELD                    (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_RANGE                    21:21
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_WOFFSET                  0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_DISABLED                 _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_ESC_CMD_REC
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_CMD_REC_INT_MASK_ENABLED                  _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_ESC_DATA_REC. Generate an interrupt when CILB_ESC_DATA_REC
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_SHIFT                   _MK_SHIFT_CONST(22)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_RANGE                   22:22
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_WOFFSET                 0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_DISABLED                        _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_ESC_DATA_REC
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_ESC_DATA_REC_INT_MASK_ENABLED                 _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_SPARE_STATUS_1. Generate an interrupt when CILB_SPARE_STATUS_1
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_SHIFT                 _MK_SHIFT_CONST(23)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_RANGE                 23:23
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_SPARE_STATUS_1
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_1_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)

// Interrupt Mask for CILB_SPARE_STATUS_2. Generate an interrupt when CILB_SPARE_STATUS_2
// is set.
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_SHIFT                 _MK_SHIFT_CONST(24)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_SHIFT)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_RANGE                 24:24
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_WOFFSET                       0x0
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_DISABLED                      _MK_ENUM_CONST(0)    // // Don't generate an interrupt when CILB_SPARE_STATUS_2
// is set.

#define CSI_CSI_CIL_INTERRUPT_MASK_0_CILB_SPARE_STATUS_2_INT_MASK_ENABLED                       _MK_ENUM_CONST(1)


// Register CSI_CSI_READONLY_STATUS_0  // CSI Read Only Status, this register is used to return
// CSI read only status.
#define CSI_CSI_READONLY_STATUS_0                       _MK_ADDR_CONST(0x222)
#define CSI_CSI_READONLY_STATUS_0_SECURE                        0x0
#define CSI_CSI_READONLY_STATUS_0_WORD_COUNT                    0x1
#define CSI_CSI_READONLY_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define CSI_CSI_READONLY_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// One only when Pixel Parser A is capturing frame data.
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_SHIFT                  _MK_SHIFT_CONST(0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_RANGE                  0:0
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_WOFFSET                        0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPA_ACTIVE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// One only when Pixel Parser B is capturing frame data.
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_SHIFT                  _MK_SHIFT_CONST(1)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_RANGE                  1:1
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_WOFFSET                        0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_PPB_ACTIVE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Reads back CSI's interrupt line. This is being used test
// the CSI logic that generates interrupt.
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_SHIFT                   _MK_SHIFT_CONST(2)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_RANGE                   2:2
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_WOFFSET                 0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Spare Read Only status bit
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_SHIFT                   _MK_SHIFT_CONST(3)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_RANGE                   3:3
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_WOFFSET                 0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Spare Read Only status bit
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_SHIFT                   _MK_SHIFT_CONST(4)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_RANGE                   4:4
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_WOFFSET                 0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE4_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Spare Read Only status bit
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_SHIFT                   _MK_SHIFT_CONST(5)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_RANGE                   5:5
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_WOFFSET                 0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE5_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Spare Read Only status bit
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_SHIFT                   _MK_SHIFT_CONST(6)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_RANGE                   6:6
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_WOFFSET                 0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE6_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Spare Read Only status bit
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_SHIFT                   _MK_SHIFT_CONST(7)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_FIELD                   (_MK_MASK_CONST(0x1) << CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_SHIFT)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_RANGE                   7:7
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_WOFFSET                 0x0
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CSI_READONLY_STATUS_0_CSI_RO_SPARE7_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register CSI_ESCAPE_MODE_COMMAND_0  // Escape Mode Command, this register is used to receive
// escape mode command bytes from CIL-A and CIL-B.
#define CSI_ESCAPE_MODE_COMMAND_0                       _MK_ADDR_CONST(0x223)
#define CSI_ESCAPE_MODE_COMMAND_0_SECURE                        0x0
#define CSI_ESCAPE_MODE_COMMAND_0_WORD_COUNT                    0x1
#define CSI_ESCAPE_MODE_COMMAND_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_READ_MASK                     _MK_MASK_CONST(0xff00ff)
#define CSI_ESCAPE_MODE_COMMAND_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// CIL-A Escape Mode Command Byte, this is the 8 bit entry
// command that was received, by CIL-A, during the last 
// escape Mode sequence. CIL-A monitors Byte Lane 0, only,
// for escape mode sequences. This command byte can only 
// be  assummed to be valid when CILA_ESC_CMD_REC status
// bit is set.
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_SHIFT                       _MK_SHIFT_CONST(0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_FIELD                       (_MK_MASK_CONST(0xff) << CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_SHIFT)
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_RANGE                       7:0
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_WOFFSET                     0x0
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILA_ESC_CMD_BYTE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// CIL-B Escape Mode Command Byte, this is the 8 bit entry
// command that was received, by CIL-B, during the last 
// escape Mode sequence. This command byte can only be 
// assummed to be valid when CILB_ESC_CMD_REC status bit
// is set.
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_SHIFT                       _MK_SHIFT_CONST(16)
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_FIELD                       (_MK_MASK_CONST(0xff) << CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_SHIFT)
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_RANGE                       23:16
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_WOFFSET                     0x0
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_COMMAND_0_CILB_ESC_CMD_BYTE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CSI_ESCAPE_MODE_DATA_0  // Escape Mode Data, this register is used to receive
// escape mode data bytes from CIL-A and CIL-B.
#define CSI_ESCAPE_MODE_DATA_0                  _MK_ADDR_CONST(0x224)
#define CSI_ESCAPE_MODE_DATA_0_SECURE                   0x0
#define CSI_ESCAPE_MODE_DATA_0_WORD_COUNT                       0x1
#define CSI_ESCAPE_MODE_DATA_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_READ_MASK                        _MK_MASK_CONST(0xff00ff)
#define CSI_ESCAPE_MODE_DATA_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
// CIL-A Escape Mode Data Byte, when read this field returns
// the last Escape Mode Data byte that was received by CIL-A.
// Escape Mode Data bytes are the bytes that are received
// in Escape Mode after receiving the Escape Mode Command.
// These bytes can be used to implement MIPI's CSI Specs Low
// Power Data Transmition. This field is only valid when 
// the status bit, CILA_ESC_DATA_REC, is set, and will be
// overwritten by the next Escape Mode data byte if not read
// before the next byte come in.
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_SHIFT                 _MK_SHIFT_CONST(0)
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_FIELD                 (_MK_MASK_CONST(0xff) << CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_SHIFT)
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_RANGE                 7:0
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_WOFFSET                       0x0
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_CILA_ESC_DATA_BYTE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// CIL-B Escape Mode Data Byte, when read this field returns
// the last Escape Mode Data byte that was received by CIL-B.
// Escape Mode Data bytes are the bytes that are received
// in Escape Mode after receiving the Escape Mode Command.
// These bytes can be used to implement MIPI's CSI Specs Low
// Power Data Transmition. This field is only valid when 
// the status bit, CILB_ESC_DATA_REC, is set, and will be
// overwritten by the next Escape Mode data byte if not read
// before the next byte come in.
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_SHIFT                 _MK_SHIFT_CONST(16)
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_FIELD                 (_MK_MASK_CONST(0xff) << CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_SHIFT)
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_RANGE                 23:16
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_WOFFSET                       0x0
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_ESCAPE_MODE_DATA_0_CILB_ESC_DATA_BYTE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CSI_CILA_PAD_CONFIG0_0  // CIL-A Pad Configuration 0
#define CSI_CILA_PAD_CONFIG0_0                  _MK_ADDR_CONST(0x225)
#define CSI_CILA_PAD_CONFIG0_0_SECURE                   0x0
#define CSI_CILA_PAD_CONFIG0_0_WORD_COUNT                       0x1
#define CSI_CILA_PAD_CONFIG0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_RESET_MASK                       _MK_MASK_CONST(0x77f1777f)
#define CSI_CILA_PAD_CONFIG0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_READ_MASK                        _MK_MASK_CONST(0x77f1777f)
#define CSI_CILA_PAD_CONFIG0_0_WRITE_MASK                       _MK_MASK_CONST(0x77f1777f)
// Power down for each data bit, including drivers,
// receivers and contention detectors
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_SHIFT                      _MK_SHIFT_CONST(0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_FIELD                      (_MK_MASK_CONST(0x3) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_RANGE                      1:0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_WOFFSET                    0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Power down for clock bit, including drivers, 
// receivers and contention detectors
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_SHIFT                  _MK_SHIFT_CONST(2)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_RANGE                  2:2
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_WOFFSET                        0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PDIO_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// HS driver preemphasis enable,1= preemphasis enabled
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_SHIFT                 _MK_SHIFT_CONST(3)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_RANGE                 3:3
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_WOFFSET                       0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_PREEMP_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Clock bit input delay trimmer, each tap delays 20ps
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_SHIFT                  _MK_SHIFT_CONST(4)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_FIELD                  (_MK_MASK_CONST(0x7) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_RANGE                  6:4
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_WOFFSET                        0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJCLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// bit 0 input delay trimmer, each tap delays 20ps
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_SHIFT                    _MK_SHIFT_CONST(8)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_FIELD                    (_MK_MASK_CONST(0x7) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_RANGE                    10:8
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_WOFFSET                  0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// bit 1 input delay trimmer, each tap delays 20ps
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_SHIFT                    _MK_SHIFT_CONST(12)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_FIELD                    (_MK_MASK_CONST(0x7) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_RANGE                    14:12
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_WOFFSET                  0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_INADJ1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Increase bandwidth of differential receiver
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_SHIFT                 _MK_SHIFT_CONST(16)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_RANGE                 16:16
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_WOFFSET                       0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_BANDWD_IN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Driver pull up impedance control
// 00 -> 130ohm, default
// 01 -> 110ohm
// 10 -> 130ohm, same as 00
// 11 -> 150ohm
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_SHIFT                   _MK_SHIFT_CONST(20)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_FIELD                   (_MK_MASK_CONST(0x3) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_RANGE                   21:20
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_WOFFSET                 0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPUPADJ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Driver pull down impedance control
// 00 -> 130ohm, default
// 01 -> 110ohm
// 10 -> 130ohm, same as 00
// 11 -> 150ohm
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_SHIFT                   _MK_SHIFT_CONST(22)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_FIELD                   (_MK_MASK_CONST(0x3) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_RANGE                   23:22
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_WOFFSET                 0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_LPDNADJ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Pull up slew rate adjust, default 000
// From 000 -> 011, slew rate increases
// 100 is the same as 000
// From 100->111, skew rate decreases.
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_SHIFT                 _MK_SHIFT_CONST(24)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_FIELD                 (_MK_MASK_CONST(0x7) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_RANGE                 26:24
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_WOFFSET                       0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWUPADJ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Pull down slew rate adjust, default 000
// From 000 -> 011, slew rate increases
// 100 is the same as 000
// From 100->111, skew rate decreases.
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_SHIFT                 _MK_SHIFT_CONST(28)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_FIELD                 (_MK_MASK_CONST(0x7) << CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_SHIFT)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_RANGE                 30:28
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_WOFFSET                       0x0
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG0_0_PAD_CILA_SLEWDNADJ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CSI_CILA_PAD_CONFIG1_0  // CIL-A Pad Configuration 4
#define CSI_CILA_PAD_CONFIG1_0                  _MK_ADDR_CONST(0x226)
#define CSI_CILA_PAD_CONFIG1_0_SECURE                   0x0
#define CSI_CILA_PAD_CONFIG1_0_WORD_COUNT                       0x1
#define CSI_CILA_PAD_CONFIG1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define CSI_CILA_PAD_CONFIG1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define CSI_CILA_PAD_CONFIG1_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
// Spare bits for CILA Config
// PAD_CILA_SPARE[15] is being used to disable 
// the CSI-A RTL code that blocks fifo pushs 
// that are past the end of the line packet.
// 0: disabled, 1: push blocking enabled
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_FIELD                     (_MK_MASK_CONST(0xffff) << CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_SHIFT)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RANGE                     15:0
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_WOFFSET                   0x0
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Spare Read only bits for CILA Config
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_SHIFT                  _MK_SHIFT_CONST(16)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_FIELD                  (_MK_MASK_CONST(0xffff) << CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_SHIFT)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_RANGE                  31:16
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_WOFFSET                        0x0
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_PAD_CONFIG1_0_PAD_CILA_SPARE_RO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CSI_CILB_PAD_CONFIG0_0  // CIL-B Pad Configuration 0
#define CSI_CILB_PAD_CONFIG0_0                  _MK_ADDR_CONST(0x227)
#define CSI_CILB_PAD_CONFIG0_0_SECURE                   0x0
#define CSI_CILB_PAD_CONFIG0_0_WORD_COUNT                       0x1
#define CSI_CILB_PAD_CONFIG0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_RESET_MASK                       _MK_MASK_CONST(0x77f1077d)
#define CSI_CILB_PAD_CONFIG0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_READ_MASK                        _MK_MASK_CONST(0x77f1077d)
#define CSI_CILB_PAD_CONFIG0_0_WRITE_MASK                       _MK_MASK_CONST(0x77f1077d)
// Power down for each data bit, including drivers,
// receivers and contention detectors
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_SHIFT                      _MK_SHIFT_CONST(0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_RANGE                      0:0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_WOFFSET                    0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Power down for clock bit, including drivers, 
// receivers and contention detectors
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_SHIFT                  _MK_SHIFT_CONST(2)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_RANGE                  2:2
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_WOFFSET                        0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PDIO_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// HS driver preemphasis enable,1= preemphasis enabled
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_SHIFT                 _MK_SHIFT_CONST(3)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_RANGE                 3:3
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_WOFFSET                       0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_PREEMP_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Clock bit input delay trimmer, each tap delays 20ps
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_SHIFT                  _MK_SHIFT_CONST(4)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_FIELD                  (_MK_MASK_CONST(0x7) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_RANGE                  6:4
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_WOFFSET                        0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJCLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// bit 0 input delay trimmer, each tap delays 20ps
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_SHIFT                    _MK_SHIFT_CONST(8)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_FIELD                    (_MK_MASK_CONST(0x7) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_RANGE                    10:8
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_WOFFSET                  0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_INADJ0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Increase bandwidth of differential receiver
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_SHIFT                 _MK_SHIFT_CONST(16)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_RANGE                 16:16
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_WOFFSET                       0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_BANDWD_IN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Driver pull up impedance control
// 00 -> 130ohm, default
// 01 -> 110ohm
// 10 -> 130ohm, same as 00
// 11 -> 150ohm
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_SHIFT                   _MK_SHIFT_CONST(20)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_FIELD                   (_MK_MASK_CONST(0x3) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_RANGE                   21:20
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_WOFFSET                 0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPUPADJ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Driver pull down impedance control
// 00 -> 130ohm, default
// 01 -> 110ohm
// 10 -> 130ohm, same as 00
// 11 -> 150ohm
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_SHIFT                   _MK_SHIFT_CONST(22)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_FIELD                   (_MK_MASK_CONST(0x3) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_RANGE                   23:22
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_WOFFSET                 0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_LPDNADJ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Pull up slew rate adjust, default 000
// From 000 -> 011, slew rate increases
// 100 is the same as 000
// From 100->111, skew rate decreases.
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_SHIFT                 _MK_SHIFT_CONST(24)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_FIELD                 (_MK_MASK_CONST(0x7) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_RANGE                 26:24
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_WOFFSET                       0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWUPADJ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Pull down slew rate adjust, default 000
// From 000 -> 011, slew rate increases
// 100 is the same as 000
// From 100->111, skew rate decreases.
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_SHIFT                 _MK_SHIFT_CONST(28)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_FIELD                 (_MK_MASK_CONST(0x7) << CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_SHIFT)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_RANGE                 30:28
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_WOFFSET                       0x0
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG0_0_PAD_CILB_SLEWDNADJ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CSI_CILB_PAD_CONFIG1_0  // CIL-B Pad Configuration 4
#define CSI_CILB_PAD_CONFIG1_0                  _MK_ADDR_CONST(0x228)
#define CSI_CILB_PAD_CONFIG1_0_SECURE                   0x0
#define CSI_CILB_PAD_CONFIG1_0_WORD_COUNT                       0x1
#define CSI_CILB_PAD_CONFIG1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define CSI_CILB_PAD_CONFIG1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define CSI_CILB_PAD_CONFIG1_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
// Spare bits for CILB Config
// PAD_CILB_SPARE[15] is being used to disable 
// the CSI-B RTL code that blocks fifo pushs 
// that are past the end of the line packet.
// 0: disabled, 1: push blocking enabled
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_FIELD                     (_MK_MASK_CONST(0xffff) << CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_SHIFT)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RANGE                     15:0
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_WOFFSET                   0x0
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Spare Read only bits for CILB Config
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_SHIFT                  _MK_SHIFT_CONST(16)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_FIELD                  (_MK_MASK_CONST(0xffff) << CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_SHIFT)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_RANGE                  31:16
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_WOFFSET                        0x0
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_PAD_CONFIG1_0_PAD_CILB_SPARE_RO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CSI_CIL_PAD_CONFIG0_0  // CIL Pad Configuration 0
#define CSI_CIL_PAD_CONFIG0_0                   _MK_ADDR_CONST(0x229)
#define CSI_CIL_PAD_CONFIG0_0_SECURE                    0x0
#define CSI_CIL_PAD_CONFIG0_0_WORD_COUNT                        0x1
#define CSI_CIL_PAD_CONFIG0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_RESET_MASK                        _MK_MASK_CONST(0xff73)
#define CSI_CIL_PAD_CONFIG0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_READ_MASK                         _MK_MASK_CONST(0xff73)
#define CSI_CIL_PAD_CONFIG0_0_WRITE_MASK                        _MK_MASK_CONST(0xff73)
// Bypass bang gap voltage reference
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_SHIFT                     _MK_SHIFT_CONST(0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_FIELD                     (_MK_MASK_CONST(0x1) << CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_SHIFT)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_RANGE                     0:0
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_WOFFSET                   0x0
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VBYPASS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Power down voltage regulator, 1=power down
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_SHIFT                      _MK_SHIFT_CONST(1)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_SHIFT)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_RANGE                      1:1
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_WOFFSET                    0x0
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_PDVREG_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// VAUXP level adjustment
// 00 -> no adjustment, default
// 01 -> 105% 
// 10 -> 110% 
// 11 -> 115%
// 100 -> no adjustment
// 101 -> 95%
// 110 -> 90%
// 111 -> 85%
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_FIELD                        (_MK_MASK_CONST(0x7) << CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_SHIFT)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_RANGE                        6:4
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_WOFFSET                      0x0
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_VADJ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Spare bit for CIL BIAS Config
// PAD_CIL_SPARE[7] is used is being used to flush VI's
// Y-FIFO when it is being use as a stream source for 
// one of the Pixel Parsers. Setting PAD_CIL_SPARE[7]
// to 1 will hold vi2csi_host_stall low. Which will
// force VI's Y-FIFO to be purged. PAD_CIL_SPARE[7]
// must be low for the pixel parser to receive source
// data from VI's Y-FIFO. 
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_SHIFT                       _MK_SHIFT_CONST(8)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_FIELD                       (_MK_MASK_CONST(0xff) << CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_SHIFT)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_RANGE                       15:8
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_WOFFSET                     0x0
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CIL_PAD_CONFIG0_0_PAD_CIL_SPARE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CSI_CILA_MIPI_CAL_CONFIG_0  // Calibration settings for CIL-A mipi pads
#define CSI_CILA_MIPI_CAL_CONFIG_0                      _MK_ADDR_CONST(0x22a)
#define CSI_CILA_MIPI_CAL_CONFIG_0_SECURE                       0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_WORD_COUNT                   0x1
#define CSI_CILA_MIPI_CAL_CONFIG_0_RESET_VAL                    _MK_MASK_CONST(0x2a200000)
#define CSI_CILA_MIPI_CAL_CONFIG_0_RESET_MASK                   _MK_MASK_CONST(0xff3f1f1f)
#define CSI_CILA_MIPI_CAL_CONFIG_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_READ_MASK                    _MK_MASK_CONST(0xff3f1f1f)
#define CSI_CILA_MIPI_CAL_CONFIG_0_WRITE_MASK                   _MK_MASK_CONST(0x7f3f1f1f)
// 2's complement offset for TERMADJ going to channel A
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_SHIFT                       _MK_SHIFT_CONST(0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_FIELD                       (_MK_MASK_CONST(0x1f) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_RANGE                       4:0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_WOFFSET                     0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 2's complement offset for HSPUADJ going to channel A
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_SHIFT                       _MK_SHIFT_CONST(8)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_FIELD                       (_MK_MASK_CONST(0x1f) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_RANGE                       12:8
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_WOFFSET                     0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 2's complement offset for HSPDADJ going to channel A
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_SHIFT                       _MK_SHIFT_CONST(16)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_FIELD                       (_MK_MASK_CONST(0x1f) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_RANGE                       20:16
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_WOFFSET                     0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Select the CSIA PADS for auto calibration.
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_SHIFT                  _MK_SHIFT_CONST(21)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_RANGE                  21:21
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_WOFFSET                        0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_DEFAULT                        _MK_MASK_CONST(0x1)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_SELA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Auto Cal calibration step prescale:
// Set to 00 when calibration step should be 0.1 us
// Set to 01 when calibration step should be 0.5 us
// Set to 10 when calibration step should be 1.0 us
// Set to 11 when calibration step should be 1.5 us
// this will keep the mipi bias cal step between 0.1-1.5 usec
// Default set for 1.0 us calibraiton step.
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_SHIFT                      _MK_SHIFT_CONST(24)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_FIELD                      (_MK_MASK_CONST(0x3) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_RANGE                      25:24
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_WOFFSET                    0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_DEFAULT                    _MK_MASK_CONST(0x2)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_PRESCALE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// The DRIVRY & TERMRY signals coming from MIPI Pads are
// utilized by Calibration state machine for PAD Calibration.
// The drivry/termry comes from a noisy analog source 
// and it could have some glitches.
// The filter in calibsm is sensitive to these noises.
// If the calibration done status does not show up, we
// can change the sensitivity of the filter through these bits.
// Ideally this has to be programmed in a range from 10 to 15.
// For the case when MIPI_CAL_PRESCALE = 2'b00, this needs to be
// programmed between 2 to 5.
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_SHIFT                     _MK_SHIFT_CONST(26)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_FIELD                     (_MK_MASK_CONST(0xf) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_RANGE                     29:26
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_WOFFSET                   0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_DEFAULT                   _MK_MASK_CONST(0xa)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_NOISE_FLT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// When 0 (normal operation), use the above registers
// as an offset to the Calibration State machine setting
// for channel A TERMADJ/HSPUADJ/HSPDADJ values to the 
// Mipi Pads. When 1, use the register values above as
// the actual value going to channel A TERMADJ/HSPUADJ/HSPDADJ
// on the Mipi Pads.
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_SHIFT                      _MK_SHIFT_CONST(30)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_RANGE                      30:30
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_WOFFSET                    0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Writting a one to this bit starts the Calibration State
// machine.  This bit must be set even if both overrides
// set in order to latch in the over ride value
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_SHIFT                      _MK_SHIFT_CONST(31)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_SHIFT)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_RANGE                      31:31
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_WOFFSET                    0x0
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILA_MIPI_CAL_CONFIG_0_MIPI_CAL_STARTCAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register CSI_CILB_MIPI_CAL_CONFIG_0  // Calibration settings for CIL-B mipi pads
#define CSI_CILB_MIPI_CAL_CONFIG_0                      _MK_ADDR_CONST(0x22b)
#define CSI_CILB_MIPI_CAL_CONFIG_0_SECURE                       0x0
#define CSI_CILB_MIPI_CAL_CONFIG_0_WORD_COUNT                   0x1
#define CSI_CILB_MIPI_CAL_CONFIG_0_RESET_VAL                    _MK_MASK_CONST(0x200000)
#define CSI_CILB_MIPI_CAL_CONFIG_0_RESET_MASK                   _MK_MASK_CONST(0x403f1f1f)
#define CSI_CILB_MIPI_CAL_CONFIG_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_READ_MASK                    _MK_MASK_CONST(0x403f1f1f)
#define CSI_CILB_MIPI_CAL_CONFIG_0_WRITE_MASK                   _MK_MASK_CONST(0x403f1f1f)
// 2's complement offset for TERMADJ going to channel B
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_SHIFT                       _MK_SHIFT_CONST(0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_FIELD                       (_MK_MASK_CONST(0x1f) << CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_SHIFT)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_RANGE                       4:0
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_WOFFSET                     0x0
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_TERMOSB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 2's complement offset for HSPUADJ going to channel B
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_SHIFT                       _MK_SHIFT_CONST(8)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_FIELD                       (_MK_MASK_CONST(0x1f) << CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_SHIFT)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_RANGE                       12:8
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_WOFFSET                     0x0
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPUOSB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 2's complement offset for HSPDADJ going to channel B
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_SHIFT                       _MK_SHIFT_CONST(16)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_FIELD                       (_MK_MASK_CONST(0x1f) << CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_SHIFT)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_RANGE                       20:16
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_WOFFSET                     0x0
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_HSPDOSB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Select the CSIB PADS for auto calibration.
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_SHIFT                  _MK_SHIFT_CONST(21)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_FIELD                  (_MK_MASK_CONST(0x1) << CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_SHIFT)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_RANGE                  21:21
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_WOFFSET                        0x0
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_DEFAULT                        _MK_MASK_CONST(0x1)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_SELB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// When 0 (normal operation), use the above registers
// as an offset to the Calibration State machine setting
// for channel B TERMADJ/HSPUADJ/HSPDADJ values to the 
// Mipi Pads. When 1, use the register values above as
// the actual value going to channel B TERMADJ/HSPUADJ/HSPDADJ
// on the Mipi Pads.
// Writting a one to Bit 31 of CILA_MIPI_CAL_CONFIG 
// (MIPI_CAL_STARTCAL) starts the Calibration State
// machine.
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_SHIFT                      _MK_SHIFT_CONST(30)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_FIELD                      (_MK_MASK_CONST(0x1) << CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_SHIFT)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_RANGE                      30:30
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_WOFFSET                    0x0
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CSI_CILB_MIPI_CAL_CONFIG_0_MIPI_CAL_OVERIDEB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register CSI_CIL_MIPI_CAL_STATUS_0  // CIL MIPI Calibrate Status
#define CSI_CIL_MIPI_CAL_STATUS_0                       _MK_ADDR_CONST(0x22c)
#define CSI_CIL_MIPI_CAL_STATUS_0_SECURE                        0x0
#define CSI_CIL_MIPI_CAL_STATUS_0_WORD_COUNT                    0x1
#define CSI_CIL_MIPI_CAL_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x38000ff1)
#define CSI_CIL_MIPI_CAL_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// One when auto calibrate is active.
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_SHIFT                 _MK_SHIFT_CONST(0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_SHIFT)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_RANGE                 0:0
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_WOFFSET                       0x0
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_ACTIVE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Termination code generated by MIPI auto Calibrate.
// Valid only after auto calibrate sequence has 
// completed (MIPI_CAL_ACTIVE == 0).
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_SHIFT                        _MK_SHIFT_CONST(4)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_FIELD                        (_MK_MASK_CONST(0xf) << CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_SHIFT)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_RANGE                        7:4
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_WOFFSET                      0x0
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_TERMADJ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Driver code generated by MIPI auto Calibrate.
// Valid only after auto calibrate sequence has 
// completed (MIPI_CAL_ACTIVE == 0).
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_SHIFT                        _MK_SHIFT_CONST(8)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_FIELD                        (_MK_MASK_CONST(0xf) << CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_SHIFT)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_RANGE                        11:8
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_WOFFSET                      0x0
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_DEFAULT                      _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_CAL_DRIVADJ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// MIPI Auto Calibrate done for CSI,
// set when the auto calibrate 
// sequence for CSI pad bricks is done.
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_SHIFT                 _MK_SHIFT_CONST(27)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_SHIFT)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_RANGE                 27:27
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_WOFFSET                       0x0
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_DEFAULT                       _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// MIPI Auto Calibrate done for CSI,
// set when the auto calibrate 
// sequence for CSI pad bricks is done.
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIB_SHIFT                 _MK_SHIFT_CONST(28)
#define CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUTO_CAL_DONE_CSIB_FIELD                 (_MK_MASK_CONST(0x1) << CSI_CIL_MIPI_CAL_STATUS_0_MIPI_AUT