/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef ___DEV_AP_PCIE2_ROOT_PORT_H_INC_
#define ___DEV_AP_PCIE2_ROOT_PORT_H_INC_

#define NV_PROJ__PCIE2_RP                                0x00000FFF:0x00000000 /* RW--D */
#define NV_PROJ__PCIE2_RP_DEV_ID                                    0x00000000 /* R--4R */
#define NV_PROJ__PCIE2_RP_DEV_ID_VENDOR_ID                                15:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_ID_VENDOR_ID_NVIDIA                   0x000010DE /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_ID_DEVICE_ID                               31:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL                                  0x00000004 /* RW-4R */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_IO_SPACE                                0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_IO_SPACE_DISABLED                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_IO_SPACE_ENABLED                 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MEMORY_SPACE                            1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MEMORY_SPACE_DISABLED            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MEMORY_SPACE_ENABLED             0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_BUS_MASTER                              2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_BUS_MASTER_DISABLED              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_BUS_MASTER_ENABLED               0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SPECIAL_CYCLE                           3:3 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SPECIAL_CYCLE_DISABLED           0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SPECIAL_CYCLE_ENABLED            0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_WRITE_AND_INVAL                         4:4 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_WRITE_AND_INVAL_DISABLED         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_WRITE_AND_INVAL_ENABLED          0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_PALETTE_SNOOP                           5:5 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_PALETTE_SNOOP_DISABLED           0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_PALETTE_SNOOP_ENABLED            0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_PERR                                    6:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_PERR_DISABLED                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_PERR_ENABLED                     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_STEP                                    7:7 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_STEP_DISABLED                    0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_STEP_ENABLED                     0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SERR                                    8:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SERR_DISABLED                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SERR_ENABLED                     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_BACK2BACK                               9:9 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_BACK2BACK_DISABLED               0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_BACK2BACK_ENABLED                0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_DISABLE                          10:10 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_DISABLE_INIT                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_DISABLE_YES                 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_DISABLE_NO                  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_STATUS                           19:19 /* R-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_STATUS_NOT_ACTIVE           0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_INTR_STATUS_ACTIVE               0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_CAPLIST                               20:20 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_CAPLIST_PRESENT                  0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_CAPLIST_NOT_PRESENT              0x00000000 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_66MHZ                                 21:21 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_66MHZ_INCAPABLE                  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_66MHZ_CAPABLE                    0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_FAST_BACK2BACK                        23:23 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_FAST_BACK2BACK_INCAPABLE         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_FAST_BACK2BACK_CAPABLE           0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MASTER_DATA_PERR                      24:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MASTER_DATA_PERR_NOT_ACTIVE      0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MASTER_DATA_PERR_ACTIVE          0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_MASTER_DATA_PERR_SET             0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DEVSEL_TIMING                         26:25 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DEVSEL_TIMING_FAST               0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DEVSEL_TIMING_MEDIUM             0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DEVSEL_TIMING_SLOW               0x00000002 /* ----V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_TARGET                       27:27 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_TARGET_NO_ABORT         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_TARGET_ABORT            0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_TARGET_SET              0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_TARGET                       28:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_TARGET_NO_ABORT         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_TARGET_ABORT            0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_TARGET_SET              0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_MASTER                       29:29 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_MASTER_NO_ABORT         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_MASTER_ABORT            0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_RECEIVED_MASTER_SET              0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_SERR                         30:30 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_SERR_NOT_ACTIVE         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_SERR_ACTIVE             0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_SIGNALED_SERR_SET                0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DETECTED_PERR                         31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DETECTED_PERR_NOT_ACTIVE         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DETECTED_PERR_ACTIVE             0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_DEV_CTRL_DETECTED_PERR_SET                0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_REV_CC                                    0x00000008 /* R--4R */
#define NV_PROJ__PCIE2_RP_REV_CC_REVISION_ID                               7:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_REV_CC_CLASS_CODE                               31:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_REV_CC_CLASS_CODE_P2P                     0x00060400 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MISC_1                                    0x0000000C /* RW-4R */
#define NV_PROJ__PCIE2_RP_MISC_1_CACHE_LINE_SIZE                           7:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MISC_1_CACHE_LINE_SIZE_0_BYTES            0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_MISC_1_PLATENCY_TIMER                          15:11 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MISC_1_PLATENCY_TIMER_0_CLOCKS            0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MISC_1_HEADER_TYPE0                            22:16 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MISC_1_HEADER_TYPE0_NON_BRIDGE            0x00000000 /* ----V */
#define NV_PROJ__PCIE2_RP_MISC_1_HEADER_TYPE0_P2P_BRIDGE            0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MISC_1_HEADER_TYPE1                            23:23 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MISC_1_HEADER_TYPE1_SINGLEFUNC            0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MISC_1_HEADER_TYPE1_MULTIFUNC             0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_MISC_1_BIST                                    31:24 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MISC_1_BIST_ZERO                          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_BAR_0                                     0x00000010 /* C--4R */
#define NV_PROJ__PCIE2_RP_BAR_0_RESERVED                                  31:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_BAR_0_RESERVED_0                          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_BAR_1                                     0x00000014 /* C--4R */
#define NV_PROJ__PCIE2_RP_BAR_1_RESERVED                                  31:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_BAR_1_RESERVED_0                          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_BN_LT                                     0x00000018 /* RW-4R */
#define NV_PROJ__PCIE2_RP_BN_LT_PRI_BUS_NUMBER                             7:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_BN_LT_PRI_BUS_NUMBER_0                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_BN_LT_SEC_BUS_NUMBER                            15:8 /* RWIUF */
#define NV_PROJ__PCIE2_RP_BN_LT_SEC_BUS_NUMBER_0                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_BN_LT_SEC_BUS_NUMBER_1                    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_BN_LT_SEC_BUS_NUMBER_2                    0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_BN_LT_SEC_BUS_NUMBER_255                  0x000000ff /* RW--V */
#define NV_PROJ__PCIE2_RP_BN_LT_SUB_BUS_NUMBER                           23:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_BN_LT_SUB_BUS_NUMBER_0                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_BN_LT_SUB_BUS_NUMBER_1                    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_BN_LT_SUB_BUS_NUMBER_2                    0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_BN_LT_SUB_BUS_NUMBER_255                  0x000000ff /* RW--V */
#define NV_PROJ__PCIE2_RP_BN_LT_SLATENCY_TIMER                           31:27 /* C-IVF */
#define NV_PROJ__PCIE2_RP_BN_LT_SLATENCY_TIMER_0_CLOCKS             0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS                                  0x0000001C /* RW-4R */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_SUPPORT                         3:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_SUPPORT_16               0x00000000 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_SUPPORT_32               0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE                                 7:4 /* RWIUF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_ADDRESS_0                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_ADDRESS_256              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_ADDRESS_512              0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_BASE_ADDRESS_64K              0x0000000f /* RW--V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_SUPPORT                       11:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_SUPPORT_16              0x00000000 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_SUPPORT_32              0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT                              15:12 /* RWIUF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_ADDRESS_0               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_ADDRESS_256             0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_ADDRESS_512             0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_IO_LIMIT_ADDRESS_64K             0x0000000f /* RW--V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_66MHZ                                 21:21 /* C-IVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_66MHZ_INCAPABLE                  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_66MHZ_CAPABLE                    0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_FAST_BACK2BACK                        23:23 /* C-IVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_FAST_BACK2BACK_INCAPABLE         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_FAST_BACK2BACK_CAPABLE           0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_MASTER_DATA_PERR                      24:24 /* C-IVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_MASTER_DATA_PERR_NOT_ACTIVE      0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_MASTER_DATA_PERR_ACTIVE          0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DEVSEL_TIMING                         26:25 /* C-IVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DEVSEL_TIMING_FAST               0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DEVSEL_TIMING_MEDIUM             0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DEVSEL_TIMING_SLOW               0x00000002 /* ----V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_SIGNALED_TARGET                       27:27 /* RWIVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_SIGNALED_TARGET_NO_ABORT         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_SIGNALED_TARGET_ABORT            0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_SIGNALED_TARGET_SET              0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_TARGET                       28:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_TARGET_NO_ABORT         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_TARGET_ABORT            0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_TARGET_SET              0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_MASTER                       29:29 /* RWIVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_MASTER_NO_ABORT         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_MASTER_ABORT            0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_MASTER_SET              0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_SERR                         30:30 /* RWIVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_SERR_NOT_ACTIVE         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_SERR_ACTIVE             0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_RECEIVED_SERR_SET                0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DETECTED_PERR                         31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DETECTED_PERR_NOT_ACTIVE         0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DETECTED_PERR_ACTIVE             0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_IO_BL_SS_DETECTED_PERR_SET                0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_MEM_BL                                    0x00000020 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_BASE                                 15:4 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_BASE_ADDRESS_0                 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_BASE_ADDRESS_1MEG              0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_BASE_ADDRESS_2MEG              0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_BASE_ADDRESS_4GIG              0x00000fff /* RW--V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_LIMIT                               31:20 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_LIMIT_ADDRESS_0                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_LIMIT_ADDRESS_1MEG             0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_LIMIT_ADDRESS_2MEG             0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_MEM_BL_MEM_LIMIT_ADDRESS_4GIG             0x00000fff /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BL                                    0x00000024 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRE_BL_B64BIT                                    3:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PRE_BL_B64BIT_YES                         0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_BASE                        15:4 /* RWIUF */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_BASE_ADDRESS_0        0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_BASE_ADDRESS_1MEG     0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_BASE_ADDRESS_2MEG     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_BASE_ADDRESS_4GIG     0x00000fff /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BL_L64BIT                                  19:16 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PRE_BL_L64BIT_YES                         0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_LIMIT                      31:20 /* RWIUF */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_LIMIT_ADDRESS_0       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_LIMIT_ADDRESS_1MEG    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_LIMIT_ADDRESS_2MEG    0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BL_PREFETCH_MEM_LIMIT_ADDRESS_4GIG    0x00000fff /* RW--V */
#define NV_PROJ__PCIE2_RP_PRE_BU32                                  0x00000028 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRE_BU32_BASE_UPPER_BITS                        31:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_PRE_BU32_BASE_UPPER_BITS_0                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRE_LU32                                  0x0000002C /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRE_LU32_LIMIT_UPPER_BITS                       31:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_PRE_LU32_LIMIT_UPPER_BITS_0               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_IO_BL_U16                                 0x00000030 /* RW-4R */
#define NV_PROJ__PCIE2_RP_IO_BL_U16_BASE_UPPER_BITS                       15:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_IO_BL_U16_BASE_UPPER_BITS_0               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_IO_BL_U16_LIMIT_UPPER_BITS                     31:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_IO_BL_U16_LIMIT_UPPER_BITS_0              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_CAP_PTR                                   0x00000034 /* C--4R */
#define NV_PROJ__PCIE2_RP_CAP_PTR_CAP_PTR                                  7:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_CAP_PTR_CAP_PTR_PM                        0x00000040 /* C-I-V */
#define NV_PROJ__PCIE2_RP_ROM_BA                                    0x00000038 /* C--4R */
#define NV_PROJ__PCIE2_RP_ROM_BA_RESERVED                                 31:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_ROM_BA_RESERVED_0                         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR                                  0x0000003C /* RW-4R */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_LINE                               7:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_LINE_IRQ0                   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_LINE_IRQ1                   0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_LINE_IRQ15                  0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_LINE_UNKNOWN                0x000000FF /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_PIN                               15:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_PIN_NONE                    0x00000000 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_PIN_INTA                    0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_PIN_INTB                    0x00000002 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_PIN_INTC                    0x00000003 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_INTR_PIN_INTD                    0x00000004 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_PERR_RESP                             16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_PERR_RESP_DISABLED               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_PERR_RESP_ENABLED                0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SERR_FORWARD                          17:17 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SERR_FORWARD_DISABLED            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SERR_FORWARD_ENABLED             0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_ISA_ADDRESS                           18:18 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_ISA_ADDRESS_DISABLED             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_ISA_ADDRESS_ENABLED              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_VGA_ADDRESS                           19:19 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_VGA_ADDRESS_DISABLED             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_VGA_ADDRESS_ENABLED              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_VGA_16BITIO                           20:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_VGA_16BITIO_DISABLED             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_VGA_16BITIO_ENABLED              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_MABORT                                21:21 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_MABORT_DISABLED                  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_MABORT_ENABLED                   0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SB_RESET                              22:22 /* RWIVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SB_RESET_DISABLED                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SB_RESET_ENABLED                 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_FAST_B2B                              23:23 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_FAST_B2B_DISABLED                0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_FAST_B2B_ENABLED                 0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_PRIMARY_DIS_TIMER                     24:24 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_PRIMARY_DIS_TIMER_LONG           0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_PRIMARY_DIS_TIMER_SHORT          0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SECONDARY_DIS_TIMER                   25:25 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SECONDARY_DIS_TIMER_LONG         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_SECONDARY_DIS_TIMER_SHORT        0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_DIS_TIMER_STATUS                      26:26 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_DIS_TIMER_STATUS_NOT_ACTIVE      0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_DIS_TIMER_STATUS_ACTIVE          0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_DIS_TIMER_SERR                        27:27 /* C-IVF */
#define NV_PROJ__PCIE2_RP_INTR_BCR_DIS_TIMER_SERR_DISABLED          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_INTR_BCR_DIS_TIMER_SERR_ENABLED           0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_SS_0                                      0x00000040 /* R--4R */
#define NV_PROJ__PCIE2_RP_SS_0_NEXT_PTR                                   15:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_SS_0_NEXT_PTR_PM                                0x48 /* C-I-V */
#define NV_PROJ__PCIE2_RP_SS_0_CAP_ID                                      7:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_SS_0_CAP_ID_SS                                  0x0D /* C-I-V */
#define NV_PROJ__PCIE2_RP_SS_1                                      0x00000044 /* R--4R */
#define NV_PROJ__PCIE2_RP_SS_1_SSID                                      31:16 /* R-IVF */
#define NV_PROJ__PCIE2_RP_SS_1_SSID_INIT                                  0x0  /* R-I-V */
#define NV_PROJ__PCIE2_RP_SS_1_SSVID                                      15:0 /* R-IVF */
#define NV_PROJ__PCIE2_RP_SS_1_SSVID_INIT                               0x10DE /* R-I-V */
#define NV_PROJ__PCIE2_RP_PM_0                                      0x00000048 /* R--4R */
#define NV_PROJ__PCIE2_RP_PM_0_PME_SUPPORT                               31:27 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_PME_SUPPORT_YES                      0x0000001F /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_PME_SUPPORT_NO                       0x00000000 /* ----V */
#define NV_PROJ__PCIE2_RP_PM_0_D2_SUPPORT                                26:26 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_D2_SUPPORT_YES                       0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_PM_0_D2_SUPPORT_NO                        0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_D1_SUPPORT                                25:25 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_D1_SUPPORT_YES                       0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_PM_0_D1_SUPPORT_NO                        0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_AUX_CURRENT                               24:22 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_AUX_CURRENT_0                        0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_DEV_SPEC_INIT                             21:21 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_DEV_SPEC_INIT_NOT_NEEDED             0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_DEV_SPEC_INIT_NEEDED                 0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_PM_0_PME_CLOCK                                 19:19 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_PME_CLOCK_NOT_NEEDED                 0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_PME_CLOCK_NEEDED                     0x00000001 /* ----V */
#define NV_PROJ__PCIE2_RP_PM_0_PCIPM_REV                                 18:16 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_PCIPM_REV_12                         0x00000003 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_0_PCIPM_REV_11                         0x00000002 /* ----V */
#define NV_PROJ__PCIE2_RP_PM_0_NEXT_PTR                                   15:8 /* R--VF */
#define NV_PROJ__PCIE2_RP_PM_0_CAP_ID                                      7:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_0_CAP_ID_PM                            0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_1                                      0x0000004C /* RW-4R */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DATA                                  31:24 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DATA_UNS                         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_BPCC                                  23:23 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_BPCC_UNS                         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_B2B3                                  22:22 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_B2B3_UNS                         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_STATUS                                15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_STATUS_NOT_ACTIVE                0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_STATUS_ACTIVE                    0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_STATUS_SET                       0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DATA_SCALE                            14:13 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DATA_SCALE_UNS                   0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DATA_SEL                               12:9 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DATA_SEL_UNS                     0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME                                         8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PM_1_PME_DISABLE                          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PM_1_PME_ENABLE                           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PM_1_PWR_STATE                                   1:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PM_1_PWR_STATE_D0                         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PM_1_PWR_STATE_D1                         0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PM_1_PWR_STATE_D2                         0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_PM_1_PWR_STATE_D3HOT                      0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL                                    0x00000050 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_RSVD                                    31:24 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_RSVD_0                             0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_64BIT_CAP                               23:23 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_64BIT_CAP_TRUE                     0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_EN                                 22:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_EN_CODE0                      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_EN_CODE2                      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_EN_CODE4                      0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_EN_CODE8                      0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_CAP                                19:17 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MULT_CAP_CODE2                     0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MSI                                     16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MSI_DISABLE                        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_MSI_ENABLE                         0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_NEXT_PTR                                 15:8 /* R--VF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_NEXT_PTR_MSIMAP                    0x00000060 /* R---V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_NEXT_PTR_PCIEXP                    0x00000080 /* R---V */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_CAP_ID                                    7:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSI_CTRL_CAP_ID_MSI                         0x00000005 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSI_LOW_ADDR                                 0x00000054 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSI_LOW_ADDR_DWORD                                 31:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSI_LOW_ADDR_DWORD_0                         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSI_LOW_ADDR_RSVD                                   1:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSI_LOW_ADDR_RSVD_0                          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSI_UPPER_ADDR                              0x00000058 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSI_UPPER_ADDR_DWORD                              31:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSI_UPPER_ADDR_DWORD_0                      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSI_DATA                                    0x0000005C /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSI_DATA_RSVD                                    31:16 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSI_DATA_RSVD_0                             0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSI_DATA_NON_RSVD                                 15:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSI_DATA_NON_RSVD_0                         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSIMAP_0                                    0x00000060 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_CAP_ID                                    7:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_CAP_ID_LDT                         0x00000008 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_CAP_PTR                                  15:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_CAP_PTR_PCIEXP                     0x00000080 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_XLATE_ENABLE                            16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_XLATE_ENABLE_DEFAULT               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_CAP_TYPE                                31:27 /* C-IVF */
#define NV_PROJ__PCIE2_RP_MSIMAP_0_CAP_TYPE_MSI                       0x00000015 /* C-I-V */
#define NV_PROJ__PCIE2_RP_MSIMAP_1                                    0x00000064 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSIMAP_1_ADDRESS_LOWER                           31:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSIMAP_1_ADDRESS_LOWER_DEFAULT              0x00000FEE /* RWI-V */
#define NV_PROJ__PCIE2_RP_MSIMAP_2                                    0x00000068 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MSIMAP_2_ADDRESS_UPPER                            31:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_MSIMAP_2_ADDRESS_UPPER_DEFAULT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY                               0x00000080 /* R--4R */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_LIST_CAPABILITY_ID                   7:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_LIST_CAPABILITY_ID_INIT       0x00000010 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_LIST_NEXT_CAPABILITY_PTR            15:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_LIST_NEXT_CAPABILITY_PTR_INIT 0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_VERSION                            19:16 /* R-IVF */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_VERSION_INIT                  0x00000002 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_VERSION_1                     0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_VERSION_2                     0x00000002 /* R---V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_DEVICE_PORT_TYPE                   23:20 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_DEVICE_PORT_TYPE_INIT         0x00000004 /* C-I-V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_SLOT_IMPLEMENTED                   24:24 /* R-IVF */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_SLOT_IMPLEMENTED_INIT         0x00000001 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_INTERRUPT_MESSAGE_NUMBER           29:25 /* C-IVF */
#define NV_PROJ__PCIE2_RP_PCI_EXPRESS_CAPABILITY_INTERRUPT_MESSAGE_NUMBER_ZERO 0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY                         		  0x00000084 /* R--4R */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_MAX_PAYLOAD_SIZE                       	 2:0 /* R-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_MAX_PAYLOAD_SIZE_INIT   		  0x00000001 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_PHANTOM_FUNCTIONS_SUPPORTED    	         4:3 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_PHANTOM_FUNCTIONS_SUPPORTED_INIT	  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_EXTENDED_TAG_FIELD_SIZE        	         5:5 /* R--VF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ENDPOINT_L0S_ACCEPTABLE_LATENCY              8:6 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ENDPOINT_L0S_ACCEPTABLE_LATENCY_INIT  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ENDPOINT_L1_ACCEPTABLE_LATENCY              11:9 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ENDPOINT_L1_ACCEPTABLE_LATENCY_INIT   0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ATTENTION_BUTTON_PRESENT                   12:12 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ATTENTION_BUTTON_PRESENT_INIT         0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ATTENTION_INDICATOR_PRESENT  	       13:13 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ATTENTION_INDICATOR_PRESENT_INIT      0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_POWER_INDICATOR_PRESENT      	       14:14 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_POWER_INDICATOR_PRESENT_INIT          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ROLE_BASED_ERR_REPORTING                   15:15 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_ROLE_BASED_ERR_REPORTING_INIT                0x1 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_CAPTURED_SLOT_POWER_LIMIT_VALUE            25:18 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_CAPTURED_SLOT_POWER_LIMIT_VALUE_INIT  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_CAPTURED_SLOT_POWER_LIMIT_SCALE            27:26 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITY_CAPTURED_SLOT_POWER_LIMIT_SCALE_INIT  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS                                    0x00000088 /* RWI4R */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_CORR_ERROR_REPORTING_ENABLE               0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_CORR_ERROR_REPORTING_ENABLE_INIT   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_NON_FATAL_ERROR_REPORTING_ENABLE          1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_NON_FATAL_ERROR_REPORTING_ENABLE_INIT     0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_FATAL_ERROR_REPORTING_ENABLE              2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_FATAL_ERROR_REPORTING_ENABLE_INIT  0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_UNSUPP_REQ_REPORTING_ENABLE               3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_UNSUPP_REQ_REPORTING_ENABLE_INIT   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_ENABLE_RELAXED_ORDERING                   4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_ENABLE_RELAXED_ORDERING_INIT       0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_MAX_PAYLOAD_SIZE                          7:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_MAX_PAYLOAD_SIZE_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_EXTENDED_TAG_FIELD_ENABLE                 8:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_EXTENDED_TAG_FIELD_ENABLE_INIT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_PHANTOM_FUNCTIONS_ENABLE                  9:9 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_PHANTOM_FUNCTIONS_ENABLE_INIT      0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_AUXILLARY_POWER_PM_ENABLE               10:10 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_AUXILLARY_POWER_PM_ENABLE_INIT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_ENABLE_NO_SNOOP                         11:11 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_ENABLE_NO_SNOOP_INIT               0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_MAX_READ_REQUEST_SIZE                   14:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_MAX_READ_REQUEST_SIZE_INIT         0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_CORR_ERROR_DETECTED                     16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_CORR_ERROR_DETECTED_INIT           0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_CORR_ERROR_DETECTED_SET            0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_NON_FATAL_ERROR_DETECTED                17:17 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_NON_FATAL_ERROR_DETECTED_INIT      0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_NON_FATAL_ERROR_DETECTED_SET       0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_FATAL_ERROR_DETECTED                    18:18 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_FATAL_ERROR_DETECTED_INIT          0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_FATAL_ERROR_DETECTED_SET           0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_UNSUPP_REQUEST_DETECTED                 19:19 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_UNSUPP_REQUEST_DETECTED_INIT       0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_UNSUPP_REQUEST_DETECTED_SET        0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_AUX_POWER_DETECTED                      20:20 /* R-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_AUX_POWER_DETECTED_INIT            0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_TRANSACTIONS_PENDING                    21:21 /* R-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_TRANSACTIONS_PENDING_INIT          0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LINK_CAPABILITIES                                     0x0000008C /* R--4R */
#define NV_PROJ__PCIE2_RP_LINK_CAPABILITIES_LINKCAP                                   31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS                                        0x00000090 /* RWI4R */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_ACTIVE_STATE_LINK_PM_CONTROL                  1:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_ACTIVE_STATE_LINK_PM_CONTROL_INIT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_READ_COMPLETION_BOUNDARY                      3:3 /* C-IVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_READ_COMPLETION_BOUNDARY_INIT          0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_LINK_DISABLE                                  4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_LINK_DISABLE_INIT                      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_RETRAIN_LINK                                  5:5 /* C-IVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_RETRAIN_LINK_INIT                      0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_COMMON_CLOCK_CONFIGURATION                    6:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_COMMON_CLOCK_CONFIGURATION_INIT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_EXTENDED_SYNCH                                7:7 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_EXTENDED_SYNCH_INIT                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_CLOCK_PM                                      8:8 /* C--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_CLOCK_PM_DEFAULT                       0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_HW_AUTO_WIDTH_DISABLE                         9:9 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_HW_AUTO_WIDTH_DISABLE_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_BW_MANAGEMENT_INT_EN                        10:10 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_BW_MANAGEMENT_INT_EN_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_AUTO_BANDWIDTH_INT_EN                       11:11 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_AUTO_BANDWIDTH_INT_EN_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_LINKSTAT                                    29:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_BW_MANAGEMENT                               30:30 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_BW_MANAGEMENT_TRUE                            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_BW_MANAGEMENT_FALSE                           0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_BW_MANAGEMENT_SET                             0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_AUTO_BANDWIDTH                              31:31 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_AUTO_BANDWIDTH_TRUE                           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_AUTO_BANDWIDTH_FALSE                          0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_AUTO_BANDWIDTH_SET                            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES                                                0x00000094 /* R--4R */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_ATTENTION_BUTTON_PRESENT                              0:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_POWER_CONTROLLER_PRESENT                              1:1 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_MRL_SENSOR_PRESENT                                    2:2 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_ATTENTION_INDICATOR_PRESENT                           3:3 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_POWER_INDICATOR_PRESENT                               4:4 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_HOT_PLUG_SURPRISE                                     5:5 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_HOT_PLUG_CAPABLE                                      6:6 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_SLOT_POWER_LIMIT_VALUE                               14:7 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_SLOT_POWER_LIMIT_SCALE                              16:15 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_ELECTROMECHANICAL_INTERLOCK_PRESENT                 17:17 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_NO_CMD_COMPLETED_SUPPORT                            18:18 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_PHYSICAL_SLOT_NUMBER                                31:19 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS                                        0x00000098 /* RWI4R */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_BUTTON_PRESSED_ENABLE                    0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_BUTTON_PRESSED_ENABLE_INIT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_FAULT_DETECTED_ENABLE                   1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_FAULT_DETECTED_ENABLE_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_CHANGED_ENABLE                     2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_CHANGED_ENABLE_INIT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_CHANGED_ENABLE                3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_CHANGED_ENABLE_INIT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_COMMAND_COMPLETED_INTERRUPT_ENABLE            4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_COMMAND_COMPLETED_INTERRUPT_ENABLE_INIT       0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HOT_PLUG_INTERRUPT_ENABLE                     5:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HOT_PLUG_INTERRUPT_ENABLE_INIT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_INDICATOR_CONTROL                        7:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_INDICATOR_CONTROL_INIT            0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_INDICATOR_CONTROL                       9:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_INDICATOR_CONTROL_INIT           0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_CONTROLLER_CONTROL                    10:10 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_CONTROLLER_CONTROL_INIT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ELECTROMECHANICAL_INTERLOCK_CONTROL         11:11 /* C-IVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ELECTROMECHANICAL_INTERLOCK_CONTROL_INIT 0x000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_DL_LAYER_STATE_CHANGED_ENABLE               12:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_DL_LAYER_STATE_CHANGED_ENABLE_INIT     0x00000000 /* RWI-V */       
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_BUTTON_PRESSED                         16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_BUTTON_PRESSED_INIT               0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ATTN_BUTTON_PRESSED_SET                0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_FAULT_DETECTED                        17:17 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_FAULT_DETECTED_INIT              0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_POWER_FAULT_DETECTED_SET               0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_CHANGED                          18:18 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_CHANGED_INIT                0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_CHANGED_SET                 0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_CHANGED                     19:19 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_CHANGED_INIT           0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_CHANGED_SET            0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_COMMAND_COMPLETED                           20:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_COMMAND_COMPLETED_INIT                 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_COMMAND_COMPLETED_SET                  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_STATE                            21:21 /* R-IVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_MRL_SENSOR_STATE_INIT                  0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_STATE                       22:22 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_PRESENCE_DETECT_STATE_YES              0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ELECTROMECHANICAL_INTERLOCK_STATE           23:23 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_ELECTROMECHANICAL_INTERLOCK_STATE_YES  0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_DL_LAYER_STATE_CHANGED                      24:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_DL_LAYER_STATE_CHANGED_INIT           0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_DL_LAYER_STATE_CHANGED_SET            0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_RCR                                       0x0000009C /* RWI4R */
#define NV_PROJ__PCIE2_RP_RCR_SERR_COR                                     0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_RCR_SERR_COR_DIS                          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RCR_SERR_NONFAT                                  1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_RCR_SERR_NONFAT_DIS                       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RCR_SERR_FAT                                     2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_RCR_SERR_FAT_DIS                          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RCR_PME_INT                                      3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_RCR_PME_INT_DIS                           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RSR                                       0x000000A0 /* RWI4R */
#define NV_PROJ__PCIE2_RP_RSR_REQID                                       15:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_RSR_PMESTAT                                    16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_RSR_PMESTAT_NOT_ACTIVE                    0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RSR_PMESTAT_ACTIVE                        0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_RSR_PMESTAT_SET                           0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_RSR_PMEPEND                                    17:17 /* R--VF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2                      0x000000A4 /* C-I4R */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2_CPL_TO_RANGES_SUP           3:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2_CPL_TO_RANGES_SUP_0  0x00000003 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2_CPL_TO_DIS_SUP              4:4 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2_CPL_TO_DIS_SUP_0     0x00000001 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2_RESERVED                   31:5 /* C-IVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CAPABILITIES_2_RESERVED_0           0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2                                    0x000000A8 /* RWI4R */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_VALUE                              3:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_VALUE_RANGE_A_LO            0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_VALUE_RANGE_A_HI            0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_VALUE_RANGE_B_LO            0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_VALUE_RANGE_B_HI            0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_VALUE_DEFAULT               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_DISABLE                            4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_CPL_TO_DISABLE_DEFAULT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_RESERVED                                 31:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_DEVICE_CONTROL_STATUS_2_RESERVED_0                         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CAPABILITIES_2                     0x000000AC /* C--4R */
#define NV_PROJ__PCIE2_RP_LINK_CAPABILITIES_2_BITS                      31:0 /* C--VF */
#define NV_PROJ__PCIE2_RP_LINK_CAPABILITIES_2_BITS_0              0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2				           0x000000B0 /* RWI4R */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_TARGET_LINK_SPEED                         3:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_TARGET_LINK_SPEED_GEN2_DIS         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_TARGET_LINK_SPEED_2P5              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_TARGET_LINK_SPEED_5P0              0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_ENTER_COMPLIANCE                          4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_ENTER_COMPLIANCE_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_HW_AUTO_SPEED_DISABLE                     5:5 /* C--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_HW_AUTO_SPEED_DISABLE_INIT         0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_SELECTABLE_DEEMPHASIS                     6:6 /* R--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_TRANSMIT_MARGIN                           9:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_TRANSMIT_MARGIN_INIT               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_ENTER_MODIFIED_COMPLIANCE	        10:10 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_ENTER_MODIFIED_COMPLIANCE_INIT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_COMPLIANCE_SOS                          11:11 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_COMPLIANCE_SOS_INIT                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_COMPLIANCE_DEEMPHASIS                   12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_COMPLIANCE_DEEMPHASIS_INIT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_RESERVED_CONTROL                        15:13 /* C--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_RESERVED_CONTROL_DEFAULT           0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_CURRENT_DEEMPHASIS_LEVEL                16:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_CURRENT_DEEMPHASIS_LEVEL_3P5       0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_CURRENT_DEEMPHASIS_LEVEL_6         0x00000000 /* R---V */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_RESERVED_STATUS                         31:17 /* C--VF */
#define NV_PROJ__PCIE2_RP_LINK_CONTROL_STATUS_2_RESERVED_STATUS_DEFAULT            0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_2                     0x000000B4 /* C--4R */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_2_BITS                      31:0 /* C--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CAPABILITIES_2_BITS_0              0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_2	               0x000000B8 /* C--4R */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_2_BITS                 31:0 /* C--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_2_BITS_0	       0x00000000 /* C---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP                                   0x00000100 /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ID                                      15:0 /* R-IVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ID_AER                                0x0001 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_VERSION                                19:16 /* C-IVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_VERSION_1                                0x1 /* C-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_NEXT_PTR                               31:20 /* C-IVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_NEXT_PTR_NONE                          0x000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR                             0x00000104 /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_TRAINING_ERR                       0:0 /* C--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_TRAINING_ERR_DEFAULT               0x0 /* C---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_DLINK_PROTO_ERR                    4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_DLINK_PROTO_ERR_FALSE              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_DLINK_PROTO_ERR_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_DLINK_PROTO_ERR_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_POS_TLP                          12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_POS_TLP_FALSE                      0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_POS_TLP_TRUE                       0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_POS_TLP_CLEAR                      0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_FC_PROTO_ERR                     13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_FC_PROTO_ERR_DEFAULT               0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_FC_PROTO_ERR_TRUE                  0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_FC_PROTO_ERR_CLEAR                 0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_TO                          14:14 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_TO_FALSE                      0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_TO_TRUE                       0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_TO_CLEAR                      0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_ABORT                       15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_ABORT_FALSE                   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_ABORT_TRUE                    0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_COMP_ABORT_CLEAR                   0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNEXP_COMP                       16:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNEXP_COMP_FALSE                   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNEXP_COMP_TRUE                    0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNEXP_COMP_CLEAR                   0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_RCV_OVFL                         17:17 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_RCV_OVFL_FALSE                     0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_RCV_OVFL_TRUE                      0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_RCV_OVFL_CLEAR                     0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MF_TLP                           18:18 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MF_TLP_FALSE                       0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MF_TLP_TRUE                        0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MF_TLP_CLEAR                       0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_ECRC_ERR                         19:19 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_ECRC_ERR_FALSE                     0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_ECRC_ERR_TRUE                      0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_ECRC_ERR_CLEAR                     0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNSUP_REQ_ERR                    20:20 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNSUP_REQ_ERR_FALSE                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNSUP_REQ_ERR_TRUE                 0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_UNSUP_REQ_ERR_CLEAR                0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK                          0x00000108 /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_TRAINING_ERR                     0:0 /* C--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_TRAINING_ERR_DEFAULT            0x0 /* C---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_DLINK_PROTO_ERR                 4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_DLINK_PROTO_ERR_NOT_MASKED      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_DLINK_PROTO_ERR_MASKED          0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_POS_TLP                       12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_POS_TLP_NOT_MASKED              0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_POS_TLP_MASKED                  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_FC_PROTO_ERR                  13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_FC_PROTO_ERR_NOT_MASKED         0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_FC_PROTO_ERR_MASKED             0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_COMP_TO                       14:14 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_COMP_TO_NOT_MASKED              0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_COMP_TO_MASKED                  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_COMP_ABORT                    15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_COMP_ABORT_NOT_MASKED           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_COMP_ABORT_MASKED               0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_UNEXP_COMP                    16:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_UNEXP_COMP_NOT_MASKED           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_UNEXP_COMP_MASKED               0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_RCV_OVFL                      17:17 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_RCV_OVFL_NOT_MASKED             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_RCV_OVFL_MASKED                 0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_MF_TLP                        18:18 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_MF_TLP_NOT_MASKED               0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_MF_TLP_MASKED                   0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_ECRC_ERR                      19:19 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_ECRC_ERR_NOT_MASKED             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_ECRC_ERR_MASKED                 0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_UNSUP_REQ_ERR                 20:20 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_UNSUP_REQ_ERR_NOT_MASKED        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_MK_UNSUP_REQ_ERR_MASKED            0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR                        0x0000010C /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_TRAINING_ERR                  0:0 /* C--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_TRAINING_ERR_NON_FATAL        0x0 /* ----V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_TRAINING_ERR_FATAL            0x1 /* C---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_DLINK_PROTO_ERR               4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_DLINK_PROTO_ERR_NON_FATAL     0x0 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_DLINK_PROTO_ERR_FATAL         0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_POS_TLP                     12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_POS_TLP_NON_FATAL             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_POS_TLP_FATAL                 0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_FC_PROTO_ERR                13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_FC_PROTO_ERR_NON_FATAL        0x0 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_FC_PROTO_ERR_FATAL            0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_COMP_TO                     14:14 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_COMP_TO_NON_FATAL             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_COMP_TO_FATAL                 0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_COMP_ABORT                  15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_COMP_ABORT_NON_FATAL          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_COMP_ABORT_FATAL              0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_UNEXP_COMP                  16:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_UNEXP_COMP_NON_FATAL          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_UNEXP_COMP_FATAL              0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_RCV_OVFL                    17:17 /* RWCVF */  
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_RCV_OVFL_NON_FATAL            0x0 /* RW--V */  
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_RCV_OVFL_FATAL                0x1 /* RWI-V */  
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_MF_TLP                      18:18 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_MF_TLP_NON_FATAL              0x0 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_MF_TLP_FATAL                  0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_ECRC_ERR                    19:19 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_ECRC_ERR_NON_FATAL            0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_ECRC_ERR_FATAL                0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_UNSUP_REQ_ERR               20:20 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_UNSUP_REQ_ERR_NON_FATAL       0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_UCERR_SEVR_UNSUP_REQ_ERR_FATAL           0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR                              0x00000110 /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RCV_ERR                             0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RCV_ERR_FALSE                       0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RCV_ERR_TRUE                        0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RCV_ERR_CLEAR                       0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_TLP                             6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_TLP_FALSE                       0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_TLP_TRUE                        0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_TLP_CLEAR                       0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_DLLP                            7:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_DLLP_FALSE                      0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_DLLP_TRUE                       0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_BAD_DLLP_CLEAR                      0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_RLOV                           8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_RLOV_FALSE                     0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_RLOV_TRUE                      0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_RLOV_CLEAR                     0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_TO                           12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_TO_FALSE                       0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_TO_TRUE                        0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_RPLY_TO_CLEAR                       0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_ADVISORY_NF                       13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_ADVISORY_NF_FALSE                   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_ADVISORY_NF_TRUE                    0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_ADVISORY_NF_CLEAR                   0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK                           0x00000114 /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RCV_ERR                          0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RCV_ERR_NOT_MASKED               0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RCV_ERR_MASKED                   0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_BAD_TLP                          6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_BAD_TLP_NOT_MASKED               0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_BAD_TLP_MASKED                   0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_BAD_DLLP                         7:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_BAD_DLLP_NOT_MASKED              0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_BAD_DLLP_MASKED                  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RPLY_RLOV                        8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RPLY_RLOV_NOT_MASKED             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RPLY_RLOV_MASKED                 0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RPLY_TO                        12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RPLY_TO_NOT_MASKED               0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_RPLY_TO_MASKED                   0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_ADVISORY_NF                    13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_ADVISORY_NF_NOT_MASKED           0x0 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_CERR_MK_ADVISORY_NF_MASKED               0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL                  0x00000118 /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ERR_PTR                 4:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_GEN_CAP            5:5 /* C-IVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_GEN_CAP_TRUE       0x1 /* C-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_GEN_EN             6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_GEN_EN_FALSE       0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_GEN_EN_TRUE        0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_CHK_CAP            7:7 /* C-IVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_CHK_CAP_TRUE       0x1 /* C-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_CHK_EN             8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_CHK_EN_FALSE       0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ADV_ERR_CAP_CNTL_ECRC_CHK_EN_TRUE        0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW0                       0x0000011C /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW0_0                           31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW1                       0x00000120 /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW1_1                           31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW2                       0x00000124 /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW2_2                           31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW3                       0x00000128 /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_HDR_LOG_DW3_3                           31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD                           0x0000012C /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_COR_ERR_RPT_EN                   0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_COR_ERR_RPT_EN_FALSE             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_COR_ERR_RPT_EN_TRUE              0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_NONFATAL_ERR_RPT_EN              1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_NONFATAL_ERR_RPT_EN_FALSE        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_NONFATAL_ERR_RPT_EN_TRUE         0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_FATAL_ERR_RPT_EN                 2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_FATAL_ERR_RPT_EN_FALSE           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_CMD_FATAL_ERR_RPT_EN_TRUE            0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS                           0x00000130 /* RW-4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_COR_RCVD                         0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_COR_RCVD_FALSE                   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_COR_RCVD_TRUE                    0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_COR_RCVD_CLEAR                   0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_COR_RCVD                    1:1 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_COR_RCVD_FALSE              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_COR_RCVD_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_COR_RCVD_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_UNCOR_RCVD                       2:2 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_UNCOR_RCVD_FALSE                 0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_UNCOR_RCVD_TRUE                  0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_UNCOR_RCVD_CLEAR                 0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_UNCOR_RCVD                  3:3 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_UNCOR_RCVD_FALSE            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_UNCOR_RCVD_TRUE             0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_MULT_UNCOR_RCVD_CLEAR            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FIRST_FATAL_RCVD                 4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FIRST_FATAL_RCVD_FALSE           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FIRST_FATAL_RCVD_TRUE            0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FIRST_FATAL_RCVD_CLEAR           0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_NONFATAL_RCVD                    5:5 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_NONFATAL_RCVD_FALSE              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_NONFATAL_RCVD_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_NONFATAL_RCVD_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FATAL_RCVD                       6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FATAL_RCVD_FALSE                 0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FATAL_RCVD_TRUE                  0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_FATAL_RCVD_CLEAR                 0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_STS_ADV_ERR_INTR_MSG_NUM           31:27 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_ID                            0x00000134 /* R--4R */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_ID_ERR_COR                          15:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_ID_ERR_COR_DEFAULT                0x0000 /* R---V */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_ID_ERR_UNCOR                       31:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_ERPTCAP_ERR_ID_ERR_UNCOR_DEFAULT              0x0000 /* R---V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0                                      0x00000494 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_DL_TIMERS_DISABLE                      0:0 /* RWIVF */ 
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_DL_TIMERS_DISABLE_INIT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_UPDATE_FC_THRESHOLD                    9:1 /* RWIVF */ 
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_UPDATE_FC_THRESHOLD_INIT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_ACK_TIMER_LIMIT                      18:10 /* RWIVF */ 
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_ACK_TIMER_LIMIT_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_REPLAY_TIMER_LIMIT                   29:19 /* RWIVF */ 
#define NV_PROJ__PCIE2_RP_PRIV_XP_DL_0_GEN2_REPLAY_TIMER_LIMIT_INIT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_DBG0                                       0x00000D00 /* RWC4R */
#define NV_PROJ__PCIE2_RP_DBG0_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG0_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG1                                       0x00000D04 /* RW-4R */
#define NV_PROJ__PCIE2_RP_DBG1_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG1_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG2                                       0x00000D08 /* RW-4R */
#define NV_PROJ__PCIE2_RP_DBG2_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG2_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG3                                       0x00000D0C /* RWC4R */
#define NV_PROJ__PCIE2_RP_DBG3_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG3_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG4                                       0x00000D10 /* RW-4R */
#define NV_PROJ__PCIE2_RP_DBG4_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG4_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG5                                       0x00000D14 /* RW-4R */
#define NV_PROJ__PCIE2_RP_DBG5_CTL                                         29:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG5_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG5_CG_EN                                      30:30 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG5_CG_EN_INIT                                   0x0 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG5_LOW_POWER_MODE                             31:31 /* RWCVF */
#define NV_PROJ__PCIE2_RP_DBG5_LOW_POWER_MODE_INIT                          0x1 /* RWC-V */
#define NV_PROJ__PCIE2_RP_DBG_RD_BACK_LO                             0x00000D18 /* R--4R */
#define NV_PROJ__PCIE2_RP_DBG_RD_BACK_LO_VALUE                             31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_DBG_RD_BACK_HI                             0x00000D1C /* R--4R */
#define NV_PROJ__PCIE2_RP_DBG_RD_BACK_HI_VALUE                             31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_LANE_DBG0                                       0x00000D20 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LANE_DBG0_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG0_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG1                                       0x00000D24 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LANE_DBG1_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG1_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG2                                       0x00000D28 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LANE_DBG2_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG2_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG3                                       0x00000D2C /* RWC4R */
#define NV_PROJ__PCIE2_RP_LANE_DBG3_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG3_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG4                                       0x00000D30 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LANE_DBG4_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG4_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG5                                       0x00000D34 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LANE_DBG5_CTL                                         29:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG5_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG5_CG_EN                                      30:30 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG5_CG_EN_INIT                                   0x0 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG5_LOW_POWER_MODE                             31:31 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LANE_DBG5_LOW_POWER_MODE_INIT                          0x1 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LANE_DBG_RD_BACK_LO                             0x00000D38 /* R--4R */    
#define NV_PROJ__PCIE2_RP_LANE_DBG_RD_BACK_LO_VALUE	                            31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_LANE_DBG_RD_BACK_HI                             0x00000D3C /* R--4R */    
#define NV_PROJ__PCIE2_RP_LANE_DBG_RD_BACK_HI_VALUE                             31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_LINK_DBG0                                       0x00000D40 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LINK_DBG0_CTL                                         31:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_DBG0_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LINK_DBG1                                       0x00000D44 /* RWC4R */
#define NV_PROJ__PCIE2_RP_LINK_DBG1_CTL                                         29:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_DBG1_CTL_INIT                              0x00000000 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LINK_DBG1_CG_EN                                      30:30 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_DBG1_CG_EN_INIT                                   0x0 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LINK_DBG1_LOW_POWER_MODE                             31:31 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LINK_DBG1_LOW_POWER_MODE_INIT                          0x1 /* RWC-V */
#define NV_PROJ__PCIE2_RP_LINK_DBG_RD_BACK_LO                             0x00000D48 /* R--4R */    
#define NV_PROJ__PCIE2_RP_LINK_DBG_RD_BACK_LO_VALUE                             31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_LINK_DBG_RD_BACK_HI                             0x00000D4C /* R--4R */    
#define NV_PROJ__PCIE2_RP_LINK_DBG_RD_BACK_HI_VALUE                             31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_RXL_DBG_RD_BACK                                0x00000D50 /* R--4R */
#define NV_PROJ__PCIE2_RP_RXL_DBG_RD_BACK_VALUE				       31:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA                                       0x00000D54 /* RWC4R */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_DFI2UBFI                                     0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_DFI2UBFI_INIT                         0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_DFIRSP                                       1:1 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_DFIRSP_INIT                           0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_DFIREQ                                       2:2 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_DFIREQ_INIT                           0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_PCA                                          3:3 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_PCA_INIT                              0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_UBFI2DFI_NTT                                 4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_UBFI2DFI_NTT_INIT                     0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_CMDQ2UFARB                                   5:5 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_CMDQ2UFARB_INIT                       0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_TXBA2DFI_WR                                  6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_TXBA2DFI_WR_INIT                      0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_UBFI2DFI_P2P                                 7:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_UBFI2DFI_P2P_INIT                     0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_UFA2WRR_PWTOP                                8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PIPE_CYA_UFA2WRR_PWTOP_INIT                    0x00000001 /* RWC-V */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT	       			   0x00000E00 /* RW-4R */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT_NP				  7:0 /* RWCUF */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT_NP_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT_PW                                15:8 /* RWCUF */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT_PW_INIT                            0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT_CPL                              23:16 /* RWCUF */
#define NV_PROJ__PCIE2_RP_RX_HDR_LIMIT_CPL_INIT                           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT				   0x00000E04 /* RW-4R */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT_NP				  7:0 /* RWCUF */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT_NP_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT_PW                               19:8 /* RWCUF */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT_PW_INIT                           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT_CPL                             27:20 /* RWCUF */
#define NV_PROJ__PCIE2_RP_RX_DATA_LIMIT_CPL_INIT                          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT				   0x00000E08 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_NP				  7:0 /* RWCUF */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_NP_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_PW                                15:8 /* RWCUF */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_PW_INIT                            0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_CPL                              23:16 /* RWCUF */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_CPL_INIT                           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_NPT                              31:24 /* RWCUF */
#define NV_PROJ__PCIE2_RP_TX_HDR_LIMIT_NPT_INIT                           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_DATA_LIMIT				   0x00000E0C /* RW-4R */
#define NV_PROJ__PCIE2_RP_TX_DATA_LIMIT_NP				  7:0 /* RWCUF */
#define NV_PROJ__PCIE2_RP_TX_DATA_LIMIT_NP_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_DATA_LIMIT_PW                               15:8 /* RWCUF */
#define NV_PROJ__PCIE2_RP_TX_DATA_LIMIT_PW_INIT                           0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_UFPCI					   0x00000E10 /* RW-4R */	
#define NV_PROJ__PCIE2_RP_UFPCI_PW_STARV_COUNT				  4:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_UFPCI_PW_STARV_COUNT_INIT		          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_UFPCI_PW_PRI_OVR_COUNT			  9:5 /* RWIUF */
#define NV_PROJ__PCIE2_RP_UFPCI_PW_PRI_OVR_COUNT_INIT		          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_UFPCI_WRR_GRANT_BURST				11:10 /* RWIUF */
#define NV_PROJ__PCIE2_RP_UFPCI_WRR_GRANT_BURST_INIT			  0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_UFPCI_REQ_PEND_PERIOD				19:12 /* RWIUF */
#define NV_PROJ__PCIE2_RP_UFPCI_REQ_PEND_PERIOD_INIT                      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_UFPCI_ISONP2HPISO                             20:20 /* RWIUF */
#define NV_PROJ__PCIE2_RP_UFPCI_ISONP2HPISO_INIT                          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_UFPCI_ISOPW2HPISO                             21:21 /* RWIUF */
#define NV_PROJ__PCIE2_RP_UFPCI_ISOPW2HPISO_INIT                          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0                                    0x00000E14 /* RW-4R */
#define NV_PROJ__PCIE2_RP_MISC0_ENABLE_CLUMPING                           0:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_ENABLE_CLUMPING_INIT	                  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_NATIVE_P2P_ENABLE			  1:1 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_NATIVE_P2P_ENABLE_INIT	                  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_ISO_NP_ENABLE		                  2:2 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_ISO_NP_ENABLE_INIT                        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_ISO_PW_ENABLE		                  3:3 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_ISO_PW_ENABLE_INIT                        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_BURST_SIZE		                 19:4 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_BURST_SIZE_INIT                      0xFF /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_RXL_CLEAR_DROP 			        20:20 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_RXL_CLEAR_DROP_INIT	                  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_AUTO_XCLK_FREQ_EN 			21:21 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_AUTO_XCLK_FREQ_EN_INIT	                  0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_NISONC2HPISO				23:23 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_NISONC2HPISO_INIT			  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_A					24:24 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_A_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_A__PROD				  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_B					25:25 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_B_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_B__PROD				  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_C					26:26 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_C_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_C__PROD				  0x0 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_D					27:27 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_D_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_D__PROD				  0x0 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_E					28:28 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_E_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_E__PROD				  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_F					29:29 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_F_INIT				  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_F__PROD				  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_SMALL_ISA_HOLE   			30:30 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_SMALL_ISA_HOLE_INIT                   0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_MISC0_P2P_SMALL_ISA_HOLE__PROD                  0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_MISC0_SHORT_RXL_TIMER 			31:31 /* RWIUF */
#define NV_PROJ__PCIE2_RP_MISC0_SHORT_RXL_TIMER_INIT 			  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0                                    0x00000E18 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TXBA0_REPLAY_BUF_LIMIT		          8:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA0_REPLAY_BUF_LIMIT_INIT                     0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0_CMPL_MERGE_DISABLE                        9:9 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA0_CMPL_MERGE_DISABLE_INIT                   0x1 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0_CMPL_MERGE_UPTO_32DW                    10:10 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA0_CMPL_MERGE_UPTO_32DW_INIT                 0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0_CMPL_MERGE_UPTO_64DW                    11:11 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA0_CMPL_MERGE_UPTO_64DW_INIT                 0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0_USE_REPLAY_TIMER_OFFSET                 12:12 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA0_USE_REPLAY_TIMER_OFFSET_INIT	          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0_USE_REPLAY_TIMER_OFFSET__PROD	          0x1 /* RW--V */
#define NV_PROJ__PCIE2_RP_TXBA0_REPLAY_TIMER_EXPIRY                     31:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA0_REPLAY_TIMER_EXPIRY_INIT	          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA0_REPLAY_TIMER_EXPIRY__PROD	         0x64 /* RW--V */
#define NV_PROJ__PCIE2_RP_TXBA1                                    0x00000E1C /* RW-4R */
#define NV_PROJ__PCIE2_RP_TXBA1_PW_OVER_CM_BURST                          3:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA1_PW_OVER_CM_BURST_INIT                     0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA1_CM_OVER_PW_BURST                          7:4 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA1_CM_OVER_PW_BURST_INIT                     0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TXBA1_CMPL_MERGE_THRESHOLD                     15:8 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TXBA1_CMPL_MERGE_THRESHOLD_INIT                 0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_FORCEFC				   0x00000E20 /* RW-4R */
#define NV_PROJ__PCIE2_RP_FORCEFC_PWH_UNRET_THRESH			  7:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_FORCEFC_PWH_UNRET_THRESH_INIT                   0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_FORCEFC_PWD_UNRET_THRESH                       15:8 /* RWIUF */
#define NV_PROJ__PCIE2_RP_FORCEFC_PWD_UNRET_THRESH_INIT                   0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_FORCEFC_NPH_UNRET_THRESH			23:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_FORCEFC_NPH_UNRET_THRESH_INIT                   0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_FORCEFC_NPD_UNRET_THRESH                      31:24 /* RWIUF */
#define NV_PROJ__PCIE2_RP_FORCEFC_NPD_UNRET_THRESH_INIT                   0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TIMEOUT0 				    0x00000E24 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TIMEOUT0_PAD_PWRUP			           7:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TIMEOUT0_PAD_PWRUP_INIT			   0xD /* RWI-V */
#define NV_PROJ__PCIE2_RP_TIMEOUT0_PAD_PWRUP_CM                           23:8 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TIMEOUT0_PAD_PWRUP_CM_INIT                      0x14 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TIMEOUT0_PAD_SPDCHNG_GEN2                      31:24 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TIMEOUT0_PAD_SPDCHNG_GEN2_INIT                   0xD /* RWI-V */
#define NV_PROJ__PCIE2_RP_TIMEOUT1                                  0x00000E28 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TIMEOUT1_PAD_SPDCHNG_GEN1                       15:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TIMEOUT1_PAD_SPDCHNG_GEN1_INIT                 0x2E8 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TIMEOUT1_RCVRY_SPD_SUCCESS_EIDLE               23:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TIMEOUT1_RCVRY_SPD_SUCCESS_EIDLE_INIT           0x14 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TIMEOUT1_RCVRY_SPD_UNSUCCESS_EIDLE             31:24 /* RWIUF */
#define NV_PROJ__PCIE2_RP_TIMEOUT1_RCVRY_SPD_UNSUCCESS_EIDLE_INIT         0x96 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR			    0x00000E2C /* RW-4R */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_DBUF                    0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_DBUF_FALSE	           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_DBUF_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_DBUF_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_HBUF                    1:1 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_HBUF_FALSE	           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_HBUF_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_CMPL_HBUF_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY                       2:2 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_FALSE	           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_TRUE                  0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_CLEAR                 0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID0                3:3 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID0_FALSE          0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID0_TRUE           0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID0_CLEAR          0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID1                4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID1_FALSE          0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID1_TRUE           0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REPLAY_SEQID1_CLEAR          0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF                     5:5 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_FALSE	           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_TRUE                0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_CLEAR               0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF                     6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_FALSE	           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_TRUE                0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_CLEAR               0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_NP_SIDEQ                 7:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_NP_SIDEQ_FALSE           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_NP_SIDEQ_TRUE            0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_NP_SIDEQ_CLEAR           0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_PW_SIDEQ                 8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_PW_SIDEQ_FALSE           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_PW_SIDEQ_TRUE            0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_PW_SIDEQ_CLEAR           0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_UCFIFO                       9:9 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_UCFIFO_FALSE                 0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_UCFIFO_TRUE                  0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_UCFIFO_CLEAR                 0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO1                  10:10 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO1_FALSE              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO1_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO1_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO2                  11:11 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO2_FALSE              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO2_TRUE               0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_TLP_FIFO2_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_DBUF                       12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_DBUF_FALSE                   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_DBUF_TRUE                    0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_DBUF_CLEAR                   0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_HBUF                       13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_HBUF_FALSE                   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_HBUF_TRUE                    0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_RX_HBUF_CLEAR                   0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO1                    14:14 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO1_FALSE                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO1_TRUE                 0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO1_CLEAR                0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO2                    15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO2_FALSE                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO2_TRUE                 0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_DCFIFO2_CLEAR                0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_ADR               16:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_ADR_FALSE	   0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_ADR_TRUE            0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_DBUF_ADR_CLEAR           0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_ADR               17:17 /* RWCVF */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_ADR_FALSE           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_ADR_TRUE            0x1 /* R---V */
#define NV_PROJ__PCIE2_RP_RAM_PARITY_ERROR_TX_REQ_HBUF_ADR_CLEAR           0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR		    0x00000E30 /* RW-4R */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_CMPL_DBUF              0:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_CMPL_DBUF_INIT         0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_CMPL_HBUF              1:1 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_CMPL_HBUF_INIT         0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REPLAY                 2:2 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REPLAY_INIT            0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REPLAY_SEQID0          3:3 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REPLAY_SEQID0_INIT     0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REPLAY_SEQID1          4:4 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REPLAY_SEQID1_INIT     0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_DBUF               5:5 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_DBUF_INIT          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_HBUF               6:6 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_HBUF_INIT          0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_NP_LEN             7:7 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_NP_LEN_INIT        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_PW_LEN             8:8 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_PW_LEN_INIT        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_UCFIFO                 9:9 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_UCFIFO_INIT            0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_TXTF_FIFO1           10:10 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_TXTF_FIFO1_INIT        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_TXTF_FIFO2           11:11 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_TXTF_FIFO2_INIT        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_RX_DBUF0                12:12 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_RX_DBUF0_INIT             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_RX_DBUF1                13:13 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_RX_DBUF1_INIT             0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_RX_HBUF                 14:14 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_RX_HBUF_INIT              0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_DBUF_ADR         16:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_DBUF_ADR_INIT      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_HBUF_ADR         17:17 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_HBUF_ADR_INIT      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_HBUF0            18:18 /* RWIUF */
#define NV_PROJ__PCIE2_RP_RAM_FORCE_PARITY_ERROR_TX_REQ_HBUF0_INIT         0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRBS					    0x00000E34 /* R--4R */
#define NV_PROJ__PCIE2_RP_PRBS_ERR_COUNT_OVERFLOW  			  15:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_PRBS_LOCKED					 31:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_LANE_PRBS_ERR                             0x00000E38 /* RW-4R */
#define NV_PROJ__PCIE2_RP_LANE_PRBS_ERR_SELECT                             3:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_LANE_PRBS_ERR_SELECT_INIT                        0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LANE_PRBS_ERR_COUNT				 31:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_0			    0x00000E3C /* RW-4R */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_0_L0_LPBK		          15:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_0_L0_LPBK_INIT                   0x80 /* RWI-V */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_0_RCVRCFG_SUC_SPEED             31:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_0_RCVRCFG_SUC_SPEED_INIT        0x500 /* RWI-V */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_1                          0x00000E40 /* RW-4R */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_1_UNSUC_SPEED_GEN1               15:0 /* RWIUF */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_1_UNSUC_SPEED_GEN1_INIT         0x7D0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_1_UNSUC_SPEED_GEN2              31:16 /* RWIUF */
#define NV_PROJ__PCIE2_RP_EIDLE_INFER_TO_1_UNSUC_SPEED_GEN2_INIT        0x3E80 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG				     0x00000E44 /* RW-4R */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM0                             0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM0_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM0_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM1                             1:1 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM1_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM1_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM2                             2:2 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM2_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM2_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM3                             3:3 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM3_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM3_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM4                             4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM4_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM4_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM5                             5:5 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM5_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM5_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM6                             6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM6_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM6_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM7                             7:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM7_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM7_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM8                             8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM8_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM8_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM9                             9:9 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM9_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM9_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM10                          10:10 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM10_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM10_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM11                          11:11 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM11_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM11_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM12                          12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM12_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM12_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM13                          13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM13_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM13_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM14                          14:14 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM14_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM14_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM15                          15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM15_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM15_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM16                          16:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM16_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM16_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM17                          17:17 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM17_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM17_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM18                          18:18 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM18_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM18_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM19                          19:19 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM19_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM19_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM20                          20:20 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM20_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM20_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM21                          21:21 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM21_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM21_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM22                          22:22 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM22_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM22_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM23                          23:23 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM23_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM23_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM24                          24:24 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM24_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM24_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM25                          25:25 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM25_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM25_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM26                          26:26 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM26_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM26_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM27                          27:27 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM27_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM27_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM28                          28:28 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM28_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM28_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM29                          29:29 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM29_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM29_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM30                          30:30 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM30_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM30_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM31                          31:31 /* RWCVF */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM31_INIT		            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_LTSSM_DBGREG_LINKFSM31_CLEAR		            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS		                     0x00000E48 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_LCRC_ERR                              0:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_LCRC_ERR_INIT                         0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_LCRC_ERR_CLEAR                        0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_FRAMING_ERR                           1:1 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_FRAMING_ERR_INIT                      0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_FRAMING_ERR_CLEAR                     0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_NP_HDR_ERR                   2:2 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_NP_HDR_ERR_INIT              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_NP_HDR_ERR_CLEAR             0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_PW_HDR_ERR                   3:3 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_PW_HDR_ERR_INIT              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_PW_HDR_ERR_CLEAR             0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_CPL_HDR_ERR                  4:4 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_CPL_HDR_ERR_INIT             0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_CPL_HDR_ERR_CLEAR            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_NP_DATA_ERR                  5:5 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_NP_DATA_ERR_INIT             0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_NP_DATA_ERR_CLEAR            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_PW_DATA_ERR                  6:6 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_PW_DATA_ERR_INIT             0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_PW_DATA_ERR_CLEAR            0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_CPL_DATA_ERR                 7:7 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_CPL_DATA_ERR_INIT            0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_CPL_DATA_ERR_CLEAR           0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISONP_HDR_ERR                8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISONP_HDR_ERR_INIT           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISONP_HDR_ERR_CLEAR          0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISOPW_HDR_ERR                9:9 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISOPW_HDR_ERR_INIT           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISOPW_HDR_ERR_CLEAR          0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISOPW_DATA_ERR             10:10 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISOPW_DATA_ERR_INIT          0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REC_OVFL_ISOPW_DATA_ERR_CLEAR         0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CD_TOO_MANY_CREDITS_ERR             11:11 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CD_TOO_MANY_CREDITS_ERR_INIT          0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CD_TOO_MANY_CREDITS_ERR_CLEAR         0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CD_UPDATE_FC_ERR                    12:12 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CD_UPDATE_FC_ERR_INIT                 0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CD_UPDATE_FC_ERR_CLEAR                0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CH_TOO_MANY_CREDITS_ERR             13:13 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CH_TOO_MANY_CREDITS_ERR_INIT          0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CH_TOO_MANY_CREDITS_ERR_CLEAR         0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CH_UPDATE_FC_ERR                    14:14 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CH_UPDATE_FC_ERR_INIT                 0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_CH_UPDATE_FC_ERR_CLEAR                0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPD_TOO_MANY_CREDITS_ERR            15:15 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPD_TOO_MANY_CREDITS_ERR_INIT         0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPD_TOO_MANY_CREDITS_ERR_CLEAR        0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPD_UPDATE_FC_ERR                   16:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPD_UPDATE_FC_ERR_INIT                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPD_UPDATE_FC_ERR_CLEAR               0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPH_TOO_MANY_CREDITS_ERR            17:17 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPH_TOO_MANY_CREDITS_ERR_INIT         0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPH_TOO_MANY_CREDITS_ERR_CLEAR        0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPH_UPDATE_FC_ERR                   18:18 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPH_UPDATE_FC_ERR_INIT                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_NPH_UPDATE_FC_ERR_CLEAR               0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWD_TOO_MANY_CREDITS_ERR            19:19 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWD_TOO_MANY_CREDITS_ERR_INIT         0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWD_TOO_MANY_CREDITS_ERR_CLEAR        0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWD_UPDATE_FC_ERR                   20:20 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWD_UPDATE_FC_ERR_INIT                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWD_UPDATE_FC_ERR_CLEAR               0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWH_TOO_MANY_CREDITS_ERR            21:21 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWH_TOO_MANY_CREDITS_ERR_INIT         0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWH_TOO_MANY_CREDITS_ERR_CLEAR        0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWH_UPDATE_FC_ERR                   22:22 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWH_UPDATE_FC_ERR_INIT                0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_PWH_UPDATE_FC_ERR_CLEAR               0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_ROLLOVER_ERR                 23:23 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_ROLLOVER_ERR_INIT              0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_ROLLOVER_ERR_CLEAR             0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_STARTED_ERR                  24:24 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_STARTED_ERR_INIT               0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_STARTED_ERR_CLEAR              0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_8B10B_ERR                           25:25 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_8B10B_ERR_INIT                        0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_8B10B_ERR_CLEAR                       0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_DLLP_CRC_ERR                        26:26 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_DLLP_CRC_ERR_INIT                     0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_DLLP_CRC_ERR_CLEAR                    0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_TRAINING_ERR                        27:27 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_TRAINING_ERR_INIT                     0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_TRAINING_ERR_CLEAR                    0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_DESKEW_ERR                          28:28 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_DESKEW_ERR_INIT                       0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_DESKEW_ERR_CLEAR                      0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_SA_ERR                              29:29 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_SA_ERR_INIT                           0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_SA_ERR_CLEAR                          0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_TIMER_EXPIRED_ERR            30:30 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_TIMER_EXPIRED_ERR_INIT         0x0 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_ERRSTS_REPLAY_TIMER_EXPIRED_ERR_CLEAR        0x1 /* -W--C */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL                                 0x00000E4C /* RW-4R */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_STORE_EN                               0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_STORE_EN_INIT                   0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_STORE_EN_CLEAR                  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_STORE_EN_SET                    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_WRAP_EN                                1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_WRAP_EN_INIT                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_WRAP_EN_CLEAR                   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_WRAP_EN_SET                     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_CLEAR_RAM                              2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_CLEAR_RAM_INIT                  0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_ON_EVENT                          3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_ON_EVENT_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_LTSSM_MAJOR                       7:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_LTSSM_MAJOR_INIT           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_PTX_LTSSM_MINOR                  10:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_PTX_LTSSM_MINOR_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_PRX_LTSSM_MINOR                 13:11 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_CONTROL_TRIG_PRX_LTSSM_MINOR_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS                                  0x00000E50 /* RW-4R */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_RAM_FULL                                0:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_WRITE_PTR                               5:1 /* R--VF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_READ_ADDR                              10:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_READ_ADDR_INIT                   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_READ_DATA_VALID                       11:11 /* R--VF */
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_LTSSM_MAJOR                           15:12 /* R--VF */      
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_PTX_LTSSM_MINOR                       18:16 /* R--VF */      
#define NV_PROJ__PCIE2_RP_LTSSM_TRACE_STATUS_PRX_LTSSM_MINOR                       21:19 /* R--VF */      
#define NV_PROJ__PCIE2_RP_VEND_XP                                   0x00000F00 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_EMULATION                                0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_EMULATION_OFF                     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_EMULATION_ON                      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PRBS_EN                                  1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PRBS_EN_DISABLED                  0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PRBS_EN_ENABLED                   0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PRBS_STAT                               17:2 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_XP_UPDATE_FC_THRESHOLD                    25:18 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_UPDATE_FC_THRESHOLD_INIT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_UPDATE_FC_THRESHOLD__PROD         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_TRAIN_ERR_ENABLE                       26:26 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_TRAIN_ERR_ENABLE_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_TRAIN_ERR_ENABLE__PROD            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_OPPORTUNISTIC_ACK                      27:27 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_OPPORTUNISTIC_ACK_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_OPPORTUNISTIC_ACK__PROD           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_OPPORTUNISTIC_UPDATEFC                 28:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_OPPORTUNISTIC_UPDATEFC_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_OPPORTUNISTIC_UPDATEFC__PROD      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_INTERLEAVE_DLLPS                       29:29 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_INTERLEAVE_DLLPS_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_INTERLEAVE_DLLPS__PROD            0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_DL_UP                                  30:30 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_XP_FORCE_COMPLIANCE			 31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_FORCE_COMPLIANCE_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1                                  0x00000F04 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_MAXWIDTH                         5:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_MAXWIDTH_INIT            0x000000010 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_GEN2_LINK_UPGRADE                6:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_GEN2_LINK_UPGRADE_INIT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_EN                               7:7 /* C-IVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_EN_ZERO                   0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_GEN2_WAIT_FOR_FIRST_EIES             8:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_RNCTRL_GEN2_WAIT_FOR_FIRST_EIES_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_ACK_TIMER_LIMIT                       18:10 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_ACK_TIMER_LIMIT_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_ACK_TIMER_LIMIT__PROD            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_CYA                                   26:19 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_CYA_INIT                         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_CYA__PROD                        0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_FORCE_UPSTREAM_NONCOH                 27:27 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP1_FORCE_UPSTREAM_NONCOH_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_FORCE_UPSTREAM_NONCOH_ENABLED    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP1_FORCE_UPSTREAM_NONCOH_DISABLED   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP2                                  0x00000F08 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_ACK_WAKE                            7:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_ACK_WAKE_INIT                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_ACK_WAKE__PROD               0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_THRESHOLD                          17:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_THRESHOLD_INIT               0x000003FF /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_THRESHOLD__PROD              0x000003FF /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_THRESHOLD_REMOTE_NFTS        0x000003FF /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_UPDATE_WAKE                       31:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_UPDATE_WAKE_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP2_L0S_UPDATE_WAKE__PROD            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT                                      0x00000F0C /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND                                 9:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_DEFAULT                  0x000000FA /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_250                      0x000000FA /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_278                      0x00000116 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_313                      0x00000139 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_357                      0x00000165 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_417                      0x000001A1 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_500                      0x000001F4 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND_555                      0x0000022B /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_MICROSECOND__PROD_C_FPGA             0x000000FA /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_100MS_DFPCI                               31:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_100MS_DFPCI_333                      0x00000030 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_100MS_DFPCI_250                      0x00000018 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_TIMEOUT_100MS_DFPCI__PROD                    0x00000018 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XV_CMN                               0x00000F14 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XV_CMN_ISO2TC_MAP                         31:29 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XV_CMN_ISO2TC_MAP_7                  0x00000007 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XV_CMN_ISO2TC_MAP__PROD              0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT                           0x00000F18 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT_ENABLE                           0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT_ENABLE_INIT                      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT_DUTY_CYCLE                       3:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT_DUTY_CYCLE_INIT                  0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT_PERIOD                          15:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_THERM_MGMT_PERIOD_INIT                      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP                           0x00000F20 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ATTENTION_BUTTON_PRESENT         0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ATTENTION_BUTTON_PRESENT_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ATTENTION_BUTTON_PRESENT__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_POWER_CONTROLLER_PRESENT         1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_POWER_CONTROLLER_PRESENT_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_POWER_CONTROLLER_PRESENT__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_MRL_SENSOR_PRESENT               2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_MRL_SENSOR_PRESENT_INIT   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_MRL_SENSOR_PRESENT__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ATTENTION_INDICATOR_PRESENT      3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ATTENTION_INDICATOR_PRESENT_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ATTENTION_INDICATOR_PRESENT__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_POWER_INDICATOR_PRESENT          4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_POWER_INDICATOR_PRESENT_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_POWER_INDICATOR_PRESENT__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_HOT_PLUG_SURPRISE                5:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_HOT_PLUG_SURPRISE_INIT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_HOT_PLUG_SURPRISE__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_HOT_PLUG_CAPABLE                 6:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_HOT_PLUG_CAPABLE_INIT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_HOT_PLUG_CAPABLE__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_SLOT_POWER_LIMIT_VALUE          14:7 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_SLOT_POWER_LIMIT_VALUE_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_SLOT_POWER_LIMIT_VALUE__PROD_C 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_SLOT_POWER_LIMIT_SCALE         16:15 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_SLOT_POWER_LIMIT_SCALE_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_SLOT_POWER_LIMIT_SCALE__PROD_C 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ELECTROMECH_INTERLOCK_PRESENT 17:17 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ELECTROMECH_INTERLOCK_PRESENT_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_ELECTROMECH_INTERLOCK_PRESENT__PROD_C_HPC 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_NO_CMD_COMPLETED_SUPPORT           18:18 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_NO_CMD_COMPLETED_SUPPORT_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_NO_CMD_COMPLETED_SUPPORT__PROD 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_PHYSICAL_SLOT_NUMBER           31:19 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_PHYSICAL_SLOT_NUMBER_INIT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SLOT_STRAP_PHYSICAL_SLOT_NUMBER__PROD_C 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0                                 0x00000F44 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_PASSPW_RO                              1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_PASSPW_RO_NOT                   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_PASSPW_RO__PROD                 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_PASSPW_RO_YES                   0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_GPU_NISONC2HPISO                       2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_GPU_NISONC2HPISO_EN             0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_GPU_NISONC2HPISO__PROD          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_GPU_NISONC2HPISO_DIS            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_DFPCI_ERR                         3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_DFPCI_ERR_NO               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_DFPCI_ERR_YES              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_DFPCI_ERR__PROD            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_IGNORE_BME                             4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_IGNORE_BME_NO                   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_IGNORE_BME__PROD                0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_IGNORE_BME_YES                  0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_ADR64                                  5:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_ADR64_EN                        0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_ADR64__PROD                     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_ADR64_DIS                       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_MAX_PAYLOAD_SIZE                       8:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_MAX_PAYLOAD_SIZE_INIT           0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_MAX_PAYLOAD_SIZE_4KB            0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_MAX_PAYLOAD_SIZE_AUTO           0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_ALL_MODE                          9:9 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_ALL_MODE_INIT              0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_ALL_MODE_YES               0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DROP_ALL_MODE_NO                0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UR_PW_DROP_ALL_MODE                  10:10 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UR_PW_DROP_ALL_MODE_INIT        0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UR_PW_DROP_ALL_MODE_YES         0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UR_PW_DROP_ALL_MODE_NO          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_FINISH_PKT_ON_RCVRY_EN               11:11 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_FINISH_PKT_ON_RCVRY_EN_INIT     0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DSK_RESET_PULSE_WIDTH                15:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DSK_RESET_PULSE_WIDTH_INIT      0x00000008 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_NATIVE_P2P_STARVE_COUNT              23:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_NATIVE_P2P_STARVE_COUNT_INIT    0x00000000 /* RWI-V */        
#define NV_PROJ__PCIE2_RP_VEND_CYA0_NATIVE_P2P_STARVE_COUNT__PROD   0x00000004 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UP_NC2C                              29:29 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UP_NC2C_EN                      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UP_NC2C__PROD                   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_UP_NC2C_DIS                     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_FORCE_RETRY_POSSIBLE                 30:30 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_FORCE_RETRY_POSSIBLE_NO         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_FORCE_RETRY_POSSIBLE_YES        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DISABLE_CRS                          31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DISABLE_CRS_INIT                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA0_DISABLE_CRS__PROD               0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1                                 0x00000F48 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_BLOCK_P2P_ONLY                     0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_BLOCK_P2P_ONLY_EN           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_BLOCK_P2P_ONLY__PROD        0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_BLOCK_P2P_ONLY_DIS          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_TC2ISO_MAP                             3:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_TC2ISO_MAP_7                    0x00000007 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_TC2ISO_MAP__PROD                0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ACCEPT_MSGD1                           4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ACCEPT_MSGD1_DIS                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ACCEPT_MSGD1_EN                 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ACCEPT_MSGD1__PROD              0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSI_CAP                         12:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSI_CAP_DIS                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSI_CAP_EN                 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSI_CAP__PROD              0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ERPT                                 13:13 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ERPT_EN                         0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ERPT_DIS                        0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_ERPT__PROD                      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_ISO2NISO                         14:14 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_ISO2NISO_EN                 0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_ISO2NISO_DIS                0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_P2P_ISO2NISO__PROD              0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_LINKACTV_REPORTING                   15:15 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_LINKACTV_REPORTING_CAPABLE      0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_LINKACTV_REPORTING_NOT_CAPABLE  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_LINKACTV_REPORTING__PROD        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSIMAP                          16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSIMAP_DIS                 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSIMAP_EN                  0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA1_HIDE_MSIMAP__PROD               0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST                                                     0x00000F4C /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL                                                      31:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_INIT                                           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL__PROD                                          0x10000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN                                 0x00000F50 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_L1                                     0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_L1_EN                           0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_L1_DIS                          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_L1__PROD                        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DYNAMIC                                1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DYNAMIC_EN                      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DYNAMIC_DIS                     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DYNAMIC__PROD                   0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DISABLED                               2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DISABLED_EN                     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DISABLED_DIS                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_DISABLED__PROD                  0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1                          4:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_L0                0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_L1                0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_L1P               0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_L1PP              0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC                     6:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_L0           0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_L1           0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_L1P          0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_L1PP         0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC__PROD        0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MINIMUM                               14:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MINIMUM_INIT                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND                          25:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_DEFAULT             0x000000FA /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_278                 0x00000116 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_312                 0x00000138 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_333                 0x0000014D /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_357                 0x00000165 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_417                 0x000001A1 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_500                 0x000001F4 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_MICROSECOND_555                 0x0000022B /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_XVR_USE_DFPCI_DATA_UNINTR            26:26 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_XVR_USE_DFPCI_DATA_UNINTR_INIT  0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_PAD_PWRDN_XVR_USE_DFPCI_DATA_UNINTR__PROD 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS                                       0x00000F54 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_N_FTS                                        7:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_N_FTS_INIT                            0x0000001F /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_N_FTS__PROD                           0x0000001F /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_N_FTS_REMOTE                                15:8 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_DETECT_START                               25:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_DETECT_START_INIT                     0x00000040 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_FTS_DETECT_START__PROD                    0x00000040 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0                                    0x00000F58 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_8B10B_ERRORS_LC                           0:0 /* C-IVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_8B10B_ERRORS_LC_INIT               0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_8B10B_ERRORS_INF                          4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_8B10B_ERRORS_INF_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_CRC_ERRORS_LC                             8:8 /* C-IVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_CRC_ERRORS_LC_INIT                 0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_CRC_ERRORS_INF                          12:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_CRC_ERRORS_INF_INIT                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_NAKS_RCVD_LC                            16:16 /* C-IVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_NAKS_RCVD_LC_INIT                  0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_NAKS_RCVD_INF                           20:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_NAKS_RCVD_INF_INIT                 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_FAILED_L0S_EXITS_LC                     24:24 /* C-IVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_FAILED_L0S_EXITS_LC_INIT           0x00000000 /* C-I-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_FAILED_L0S_EXITS_INF                    28:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS0_FAILED_L0S_EXITS_INF_INIT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS1                                    0x00000F5C /* R--4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS1_8B10B_ERRORS                              7:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS1_CRC_ERRORS                               15:8 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS1_NAKS_RCVD                               23:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_XP_STATS1_FAILED_L0S_EXITS                        31:24 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_ERROR_COUNT                                  0x00000F60 /* R--4R */
#define NV_PROJ__PCIE2_RP_VEND_ERROR_COUNT_LCRC_ERR                                7:0 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_ERROR_COUNT_BAD_TLP                                15:8 /* R--VF */
#define NV_PROJ__PCIE2_RP_VEND_ERROR_COUNT_REPLAY                                23:16 /* R--VF */
#define NV_PROJ__PCIE2_RP_CFG_MISC                                        0x00000F64 /* RW-4R */
#define NV_PROJ__PCIE2_RP_CFG_MISC_MUTE_IDLE                                     7:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CFG_MISC_MUTE_IDLE_MIN                          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_CFG_MISC_MUTE_IDLE_MAX                          0x000000FF /* RW--V */
#define NV_PROJ__PCIE2_RP_CFG_MISC_MUTE_IDLE__PROD                        0x0000001F /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY                            0x00000F68 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY_8B10B_ERROR_THRESHOLD            19:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY_8B10B_ERROR_THRESHOLD_2500 0x000009C4 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY_8B10B_ERROR_WINDOW              30:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY_8B10B_ERROR_WINDOW_100US   0x00000064 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY_8B10B_ERROR_ENABLE              31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_INIT_RECOVERY_8B10B_ERROR_ENABLE_INIT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2                                       0x00000F6C /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_SPEED_CHANGE                                 0:0 /* CWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_SPEED_CHANGE_ZERO                     0x00000000 /* CWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_ADVERTISED_RATE_CHANGE                       1:1 /* CWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_ADVERTISED_RATE_CHANGE_ZERO           0x00000000 /* CWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_CYA_DEEMPHASIS_OVERRIDE                      2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_CYA_DEEMPHASIS_OVERRIDE_DISABLED      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_CYA_DEEMPHASIS_OVERRIDE_ENABLED       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_CYA_TX_MARGIN_OVERRIDE                       3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_CYA_TX_MARGIN_OVERRIDE_DISABLED       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_CYA_TX_MARGIN_OVERRIDE_ENABLED        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_TARGET_LINK_SPEED                            7:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_TARGET_LINK_SPEED_2P5                 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_TARGET_LINK_SPEED_5P0                 0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DATA_RATE_SUPPORTED                         11:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DATA_RATE_SUPPORTED_2P5               0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DATA_RATE_SUPPORTED_5P0_2P5           0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DATA_RATE_SUPPORTED_REMOTE                 15:12 /* R-IVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DATA_RATE_SUPPORTED_REMOTE_2P5        0x00000001 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DATA_RATE_SUPPORTED_REMOTE_5P0_2P5    0x00000002 /* R---V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_AUTONOMOUS_CHANGE	                     16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_AUTONOMOUS_CHANGE_INIT                0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_POLLING_PREDETERMINED_LANES                17:17 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_POLLING_PREDETERMINED_LANES_DISABLE   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_ENFORCE_DEEMPHASIS                         18:18 /* RWCVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_ENFORCE_DEEMPHASIS_INIT               0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DEEMPHASIS_STRAP                           19:19 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_DEEMPHASIS_STRAP_INIT                 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_N_EIE_SYMBOLS		                     23:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_N_EIE_SYMBOLS_INIT	                0x00000006 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_RECOVERY_SPEED_TIMEOUT_ADJ                 26:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_RECOVERY_SPEED_TIMEOUT_ADJ_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_ALLOW_SPEED_CHANGE_FROM_L1                 27:27 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_ALLOW_SPEED_CHANGE_FROM_L1_INIT       0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_SURPRISE_IDLE_USE_STAT_IDLE                28:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_SURPRISE_IDLE_USE_STAT_IDLE_INIT      0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_EIDLE_INFERENCE_EN                         29:29 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_EIDLE_INFERENCE_EN_INIT               0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_REV2P0_COMPLIANCE_DIS                      30:30 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_REV2P0_COMPLIANCE_DIS_INIT            0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_REV2P0_COMPLIANCE_DIS__PROD           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_LCTRL_2_UPCONFIGURE_CAPABLE                        31:31 /* R--VF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_PAD_PWRUP                                  0x00000F74 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_PAD_PWRUP_PMRX_PWRUP_THRESHOLD                  23:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_PAD_PWRUP_PMRX_PWRUP_THRESHOLD_INIT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_GEN2_PAD_PWRDN                             0x00000F78 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_GEN2_PAD_PWRDN_MICROSECOND                     25:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_GEN2_PAD_PWRDN_MICROSECOND_277             0x00000115 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_GEN2_PAD_PWRDN_MICROSECOND_555             0x0000022B /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_GEN2_PAD_PWRDN_MICROSECOND_500             0x000001F4 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_REASONS                         0x00000F84 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_REASONS_VALUE                         31:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_REASONS_VALUE_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_REASONS_VALUE_REC_ALL           0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_REASONS_VALUE_REC_NEXT          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_COUNT                            0x00000F88 /* R--4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_COUNT_VALUE                            31:0 /* R-IVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_RECOVERY_COUNT_VALUE_INIT                 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2                                        0x00000F8C /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_DIS_MA_TA_EP_MERGE                            1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_DIS_MA_TA_EP_MERGE_ON                  0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_DIS_MA_TA_EP_MERGE_OFF                 0x00000000 /* RWI-V */    
#define NV_PROJ__PCIE2_RP_VEND_CYA2_DEV_CAP_EXTENDED_TAG_FIELD_SIZE               2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_DEV_CAP_EXTENDED_TAG_FIELD_SIZE_8B     0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_DEV_CAP_EXTENDED_TAG_FIELD_SIZE_5B     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_GEN2_PROTOCOL_DISABLE		       4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_GEN2_PROTOCOL_DISABLE_OFF		0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_GEN2_PROTOCOL_DISABLE_ON		0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_GEN2_SPEED_DISABLE			       5:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_GEN2_SPEED_DISABLE_ON		0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_GEN2_SPEED_DISABLE_OFF		0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_PCA_ENABLE			               7:7 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_PCA_ENABLE_ON		        0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_PCA_ENABLE_OFF			0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_NMI                        8:8 /* RWCVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_NMI_FALSE           0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_NMI_TRUE           	0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_NMI_CLEAR          	0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_PME                        9:9 /* RWCVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_PME_FALSE           0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_PME_TRUE           	0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_ERR_STS_HOTPLUG_PME_CLEAR          	0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SLOT_IMPLEMENTED                         11:11 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SLOT_IMPLEMENTED_INIT               0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SLOT_IMPLEMENTED_YES                0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SLOT_IMPLEMENTED_NO                 0x00000000 /* RW--V */    
#define NV_PROJ__PCIE2_RP_VEND_CYA2_FUSE_GEN2_PROTOCOL_DISABLE	            12:12 /* R-IVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_FUSE_GEN2_PROTOCOL_DISABLE_ON      0x00000001 /* R---V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_FUSE_GEN2_PROTOCOL_DISABLE_OFF     0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SHADOW_LINK_BW_NOTIFY_CAP               13:13 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SHADOW_LINK_BW_NOTIFY_CAP_EN       0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_SHADOW_LINK_BW_NOTIFY_CAP_DIS      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BW_MANAGEMENT_DIS                       16:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BW_MANAGEMENT_DIS_TRUE             0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BW_MANAGEMENT_DIS_FALSE            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_AUTO_BANDWIDTH_DIS                      17:17 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_AUTO_BANDWIDTH_DIS_TRUE            0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_AUTO_BANDWIDTH_DIS_FALSE           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_AUTO_BANDWIDTH_INT_EN_DIS	             18:18 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_AUTO_BANDWIDTH_INT_EN_DIS_TRUE      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_AUTO_BANDWIDTH_INT_EN_DIS_FALSE     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BW_MANAGEMENT_INT_EN_DIS                 19:19 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BW_MANAGEMENT_INT_EN_DIS_TRUE       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BW_MANAGEMENT_INT_EN_DIS_FALSE      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_HW_AUTO_WIDTH_DISABLE_DIS	             20:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_HW_AUTO_WIDTH_DISABLE_DIS_TRUE      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_HW_AUTO_WIDTH_DISABLE_DIS_FALSE     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BLOCK_UP_TRANSACTIONS_ON_ERR                21:21 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BLOCK_UP_TRANSACTIONS_ON_ERR_EN        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_BLOCK_UP_TRANSACTIONS_ON_ERR_DIS       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_UNBLOCK_UP_TRANSACTIONS	                22:22 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_UNBLOCK_UP_TRANSACTIONS_FALSE          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_UNBLOCK_UP_TRANSACTIONS_TRUE           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_IGNORE_ATTENTION_BUTTON_MSG	                23:23 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_IGNORE_ATTENTION_BUTTON_MSG_FALSE      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_IGNORE_ATTENTION_BUTTON_MSG_TRUE       0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_COMPLIANCE_X8_DELAY                         24:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_CYA2_COMPLIANCE_X8_DELAY_INIT                      0x0 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_CONFIG                                   0x00000F94 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_CONFIG_LOW_PWR_DURATION                         1:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_CONFIG_LOW_PWR_DURATION_TX_L0S           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_CONFIG_LOW_PWR_DURATION_RX_L0S           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_CONFIG_LOW_PWR_DURATION_L1               0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_CONFIG_LOW_PWR_DURATION_IDLE             0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DURATION_IN_LOW_PWR_100NS                 0x00000F98 /* R-I4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DURATION_IN_LOW_PWR_100NS_VALUE                 31:0 /* R-IVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_DURATION_IN_LOW_PWR_100NS_VALUE_INIT      0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT				    0x00000F9C /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD     		          12:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_INIT		    0x00000569 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_250                 0x000004E2 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_278                 0x00000569 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_313                 0x0000061A /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_357                 0x000006F5 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_417                 0x00000821 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_500                 0x000009BF /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_555                 0x00000AD2 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2     	         25:13 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_INIT	    0x00000569 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_250            0x00000271 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_278            0x000002B4 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_313            0x0000030D /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_357            0x0000037A /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_417            0x00000410 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_500            0x000004DF /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_SKP_TIMEOUT_THRESHOLD_GEN2_555            0x00000569 /* RW--V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_EIDLE_INFERENCE_TIMEOUT		 0x00000FA0 /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_XP_EIDLE_INFERENCE_TIMEOUT_A		       15:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_EIDLE_INFERENCE_TIMEOUT_A_INIT	 0x0000008F /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_XP_EIDLE_INFERENCE_TIMEOUT_B		      31:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_XP_EIDLE_INFERENCE_TIMEOUT_B_INIT	 0x000006F2 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC                    0x00000FA4 /* RWI4R */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_COMMAND                 31:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_COMMAND_INIT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE                    15:8 /* R--VF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE7             7:7 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE7_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE7_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE6             6:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE6_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE6_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE5             5:5 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE5_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE5_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE4             4:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE4_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE4_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE3             3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE3_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE3_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE2             2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE2_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE2_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE1             1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE1_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE1_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE0             0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE0_INIT 0x00000000 /* R-I-V */
#define NV_PROJ__PCIE2_RP_SLOT_CONTROL_STATUS_HPC_STATE_CHANGE0_SET  0x00000001 /* -W--C */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0                                  0x00000FA8 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_0                                  3:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_0_INIT                      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_1                                  7:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_1_INIT                      0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_2                                 11:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_2_INIT                      0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_3                                15:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_3_INIT                      0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_4                                19:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_4_INIT                      0x00000004 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_5                                23:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_5_INIT                      0x00000005 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_6                                27:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_6_INIT                      0x00000006 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_7                                31:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP0_LANE_7_INIT                      0x00000007 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1                                  0x00000FAC /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_8                                  3:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_8_INIT                      0x00000008 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_9                                  7:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_9_INIT                      0x00000009 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_10                                11:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_10_INIT                     0x0000000A /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_11                               15:12 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_11_INIT                     0x0000000B /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_12                               19:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_12_INIT                     0x0000000C /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_13                               23:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_13_INIT                     0x0000000D /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_14                               27:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_14_INIT                     0x0000000E /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_15                               31:28 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_LANEMAP1_LANE_15_INIT                     0x0000000F /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SHADOW_SS_1                                  0x00000FB0 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_SHADOW_SS_1_SSID                                  31:16 /* RWCVF */
#define NV_PROJ__PCIE2_RP_VEND_SHADOW_SS_1_SSID_INIT                              0x0  /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_SHADOW_SS_1_SSVID                                  15:0 /* RWCVF */
#define NV_PROJ__PCIE2_RP_VEND_SHADOW_SS_1_SSVID_INIT                           0x10DE /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP                       0x00000FB4 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE0                        5:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE0_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE1                       13:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE1_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE2                      21:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE2_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE3                      29:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP0_TX_AMP_CODE3_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP                      0x00000FB8 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE4                        5:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE4_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE5                       13:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE5_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE6                      21:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE6_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE7                      29:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TX_MARGIN_MAP1_TX_AMP_CODE7_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_2                                 0x00000FBC /* RW-4R */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R0_1C                          18:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R0_1C_DEFAULT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R0_1C_NO_EQ		0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R0_1C_MAX_EQ		0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R1_1C                          22:20 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R1_1C_DEFAULT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R1_1C_NO_EQ		0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R1_1C_MAX_EQ		0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R2_1C                          26:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R2_1C_DEFAULT             0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R2_1C_NO_EQ		0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_2_RX_EQ_R2_1C_MAX_EQ		0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3                             0x00000FC0 /* RW-4R */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C                       5:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C_DEFAULT        0x0000000C /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C_1150_MVPPD     0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C_1100_MVPPD     0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C_1050_MVPPD     0x0000000D /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C_1000_MVPPD     0x0000000C /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__950_MVPPD     0x0000000B /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__900_MVPPD     0x0000000A /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__850_MVPPD     0x00000009 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__800_MVPPD     0x00000008 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__750_MVPPD     0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__700_MVPPD     0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__650_MVPPD     0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__600_MVPPD     0x00000004 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__550_MVPPD     0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__500_MVPPD     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__450_MVPPD     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R0_1C__400_MVPPD     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R0_1C                     12:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R0_1C_DEFAULT       0x0000000A /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R0_1C_MAX           0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R0_1C_DISABLE       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R0_1C_36DB          0x0000000A /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R0_1C_6DB           0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C                     21:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C_DEFAULT        0x0000000C /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C_1150_MVPPD     0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C_1100_MVPPD     0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C_1050_MVPPD     0x0000000D /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C_1000_MVPPD     0x0000000C /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__950_MVPPD     0x0000000B /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__900_MVPPD     0x0000000A /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__850_MVPPD     0x00000009 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__800_MVPPD     0x00000008 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__750_MVPPD     0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__700_MVPPD     0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__650_MVPPD     0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__600_MVPPD     0x00000004 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__550_MVPPD     0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__500_MVPPD     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__450_MVPPD     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_AMP_R1_1C__400_MVPPD     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R1_1C                    27:23 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R1_1C_DEFAULT       0x0000000A /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R1_1C_MAX           0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R1_1C_DISABLE       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R1_1C_36DB          0x0000000A /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_3_TX_PEAK_R1_1C_6DB           0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4                             0x00000FC4 /* RW-4R */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C                       5:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C_DEFAULT        0x0000000C /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C_1150_MVPPD     0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C_1100_MVPPD     0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C_1050_MVPPD     0x0000000D /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C_1000_MVPPD     0x0000000C /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__950_MVPPD     0x0000000B /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__900_MVPPD     0x0000000A /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__850_MVPPD     0x00000009 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__800_MVPPD     0x00000008 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__750_MVPPD     0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__700_MVPPD     0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__650_MVPPD     0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__600_MVPPD     0x00000004 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__550_MVPPD     0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__500_MVPPD     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__450_MVPPD     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_AMP_R2_1C__400_MVPPD     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_PEAK_R2_1C                     12:8 /* RWIVF */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_PEAK_R2_1C_DEFAULT       0x0000000F /* RWI-V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_PEAK_R2_1C_MAX           0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_PEAK_R2_1C_DISABLE       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_PEAK_R2_1C_36DB          0x0000000A /* RW--V */
#define NV_PROJ__PCIE2_RP_CTL_4_TX_PEAK_R2_1C_6DB           0x0000000F /* RW--V */
#define NV_PROJ__PCIE2_RP_TIMEOUT2                                       0x00000FC8 /* RW-4R */
#define NV_PROJ__PCIE2_RP_TIMEOUT2_MIN_L1_L2_IDLE_TIME  		        4:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_TIMEOUT2_MIN_L1_L2_IDLE_TIME_INIT	         0x0000000A /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_MISC                       		   0x00000FCC /* RW-4R */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_PRSNT_MAP                                     3:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_PRSNT_MAP_INIT	                   0x0000000F /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_CTLR_CLK_CLAMP_THRESHOLD                    22:16 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_CTLR_CLK_CLAMP_THRESHOLD_INIT          0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_CTLR_CLK_CLAMP_ENABLE                       23:23 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_CTLR_CLK_CLAMP_ENABLE_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_TMS_CLK_CLAMP_THRESHOLD                     30:24 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_TMS_CLK_CLAMP_THRESHOLD_INIT           0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_TMS_CLK_CLAMP_ENABLE                        31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_PRIV_MISC_TMS_CLK_CLAMP_ENABLE_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2                                    0x00000FD0 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_SHORT_LINK_TIMERS                         0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_SHORT_LINK_TIMERS_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_EIDLE_ENTRY                        1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_EIDLE_ENTRY_INIT            0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_EIDLE_EXIT                         2:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_EIDLE_EXIT_INIT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_MIN_EIDLE                          3:3 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_MIN_EIDLE_INIT              0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_SPEED                              7:4 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_SPEED_2P5                   0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_TXCHAR_SPEED_5P0                   0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_OVERRIDE_JTAG                           31:31 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP_BIST_CTRL_2_OVERRIDE_JTAG_INIT                 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_VEND_XP3                                               0x00000FD4 /* RW-4R */
#define NV_PROJ__PCIE2_RP_VEND_XP3_SA_ERROR_LIMIT                                       7:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_VEND_XP3_SA_ERROR_LIMIT_INIT                           0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_RP_XP_CYA_1                                            0x00000FD8 /* RW-4R */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_FORCE_SA_IN_CONFIG                                0:0 /* RWIVF */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_FORCE_SA_IN_CONFIG_INIT                    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_LWLO_HUNT_ON_BAD_TS1                              1:1 /* RWIVF */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_LWLO_HUNT_ON_BAD_TS1_INIT                  0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_IDLE_TO_L0_DELAY                                  5:2 /* RWIVF */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_IDLE_TO_L0_DELAY_INIT                      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_RESET_LANE_ENABLE_ORIG_IN_DETECT                  6:6 /* RWIVF */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_RESET_LANE_ENABLE_ORIG_IN_DETECT_INIT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_SPARE                                            31:7 /* RWIVF */
#define NV_PROJ__PCIE2_RP_XP_CYA_1_SPARE_INIT                                 0x00000000 /* RWI-V */

#endif // ___DEV_AP_PCIE2_ROOT_PORT_H_INC_

