/*
 * Copyright (c) 2007-2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef NVRM_IOCTLS_H
#define NVRM_IOCTLS_H


/* When we trap into the kernel, the majority of the ioctls
 * are handled by the Generic handler, which is automatically
 * generated by the IDL compiler.  
 *
 * For some special functions, we override the generated code
 * and supply custom marshalling/unmarshalling code for performance
 * reasons.  NvRmMemRead/Write are done this way to avoid having
 * to allocate a buffer and do an extra copy.
 *
 * I'm sure as time passes we'll add more to the list here.
 */

typedef enum
{
    NvRmIoctls_Generic = 5000,
    NvRmIoctls_NvRmMemRead,
    NvRmIoctls_NvRmMemWrite,
    NvRmIoctls_NvRmMemReadStrided,
    NvRmIoctls_NvRmMemWriteStrided,
    NvRmIoctls_NvRmMemMapIntoCallerPtr,
    NvRmIoctls_NvRmGetCarveoutInfo,
    NvRmIoctls_NvRmGraphics,    // Note: not used in Linux (see nvidlcmd.h)
    NvRmIoctls_NvRmFbControl,
    NvRmIoctls_NvRmBootDone,    // Called after primary boot-up complete

    // These following ones are used for attaching to an existing NvRm
    // context from another process - this is used for reference counting
    // the kernel context when it is used both from a client process and
    // the nvrm daemon in Linux. This mechanism is roughly equal to duplicating
    // the nvrm driver filehandle across processes.
    NvRmIoctls_NvRmGetClientId,
    NvRmIoctls_NvRmClientAttach,
    NvRmIoctls_NvRmClientDetach,

    // This ioctl is for the nvrm_gpu module
    NvRmIoctls_NvRmGpu,

    NvRmIoctls_ForceWord = 0x7FFFFFFF,
} NvRmKernelIoctls;

#endif
