
(** The container type *)
type container_info = VolumeGroup of Lvm.Vg.vg | FileSystem of string | OrigLVMVG of Olvm.vg

(** The type of object a location references *)
type location_type = Vhd | Raw | Metadata

(** A reference to a thing stored in the container *)
type location = LogicalVolume of string | OLV of Olvm.lv | File of string 

(** Something to combine a location and location_type *)
type location_info = { location : location; location_type : location_type; }

(** Autogenerated functions *)
val location_info_of_rpc : Rpc.t -> location_info
val location_of_rpc : Rpc.t -> location
val location_type_of_rpc : Rpc.t -> location_type
val container_info_of_rpc : Rpc.t -> container_info
val rpc_of_location_info : location_info -> Rpc.t
val rpc_of_location : location -> Rpc.t
val rpc_of_location_type : location_type -> Rpc.t
val rpc_of_container_info : container_info -> Rpc.t
