
/*
 * public xen defines and struct for ia64
 * generated by mkheader.py -- DO NOT EDIT
 */

#ifndef __FOREIGN_IA64_H__
#define __FOREIGN_IA64_H__ 1


#define __align8__ __attribute__((aligned (8)))
#define __align16__ __attribute__((aligned (16)))
typedef unsigned char ldouble_t[16];

#define MAX_VIRT_CPUS_IA64 64
#define VGCF_EXTRA_REGS_IA64 (1<<1)	/* Get/Set extra regs.  */
#define MAX_GUEST_CMDLINE_IA64 1024

struct start_info_ia64 {
    char magic[32];             
    __align8__ uint64_t nr_pages;     
    __align8__ uint64_t shared_info;  
    uint32_t flags;             
    __align8__ uint64_t store_mfn;        
    uint32_t store_evtchn;      
    union {
        struct {
            __align8__ uint64_t mfn;      
            uint32_t  evtchn;   
        } domU;
        struct {
            uint32_t info_off;  
            uint32_t info_size; 
        } dom0;
    } console;
    __align8__ uint64_t pt_base;      
    __align8__ uint64_t nr_pt_frames; 
    __align8__ uint64_t mfn_list;     
    __align8__ uint64_t mod_start;    
    __align8__ uint64_t mod_len;      
    int8_t cmd_line[MAX_GUEST_CMDLINE_IA64];
};
typedef struct start_info_ia64 start_info_ia64_t;

#define ia64_has_no_trap_info 1

struct pt_fpreg_ia64 {
    union {
        __align8__ uint64_t bits[2];
        __align16__ ldouble_t __dummy;    
    } u;
};
typedef struct pt_fpreg_ia64 pt_fpreg_ia64_t;

struct cpu_user_regs_ia64 {
    __align8__ uint64_t b6;  
    __align8__ uint64_t b7;  
    __align8__ uint64_t ar_csd; 
    __align8__ uint64_t ar_ssd; 
    __align8__ uint64_t r8;  
    __align8__ uint64_t r9;  
    __align8__ uint64_t r10; 
    __align8__ uint64_t r11; 
    __align8__ uint64_t cr_ipsr; 
    __align8__ uint64_t cr_iip;  
    __align8__ uint64_t cr_ifs;  
    __align8__ uint64_t ar_unat; 
    __align8__ uint64_t ar_pfs;  
    __align8__ uint64_t ar_rsc;  
    __align8__ uint64_t ar_rnat;  
    __align8__ uint64_t ar_bspstore; 
    __align8__ uint64_t pr;  
    __align8__ uint64_t b0;  
    __align8__ uint64_t loadrs;  
    __align8__ uint64_t r1;  
    __align8__ uint64_t r12; 
    __align8__ uint64_t r13; 
    __align8__ uint64_t ar_fpsr;  
    __align8__ uint64_t r15;  
    __align8__ uint64_t r14;  
    __align8__ uint64_t r2;  
    __align8__ uint64_t r3;  
    __align8__ uint64_t r16;  
    __align8__ uint64_t r17;  
    __align8__ uint64_t r18;  
    __align8__ uint64_t r19;  
    __align8__ uint64_t r20;  
    __align8__ uint64_t r21;  
    __align8__ uint64_t r22;  
    __align8__ uint64_t r23;  
    __align8__ uint64_t r24;  
    __align8__ uint64_t r25;  
    __align8__ uint64_t r26;  
    __align8__ uint64_t r27;  
    __align8__ uint64_t r28;  
    __align8__ uint64_t r29;  
    __align8__ uint64_t r30;  
    __align8__ uint64_t r31;  
    __align8__ uint64_t ar_ccv;  
    struct pt_fpreg_ia64 f6;  
    struct pt_fpreg_ia64 f7;  
    struct pt_fpreg_ia64 f8;  
    struct pt_fpreg_ia64 f9;  
    struct pt_fpreg_ia64 f10;  
    struct pt_fpreg_ia64 f11;  
    __align8__ uint64_t r4;  
    __align8__ uint64_t r5;  
    __align8__ uint64_t r6;  
    __align8__ uint64_t r7;  
    __align8__ uint64_t eml_unat;    
    __align8__ uint64_t pad0;     
};
typedef struct cpu_user_regs_ia64 cpu_user_regs_ia64_t;

struct xen_ia64_boot_param_ia64 {
	__align8__ uint64_t command_line;	
	__align8__ uint64_t efi_systab;	
	__align8__ uint64_t efi_memmap;	
	__align8__ uint64_t efi_memmap_size;	
	__align8__ uint64_t efi_memdesc_size;	
	unsigned int  efi_memdesc_version;	
	struct {
		unsigned short num_cols;	
		unsigned short num_rows;	
		unsigned short orig_x;	
		unsigned short orig_y;	
	} console_info;
	__align8__ uint64_t fpswa;		
	__align8__ uint64_t initrd_start;
	__align8__ uint64_t initrd_size;
	__align8__ uint64_t domain_start;	
	__align8__ uint64_t domain_size;	
};
typedef struct xen_ia64_boot_param_ia64 xen_ia64_boot_param_ia64_t;

struct ia64_tr_entry_ia64 {
    __align8__ uint64_t pte;
    __align8__ uint64_t itir;
    __align8__ uint64_t vadr;
    __align8__ uint64_t rid;
};
typedef struct ia64_tr_entry_ia64 ia64_tr_entry_ia64_t;

struct vcpu_extra_regs_ia64 {
    struct ia64_tr_entry_ia64 itrs[8];
    struct ia64_tr_entry_ia64 dtrs[8];
    __align8__ uint64_t iva;
    __align8__ uint64_t dcr;
    __align8__ uint64_t event_callback_ip;
};
typedef struct vcpu_extra_regs_ia64 vcpu_extra_regs_ia64_t;

struct vcpu_guest_context_ia64 {
    __align8__ uint64_t flags;       
    struct cpu_user_regs_ia64 user_regs;
    struct vcpu_extra_regs_ia64 extra_regs;
    __align8__ uint64_t privregs_pfn;
};
typedef struct vcpu_guest_context_ia64 vcpu_guest_context_ia64_t;

struct arch_vcpu_info_ia64 {
};
typedef struct arch_vcpu_info_ia64 arch_vcpu_info_ia64_t;

struct vcpu_time_info_ia64 {
    uint32_t version;
    uint32_t pad0;
    uint64_t tsc_timestamp;   
    uint64_t system_time;     
    uint32_t tsc_to_system_mul;
    int8_t   tsc_shift;
    int8_t   pad1[3];
};
typedef struct vcpu_time_info_ia64 vcpu_time_info_ia64_t;

struct vcpu_info_ia64 {
    uint8_t evtchn_upcall_pending;
    uint8_t evtchn_upcall_mask;
    __align8__ uint64_t evtchn_pending_sel;
    struct arch_vcpu_info_ia64 arch;
    struct vcpu_time_info_ia64 time;
};
typedef struct vcpu_info_ia64 vcpu_info_ia64_t;

struct arch_shared_info_ia64 {
    __align8__ uint64_t start_info_pfn;
    int evtchn_vector;
    uint64_t pad[32];
};
typedef struct arch_shared_info_ia64 arch_shared_info_ia64_t;

struct shared_info_ia64 {
    struct vcpu_info_ia64 vcpu_info[MAX_VIRT_CPUS_IA64];
    __align8__ uint64_t evtchn_pending[sizeof(__align8__ uint64_t) * 8];
    __align8__ uint64_t evtchn_mask[sizeof(__align8__ uint64_t) * 8];
    uint32_t wc_version;      
    uint32_t wc_sec;          
    uint32_t wc_nsec;         
    struct arch_shared_info_ia64 arch;
};
typedef struct shared_info_ia64 shared_info_ia64_t;

#endif /* __FOREIGN_IA64_H__ */
