#!/bin/sh
# Copyright (c) 2016-2018 Red Hat, Inc. and/or its affiliates
# This work is licensed under the terms of the GNU GPL, version 2 or later.
# See the COPYING file in the top-level directory.
#
# Author: dgilbert@redhat.com

ASMFILE=$PWD/tests/migration/x86-a-b-bootblock.s
HEADER=$PWD/tests/migration/x86-a-b-bootblock.h

if [ ! -e "$ASMFILE" ]
then
  echo "Couldn't find $ASMFILE" >&2
  exit 1
fi

ASM_WORK_DIR=$(mktemp -d --tmpdir X86BB.XXXXXX)
cd "$ASM_WORK_DIR" &&
as --32 -march=i486 "$ASMFILE" -o x86.o &&
objcopy -O binary x86.o x86.boot &&
dd if=x86.boot of=x86.bootsect bs=256 count=2 skip=124 &&
xxd -i x86.bootsect |
sed -e 's/.*int.*//' > x86.hex &&
cat - x86.hex <<HERE > "$HEADER"
/* This file is automatically generated from
 * tests/migration/x86-a-b-bootblock.s, edit that and then run
 * tests/migration/rebuild-x86-bootblock.sh to update,
 * and then remember to send both in your patch submission.
 */
HERE

rm x86.hex x86.bootsect x86.boot x86.o
cd .. && rmdir "$ASM_WORK_DIR"
