/*
 * QEMU CPU model
 *
 * Copyright (c) 2012 SUSE LINUX Products GmbH
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>
 */

#include "qemu/cpu.h"
#include "qemu-common.h"

void cpu_reset(CPUState *cpu)
{
    CPUClass *klass = CPU_GET_CLASS(cpu);

    if (klass->reset != NULL) {
        (*klass->reset)(cpu);
    }
}

static void cpu_common_reset(CPUState *cpu)
{
}

static int64_t cpu_common_get_arch_id(CPUState *cpu)
{
    /* Not used in Xen, so no backport.
     * There is a missing cpu_index field in CPUState. */
    abort();
}

static void cpu_class_init(ObjectClass *klass, void *data)
{
    CPUClass *k = CPU_CLASS(klass);

    k->reset = cpu_common_reset;
    k->get_arch_id = cpu_common_get_arch_id;
}

static TypeInfo cpu_type_info = {
    .name = TYPE_CPU,
    .parent = TYPE_OBJECT,
    .instance_size = sizeof(CPUState),
    .abstract = true,
    .class_size = sizeof(CPUClass),
    .class_init = cpu_class_init,
};

static void cpu_register_types(void)
{
    type_register_static(&cpu_type_info);
}

type_init(cpu_register_types)
